/*
 * Decompiled with CFR 0.152.
 */
package binnie.core;

import binnie.Binnie;
import binnie.core.BaseManager;
import binnie.core.IBinnieMod;
import binnie.core.block.MultipassBlockRenderer;
import binnie.core.block.TileEntityMetadata;
import binnie.core.genetics.BeeBreedingSystem;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.FlowerBreedingSystem;
import binnie.core.genetics.MothBreedingSystem;
import binnie.core.genetics.TreeBreedingSystem;
import binnie.core.gui.BinnieCoreGUI;
import binnie.core.gui.BinnieGUIHandler;
import binnie.core.gui.IBinnieGUID;
import binnie.core.item.ModuleItems;
import binnie.core.liquid.FluidContainer;
import binnie.core.liquid.ItemFluidContainer;
import binnie.core.machines.MachineGroup;
import binnie.core.machines.storage.ModuleStorage;
import binnie.core.mod.config.ConfigurationMain;
import binnie.core.mod.config.ConfigurationMods;
import binnie.core.mod.parser.ItemParser;
import binnie.core.mod.parser.VariableParser;
import binnie.core.network.BinnieCorePacketID;
import binnie.core.network.BinniePacketHandler;
import binnie.core.network.IPacketID;
import binnie.core.proxy.BinnieProxy;
import binnie.core.proxy.IBinnieProxy;
import binnie.core.resource.IBinnieTexture;
import binnie.core.texture.BinnieCoreTexture;
import binnie.core.triggers.BinnieAction;
import binnie.core.triggers.BinnieTrigger;
import binnie.craftgui.minecraft.ModuleCraftGUI;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryEvent;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.world.WorldEvent;

@Mod(modid="BinnieCore", name="Binnie Core", useMetadata=true)
public final class BinnieCore
extends IBinnieMod {
    @Mod.Instance(value="BinnieCore")
    public static BinnieCore instance;
    @SidedProxy(clientSide="binnie.core.proxy.BinnieProxyClient", serverSide="binnie.core.proxy.BinnieProxyServer")
    public static BinnieProxy proxy;
    public static int multipassRenderID;
    private static List<IBinnieMod> modList;
    public static MachineGroup packageCompartment;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        Binnie.Configuration.registerConfiguration(ConfigurationMods.class, this);
        this.addModule(new ModuleCraftGUI());
        this.addModule(new ModuleStorage());
        this.addModule(new ModuleItems());
        this.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        this.postInit();
    }

    @Override
    public IBinnieGUID[] getGUIDs() {
        return BinnieCoreGUI.values();
    }

    @Override
    public void preInit() {
        instance = this;
        for (FluidContainer container : FluidContainer.values()) {
            ItemFluidContainer item = new ItemFluidContainer(container);
            GameRegistry.registerItem((Item)item, (String)item.func_77658_a().substring(5));
        }
        VariableParser.parsers.add(new ItemParser());
        super.preInit();
        for (BaseManager manager : Binnie.Managers) {
            manager.preInit();
        }
    }

    @Override
    public void init() {
        super.init();
        for (BaseManager manager : Binnie.Managers) {
            manager.init();
        }
        if (BinnieCore.isApicultureActive()) {
            Binnie.Genetics.beeBreedingSystem = new BeeBreedingSystem();
        }
        if (BinnieCore.isArboricultureActive()) {
            Binnie.Genetics.treeBreedingSystem = new TreeBreedingSystem();
        }
        if (BinnieCore.isLepidopteryActive()) {
            Binnie.Genetics.mothBreedingSystem = new MothBreedingSystem();
        }
        if (BinnieCore.isBotanyActive()) {
            Binnie.Genetics.flowerBreedingSystem = new FlowerBreedingSystem();
        }
        for (IBinnieMod mod : BinnieCore.getActiveMods()) {
            NetworkRegistry.INSTANCE.registerGuiHandler((Object)mod, (IGuiHandler)new BinnieGUIHandler(mod));
        }
        multipassRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new MultipassBlockRenderer());
        GameRegistry.registerTileEntity(TileEntityMetadata.class, (String)"binnie.tile.metadata");
        BinnieAction.setup();
        BinnieTrigger.setup();
    }

    public static boolean isLepidopteryActive() {
        return PluginManager.Module.LEPIDOPTEROLOGY.isEnabled();
    }

    public static boolean isApicultureActive() {
        return PluginManager.Module.APICULTURE.isEnabled();
    }

    public static boolean isArboricultureActive() {
        return PluginManager.Module.ARBORICULTURE.isEnabled();
    }

    public static boolean isBotanyActive() {
        return ConfigurationMods.botany;
    }

    public static boolean isGeneticsActive() {
        return ConfigurationMods.genetics;
    }

    public static boolean isExtraBeesActive() {
        return ConfigurationMods.extraBees && BinnieCore.isApicultureActive();
    }

    public static boolean isExtraTreesActive() {
        return ConfigurationMods.extraTrees && BinnieCore.isArboricultureActive();
    }

    @Override
    public void postInit() {
        super.postInit();
        for (BaseManager manager : Binnie.Managers) {
            manager.postInit();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        for (BreedingSystem system : Binnie.Genetics.getActiveSystems()) {
            system.calculateArrays();
        }
    }

    static void registerMod(IBinnieMod mod) {
        modList.add(mod);
    }

    private static List<IBinnieMod> getActiveMods() {
        ArrayList<IBinnieMod> list = new ArrayList<IBinnieMod>();
        for (IBinnieMod mod : modList) {
            if (!mod.isActive()) continue;
            list.add(mod);
        }
        return list;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleSpeciesDiscovered(ForestryEvent.SpeciesDiscovered event) {
        try {
            EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(event.username.getName());
            if (player == null) {
                return;
            }
            event.tracker.synchToPlayer((EntityPlayer)player);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("species", event.species.getUID());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getChannel() {
        return "BIN";
    }

    @Override
    public IBinnieProxy getProxy() {
        return proxy;
    }

    @Override
    public String getModID() {
        return "binniecore";
    }

    @Override
    public IPacketID[] getPacketIDs() {
        return BinnieCorePacketID.values();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRemap(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            Binnie.Liquid.reloadIcons((IIconRegister)event.map);
        }
        Binnie.Resource.registerIcons((IIconRegister)event.map, event.map.func_130086_a());
    }

    @Override
    public Class[] getConfigs() {
        return new Class[]{ConfigurationMain.class};
    }

    @Override
    protected Class<? extends BinniePacketHandler> getPacketHandler() {
        return PacketHandler.class;
    }

    @Override
    public IBinnieTexture[] getTextures() {
        return BinnieCoreTexture.values();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    static {
        modList = new ArrayList<IBinnieMod>();
    }

    public static class PacketHandler
    extends BinniePacketHandler {
        public PacketHandler() {
            super(instance);
        }
    }
}

