/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.botany.Botany;
import binnie.botany.api.EnumFlowerChromosome;
import binnie.botany.api.EnumFlowerStage;
import binnie.botany.api.IAlleleFlowerSpecies;
import binnie.botany.api.IBotanistTracker;
import binnie.botany.api.IColourMix;
import binnie.botany.api.IFlower;
import binnie.botany.api.IFlowerGenome;
import binnie.botany.api.IFlowerMutation;
import binnie.botany.api.IFlowerRoot;
import binnie.botany.flower.ItemFlower;
import binnie.botany.genetics.BotanistTracker;
import binnie.botany.genetics.Flower;
import binnie.botany.genetics.FlowerGenome;
import binnie.botany.genetics.FlowerTemplates;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.core.genetics.SpeciesRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class FlowerHelper
extends SpeciesRoot
implements IFlowerRoot {
    public static int flowerSpeciesCount = -1;
    private static final String uid = "rootFlowers";
    public static ArrayList<IFlower> flowerTemplates = new ArrayList();
    private static ArrayList<IFlowerMutation> flowerMutations = new ArrayList();
    Map<ItemStack, IFlower> conversions = new HashMap<ItemStack, IFlower>();
    private static ArrayList<IColourMix> colourMixes = new ArrayList();

    public String getUID() {
        return uid;
    }

    public int getSpeciesCount() {
        if (flowerSpeciesCount < 0) {
            flowerSpeciesCount = 0;
            for (Map.Entry entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                if (!(entry.getValue() instanceof IAlleleFlowerSpecies) || !((IAlleleFlowerSpecies)entry.getValue()).isCounted()) continue;
                ++flowerSpeciesCount;
            }
        }
        return flowerSpeciesCount;
    }

    public boolean isMember(ItemStack stack) {
        return this.getType(stack) != EnumFlowerStage.NONE;
    }

    public boolean isMember(ItemStack stack, int type) {
        return this.getType(stack).ordinal() == type;
    }

    public boolean isMember(IIndividual individual) {
        return individual instanceof IFlower;
    }

    public ItemStack getMemberStack(IIndividual flower, int type) {
        if (!this.isMember(flower)) {
            return null;
        }
        ItemFlower flowerItem = Botany.flowerItem;
        if (type == EnumFlowerStage.SEED.ordinal()) {
            flowerItem = Botany.seed;
        }
        if (type == EnumFlowerStage.POLLEN.ordinal()) {
            flowerItem = Botany.pollen;
        }
        if (flowerItem != Botany.flowerItem) {
            ((IFlower)flower).setAge(0);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        flower.writeToNBT(nbttagcompound);
        ItemStack flowerStack = new ItemStack((Item)flowerItem);
        flowerStack.func_77982_d(nbttagcompound);
        return flowerStack;
    }

    @Override
    public EnumFlowerStage getType(ItemStack stack) {
        return stack.func_77973_b() == Botany.flowerItem ? EnumFlowerStage.FLOWER : (stack.func_77973_b() == Botany.pollen ? EnumFlowerStage.POLLEN : (stack.func_77973_b() == Botany.seed ? EnumFlowerStage.SEED : EnumFlowerStage.NONE));
    }

    @Override
    public IFlower getMember(ItemStack stack) {
        if (!this.isMember(stack)) {
            return null;
        }
        return new Flower(stack.func_77978_p());
    }

    @Override
    public IFlower getFlower(World world, IFlowerGenome genome) {
        return new Flower(genome, 2);
    }

    @Override
    public IFlowerGenome templateAsGenome(IAllele[] template) {
        return new FlowerGenome(this.templateAsChromosomes(template));
    }

    @Override
    public IFlowerGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new FlowerGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }

    @Override
    public IFlower templateAsIndividual(IAllele[] template) {
        return new Flower(this.templateAsGenome(template), 2);
    }

    @Override
    public IFlower templateAsIndividual(IAllele[] templateActive, IAllele[] templateInactive) {
        return new Flower(this.templateAsGenome(templateActive, templateInactive), 2);
    }

    public ArrayList<IFlower> getIndividualTemplates() {
        return flowerTemplates;
    }

    public void registerTemplate(IAllele[] template) {
        this.registerTemplate(template[0].getUID(), template);
    }

    public void registerTemplate(String identifier, IAllele[] template) {
        flowerTemplates.add(new Flower(this.templateAsGenome(template), 2));
        if (!this.speciesTemplates.containsKey(identifier)) {
            this.speciesTemplates.put(identifier, template);
        }
    }

    public IAllele[] getTemplate(String identifier) {
        return (IAllele[])this.speciesTemplates.get(identifier);
    }

    public IAllele[] getDefaultTemplate() {
        return FlowerTemplates.getDefaultTemplate();
    }

    public IAllele[] getRandomTemplate(Random rand) {
        return ((IAllele[][])this.speciesTemplates.values().toArray((T[])new IAllele[0][]))[rand.nextInt(this.speciesTemplates.values().size())];
    }

    @Override
    public Collection<IFlowerMutation> getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(flowerMutations);
        }
        return flowerMutations;
    }

    public void registerMutation(IMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        flowerMutations.add((IFlowerMutation)mutation);
    }

    @Override
    public IBotanistTracker getBreedingTracker(World world, GameProfile player) {
        String filename = "BotanistTracker." + (player == null ? "common" : player.getId());
        BotanistTracker tracker = (BotanistTracker)world.func_72943_a(BotanistTracker.class, filename);
        if (tracker == null) {
            tracker = new BotanistTracker(filename, player);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        return tracker;
    }

    public IIndividual getMember(NBTTagCompound compound) {
        return new Flower(compound);
    }

    public Class getMemberClass() {
        return IFlower.class;
    }

    public IChromosomeType[] getKaryotype() {
        return EnumFlowerChromosome.values();
    }

    public IChromosomeType getKaryotypeKey() {
        return EnumFlowerChromosome.SPECIES;
    }

    @Override
    public void addConversion(ItemStack itemstack, IAllele[] template) {
        IFlower flower = this.getFlower(null, this.templateAsGenome(template));
        this.conversions.put(itemstack, flower);
    }

    @Override
    public IFlower getConversion(ItemStack itemstack) {
        for (Map.Entry<ItemStack, IFlower> entry : this.conversions.entrySet()) {
            if (!entry.getKey().func_77969_a(itemstack)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void registerColourMix(IColourMix colourMix) {
        colourMixes.add(colourMix);
    }

    @Override
    public Collection<IColourMix> getColourMixes(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(colourMixes);
        }
        return colourMixes;
    }
}

