/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.botany.api.IFlowerColour;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.AlleleColor;
import binnie.botany.genetics.ColourMix;
import forestry.api.genetics.IAlleleInteger;

public enum EnumFlowerColor implements IFlowerColour
{
    Aquamarine("aquamarine", 8388564),
    Black("black", 0),
    Blue("blue", 255),
    Brown("brown", 0xA52A2A),
    CadetBlue("cadetBlue", 6266528),
    Chocolate("chocolate", 13789470),
    Coral("coral", 16744272),
    Crimson("crimson", 14423100),
    Cyan("cyan", 65535),
    DarkGoldenrod("darkGoldenrod", 12092939),
    DarkGray("darkGray", 0xA9A9A9),
    DarkGreen("darkGreen", 25600),
    DarkKhaki("darkKhaki", 12433259),
    DarkOliveGreen("darkOliveGreen", 5597999),
    DarkOrange("darkOrange", 16747520),
    DarkSalmon("darkSalmon", 15308410),
    DarkSeaGreen("darkSeaGreen", 9419915),
    DarkSlateBlue("darkSlateBlue", 4734347),
    DarkSlateGray("darkSlateGray", 0x2F4F4F),
    DarkTurquoise("darkTurquoise", 52945),
    DarkViolet("darkViolet", 9699539),
    DeepPink("deepPink", 16716947),
    DeepSkyBlue("deepSkyBlue", 49151),
    DimGray("dimGray", 0x696969),
    DodgerBlue("dodgerBlue", 2003199),
    Gold("gold", 16766720),
    Goldenrod("goldenrod", 14329120),
    Gray("gray", 0x808080),
    Green("green", 32768),
    HotPink("hotPink", 16738740),
    IndianRed("indianRed", 0xCD5C5C),
    Indigo("indigo", 4915330),
    Khaki("khaki", 15787660),
    Lavender("lavender", 15132410),
    LemonChiffon("lemonChiffon", 16775885),
    LightGray("lightGray", 0xD3D3D3),
    LightSeaGreen("lightSeaGreen", 2142890),
    LightSteelBlue("lightSteelBlue", 11584734),
    Lime("lime", 65280),
    LimeGreen("limeGreen", 3329330),
    Magenta("magenta", 0xFF00FF),
    Maroon("maroon", 0x800000),
    MediumAquamarine("mediumAquamarine", 6737322),
    MediumOrchid("mediumOrchid", 12211667),
    MediumPurple("mediumPurple", 9662683),
    MediumSeaGreen("mediumSeaGreen", 3978097),
    MediumVioletRed("mediumVioletRed", 13047173),
    MistyRose("mistyRose", 16770273),
    Navy("navy", 128),
    Olive("olive", 0x808000),
    OliveDrab("oliveDrab", 7048739),
    Orange("orange", 16753920),
    PaleGreen("paleGreen", 10025880),
    PaleTurquoise("paleTurquoise", 0xAFEEEE),
    PaleVioletRed("paleVioletRed", 14381203),
    Peru("peru", 13468991),
    Pink("pink", 16761035),
    Plum("plum", 0xDDA0DD),
    Purple("purple", 0x800080),
    Red("red", 0xFF0000),
    RosyBrown("rosyBrown", 12357519),
    RoyalBlue("royalBlue", 4286945),
    Salmon("salmon", 16416882),
    SandyBrown("sandyBrown", 16032864),
    SeaGreen("seaGreen", 3050327),
    Sienna("sienna", 10506797),
    SkyBlue("skyBlue", 8900331),
    SlateBlue("slateBlue", 6970061),
    SlateGray("slateGray", 7372944),
    SpringGreen("springGreen", 65407),
    SteelBlue("steelBlue", 4620980),
    Tan("tan", 13808780),
    Teal("teal", 32896),
    Thistle("thistle", 14204888),
    Turquoise("turquoise", 4251856),
    Violet("violet", 0xEE82EE),
    Wheat("wheat", 16113331),
    White("white", 0xFFFFFF),
    Yellow("yellow", 0xFFFF00),
    YellowGreen("yellowGreen", 10145074);

    int color;
    int colorDis;
    AlleleColor allele;
    String ident;
    public String name = Binnie.Language.get(Botany.instance, "colour." + this.name().toLowerCase());

    private EnumFlowerColor(String ident, int c) {
        this(c);
    }

    private EnumFlowerColor(int c) {
        this.color = c;
        this.allele = new AlleleColor(this, "botany.color" + this.name(), this.toString(), this.color);
        int r = this.color >> 16 & 0xFF;
        int g = this.color >> 8 & 0xFF;
        int b = this.color & 0xFF;
        r = (int)(0.45 * (double)(r + 214));
        g = (int)(0.45 * (double)(r + 174));
        b = (int)(0.45 * (double)(r + 131));
        this.colorDis = (r << 16) + (g << 8) + b;
    }

    @Override
    public int getColor(boolean dis) {
        return dis ? this.colorDis : this.color;
    }

    @Override
    public IAlleleInteger getAllele() {
        return this.allele;
    }

    @Override
    public int getID() {
        return this.ordinal();
    }

    public static void addMix(EnumFlowerColor start1, EnumFlowerColor start2, EnumFlowerColor result, int chance) {
        BotanyCore.getFlowerRoot().registerColourMix(new ColourMix(start1, start2, result, chance));
    }

    /*
     * Opcode count of 14077 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void setupMutations() {
        EnumFlowerColor.addMix(Blue, Aquamarine, SteelBlue, 55);
        EnumFlowerColor.addMix(Blue, Black, Navy, 85);
        EnumFlowerColor.addMix(Brown, Aquamarine, Gray, 50);
        EnumFlowerColor.addMix(Brown, Black, Maroon, 90);
        EnumFlowerColor.addMix(Brown, Blue, Indigo, 85);
        EnumFlowerColor.addMix(CadetBlue, Aquamarine, MediumAquamarine, 100);
        EnumFlowerColor.addMix(CadetBlue, Black, DarkSlateGray, 75);
        EnumFlowerColor.addMix(CadetBlue, Blue, SlateBlue, 85);
        EnumFlowerColor.addMix(Chocolate, Aquamarine, DarkKhaki, 65);
        EnumFlowerColor.addMix(Chocolate, Blue, DarkSlateBlue, 65);
        EnumFlowerColor.addMix(Chocolate, Brown, Sienna, 100);
        EnumFlowerColor.addMix(Coral, Aquamarine, DarkKhaki, 65);
        EnumFlowerColor.addMix(Coral, Black, Sienna, 65);
        EnumFlowerColor.addMix(Coral, Blue, DarkViolet, 65);
        EnumFlowerColor.addMix(Coral, Brown, IndianRed, 95);
        EnumFlowerColor.addMix(Coral, CadetBlue, RosyBrown, 80);
        EnumFlowerColor.addMix(Coral, Chocolate, Peru, 115);
        EnumFlowerColor.addMix(Crimson, Aquamarine, RosyBrown, 45);
        EnumFlowerColor.addMix(Crimson, Black, Maroon, 80);
        EnumFlowerColor.addMix(Crimson, Blue, Indigo, 85);
        EnumFlowerColor.addMix(Crimson, Brown, IndianRed, 115);
        EnumFlowerColor.addMix(Crimson, Chocolate, Red, 100);
        EnumFlowerColor.addMix(Crimson, Coral, IndianRed, 105);
        EnumFlowerColor.addMix(Cyan, Aquamarine, Turquoise, 115);
        EnumFlowerColor.addMix(Cyan, Blue, DodgerBlue, 60);
        EnumFlowerColor.addMix(Cyan, Brown, CadetBlue, 50);
        EnumFlowerColor.addMix(Cyan, CadetBlue, DarkTurquoise, 100);
        EnumFlowerColor.addMix(Cyan, Chocolate, MediumAquamarine, 65);
        EnumFlowerColor.addMix(Cyan, Coral, MediumAquamarine, 65);
        EnumFlowerColor.addMix(Cyan, Crimson, SlateGray, 50);
        EnumFlowerColor.addMix(DarkGoldenrod, Aquamarine, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(DarkGoldenrod, Blue, DarkSlateBlue, 55);
        EnumFlowerColor.addMix(DarkGoldenrod, Brown, Sienna, 85);
        EnumFlowerColor.addMix(DarkGoldenrod, CadetBlue, OliveDrab, 90);
        EnumFlowerColor.addMix(DarkGoldenrod, Chocolate, Peru, 110);
        EnumFlowerColor.addMix(DarkGoldenrod, Coral, Peru, 100);
        EnumFlowerColor.addMix(DarkGoldenrod, Crimson, Sienna, 85);
        EnumFlowerColor.addMix(DarkGoldenrod, Cyan, MediumSeaGreen, 75);
        EnumFlowerColor.addMix(DarkGray, Aquamarine, MediumAquamarine, 95);
        EnumFlowerColor.addMix(DarkGray, Black, DimGray, 70);
        EnumFlowerColor.addMix(DarkGray, Blue, SlateBlue, 75);
        EnumFlowerColor.addMix(DarkGray, Brown, IndianRed, 85);
        EnumFlowerColor.addMix(DarkGray, Chocolate, Peru, 95);
        EnumFlowerColor.addMix(DarkGray, Coral, DarkSalmon, 100);
        EnumFlowerColor.addMix(DarkGray, Crimson, IndianRed, 90);
        EnumFlowerColor.addMix(DarkGray, Cyan, DarkTurquoise, 95);
        EnumFlowerColor.addMix(DarkGray, DarkGoldenrod, DarkKhaki, 100);
        EnumFlowerColor.addMix(DarkGreen, Aquamarine, MediumSeaGreen, 75);
        EnumFlowerColor.addMix(DarkGreen, Blue, DarkSlateBlue, 65);
        EnumFlowerColor.addMix(DarkGreen, CadetBlue, SeaGreen, 90);
        EnumFlowerColor.addMix(DarkGreen, Chocolate, DarkOliveGreen, 70);
        EnumFlowerColor.addMix(DarkGreen, Coral, Olive, 60);
        EnumFlowerColor.addMix(DarkGreen, Crimson, Sienna, 55);
        EnumFlowerColor.addMix(DarkGreen, Cyan, MediumSeaGreen, 70);
        EnumFlowerColor.addMix(DarkGreen, DarkGoldenrod, DarkOliveGreen, 85);
        EnumFlowerColor.addMix(DarkGreen, DarkGray, SeaGreen, 85);
        EnumFlowerColor.addMix(DarkKhaki, Aquamarine, DarkSeaGreen, 100);
        EnumFlowerColor.addMix(DarkKhaki, Black, DarkOliveGreen, 60);
        EnumFlowerColor.addMix(DarkKhaki, Brown, Chocolate, 75);
        EnumFlowerColor.addMix(DarkKhaki, CadetBlue, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(DarkKhaki, Chocolate, Peru, 95);
        EnumFlowerColor.addMix(DarkKhaki, Coral, SandyBrown, 90);
        EnumFlowerColor.addMix(DarkKhaki, Crimson, IndianRed, 75);
        EnumFlowerColor.addMix(DarkKhaki, Cyan, MediumAquamarine, 90);
        EnumFlowerColor.addMix(DarkKhaki, DarkGoldenrod, Goldenrod, 110);
        EnumFlowerColor.addMix(DarkKhaki, DarkGray, Tan, 105);
        EnumFlowerColor.addMix(DarkKhaki, DarkGreen, OliveDrab, 85);
        EnumFlowerColor.addMix(DarkOliveGreen, Aquamarine, MediumSeaGreen, 80);
        EnumFlowerColor.addMix(DarkOliveGreen, Blue, DarkSlateBlue, 50);
        EnumFlowerColor.addMix(DarkOliveGreen, Brown, Sienna, 80);
        EnumFlowerColor.addMix(DarkOliveGreen, CadetBlue, SeaGreen, 95);
        EnumFlowerColor.addMix(DarkOliveGreen, Chocolate, DarkGoldenrod, 85);
        EnumFlowerColor.addMix(DarkOliveGreen, Coral, Peru, 75);
        EnumFlowerColor.addMix(DarkOliveGreen, Crimson, Brown, 70);
        EnumFlowerColor.addMix(DarkOliveGreen, Cyan, LightSeaGreen, 75);
        EnumFlowerColor.addMix(DarkOliveGreen, DarkGoldenrod, Olive, 100);
        EnumFlowerColor.addMix(DarkOliveGreen, DarkGreen, Green, 115);
        EnumFlowerColor.addMix(DarkOliveGreen, DarkKhaki, OliveDrab, 95);
        EnumFlowerColor.addMix(DarkOrange, Aquamarine, DarkKhaki, 70);
        EnumFlowerColor.addMix(DarkOrange, Black, Sienna, 60);
        EnumFlowerColor.addMix(DarkOrange, Blue, Violet, 55);
        EnumFlowerColor.addMix(DarkOrange, Brown, Chocolate, 85);
        EnumFlowerColor.addMix(DarkOrange, CadetBlue, DarkGoldenrod, 80);
        EnumFlowerColor.addMix(DarkOrange, Chocolate, Peru, 115);
        EnumFlowerColor.addMix(DarkOrange, Coral, SandyBrown, 115);
        EnumFlowerColor.addMix(DarkOrange, Crimson, Red, 90);
        EnumFlowerColor.addMix(DarkOrange, Cyan, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(DarkOrange, DarkGoldenrod, Peru, 110);
        EnumFlowerColor.addMix(DarkOrange, DarkGray, Peru, 95);
        EnumFlowerColor.addMix(DarkOrange, DarkGreen, Olive, 70);
        EnumFlowerColor.addMix(DarkOrange, DarkKhaki, Goldenrod, 100);
        EnumFlowerColor.addMix(DarkOrange, DarkOliveGreen, DarkGoldenrod, 80);
        EnumFlowerColor.addMix(DarkSalmon, Aquamarine, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(DarkSalmon, Black, Sienna, 65);
        EnumFlowerColor.addMix(DarkSalmon, Blue, SlateBlue, 70);
        EnumFlowerColor.addMix(DarkSalmon, Brown, IndianRed, 95);
        EnumFlowerColor.addMix(DarkSalmon, CadetBlue, DarkGray, 85);
        EnumFlowerColor.addMix(DarkSalmon, Chocolate, Coral, 110);
        EnumFlowerColor.addMix(DarkSalmon, Coral, Salmon, 120);
        EnumFlowerColor.addMix(DarkSalmon, Crimson, IndianRed, 100);
        EnumFlowerColor.addMix(DarkSalmon, Cyan, MediumAquamarine, 75);
        EnumFlowerColor.addMix(DarkSalmon, DarkGoldenrod, Peru, 100);
        EnumFlowerColor.addMix(DarkSalmon, DarkGray, RosyBrown, 105);
        EnumFlowerColor.addMix(DarkSalmon, DarkGreen, Olive, 65);
        EnumFlowerColor.addMix(DarkSalmon, DarkKhaki, Tan, 95);
        EnumFlowerColor.addMix(DarkSalmon, DarkOliveGreen, Peru, 80);
        EnumFlowerColor.addMix(DarkSalmon, DarkOrange, SandyBrown, 110);
        EnumFlowerColor.addMix(DarkSeaGreen, Aquamarine, MediumAquamarine, 110);
        EnumFlowerColor.addMix(DarkSeaGreen, Black, DarkOliveGreen, 60);
        EnumFlowerColor.addMix(DarkSeaGreen, Blue, RoyalBlue, 60);
        EnumFlowerColor.addMix(DarkSeaGreen, Brown, Sienna, 65);
        EnumFlowerColor.addMix(DarkSeaGreen, CadetBlue, MediumAquamarine, 105);
        EnumFlowerColor.addMix(DarkSeaGreen, Chocolate, DarkGoldenrod, 80);
        EnumFlowerColor.addMix(DarkSeaGreen, Coral, Tan, 80);
        EnumFlowerColor.addMix(DarkSeaGreen, Crimson, IndianRed, 60);
        EnumFlowerColor.addMix(DarkSeaGreen, Cyan, Turquoise, 100);
        EnumFlowerColor.addMix(DarkSeaGreen, DarkGoldenrod, DarkKhaki, 95);
        EnumFlowerColor.addMix(DarkSeaGreen, DarkGreen, SeaGreen, 90);
        EnumFlowerColor.addMix(DarkSeaGreen, DarkKhaki, YellowGreen, 110);
        EnumFlowerColor.addMix(DarkSeaGreen, DarkOliveGreen, OliveDrab, 100);
        EnumFlowerColor.addMix(DarkSeaGreen, DarkOrange, Goldenrod, 85);
        EnumFlowerColor.addMix(DarkSeaGreen, DarkSalmon, Tan, 85);
        EnumFlowerColor.addMix(DarkSlateBlue, Aquamarine, CadetBlue, 60);
        EnumFlowerColor.addMix(DarkSlateBlue, Blue, Indigo, 110);
        EnumFlowerColor.addMix(DarkSlateBlue, Brown, Purple, 90);
        EnumFlowerColor.addMix(DarkSlateBlue, CadetBlue, RoyalBlue, 85);
        EnumFlowerColor.addMix(DarkSlateBlue, Chocolate, Brown, 75);
        EnumFlowerColor.addMix(DarkSlateBlue, Coral, IndianRed, 70);
        EnumFlowerColor.addMix(DarkSlateBlue, Crimson, MediumVioletRed, 90);
        EnumFlowerColor.addMix(DarkSlateBlue, Cyan, DeepSkyBlue, 60);
        EnumFlowerColor.addMix(DarkSlateBlue, DarkGoldenrod, Sienna, 65);
        EnumFlowerColor.addMix(DarkSlateBlue, DarkGreen, DarkSlateGray, 75);
        EnumFlowerColor.addMix(DarkSlateBlue, DarkKhaki, Gray, 55);
        EnumFlowerColor.addMix(DarkSlateBlue, DarkOliveGreen, DimGray, 70);
        EnumFlowerColor.addMix(DarkSlateBlue, DarkOrange, Sienna, 60);
        EnumFlowerColor.addMix(DarkSlateBlue, DarkSeaGreen, SlateGray, 65);
        EnumFlowerColor.addMix(DarkSlateGray, Aquamarine, LightSeaGreen, 70);
        EnumFlowerColor.addMix(DarkSlateGray, Blue, Navy, 95);
        EnumFlowerColor.addMix(DarkSlateGray, CadetBlue, Teal, 95);
        EnumFlowerColor.addMix(DarkSlateGray, Chocolate, Sienna, 80);
        EnumFlowerColor.addMix(DarkSlateGray, Coral, Sienna, 75);
        EnumFlowerColor.addMix(DarkSlateGray, Crimson, Brown, 80);
        EnumFlowerColor.addMix(DarkSlateGray, Cyan, LightSeaGreen, 70);
        EnumFlowerColor.addMix(DarkSlateGray, DarkGoldenrod, DarkOliveGreen, 85);
        EnumFlowerColor.addMix(DarkSlateGray, DarkGray, Gray, 85);
        EnumFlowerColor.addMix(DarkSlateGray, DarkGreen, DarkOliveGreen, 100);
        EnumFlowerColor.addMix(DarkSlateGray, DarkKhaki, DarkOliveGreen, 75);
        EnumFlowerColor.addMix(DarkSlateGray, DarkOrange, DarkGoldenrod, 70);
        EnumFlowerColor.addMix(DarkSlateGray, DarkSalmon, Gray, 75);
        EnumFlowerColor.addMix(DarkSlateGray, DarkSeaGreen, SeaGreen, 80);
        EnumFlowerColor.addMix(DarkTurquoise, Aquamarine, Turquoise, 110);
        EnumFlowerColor.addMix(DarkTurquoise, Black, Teal, 55);
        EnumFlowerColor.addMix(DarkTurquoise, Blue, RoyalBlue, 65);
        EnumFlowerColor.addMix(DarkTurquoise, Brown, Teal, 60);
        EnumFlowerColor.addMix(DarkTurquoise, CadetBlue, LightSeaGreen, 115);
        EnumFlowerColor.addMix(DarkTurquoise, Chocolate, SeaGreen, 70);
        EnumFlowerColor.addMix(DarkTurquoise, Coral, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(DarkTurquoise, Crimson, SlateGray, 55);
        EnumFlowerColor.addMix(DarkTurquoise, Cyan, Turquoise, 115);
        EnumFlowerColor.addMix(DarkTurquoise, DarkGoldenrod, MediumSeaGreen, 80);
        EnumFlowerColor.addMix(DarkTurquoise, DarkGray, LightSeaGreen, 100);
        EnumFlowerColor.addMix(DarkTurquoise, DarkGreen, SeaGreen, 80);
        EnumFlowerColor.addMix(DarkTurquoise, DarkKhaki, MediumAquamarine, 95);
        EnumFlowerColor.addMix(DarkTurquoise, DarkOliveGreen, SeaGreen, 85);
        EnumFlowerColor.addMix(DarkTurquoise, DarkOrange, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(DarkTurquoise, DarkSalmon, LightSeaGreen, 80);
        EnumFlowerColor.addMix(DarkTurquoise, DarkSeaGreen, MediumAquamarine, 105);
        EnumFlowerColor.addMix(DarkTurquoise, DarkSlateBlue, SteelBlue, 70);
        EnumFlowerColor.addMix(DarkTurquoise, DarkSlateGray, Teal, 80);
        EnumFlowerColor.addMix(DarkViolet, Aquamarine, MediumPurple, 60);
        EnumFlowerColor.addMix(DarkViolet, Black, Indigo, 85);
        EnumFlowerColor.addMix(DarkViolet, Brown, Purple, 90);
        EnumFlowerColor.addMix(DarkViolet, CadetBlue, SlateBlue, 90);
        EnumFlowerColor.addMix(DarkViolet, Chocolate, MediumVioletRed, 70);
        EnumFlowerColor.addMix(DarkViolet, Coral, MediumVioletRed, 75);
        EnumFlowerColor.addMix(DarkViolet, Crimson, MediumVioletRed, 90);
        EnumFlowerColor.addMix(DarkViolet, Cyan, SteelBlue, 60);
        EnumFlowerColor.addMix(DarkViolet, DarkGoldenrod, MediumVioletRed, 55);
        EnumFlowerColor.addMix(DarkViolet, DarkGray, MediumOrchid, 85);
        EnumFlowerColor.addMix(DarkViolet, DarkKhaki, MediumOrchid, 50);
        EnumFlowerColor.addMix(DarkViolet, DarkOliveGreen, Purple, 55);
        EnumFlowerColor.addMix(DarkViolet, DarkOrange, IndianRed, 60);
        EnumFlowerColor.addMix(DarkViolet, DarkSalmon, MediumOrchid, 75);
        EnumFlowerColor.addMix(DarkViolet, DarkSeaGreen, MediumOrchid, 70);
        EnumFlowerColor.addMix(DarkViolet, DarkSlateBlue, Indigo, 110);
        EnumFlowerColor.addMix(DarkViolet, DarkSlateGray, Indigo, 100);
        EnumFlowerColor.addMix(DarkViolet, DarkTurquoise, RoyalBlue, 70);
        EnumFlowerColor.addMix(DeepPink, Blue, DarkViolet, 90);
        EnumFlowerColor.addMix(DeepPink, Brown, Crimson, 100);
        EnumFlowerColor.addMix(DeepPink, CadetBlue, MediumVioletRed, 80);
        EnumFlowerColor.addMix(DeepPink, Chocolate, IndianRed, 85);
        EnumFlowerColor.addMix(DeepPink, Coral, IndianRed, 95);
        EnumFlowerColor.addMix(DeepPink, Crimson, IndianRed, 105);
        EnumFlowerColor.addMix(DeepPink, Cyan, MediumPurple, 45);
        EnumFlowerColor.addMix(DeepPink, DarkGoldenrod, IndianRed, 70);
        EnumFlowerColor.addMix(DeepPink, DarkGray, PaleVioletRed, 95);
        EnumFlowerColor.addMix(DeepPink, DarkKhaki, PaleVioletRed, 65);
        EnumFlowerColor.addMix(DeepPink, DarkOliveGreen, MediumVioletRed, 60);
        EnumFlowerColor.addMix(DeepPink, DarkOrange, Salmon, 80);
        EnumFlowerColor.addMix(DeepPink, DarkSalmon, PaleVioletRed, 95);
        EnumFlowerColor.addMix(DeepPink, DarkSeaGreen, PaleVioletRed, 55);
        EnumFlowerColor.addMix(DeepPink, DarkSlateBlue, MediumVioletRed, 90);
        EnumFlowerColor.addMix(DeepPink, DarkSlateGray, MediumVioletRed, 90);
        EnumFlowerColor.addMix(DeepPink, DarkTurquoise, MediumPurple, 55);
        EnumFlowerColor.addMix(DeepPink, DarkViolet, MediumVioletRed, 100);
        EnumFlowerColor.addMix(DeepSkyBlue, Aquamarine, DarkTurquoise, 90);
        EnumFlowerColor.addMix(DeepSkyBlue, Blue, RoyalBlue, 75);
        EnumFlowerColor.addMix(DeepSkyBlue, Brown, SteelBlue, 60);
        EnumFlowerColor.addMix(DeepSkyBlue, CadetBlue, SkyBlue, 105);
        EnumFlowerColor.addMix(DeepSkyBlue, Chocolate, CadetBlue, 70);
        EnumFlowerColor.addMix(DeepSkyBlue, Coral, CadetBlue, 70);
        EnumFlowerColor.addMix(DeepSkyBlue, Crimson, SlateBlue, 60);
        EnumFlowerColor.addMix(DeepSkyBlue, Cyan, SkyBlue, 105);
        EnumFlowerColor.addMix(DeepSkyBlue, DarkGoldenrod, MediumSeaGreen, 70);
        EnumFlowerColor.addMix(DeepSkyBlue, DarkGray, SkyBlue, 105);
        EnumFlowerColor.addMix(DeepSkyBlue, DarkGreen, Teal, 65);
        EnumFlowerColor.addMix(DeepSkyBlue, DarkKhaki, LightSeaGreen, 75);
        EnumFlowerColor.addMix(DeepSkyBlue, DarkOliveGreen, CadetBlue, 70);
        EnumFlowerColor.addMix(DeepSkyBlue, DarkOrange, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(DeepSkyBlue, DarkSalmon, CadetBlue, 80);
        EnumFlowerColor.addMix(DeepSkyBlue, DarkSeaGreen, DarkTurquoise, 85);
        EnumFlowerColor.addMix(DeepSkyBlue, DarkSlateBlue, SteelBlue, 75);
        EnumFlowerColor.addMix(DeepSkyBlue, DarkSlateGray, SteelBlue, 80);
        EnumFlowerColor.addMix(DeepSkyBlue, DarkTurquoise, SkyBlue, 110);
        EnumFlowerColor.addMix(DeepSkyBlue, DarkViolet, RoyalBlue, 70);
        EnumFlowerColor.addMix(DeepSkyBlue, DeepPink, MediumPurple, 55);
        EnumFlowerColor.addMix(DimGray, Aquamarine, MediumAquamarine, 80);
        EnumFlowerColor.addMix(DimGray, Blue, DarkSlateBlue, 90);
        EnumFlowerColor.addMix(DimGray, CadetBlue, SlateGray, 100);
        EnumFlowerColor.addMix(DimGray, Chocolate, Sienna, 95);
        EnumFlowerColor.addMix(DimGray, Coral, IndianRed, 90);
        EnumFlowerColor.addMix(DimGray, Crimson, Brown, 100);
        EnumFlowerColor.addMix(DimGray, Cyan, LightSeaGreen, 80);
        EnumFlowerColor.addMix(DimGray, DarkGoldenrod, Olive, 95);
        EnumFlowerColor.addMix(DimGray, DarkGray, Gray, 105);
        EnumFlowerColor.addMix(DimGray, DarkGreen, DarkOliveGreen, 100);
        EnumFlowerColor.addMix(DimGray, DarkOrange, Peru, 90);
        EnumFlowerColor.addMix(DimGray, DarkSalmon, RosyBrown, 95);
        EnumFlowerColor.addMix(DimGray, DarkTurquoise, CadetBlue, 90);
        EnumFlowerColor.addMix(DimGray, DarkViolet, Purple, 95);
        EnumFlowerColor.addMix(DimGray, DeepPink, MediumVioletRed, 95);
        EnumFlowerColor.addMix(DimGray, DeepSkyBlue, SteelBlue, 90);
        EnumFlowerColor.addMix(DodgerBlue, Aquamarine, SkyBlue, 80);
        EnumFlowerColor.addMix(DodgerBlue, Black, DarkSlateBlue, 75);
        EnumFlowerColor.addMix(DodgerBlue, Blue, SlateBlue, 90);
        EnumFlowerColor.addMix(DodgerBlue, Brown, SlateBlue, 75);
        EnumFlowerColor.addMix(DodgerBlue, CadetBlue, SteelBlue, 100);
        EnumFlowerColor.addMix(DodgerBlue, Chocolate, SlateGray, 75);
        EnumFlowerColor.addMix(DodgerBlue, Crimson, SlateBlue, 75);
        EnumFlowerColor.addMix(DodgerBlue, Cyan, DeepSkyBlue, 85);
        EnumFlowerColor.addMix(DodgerBlue, DarkGoldenrod, CadetBlue, 70);
        EnumFlowerColor.addMix(DodgerBlue, DarkGray, SteelBlue, 100);
        EnumFlowerColor.addMix(DodgerBlue, DarkGreen, Teal, 65);
        EnumFlowerColor.addMix(DodgerBlue, DarkKhaki, CadetBlue, 65);
        EnumFlowerColor.addMix(DodgerBlue, DarkOliveGreen, SteelBlue, 70);
        EnumFlowerColor.addMix(DodgerBlue, DarkOrange, Gray, 70);
        EnumFlowerColor.addMix(DodgerBlue, DarkSalmon, SlateGray, 80);
        EnumFlowerColor.addMix(DodgerBlue, DarkSeaGreen, DeepSkyBlue, 80);
        EnumFlowerColor.addMix(DodgerBlue, DarkSlateBlue, RoyalBlue, 90);
        EnumFlowerColor.addMix(DodgerBlue, DarkSlateGray, SteelBlue, 90);
        EnumFlowerColor.addMix(DodgerBlue, DarkTurquoise, DeepSkyBlue, 95);
        EnumFlowerColor.addMix(DodgerBlue, DarkViolet, SlateBlue, 90);
        EnumFlowerColor.addMix(DodgerBlue, DeepPink, SlateBlue, 80);
        EnumFlowerColor.addMix(DodgerBlue, DimGray, SteelBlue, 95);
        EnumFlowerColor.addMix(Gold, Aquamarine, YellowGreen, 90);
        EnumFlowerColor.addMix(Gold, Brown, Peru, 65);
        EnumFlowerColor.addMix(Gold, CadetBlue, DarkKhaki, 85);
        EnumFlowerColor.addMix(Gold, Chocolate, Orange, 90);
        EnumFlowerColor.addMix(Gold, Coral, Orange, 90);
        EnumFlowerColor.addMix(Gold, Crimson, Chocolate, 65);
        EnumFlowerColor.addMix(Gold, Cyan, PaleGreen, 80);
        EnumFlowerColor.addMix(Gold, DarkGoldenrod, Goldenrod, 105);
        EnumFlowerColor.addMix(Gold, DarkGray, DarkKhaki, 95);
        EnumFlowerColor.addMix(Gold, DarkGreen, OliveDrab, 75);
        EnumFlowerColor.addMix(Gold, DarkKhaki, Khaki, 110);
        EnumFlowerColor.addMix(Gold, DarkOliveGreen, DarkKhaki, 85);
        EnumFlowerColor.addMix(Gold, DarkOrange, Orange, 100);
        EnumFlowerColor.addMix(Gold, DarkSalmon, Goldenrod, 90);
        EnumFlowerColor.addMix(Gold, DarkSeaGreen, DarkKhaki, 95);
        EnumFlowerColor.addMix(Gold, DarkSlateGray, Olive, 65);
        EnumFlowerColor.addMix(Gold, DarkTurquoise, LimeGreen, 80);
        EnumFlowerColor.addMix(Gold, DeepPink, Coral, 55);
        EnumFlowerColor.addMix(Gold, DeepSkyBlue, DarkSeaGreen, 65);
        EnumFlowerColor.addMix(Gold, DimGray, DarkKhaki, 80);
        EnumFlowerColor.addMix(Gold, DodgerBlue, DarkSeaGreen, 60);
        EnumFlowerColor.addMix(Goldenrod, Aquamarine, YellowGreen, 85);
        EnumFlowerColor.addMix(Goldenrod, Blue, DarkSlateBlue, 45);
        EnumFlowerColor.addMix(Goldenrod, Brown, Chocolate, 80);
        EnumFlowerColor.addMix(Goldenrod, CadetBlue, DarkKhaki, 90);
        EnumFlowerColor.addMix(Goldenrod, Chocolate, Peru, 105);
        EnumFlowerColor.addMix(Goldenrod, Coral, DarkOrange, 100);
        EnumFlowerColor.addMix(Goldenrod, Crimson, Chocolate, 80);
        EnumFlowerColor.addMix(Goldenrod, Cyan, MediumAquamarine, 80);
        EnumFlowerColor.addMix(Goldenrod, DarkGoldenrod, Orange, 115);
        EnumFlowerColor.addMix(Goldenrod, DarkGray, DarkKhaki, 100);
        EnumFlowerColor.addMix(Goldenrod, DarkGreen, OliveDrab, 80);
        EnumFlowerColor.addMix(Goldenrod, DarkKhaki, DarkGoldenrod, 110);
        EnumFlowerColor.addMix(Goldenrod, DarkOliveGreen, Olive, 90);
        EnumFlowerColor.addMix(Goldenrod, DarkOrange, Orange, 110);
        EnumFlowerColor.addMix(Goldenrod, DarkSalmon, SandyBrown, 100);
        EnumFlowerColor.addMix(Goldenrod, DarkSeaGreen, DarkKhaki, 95);
        EnumFlowerColor.addMix(Goldenrod, DarkSlateGray, Olive, 75);
        EnumFlowerColor.addMix(Goldenrod, DarkTurquoise, MediumSeaGreen, 80);
        EnumFlowerColor.addMix(Goldenrod, DarkViolet, MediumVioletRed, 50);
        EnumFlowerColor.addMix(Goldenrod, DeepPink, IndianRed, 65);
        EnumFlowerColor.addMix(Goldenrod, DeepSkyBlue, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(Goldenrod, DimGray, DarkGoldenrod, 90);
        EnumFlowerColor.addMix(Goldenrod, DodgerBlue, CadetBlue, 65);
        EnumFlowerColor.addMix(Goldenrod, Gold, Orange, 115);
        EnumFlowerColor.addMix(Gray, Aquamarine, MediumAquamarine, 90);
        EnumFlowerColor.addMix(Gray, Blue, DarkSlateBlue, 85);
        EnumFlowerColor.addMix(Gray, CadetBlue, SlateGray, 105);
        EnumFlowerColor.addMix(Gray, Chocolate, Peru, 100);
        EnumFlowerColor.addMix(Gray, Coral, DarkSalmon, 95);
        EnumFlowerColor.addMix(Gray, Crimson, IndianRed, 95);
        EnumFlowerColor.addMix(Gray, Cyan, DarkTurquoise, 90);
        EnumFlowerColor.addMix(Gray, DarkGoldenrod, Olive, 100);
        EnumFlowerColor.addMix(Gray, DarkGray, SlateGray, 115);
        EnumFlowerColor.addMix(Gray, DarkGreen, DarkOliveGreen, 95);
        EnumFlowerColor.addMix(Gray, DarkOrange, Peru, 95);
        EnumFlowerColor.addMix(Gray, DarkSalmon, RosyBrown, 100);
        EnumFlowerColor.addMix(Gray, DarkSlateGray, DimGray, 100);
        EnumFlowerColor.addMix(Gray, DarkTurquoise, CadetBlue, 95);
        EnumFlowerColor.addMix(Gray, DarkViolet, Purple, 90);
        EnumFlowerColor.addMix(Gray, DeepPink, MediumVioletRed, 95);
        EnumFlowerColor.addMix(Gray, DeepSkyBlue, CadetBlue, 100);
        EnumFlowerColor.addMix(Gray, DimGray, SlateGray, 120);
        EnumFlowerColor.addMix(Gray, DodgerBlue, SteelBlue, 100);
        EnumFlowerColor.addMix(Gray, Gold, DarkKhaki, 85);
        EnumFlowerColor.addMix(Gray, Goldenrod, DarkGoldenrod, 95);
        EnumFlowerColor.addMix(Green, Aquamarine, MediumSeaGreen, 85);
        EnumFlowerColor.addMix(Green, Black, DarkGreen, 85);
        EnumFlowerColor.addMix(Green, Blue, DarkSlateBlue, 60);
        EnumFlowerColor.addMix(Green, Brown, DarkOliveGreen, 60);
        EnumFlowerColor.addMix(Green, CadetBlue, SeaGreen, 95);
        EnumFlowerColor.addMix(Green, Chocolate, Olive, 70);
        EnumFlowerColor.addMix(Green, Coral, Olive, 65);
        EnumFlowerColor.addMix(Green, Cyan, MediumSeaGreen, 80);
        EnumFlowerColor.addMix(Green, DarkGoldenrod, OliveDrab, 90);
        EnumFlowerColor.addMix(Green, DarkGray, SeaGreen, 90);
        EnumFlowerColor.addMix(Green, DarkGreen, DarkOliveGreen, 120);
        EnumFlowerColor.addMix(Green, DarkKhaki, OliveDrab, 95);
        EnumFlowerColor.addMix(Green, DarkOliveGreen, DarkGreen, 115);
        EnumFlowerColor.addMix(Green, DarkOrange, Olive, 70);
        EnumFlowerColor.addMix(Green, DarkSalmon, OliveDrab, 70);
        EnumFlowerColor.addMix(Green, DarkSeaGreen, MediumSeaGreen, 100);
        EnumFlowerColor.addMix(Green, DarkSlateBlue, DarkSlateGray, 70);
        EnumFlowerColor.addMix(Green, DarkSlateGray, DarkGreen, 95);
        EnumFlowerColor.addMix(Green, DarkTurquoise, MediumSeaGreen, 85);
        EnumFlowerColor.addMix(Green, DeepSkyBlue, SeaGreen, 70);
        EnumFlowerColor.addMix(Green, DimGray, DarkGreen, 100);
        EnumFlowerColor.addMix(Green, DodgerBlue, Teal, 65);
        EnumFlowerColor.addMix(Green, Gold, YellowGreen, 80);
        EnumFlowerColor.addMix(Green, Goldenrod, OliveDrab, 85);
        EnumFlowerColor.addMix(Green, Gray, SeaGreen, 100);
        EnumFlowerColor.addMix(HotPink, Aquamarine, Thistle, 50);
        EnumFlowerColor.addMix(HotPink, Blue, DarkViolet, 80);
        EnumFlowerColor.addMix(HotPink, Brown, IndianRed, 90);
        EnumFlowerColor.addMix(HotPink, CadetBlue, Plum, 85);
        EnumFlowerColor.addMix(HotPink, Chocolate, IndianRed, 85);
        EnumFlowerColor.addMix(HotPink, Coral, Salmon, 95);
        EnumFlowerColor.addMix(HotPink, Crimson, DeepPink, 100);
        EnumFlowerColor.addMix(HotPink, Cyan, SkyBlue, 55);
        EnumFlowerColor.addMix(HotPink, DarkGoldenrod, Salmon, 70);
        EnumFlowerColor.addMix(HotPink, DarkGray, PaleVioletRed, 100);
        EnumFlowerColor.addMix(HotPink, DarkKhaki, RosyBrown, 70);
        EnumFlowerColor.addMix(HotPink, DarkOliveGreen, IndianRed, 60);
        EnumFlowerColor.addMix(HotPink, DarkOrange, Coral, 80);
        EnumFlowerColor.addMix(HotPink, DarkSalmon, PaleVioletRed, 100);
        EnumFlowerColor.addMix(HotPink, DarkSeaGreen, RosyBrown, 60);
        EnumFlowerColor.addMix(HotPink, DarkSlateBlue, MediumOrchid, 85);
        EnumFlowerColor.addMix(HotPink, DarkTurquoise, DodgerBlue, 60);
        EnumFlowerColor.addMix(HotPink, DarkViolet, MediumOrchid, 95);
        EnumFlowerColor.addMix(HotPink, DeepPink, PaleVioletRed, 115);
        EnumFlowerColor.addMix(HotPink, DeepSkyBlue, DodgerBlue, 65);
        EnumFlowerColor.addMix(HotPink, DimGray, PaleVioletRed, 95);
        EnumFlowerColor.addMix(HotPink, DodgerBlue, MediumPurple, 85);
        EnumFlowerColor.addMix(HotPink, Gold, SandyBrown, 60);
        EnumFlowerColor.addMix(HotPink, Goldenrod, DarkSalmon, 70);
        EnumFlowerColor.addMix(HotPink, Gray, PaleVioletRed, 100);
        EnumFlowerColor.addMix(IndianRed, Aquamarine, DarkGray, 55);
        EnumFlowerColor.addMix(IndianRed, Black, Maroon, 80);
        EnumFlowerColor.addMix(IndianRed, Blue, DarkViolet, 80);
        EnumFlowerColor.addMix(IndianRed, Brown, Crimson, 110);
        EnumFlowerColor.addMix(IndianRed, CadetBlue, RosyBrown, 80);
        EnumFlowerColor.addMix(IndianRed, Chocolate, Red, 105);
        EnumFlowerColor.addMix(IndianRed, Coral, Salmon, 110);
        EnumFlowerColor.addMix(IndianRed, Crimson, Brown, 115);
        EnumFlowerColor.addMix(IndianRed, Cyan, CadetBlue, 60);
        EnumFlowerColor.addMix(IndianRed, DarkGoldenrod, Chocolate, 90);
        EnumFlowerColor.addMix(IndianRed, DarkGray, RosyBrown, 100);
        EnumFlowerColor.addMix(IndianRed, DarkGreen, DarkOliveGreen, 60);
        EnumFlowerColor.addMix(IndianRed, DarkKhaki, Peru, 85);
        EnumFlowerColor.addMix(IndianRed, DarkOliveGreen, Sienna, 80);
        EnumFlowerColor.addMix(IndianRed, DarkOrange, Chocolate, 95);
        EnumFlowerColor.addMix(IndianRed, DarkSalmon, Salmon, 110);
        EnumFlowerColor.addMix(IndianRed, DarkSeaGreen, Peru, 75);
        EnumFlowerColor.addMix(IndianRed, DarkSlateBlue, MediumVioletRed, 90);
        EnumFlowerColor.addMix(IndianRed, DarkTurquoise, CadetBlue, 65);
        EnumFlowerColor.addMix(IndianRed, DarkViolet, MediumVioletRed, 90);
        EnumFlowerColor.addMix(IndianRed, DeepPink, PaleVioletRed, 110);
        EnumFlowerColor.addMix(IndianRed, DeepSkyBlue, SteelBlue, 70);
        EnumFlowerColor.addMix(IndianRed, DodgerBlue, MediumPurple, 80);
        EnumFlowerColor.addMix(IndianRed, Gold, Orange, 75);
        EnumFlowerColor.addMix(IndianRed, Goldenrod, Peru, 85);
        EnumFlowerColor.addMix(IndianRed, Gray, RosyBrown, 100);
        EnumFlowerColor.addMix(IndianRed, Green, DarkOliveGreen, 60);
        EnumFlowerColor.addMix(IndianRed, HotPink, PaleVioletRed, 105);
        EnumFlowerColor.addMix(Indigo, Black, Navy, 95);
        EnumFlowerColor.addMix(Indigo, Blue, Navy, 110);
        EnumFlowerColor.addMix(Indigo, Brown, Purple, 90);
        EnumFlowerColor.addMix(Indigo, CadetBlue, DarkSlateBlue, 80);
        EnumFlowerColor.addMix(Indigo, Coral, MediumVioletRed, 65);
        EnumFlowerColor.addMix(Indigo, Crimson, Purple, 85);
        EnumFlowerColor.addMix(Indigo, DarkGoldenrod, Brown, 55);
        EnumFlowerColor.addMix(Indigo, DarkGray, SlateBlue, 70);
        EnumFlowerColor.addMix(Indigo, DarkOrange, Brown, 55);
        EnumFlowerColor.addMix(Indigo, DarkSalmon, MediumVioletRed, 65);
        EnumFlowerColor.addMix(Indigo, DarkSlateBlue, Navy, 115);
        EnumFlowerColor.addMix(Indigo, DarkSlateGray, DarkSlateBlue, 100);
        EnumFlowerColor.addMix(Indigo, DarkTurquoise, RoyalBlue, 55);
        EnumFlowerColor.addMix(Indigo, DarkViolet, Purple, 110);
        EnumFlowerColor.addMix(Indigo, DeepPink, Purple, 90);
        EnumFlowerColor.addMix(Indigo, DeepSkyBlue, RoyalBlue, 60);
        EnumFlowerColor.addMix(Indigo, DimGray, DarkSlateBlue, 90);
        EnumFlowerColor.addMix(Indigo, DodgerBlue, SlateBlue, 80);
        EnumFlowerColor.addMix(Indigo, Goldenrod, Brown, 45);
        EnumFlowerColor.addMix(Indigo, Gray, DarkSlateBlue, 85);
        EnumFlowerColor.addMix(Indigo, Green, DarkSlateGray, 65);
        EnumFlowerColor.addMix(Indigo, HotPink, MediumVioletRed, 80);
        EnumFlowerColor.addMix(Indigo, IndianRed, Purple, 85);
        EnumFlowerColor.addMix(Khaki, Aquamarine, PaleGreen, 100);
        EnumFlowerColor.addMix(Khaki, Brown, Peru, 65);
        EnumFlowerColor.addMix(Khaki, CadetBlue, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(Khaki, Chocolate, Goldenrod, 85);
        EnumFlowerColor.addMix(Khaki, Coral, SandyBrown, 90);
        EnumFlowerColor.addMix(Khaki, Crimson, Salmon, 65);
        EnumFlowerColor.addMix(Khaki, Cyan, Aquamarine, 90);
        EnumFlowerColor.addMix(Khaki, DarkGoldenrod, Goldenrod, 100);
        EnumFlowerColor.addMix(Khaki, DarkGray, DarkKhaki, 100);
        EnumFlowerColor.addMix(Khaki, DarkGreen, OliveDrab, 75);
        EnumFlowerColor.addMix(Khaki, DarkKhaki, Wheat, 115);
        EnumFlowerColor.addMix(Khaki, DarkOliveGreen, DarkKhaki, 85);
        EnumFlowerColor.addMix(Khaki, DarkOrange, Goldenrod, 95);
        EnumFlowerColor.addMix(Khaki, DarkSalmon, Tan, 95);
        EnumFlowerColor.addMix(Khaki, DarkSeaGreen, DarkKhaki, 105);
        EnumFlowerColor.addMix(Khaki, DarkSlateBlue, Gray, 50);
        EnumFlowerColor.addMix(Khaki, DarkSlateGray, DarkSeaGreen, 65);
        EnumFlowerColor.addMix(Khaki, DarkTurquoise, MediumAquamarine, 90);
        EnumFlowerColor.addMix(Khaki, DeepPink, PaleVioletRed, 60);
        EnumFlowerColor.addMix(Khaki, DeepSkyBlue, Turquoise, 75);
        EnumFlowerColor.addMix(Khaki, DimGray, DarkKhaki, 85);
        EnumFlowerColor.addMix(Khaki, DodgerBlue, SkyBlue, 60);
        EnumFlowerColor.addMix(Khaki, Gold, Yellow, 115);
        EnumFlowerColor.addMix(Khaki, Goldenrod, Gold, 110);
        EnumFlowerColor.addMix(Khaki, Gray, DarkKhaki, 90);
        EnumFlowerColor.addMix(Khaki, Green, YellowGreen, 85);
        EnumFlowerColor.addMix(Khaki, HotPink, DarkSalmon, 65);
        EnumFlowerColor.addMix(Khaki, IndianRed, SandyBrown, 75);
        EnumFlowerColor.addMix(Lavender, Aquamarine, PaleTurquoise, 95);
        EnumFlowerColor.addMix(Lavender, Blue, MediumPurple, 65);
        EnumFlowerColor.addMix(Lavender, Brown, RosyBrown, 70);
        EnumFlowerColor.addMix(Lavender, CadetBlue, SkyBlue, 95);
        EnumFlowerColor.addMix(Lavender, Chocolate, DarkSalmon, 85);
        EnumFlowerColor.addMix(Lavender, Coral, DarkSalmon, 90);
        EnumFlowerColor.addMix(Lavender, Crimson, PaleVioletRed, 80);
        EnumFlowerColor.addMix(Lavender, Cyan, PaleTurquoise, 95);
        EnumFlowerColor.addMix(Lavender, DarkGoldenrod, Tan, 85);
        EnumFlowerColor.addMix(Lavender, DarkGray, LightGray, 110);
        EnumFlowerColor.addMix(Lavender, DarkGreen, DarkSeaGreen, 65);
        EnumFlowerColor.addMix(Lavender, DarkKhaki, Wheat, 90);
        EnumFlowerColor.addMix(Lavender, DarkOliveGreen, DarkGray, 75);
        EnumFlowerColor.addMix(Lavender, DarkOrange, SandyBrown, 85);
        EnumFlowerColor.addMix(Lavender, DarkSalmon, Pink, 95);
        EnumFlowerColor.addMix(Lavender, DarkSeaGreen, PaleTurquoise, 95);
        EnumFlowerColor.addMix(Lavender, DarkSlateBlue, MediumPurple, 70);
        EnumFlowerColor.addMix(Lavender, DarkSlateGray, DarkGray, 70);
        EnumFlowerColor.addMix(Lavender, DarkTurquoise, PaleTurquoise, 95);
        EnumFlowerColor.addMix(Lavender, DarkViolet, MediumOrchid, 75);
        EnumFlowerColor.addMix(Lavender, DeepPink, HotPink, 85);
        EnumFlowerColor.addMix(Lavender, DeepSkyBlue, SkyBlue, 95);
        EnumFlowerColor.addMix(Lavender, DimGray, DarkGray, 85);
        EnumFlowerColor.addMix(Lavender, DodgerBlue, LightSteelBlue, 95);
        EnumFlowerColor.addMix(Lavender, Gold, Khaki, 85);
        EnumFlowerColor.addMix(Lavender, Goldenrod, Tan, 85);
        EnumFlowerColor.addMix(Lavender, Gray, DarkGray, 95);
        EnumFlowerColor.addMix(Lavender, Green, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(Lavender, HotPink, Plum, 95);
        EnumFlowerColor.addMix(Lavender, IndianRed, RosyBrown, 85);
        EnumFlowerColor.addMix(Lavender, Indigo, MediumPurple, 55);
        EnumFlowerColor.addMix(Lavender, Khaki, LemonChiffon, 90);
        EnumFlowerColor.addMix(LemonChiffon, Aquamarine, PaleGreen, 105);
        EnumFlowerColor.addMix(LemonChiffon, Blue, MediumPurple, 45);
        EnumFlowerColor.addMix(LemonChiffon, Brown, DarkSalmon, 65);
        EnumFlowerColor.addMix(LemonChiffon, CadetBlue, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(LemonChiffon, Chocolate, SandyBrown, 85);
        EnumFlowerColor.addMix(LemonChiffon, Coral, SandyBrown, 90);
        EnumFlowerColor.addMix(LemonChiffon, Crimson, Salmon, 70);
        EnumFlowerColor.addMix(LemonChiffon, Cyan, Aquamarine, 95);
        EnumFlowerColor.addMix(LemonChiffon, DarkGoldenrod, DarkKhaki, 95);
        EnumFlowerColor.addMix(LemonChiffon, DarkGray, LightGray, 100);
        EnumFlowerColor.addMix(LemonChiffon, DarkGreen, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(LemonChiffon, DarkKhaki, Khaki, 110);
        EnumFlowerColor.addMix(LemonChiffon, DarkOliveGreen, DarkKhaki, 80);
        EnumFlowerColor.addMix(LemonChiffon, DarkOrange, Orange, 95);
        EnumFlowerColor.addMix(LemonChiffon, DarkSalmon, Tan, 95);
        EnumFlowerColor.addMix(LemonChiffon, DarkSeaGreen, Khaki, 105);
        EnumFlowerColor.addMix(LemonChiffon, DarkSlateBlue, DarkGray, 55);
        EnumFlowerColor.addMix(LemonChiffon, DarkSlateGray, DarkSeaGreen, 65);
        EnumFlowerColor.addMix(LemonChiffon, DarkTurquoise, Turquoise, 95);
        EnumFlowerColor.addMix(LemonChiffon, DarkViolet, Violet, 50);
        EnumFlowerColor.addMix(LemonChiffon, DeepPink, HotPink, 65);
        EnumFlowerColor.addMix(LemonChiffon, DeepSkyBlue, PaleTurquoise, 80);
        EnumFlowerColor.addMix(LemonChiffon, DimGray, DarkGray, 80);
        EnumFlowerColor.addMix(LemonChiffon, DodgerBlue, SkyBlue, 70);
        EnumFlowerColor.addMix(LemonChiffon, Gold, Khaki, 105);
        EnumFlowerColor.addMix(LemonChiffon, Goldenrod, Khaki, 100);
        EnumFlowerColor.addMix(LemonChiffon, Gray, DarkGray, 90);
        EnumFlowerColor.addMix(LemonChiffon, Green, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(LemonChiffon, HotPink, Pink, 75);
        EnumFlowerColor.addMix(LemonChiffon, IndianRed, DarkSalmon, 80);
        EnumFlowerColor.addMix(LemonChiffon, Khaki, Wheat, 115);
        EnumFlowerColor.addMix(LightGray, Aquamarine, PaleTurquoise, 100);
        EnumFlowerColor.addMix(LightGray, Black, DimGray, 45);
        EnumFlowerColor.addMix(LightGray, Blue, RoyalBlue, 65);
        EnumFlowerColor.addMix(LightGray, Brown, RosyBrown, 75);
        EnumFlowerColor.addMix(LightGray, CadetBlue, SkyBlue, 100);
        EnumFlowerColor.addMix(LightGray, Chocolate, SandyBrown, 90);
        EnumFlowerColor.addMix(LightGray, Coral, DarkSalmon, 95);
        EnumFlowerColor.addMix(LightGray, Crimson, PaleVioletRed, 85);
        EnumFlowerColor.addMix(LightGray, Cyan, Turquoise, 100);
        EnumFlowerColor.addMix(LightGray, DarkGoldenrod, Tan, 95);
        EnumFlowerColor.addMix(LightGray, DarkGray, LightSteelBlue, 115);
        EnumFlowerColor.addMix(LightGray, DarkGreen, SeaGreen, 75);
        EnumFlowerColor.addMix(LightGray, DarkKhaki, Wheat, 105);
        EnumFlowerColor.addMix(LightGray, DarkOliveGreen, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(LightGray, DarkOrange, SandyBrown, 95);
        EnumFlowerColor.addMix(LightGray, DarkSalmon, RosyBrown, 100);
        EnumFlowerColor.addMix(LightGray, DarkSlateGray, Gray, 75);
        EnumFlowerColor.addMix(LightGray, DarkTurquoise, Turquoise, 100);
        EnumFlowerColor.addMix(LightGray, DarkViolet, MediumOrchid, 75);
        EnumFlowerColor.addMix(LightGray, DeepPink, HotPink, 90);
        EnumFlowerColor.addMix(LightGray, DeepSkyBlue, SkyBlue, 100);
        EnumFlowerColor.addMix(LightGray, DimGray, DarkGray, 95);
        EnumFlowerColor.addMix(LightGray, DodgerBlue, DeepSkyBlue, 95);
        EnumFlowerColor.addMix(LightGray, Gold, Khaki, 95);
        EnumFlowerColor.addMix(LightGray, Goldenrod, DarkKhaki, 100);
        EnumFlowerColor.addMix(LightGray, Gray, DarkGray, 100);
        EnumFlowerColor.addMix(LightGray, Green, MediumSeaGreen, 85);
        EnumFlowerColor.addMix(LightGray, HotPink, Plum, 95);
        EnumFlowerColor.addMix(LightGray, IndianRed, RosyBrown, 90);
        EnumFlowerColor.addMix(LightGray, Indigo, MediumPurple, 55);
        EnumFlowerColor.addMix(LightGray, Khaki, LemonChiffon, 105);
        EnumFlowerColor.addMix(LightGray, LemonChiffon, Wheat, 110);
        EnumFlowerColor.addMix(LightSeaGreen, Aquamarine, Turquoise, 105);
        EnumFlowerColor.addMix(LightSeaGreen, Black, DarkSlateGray, 65);
        EnumFlowerColor.addMix(LightSeaGreen, Blue, RoyalBlue, 70);
        EnumFlowerColor.addMix(LightSeaGreen, Brown, DimGray, 60);
        EnumFlowerColor.addMix(LightSeaGreen, CadetBlue, DarkTurquoise, 120);
        EnumFlowerColor.addMix(LightSeaGreen, Chocolate, OliveDrab, 75);
        EnumFlowerColor.addMix(LightSeaGreen, Cyan, DarkTurquoise, 110);
        EnumFlowerColor.addMix(LightSeaGreen, DarkGoldenrod, OliveDrab, 85);
        EnumFlowerColor.addMix(LightSeaGreen, DarkGray, CadetBlue, 105);
        EnumFlowerColor.addMix(LightSeaGreen, DarkGreen, SeaGreen, 90);
        EnumFlowerColor.addMix(LightSeaGreen, DarkKhaki, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(LightSeaGreen, DarkOliveGreen, SeaGreen, 95);
        EnumFlowerColor.addMix(LightSeaGreen, DarkOrange, OliveDrab, 75);
        EnumFlowerColor.addMix(LightSeaGreen, DarkSalmon, CadetBlue, 80);
        EnumFlowerColor.addMix(LightSeaGreen, DarkSeaGreen, MediumAquamarine, 110);
        EnumFlowerColor.addMix(LightSeaGreen, DarkSlateBlue, SteelBlue, 75);
        EnumFlowerColor.addMix(LightSeaGreen, DarkSlateGray, Teal, 90);
        EnumFlowerColor.addMix(LightSeaGreen, DarkTurquoise, Turquoise, 120);
        EnumFlowerColor.addMix(LightSeaGreen, DarkViolet, SlateBlue, 75);
        EnumFlowerColor.addMix(LightSeaGreen, DeepPink, MediumOrchid, 65);
        EnumFlowerColor.addMix(LightSeaGreen, DeepSkyBlue, SkyBlue, 105);
        EnumFlowerColor.addMix(LightSeaGreen, DimGray, Teal, 95);
        EnumFlowerColor.addMix(LightSeaGreen, DodgerBlue, DeepSkyBlue, 95);
        EnumFlowerColor.addMix(LightSeaGreen, Gold, YellowGreen, 85);
        EnumFlowerColor.addMix(LightSeaGreen, Goldenrod, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(LightSeaGreen, Gray, CadetBlue, 100);
        EnumFlowerColor.addMix(LightSeaGreen, Green, SeaGreen, 95);
        EnumFlowerColor.addMix(LightSeaGreen, IndianRed, Gray, 70);
        EnumFlowerColor.addMix(LightSeaGreen, Indigo, RoyalBlue, 65);
        EnumFlowerColor.addMix(LightSeaGreen, Khaki, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(LightSeaGreen, Lavender, DarkTurquoise, 95);
        EnumFlowerColor.addMix(LightSeaGreen, LemonChiffon, MediumAquamarine, 95);
        EnumFlowerColor.addMix(LightSeaGreen, LightGray, DarkTurquoise, 100);
        EnumFlowerColor.addMix(LightSteelBlue, Aquamarine, PaleTurquoise, 95);
        EnumFlowerColor.addMix(LightSteelBlue, Black, DimGray, 55);
        EnumFlowerColor.addMix(LightSteelBlue, Blue, RoyalBlue, 80);
        EnumFlowerColor.addMix(LightSteelBlue, Brown, RosyBrown, 75);
        EnumFlowerColor.addMix(LightSteelBlue, CadetBlue, SkyBlue, 105);
        EnumFlowerColor.addMix(LightSteelBlue, Chocolate, DarkSalmon, 85);
        EnumFlowerColor.addMix(LightSteelBlue, Coral, RosyBrown, 90);
        EnumFlowerColor.addMix(LightSteelBlue, Crimson, PaleVioletRed, 80);
        EnumFlowerColor.addMix(LightSteelBlue, Cyan, DarkTurquoise, 100);
        EnumFlowerColor.addMix(LightSteelBlue, DarkGoldenrod, DarkKhaki, 85);
        EnumFlowerColor.addMix(LightSteelBlue, DarkGray, LightGray, 115);
        EnumFlowerColor.addMix(LightSteelBlue, DarkGreen, SeaGreen, 70);
        EnumFlowerColor.addMix(LightSteelBlue, DarkKhaki, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(LightSteelBlue, DarkOliveGreen, CadetBlue, 80);
        EnumFlowerColor.addMix(LightSteelBlue, DarkOrange, Tan, 85);
        EnumFlowerColor.addMix(LightSteelBlue, DarkSalmon, RosyBrown, 95);
        EnumFlowerColor.addMix(LightSteelBlue, DarkSeaGreen, MediumAquamarine, 95);
        EnumFlowerColor.addMix(LightSteelBlue, DarkSlateBlue, MediumPurple, 80);
        EnumFlowerColor.addMix(LightSteelBlue, DarkSlateGray, SlateGray, 80);
        EnumFlowerColor.addMix(LightSteelBlue, DarkTurquoise, SkyBlue, 105);
        EnumFlowerColor.addMix(LightSteelBlue, DarkViolet, MediumPurple, 85);
        EnumFlowerColor.addMix(LightSteelBlue, DeepPink, HotPink, 85);
        EnumFlowerColor.addMix(LightSteelBlue, DeepSkyBlue, SkyBlue, 110);
        EnumFlowerColor.addMix(LightSteelBlue, DimGray, SlateGray, 95);
        EnumFlowerColor.addMix(LightSteelBlue, DodgerBlue, DeepSkyBlue, 105);
        EnumFlowerColor.addMix(LightSteelBlue, Gold, Khaki, 80);
        EnumFlowerColor.addMix(LightSteelBlue, Goldenrod, DarkKhaki, 85);
        EnumFlowerColor.addMix(LightSteelBlue, Gray, DarkGray, 105);
        EnumFlowerColor.addMix(LightSteelBlue, Green, MediumSeaGreen, 75);
        EnumFlowerColor.addMix(LightSteelBlue, HotPink, Plum, 90);
        EnumFlowerColor.addMix(LightSteelBlue, IndianRed, RosyBrown, 85);
        EnumFlowerColor.addMix(LightSteelBlue, Indigo, SlateBlue, 65);
        EnumFlowerColor.addMix(LightSteelBlue, Khaki, LemonChiffon, 85);
        EnumFlowerColor.addMix(LightSteelBlue, Lavender, LightGray, 115);
        EnumFlowerColor.addMix(LightSteelBlue, LemonChiffon, LightGray, 95);
        EnumFlowerColor.addMix(LightSteelBlue, LightGray, Lavender, 115);
        EnumFlowerColor.addMix(LightSteelBlue, LightSeaGreen, DarkTurquoise, 100);
        EnumFlowerColor.addMix(Lime, Aquamarine, SpringGreen, 105);
        EnumFlowerColor.addMix(Lime, CadetBlue, LimeGreen, 85);
        EnumFlowerColor.addMix(Lime, Chocolate, YellowGreen, 60);
        EnumFlowerColor.addMix(Lime, Coral, YellowGreen, 55);
        EnumFlowerColor.addMix(Lime, Cyan, SpringGreen, 90);
        EnumFlowerColor.addMix(Lime, DarkGoldenrod, LimeGreen, 80);
        EnumFlowerColor.addMix(Lime, DarkGray, LimeGreen, 90);
        EnumFlowerColor.addMix(Lime, DarkGreen, LimeGreen, 80);
        EnumFlowerColor.addMix(Lime, DarkKhaki, LimeGreen, 100);
        EnumFlowerColor.addMix(Lime, DarkOliveGreen, LimeGreen, 85);
        EnumFlowerColor.addMix(Lime, DarkOrange, YellowGreen, 65);
        EnumFlowerColor.addMix(Lime, DarkSalmon, LimeGreen, 65);
        EnumFlowerColor.addMix(Lime, DarkSeaGreen, LimeGreen, 105);
        EnumFlowerColor.addMix(Lime, DarkSlateBlue, MediumSeaGreen, 50);
        EnumFlowerColor.addMix(Lime, DarkSlateGray, MediumSeaGreen, 65);
        EnumFlowerColor.addMix(Lime, DarkTurquoise, SpringGreen, 90);
        EnumFlowerColor.addMix(Lime, DeepSkyBlue, SpringGreen, 65);
        EnumFlowerColor.addMix(Lime, DimGray, LimeGreen, 80);
        EnumFlowerColor.addMix(Lime, DodgerBlue, MediumSeaGreen, 55);
        EnumFlowerColor.addMix(Lime, Gold, YellowGreen, 95);
        EnumFlowerColor.addMix(Lime, Goldenrod, LimeGreen, 85);
        EnumFlowerColor.addMix(Lime, Gray, LimeGreen, 85);
        EnumFlowerColor.addMix(Lime, Green, LimeGreen, 90);
        EnumFlowerColor.addMix(Lime, IndianRed, LimeGreen, 45);
        EnumFlowerColor.addMix(Lime, Khaki, PaleGreen, 100);
        EnumFlowerColor.addMix(Lime, Lavender, PaleGreen, 85);
        EnumFlowerColor.addMix(Lime, LemonChiffon, PaleGreen, 100);
        EnumFlowerColor.addMix(Lime, LightGray, SpringGreen, 95);
        EnumFlowerColor.addMix(Lime, LightSeaGreen, LimeGreen, 90);
        EnumFlowerColor.addMix(Lime, LightSteelBlue, SpringGreen, 80);
        EnumFlowerColor.addMix(LimeGreen, Aquamarine, SpringGreen, 105);
        EnumFlowerColor.addMix(LimeGreen, Black, DarkGreen, 55);
        EnumFlowerColor.addMix(LimeGreen, Blue, SteelBlue, 50);
        EnumFlowerColor.addMix(LimeGreen, Brown, DarkOliveGreen, 45);
        EnumFlowerColor.addMix(LimeGreen, CadetBlue, MediumSeaGreen, 95);
        EnumFlowerColor.addMix(LimeGreen, Chocolate, OliveDrab, 65);
        EnumFlowerColor.addMix(LimeGreen, Coral, DarkKhaki, 60);
        EnumFlowerColor.addMix(LimeGreen, Cyan, SpringGreen, 90);
        EnumFlowerColor.addMix(LimeGreen, DarkGoldenrod, OliveDrab, 90);
        EnumFlowerColor.addMix(LimeGreen, DarkGray, MediumSeaGreen, 95);
        EnumFlowerColor.addMix(LimeGreen, DarkGreen, Green, 90);
        EnumFlowerColor.addMix(LimeGreen, DarkKhaki, YellowGreen, 105);
        EnumFlowerColor.addMix(LimeGreen, DarkOliveGreen, OliveDrab, 95);
        EnumFlowerColor.addMix(LimeGreen, DarkOrange, YellowGreen, 70);
        EnumFlowerColor.addMix(LimeGreen, DarkSalmon, YellowGreen, 70);
        EnumFlowerColor.addMix(LimeGreen, DarkSeaGreen, MediumSeaGreen, 110);
        EnumFlowerColor.addMix(LimeGreen, DarkSlateBlue, SeaGreen, 55);
        EnumFlowerColor.addMix(LimeGreen, DarkSlateGray, SeaGreen, 75);
        EnumFlowerColor.addMix(LimeGreen, DarkTurquoise, MediumSeaGreen, 95);
        EnumFlowerColor.addMix(LimeGreen, DarkViolet, DimGray, 55);
        EnumFlowerColor.addMix(LimeGreen, DeepSkyBlue, MediumAquamarine, 70);
        EnumFlowerColor.addMix(LimeGreen, DimGray, SeaGreen, 85);
        EnumFlowerColor.addMix(LimeGreen, DodgerBlue, LightSeaGreen, 65);
        EnumFlowerColor.addMix(LimeGreen, Gold, YellowGreen, 95);
        EnumFlowerColor.addMix(LimeGreen, Goldenrod, YellowGreen, 90);
        EnumFlowerColor.addMix(LimeGreen, Gray, MediumSeaGreen, 90);
        EnumFlowerColor.addMix(LimeGreen, Green, MediumSeaGreen, 105);
        EnumFlowerColor.addMix(LimeGreen, IndianRed, OliveDrab, 55);
        EnumFlowerColor.addMix(LimeGreen, Indigo, DarkSlateGray, 50);
        EnumFlowerColor.addMix(LimeGreen, Khaki, YellowGreen, 100);
        EnumFlowerColor.addMix(LimeGreen, Lavender, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(LimeGreen, LemonChiffon, PaleGreen, 100);
        EnumFlowerColor.addMix(LimeGreen, LightGray, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(LimeGreen, LightSeaGreen, MediumSeaGreen, 100);
        EnumFlowerColor.addMix(LimeGreen, LightSteelBlue, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(LimeGreen, Lime, SpringGreen, 115);
        EnumFlowerColor.addMix(Magenta, Aquamarine, Violet, 70);
        EnumFlowerColor.addMix(Magenta, Black, Purple, 70);
        EnumFlowerColor.addMix(Magenta, Blue, DarkViolet, 95);
        EnumFlowerColor.addMix(Magenta, Brown, MediumVioletRed, 85);
        EnumFlowerColor.addMix(Magenta, CadetBlue, MediumOrchid, 95);
        EnumFlowerColor.addMix(Magenta, Chocolate, DeepPink, 75);
        EnumFlowerColor.addMix(Magenta, Coral, DeepPink, 80);
        EnumFlowerColor.addMix(Magenta, Crimson, DeepPink, 90);
        EnumFlowerColor.addMix(Magenta, Cyan, MediumPurple, 65);
        EnumFlowerColor.addMix(Magenta, DarkGoldenrod, DeepPink, 60);
        EnumFlowerColor.addMix(Magenta, DarkGray, MediumOrchid, 95);
        EnumFlowerColor.addMix(Magenta, DarkKhaki, HotPink, 55);
        EnumFlowerColor.addMix(Magenta, DarkOliveGreen, MediumVioletRed, 50);
        EnumFlowerColor.addMix(Magenta, DarkOrange, DeepPink, 65);
        EnumFlowerColor.addMix(Magenta, DarkSalmon, HotPink, 85);
        EnumFlowerColor.addMix(Magenta, DarkSeaGreen, MediumOrchid, 50);
        EnumFlowerColor.addMix(Magenta, DarkSlateBlue, DarkViolet, 90);
        EnumFlowerColor.addMix(Magenta, DarkSlateGray, DarkViolet, 90);
        EnumFlowerColor.addMix(Magenta, DarkTurquoise, MediumPurple, 75);
        EnumFlowerColor.addMix(Magenta, DarkViolet, MediumOrchid, 105);
        EnumFlowerColor.addMix(Magenta, DeepPink, HotPink, 110);
        EnumFlowerColor.addMix(Magenta, DeepSkyBlue, MediumPurple, 70);
        EnumFlowerColor.addMix(Magenta, DimGray, MediumOrchid, 90);
        EnumFlowerColor.addMix(Magenta, DodgerBlue, SlateBlue, 85);
        EnumFlowerColor.addMix(Magenta, Goldenrod, DeepPink, 55);
        EnumFlowerColor.addMix(Magenta, Gray, MediumOrchid, 95);
        EnumFlowerColor.addMix(Magenta, HotPink, Violet, 110);
        EnumFlowerColor.addMix(Magenta, IndianRed, DeepPink, 95);
        EnumFlowerColor.addMix(Magenta, Indigo, DarkViolet, 90);
        EnumFlowerColor.addMix(Magenta, Khaki, HotPink, 50);
        EnumFlowerColor.addMix(Magenta, Lavender, Violet, 90);
        EnumFlowerColor.addMix(Magenta, LemonChiffon, Violet, 60);
        EnumFlowerColor.addMix(Magenta, LightGray, Violet, 90);
        EnumFlowerColor.addMix(Magenta, LightSeaGreen, MediumPurple, 80);
        EnumFlowerColor.addMix(Magenta, LightSteelBlue, MediumOrchid, 95);
        EnumFlowerColor.addMix(Maroon, Blue, Indigo, 80);
        EnumFlowerColor.addMix(Maroon, Chocolate, Sienna, 95);
        EnumFlowerColor.addMix(Maroon, Coral, Sienna, 85);
        EnumFlowerColor.addMix(Maroon, Crimson, Brown, 105);
        EnumFlowerColor.addMix(Maroon, DarkGoldenrod, Sienna, 85);
        EnumFlowerColor.addMix(Maroon, DarkGray, Brown, 75);
        EnumFlowerColor.addMix(Maroon, DarkKhaki, Sienna, 65);
        EnumFlowerColor.addMix(Maroon, DarkOrange, Sienna, 80);
        EnumFlowerColor.addMix(Maroon, DarkSalmon, Brown, 80);
        EnumFlowerColor.addMix(Maroon, DarkSeaGreen, Sienna, 55);
        EnumFlowerColor.addMix(Maroon, DarkTurquoise, DarkSlateGray, 50);
        EnumFlowerColor.addMix(Maroon, DarkViolet, Purple, 85);
        EnumFlowerColor.addMix(Maroon, DeepPink, Crimson, 90);
        EnumFlowerColor.addMix(Maroon, DeepSkyBlue, RoyalBlue, 50);
        EnumFlowerColor.addMix(Maroon, DimGray, Brown, 95);
        EnumFlowerColor.addMix(Maroon, DodgerBlue, DarkSlateBlue, 70);
        EnumFlowerColor.addMix(Maroon, Gold, Chocolate, 55);
        EnumFlowerColor.addMix(Maroon, Goldenrod, Sienna, 70);
        EnumFlowerColor.addMix(Maroon, Gray, Brown, 90);
        EnumFlowerColor.addMix(Maroon, Green, Olive, 60);
        EnumFlowerColor.addMix(Maroon, HotPink, Crimson, 80);
        EnumFlowerColor.addMix(Maroon, IndianRed, Brown, 100);
        EnumFlowerColor.addMix(Maroon, Indigo, Purple, 90);
        EnumFlowerColor.addMix(Maroon, Khaki, Chocolate, 55);
        EnumFlowerColor.addMix(Maroon, Lavender, RosyBrown, 60);
        EnumFlowerColor.addMix(Maroon, LemonChiffon, DarkSalmon, 55);
        EnumFlowerColor.addMix(Maroon, LightGray, IndianRed, 65);
        EnumFlowerColor.addMix(Maroon, LightSeaGreen, DimGray, 60);
        EnumFlowerColor.addMix(Maroon, Magenta, MediumVioletRed, 75);
        EnumFlowerColor.addMix(MediumAquamarine, Aquamarine, Turquoise, 115);
        EnumFlowerColor.addMix(MediumAquamarine, Black, DarkSlateGray, 55);
        EnumFlowerColor.addMix(MediumAquamarine, Blue, RoyalBlue, 60);
        EnumFlowerColor.addMix(MediumAquamarine, Brown, Gray, 55);
        EnumFlowerColor.addMix(MediumAquamarine, CadetBlue, LightSeaGreen, 110);
        EnumFlowerColor.addMix(MediumAquamarine, Chocolate, DarkKhaki, 75);
        EnumFlowerColor.addMix(MediumAquamarine, Coral, Tan, 70);
        EnumFlowerColor.addMix(MediumAquamarine, Crimson, RosyBrown, 55);
        EnumFlowerColor.addMix(MediumAquamarine, Cyan, Turquoise, 110);
        EnumFlowerColor.addMix(MediumAquamarine, DarkGoldenrod, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(MediumAquamarine, DarkGray, DarkSeaGreen, 100);
        EnumFlowerColor.addMix(MediumAquamarine, DarkGreen, SeaGreen, 85);
        EnumFlowerColor.addMix(MediumAquamarine, DarkKhaki, DarkSeaGreen, 105);
        EnumFlowerColor.addMix(MediumAquamarine, DarkOliveGreen, SeaGreen, 90);
        EnumFlowerColor.addMix(MediumAquamarine, DarkOrange, DarkKhaki, 75);
        EnumFlowerColor.addMix(MediumAquamarine, DarkSalmon, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(MediumAquamarine, DarkSeaGreen, MediumSeaGreen, 115);
        EnumFlowerColor.addMix(MediumAquamarine, DarkSlateBlue, SlateGray, 65);
        EnumFlowerColor.addMix(MediumAquamarine, DarkSlateGray, Teal, 80);
        EnumFlowerColor.addMix(MediumAquamarine, DarkTurquoise, Turquoise, 115);
        EnumFlowerColor.addMix(MediumAquamarine, DarkViolet, SlateBlue, 70);
        EnumFlowerColor.addMix(MediumAquamarine, DeepPink, PaleVioletRed, 45);
        EnumFlowerColor.addMix(MediumAquamarine, DeepSkyBlue, DarkTurquoise, 95);
        EnumFlowerColor.addMix(MediumAquamarine, DimGray, CadetBlue, 90);
        EnumFlowerColor.addMix(MediumAquamarine, DodgerBlue, DeepSkyBlue, 85);
        EnumFlowerColor.addMix(MediumAquamarine, Gold, YellowGreen, 90);
        EnumFlowerColor.addMix(MediumAquamarine, Goldenrod, DarkKhaki, 90);
        EnumFlowerColor.addMix(MediumAquamarine, Gray, CadetBlue, 95);
        EnumFlowerColor.addMix(MediumAquamarine, Green, MediumSeaGreen, 95);
        EnumFlowerColor.addMix(MediumAquamarine, HotPink, Thistle, 55);
        EnumFlowerColor.addMix(MediumAquamarine, IndianRed, DarkGray, 65);
        EnumFlowerColor.addMix(MediumAquamarine, Indigo, SlateBlue, 55);
        EnumFlowerColor.addMix(MediumAquamarine, Khaki, DarkSeaGreen, 100);
        EnumFlowerColor.addMix(MediumAquamarine, Lavender, PaleTurquoise, 95);
        EnumFlowerColor.addMix(MediumAquamarine, LemonChiffon, DarkSeaGreen, 100);
        EnumFlowerColor.addMix(MediumAquamarine, LightGray, PaleTurquoise, 100);
        EnumFlowerColor.addMix(MediumAquamarine, LightSeaGreen, Turquoise, 115);
        EnumFlowerColor.addMix(MediumAquamarine, LightSteelBlue, PaleTurquoise, 100);
        EnumFlowerColor.addMix(MediumAquamarine, Lime, LimeGreen, 100);
        EnumFlowerColor.addMix(MediumAquamarine, LimeGreen, MediumSeaGreen, 110);
        EnumFlowerColor.addMix(MediumAquamarine, Magenta, MediumOrchid, 75);
        EnumFlowerColor.addMix(MediumAquamarine, Maroon, DimGray, 50);
        EnumFlowerColor.addMix(MediumOrchid, Aquamarine, LightSteelBlue, 70);
        EnumFlowerColor.addMix(MediumOrchid, Black, Purple, 75);
        EnumFlowerColor.addMix(MediumOrchid, Blue, DarkViolet, 100);
        EnumFlowerColor.addMix(MediumOrchid, Brown, MediumVioletRed, 90);
        EnumFlowerColor.addMix(MediumOrchid, CadetBlue, MediumPurple, 95);
        EnumFlowerColor.addMix(MediumOrchid, Chocolate, PaleVioletRed, 80);
        EnumFlowerColor.addMix(MediumOrchid, Coral, PaleVioletRed, 85);
        EnumFlowerColor.addMix(MediumOrchid, Crimson, MediumVioletRed, 95);
        EnumFlowerColor.addMix(MediumOrchid, Cyan, DodgerBlue, 70);
        EnumFlowerColor.addMix(MediumOrchid, DarkGoldenrod, IndianRed, 65);
        EnumFlowerColor.addMix(MediumOrchid, DarkGray, Plum, 95);
        EnumFlowerColor.addMix(MediumOrchid, DarkKhaki, RosyBrown, 60);
        EnumFlowerColor.addMix(MediumOrchid, DarkOrange, IndianRed, 70);
        EnumFlowerColor.addMix(MediumOrchid, DarkSalmon, PaleVioletRed, 85);
        EnumFlowerColor.addMix(MediumOrchid, DarkSeaGreen, Plum, 55);
        EnumFlowerColor.addMix(MediumOrchid, DarkSlateBlue, SlateBlue, 100);
        EnumFlowerColor.addMix(MediumOrchid, DarkSlateGray, DarkSlateBlue, 95);
        EnumFlowerColor.addMix(MediumOrchid, DarkTurquoise, DodgerBlue, 75);
        EnumFlowerColor.addMix(MediumOrchid, DeepPink, MediumVioletRed, 110);
        EnumFlowerColor.addMix(MediumOrchid, DeepSkyBlue, DodgerBlue, 75);
        EnumFlowerColor.addMix(MediumOrchid, DimGray, MediumPurple, 95);
        EnumFlowerColor.addMix(MediumOrchid, DodgerBlue, RoyalBlue, 95);
        EnumFlowerColor.addMix(MediumOrchid, Gold, SandyBrown, 50);
        EnumFlowerColor.addMix(MediumOrchid, Goldenrod, RosyBrown, 60);
        EnumFlowerColor.addMix(MediumOrchid, Gray, MediumPurple, 100);
        EnumFlowerColor.addMix(MediumOrchid, HotPink, Violet, 110);
        EnumFlowerColor.addMix(MediumOrchid, IndianRed, MediumVioletRed, 95);
        EnumFlowerColor.addMix(MediumOrchid, Indigo, DarkViolet, 100);
        EnumFlowerColor.addMix(MediumOrchid, Khaki, RosyBrown, 55);
        EnumFlowerColor.addMix(MediumOrchid, Lavender, Plum, 90);
        EnumFlowerColor.addMix(MediumOrchid, LemonChiffon, Plum, 65);
        EnumFlowerColor.addMix(MediumOrchid, LightGray, Plum, 90);
        EnumFlowerColor.addMix(MediumOrchid, LightSeaGreen, SteelBlue, 80);
        EnumFlowerColor.addMix(MediumOrchid, LightSteelBlue, Plum, 95);
        EnumFlowerColor.addMix(MediumOrchid, Maroon, MediumVioletRed, 80);
        EnumFlowerColor.addMix(MediumPurple, Aquamarine, SkyBlue, 75);
        EnumFlowerColor.addMix(MediumPurple, Black, DarkSlateBlue, 75);
        EnumFlowerColor.addMix(MediumPurple, Blue, SlateBlue, 100);
        EnumFlowerColor.addMix(MediumPurple, Brown, MediumVioletRed, 85);
        EnumFlowerColor.addMix(MediumPurple, CadetBlue, SlateGray, 95);
        EnumFlowerColor.addMix(MediumPurple, Chocolate, PaleVioletRed, 80);
        EnumFlowerColor.addMix(MediumPurple, Coral, PaleVioletRed, 80);
        EnumFlowerColor.addMix(MediumPurple, Crimson, MediumVioletRed, 90);
        EnumFlowerColor.addMix(MediumPurple, Cyan, DeepSkyBlue, 75);
        EnumFlowerColor.addMix(MediumPurple, DarkGoldenrod, RosyBrown, 65);
        EnumFlowerColor.addMix(MediumPurple, DarkGreen, DarkSlateGray, 70);
        EnumFlowerColor.addMix(MediumPurple, DarkKhaki, RosyBrown, 65);
        EnumFlowerColor.addMix(MediumPurple, DarkOliveGreen, DimGray, 65);
        EnumFlowerColor.addMix(MediumPurple, DarkOrange, DarkSalmon, 70);
        EnumFlowerColor.addMix(MediumPurple, DarkSalmon, PaleVioletRed, 85);
        EnumFlowerColor.addMix(MediumPurple, DarkSeaGreen, SlateGray, 80);
        EnumFlowerColor.addMix(MediumPurple, DarkSlateBlue, SlateBlue, 105);
        EnumFlowerColor.addMix(MediumPurple, DarkSlateGray, SlateBlue, 95);
        EnumFlowerColor.addMix(MediumPurple, DarkTurquoise, DodgerBlue, 85);
        EnumFlowerColor.addMix(MediumPurple, DarkViolet, SlateBlue, 110);
        EnumFlowerColor.addMix(MediumPurple, DeepPink, MediumOrchid, 100);
        EnumFlowerColor.addMix(MediumPurple, DeepSkyBlue, DodgerBlue, 90);
        EnumFlowerColor.addMix(MediumPurple, DimGray, SlateBlue, 100);
        EnumFlowerColor.addMix(MediumPurple, DodgerBlue, RoyalBlue, 105);
        EnumFlowerColor.addMix(MediumPurple, Gold, Tan, 55);
        EnumFlowerColor.addMix(MediumPurple, Goldenrod, RosyBrown, 65);
        EnumFlowerColor.addMix(MediumPurple, Green, Teal, 70);
        EnumFlowerColor.addMix(MediumPurple, HotPink, MediumOrchid, 105);
        EnumFlowerColor.addMix(MediumPurple, IndianRed, PaleVioletRed, 95);
        EnumFlowerColor.addMix(MediumPurple, Indigo, DarkViolet, 95);
        EnumFlowerColor.addMix(MediumPurple, Khaki, Thistle, 60);
        EnumFlowerColor.addMix(MediumPurple, Lavender, Plum, 95);
        EnumFlowerColor.addMix(MediumPurple, LemonChiffon, Thistle, 65);
        EnumFlowerColor.addMix(MediumPurple, LightGray, Plum, 90);
        EnumFlowerColor.addMix(MediumPurple, LightSeaGreen, SteelBlue, 85);
        EnumFlowerColor.addMix(MediumPurple, Lime, MediumSeaGreen, 60);
        EnumFlowerColor.addMix(MediumPurple, LimeGreen, CadetBlue, 65);
        EnumFlowerColor.addMix(MediumPurple, Magenta, MediumOrchid, 110);
        EnumFlowerColor.addMix(MediumPurple, Maroon, Purple, 80);
        EnumFlowerColor.addMix(MediumPurple, MediumAquamarine, DodgerBlue, 80);
        EnumFlowerColor.addMix(MediumPurple, MediumOrchid, SlateBlue, 115);
        EnumFlowerColor.addMix(MediumSeaGreen, Aquamarine, MediumAquamarine, 105);
        EnumFlowerColor.addMix(MediumSeaGreen, Black, DarkGreen, 65);
        EnumFlowerColor.addMix(MediumSeaGreen, Blue, RoyalBlue, 60);
        EnumFlowerColor.addMix(MediumSeaGreen, Brown, DarkOliveGreen, 55);
        EnumFlowerColor.addMix(MediumSeaGreen, CadetBlue, LightSeaGreen, 105);
        EnumFlowerColor.addMix(MediumSeaGreen, Chocolate, OliveDrab, 70);
        EnumFlowerColor.addMix(MediumSeaGreen, Coral, DarkKhaki, 65);
        EnumFlowerColor.addMix(MediumSeaGreen, Crimson, Sienna, 50);
        EnumFlowerColor.addMix(MediumSeaGreen, Cyan, MediumAquamarine, 100);
        EnumFlowerColor.addMix(MediumSeaGreen, DarkGoldenrod, OliveDrab, 90);
        EnumFlowerColor.addMix(MediumSeaGreen, DarkGray, DarkSeaGreen, 100);
        EnumFlowerColor.addMix(MediumSeaGreen, DarkGreen, SeaGreen, 95);
        EnumFlowerColor.addMix(MediumSeaGreen, DarkKhaki, DarkSeaGreen, 105);
        EnumFlowerColor.addMix(MediumSeaGreen, DarkOliveGreen, SeaGreen, 100);
        EnumFlowerColor.addMix(MediumSeaGreen, DarkOrange, DarkKhaki, 75);
        EnumFlowerColor.addMix(MediumSeaGreen, DarkSalmon, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(MediumSeaGreen, DarkSeaGreen, MediumAquamarine, 115);
        EnumFlowerColor.addMix(MediumSeaGreen, DarkSlateBlue, Teal, 70);
        EnumFlowerColor.addMix(MediumSeaGreen, DarkSlateGray, SeaGreen, 85);
        EnumFlowerColor.addMix(MediumSeaGreen, DarkTurquoise, MediumAquamarine, 105);
        EnumFlowerColor.addMix(MediumSeaGreen, DarkViolet, SlateBlue, 65);
        EnumFlowerColor.addMix(MediumSeaGreen, DeepSkyBlue, LightSeaGreen, 85);
        EnumFlowerColor.addMix(MediumSeaGreen, DimGray, SeaGreen, 95);
        EnumFlowerColor.addMix(MediumSeaGreen, DodgerBlue, CadetBlue, 75);
        EnumFlowerColor.addMix(MediumSeaGreen, Gold, YellowGreen, 90);
        EnumFlowerColor.addMix(MediumSeaGreen, Goldenrod, YellowGreen, 90);
        EnumFlowerColor.addMix(MediumSeaGreen, Gray, SeaGreen, 100);
        EnumFlowerColor.addMix(MediumSeaGreen, Green, SeaGreen, 105);
        EnumFlowerColor.addMix(MediumSeaGreen, HotPink, Gray, 45);
        EnumFlowerColor.addMix(MediumSeaGreen, Indigo, DarkSlateBlue, 60);
        EnumFlowerColor.addMix(MediumSeaGreen, Khaki, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(MediumSeaGreen, Lavender, MediumAquamarine, 90);
        EnumFlowerColor.addMix(MediumSeaGreen, LemonChiffon, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(MediumSeaGreen, LightGray, MediumAquamarine, 95);
        EnumFlowerColor.addMix(MediumSeaGreen, LightSeaGreen, MediumAquamarine, 110);
        EnumFlowerColor.addMix(MediumSeaGreen, LightSteelBlue, MediumAquamarine, 90);
        EnumFlowerColor.addMix(MediumSeaGreen, Lime, LimeGreen, 105);
        EnumFlowerColor.addMix(MediumSeaGreen, Magenta, MediumOrchid, 70);
        EnumFlowerColor.addMix(MediumSeaGreen, Maroon, DarkOliveGreen, 50);
        EnumFlowerColor.addMix(MediumSeaGreen, MediumAquamarine, DarkSeaGreen, 115);
        EnumFlowerColor.addMix(MediumSeaGreen, MediumOrchid, SlateGray, 75);
        EnumFlowerColor.addMix(MediumSeaGreen, MediumPurple, SlateGray, 75);
        EnumFlowerColor.addMix(MediumVioletRed, Black, Purple, 85);
        EnumFlowerColor.addMix(MediumVioletRed, Blue, DarkViolet, 95);
        EnumFlowerColor.addMix(MediumVioletRed, Chocolate, Crimson, 85);
        EnumFlowerColor.addMix(MediumVioletRed, Coral, IndianRed, 85);
        EnumFlowerColor.addMix(MediumVioletRed, Crimson, DeepPink, 105);
        EnumFlowerColor.addMix(MediumVioletRed, Cyan, SteelBlue, 45);
        EnumFlowerColor.addMix(MediumVioletRed, DarkGoldenrod, IndianRed, 70);
        EnumFlowerColor.addMix(MediumVioletRed, DarkGray, PaleVioletRed, 90);
        EnumFlowerColor.addMix(MediumVioletRed, DarkKhaki, PaleVioletRed, 60);
        EnumFlowerColor.addMix(MediumVioletRed, DarkOrange, IndianRed, 70);
        EnumFlowerColor.addMix(MediumVioletRed, DarkSalmon, PaleVioletRed, 90);
        EnumFlowerColor.addMix(MediumVioletRed, DarkSeaGreen, PaleVioletRed, 55);
        EnumFlowerColor.addMix(MediumVioletRed, DarkSlateBlue, Purple, 100);
        EnumFlowerColor.addMix(MediumVioletRed, DarkSlateGray, Purple, 100);
        EnumFlowerColor.addMix(MediumVioletRed, DarkTurquoise, RoyalBlue, 55);
        EnumFlowerColor.addMix(MediumVioletRed, DarkViolet, Purple, 110);
        EnumFlowerColor.addMix(MediumVioletRed, DeepSkyBlue, SlateBlue, 60);
        EnumFlowerColor.addMix(MediumVioletRed, DimGray, Purple, 100);
        EnumFlowerColor.addMix(MediumVioletRed, DodgerBlue, SlateBlue, 80);
        EnumFlowerColor.addMix(MediumVioletRed, Gold, Coral, 50);
        EnumFlowerColor.addMix(MediumVioletRed, Goldenrod, IndianRed, 60);
        EnumFlowerColor.addMix(MediumVioletRed, HotPink, DeepPink, 105);
        EnumFlowerColor.addMix(MediumVioletRed, IndianRed, DeepPink, 105);
        EnumFlowerColor.addMix(MediumVioletRed, Indigo, Purple, 100);
        EnumFlowerColor.addMix(MediumVioletRed, Khaki, PaleVioletRed, 55);
        EnumFlowerColor.addMix(MediumVioletRed, Lavender, Violet, 80);
        EnumFlowerColor.addMix(MediumVioletRed, LemonChiffon, PaleVioletRed, 60);
        EnumFlowerColor.addMix(MediumVioletRed, LightGray, PaleVioletRed, 85);
        EnumFlowerColor.addMix(MediumVioletRed, LightSeaGreen, SlateBlue, 65);
        EnumFlowerColor.addMix(MediumVioletRed, LightSteelBlue, MediumOrchid, 80);
        EnumFlowerColor.addMix(MediumVioletRed, Magenta, MediumOrchid, 105);
        EnumFlowerColor.addMix(MediumVioletRed, Maroon, Brown, 95);
        EnumFlowerColor.addMix(MediumVioletRed, MediumPurple, MediumOrchid, 105);
        EnumFlowerColor.addMix(MistyRose, Aquamarine, PaleTurquoise, 90);
        EnumFlowerColor.addMix(MistyRose, Blue, MediumPurple, 65);
        EnumFlowerColor.addMix(MistyRose, Brown, RosyBrown, 75);
        EnumFlowerColor.addMix(MistyRose, CadetBlue, LightGray, 85);
        EnumFlowerColor.addMix(MistyRose, Chocolate, DarkSalmon, 90);
        EnumFlowerColor.addMix(MistyRose, Coral, DarkSalmon, 100);
        EnumFlowerColor.addMix(MistyRose, Crimson, PaleVioletRed, 85);
        EnumFlowerColor.addMix(MistyRose, Cyan, PaleTurquoise, 90);
        EnumFlowerColor.addMix(MistyRose, DarkGoldenrod, Tan, 90);
        EnumFlowerColor.addMix(MistyRose, DarkGray, LightGray, 105);
        EnumFlowerColor.addMix(MistyRose, DarkGreen, DarkSeaGreen, 65);
        EnumFlowerColor.addMix(MistyRose, DarkKhaki, Wheat, 100);
        EnumFlowerColor.addMix(MistyRose, DarkOliveGreen, DarkKhaki, 75);
        EnumFlowerColor.addMix(MistyRose, DarkOrange, SandyBrown, 95);
        EnumFlowerColor.addMix(MistyRose, DarkSalmon, Pink, 105);
        EnumFlowerColor.addMix(MistyRose, DarkSeaGreen, LemonChiffon, 90);
        EnumFlowerColor.addMix(MistyRose, DarkSlateBlue, Plum, 65);
        EnumFlowerColor.addMix(MistyRose, DarkSlateGray, DarkGray, 65);
        EnumFlowerColor.addMix(MistyRose, DarkTurquoise, PaleTurquoise, 90);
        EnumFlowerColor.addMix(MistyRose, DarkViolet, Violet, 70);
        EnumFlowerColor.addMix(MistyRose, DeepPink, HotPink, 90);
        EnumFlowerColor.addMix(MistyRose, DeepSkyBlue, SkyBlue, 90);
        EnumFlowerColor.addMix(MistyRose, DimGray, DarkGray, 85);
        EnumFlowerColor.addMix(MistyRose, DodgerBlue, LightSteelBlue, 85);
        EnumFlowerColor.addMix(MistyRose, Gold, Khaki, 95);
        EnumFlowerColor.addMix(MistyRose, Goldenrod, Tan, 95);
        EnumFlowerColor.addMix(MistyRose, Gray, DarkGray, 95);
        EnumFlowerColor.addMix(MistyRose, Green, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(MistyRose, HotPink, Pink, 95);
        EnumFlowerColor.addMix(MistyRose, IndianRed, RosyBrown, 90);
        EnumFlowerColor.addMix(MistyRose, Indigo, MediumOrchid, 50);
        EnumFlowerColor.addMix(MistyRose, Khaki, Wheat, 100);
        EnumFlowerColor.addMix(MistyRose, LemonChiffon, Wheat, 105);
        EnumFlowerColor.addMix(MistyRose, LightSeaGreen, PaleTurquoise, 85);
        EnumFlowerColor.addMix(MistyRose, LightSteelBlue, Lavender, 105);
        EnumFlowerColor.addMix(MistyRose, Lime, PaleGreen, 80);
        EnumFlowerColor.addMix(MistyRose, LimeGreen, PaleGreen, 80);
        EnumFlowerColor.addMix(MistyRose, Magenta, Violet, 85);
        EnumFlowerColor.addMix(MistyRose, Maroon, IndianRed, 60);
        EnumFlowerColor.addMix(MistyRose, MediumAquamarine, PaleTurquoise, 90);
        EnumFlowerColor.addMix(MistyRose, MediumOrchid, Plum, 85);
        EnumFlowerColor.addMix(MistyRose, MediumPurple, Plum, 85);
        EnumFlowerColor.addMix(MistyRose, MediumSeaGreen, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(MistyRose, MediumVioletRed, HotPink, 80);
        EnumFlowerColor.addMix(Navy, Blue, Indigo, 110);
        EnumFlowerColor.addMix(Navy, Brown, Purple, 85);
        EnumFlowerColor.addMix(Navy, CadetBlue, DarkSlateBlue, 75);
        EnumFlowerColor.addMix(Navy, Coral, Purple, 60);
        EnumFlowerColor.addMix(Navy, Crimson, Purple, 80);
        EnumFlowerColor.addMix(Navy, DarkGray, DarkSlateBlue, 65);
        EnumFlowerColor.addMix(Navy, DarkGreen, DarkSlateGray, 65);
        EnumFlowerColor.addMix(Navy, DarkOliveGreen, DarkSlateBlue, 55);
        EnumFlowerColor.addMix(Navy, DarkOrange, Brown, 50);
        EnumFlowerColor.addMix(Navy, DarkSeaGreen, RoyalBlue, 55);
        EnumFlowerColor.addMix(Navy, DarkSlateBlue, Indigo, 110);
        EnumFlowerColor.addMix(Navy, DarkSlateGray, DarkSlateBlue, 95);
        EnumFlowerColor.addMix(Navy, DarkTurquoise, SteelBlue, 55);
        EnumFlowerColor.addMix(Navy, DarkViolet, Indigo, 105);
        EnumFlowerColor.addMix(Navy, DeepPink, Purple, 80);
        EnumFlowerColor.addMix(Navy, DeepSkyBlue, RoyalBlue, 60);
        EnumFlowerColor.addMix(Navy, DimGray, DarkSlateBlue, 90);
        EnumFlowerColor.addMix(Navy, DodgerBlue, DarkSlateBlue, 80);
        EnumFlowerColor.addMix(Navy, Gray, DarkSlateBlue, 80);
        EnumFlowerColor.addMix(Navy, Green, Teal, 60);
        EnumFlowerColor.addMix(Navy, HotPink, Purple, 75);
        EnumFlowerColor.addMix(Navy, IndianRed, Purple, 80);
        EnumFlowerColor.addMix(Navy, LightGray, SlateBlue, 50);
        EnumFlowerColor.addMix(Navy, LightSeaGreen, RoyalBlue, 65);
        EnumFlowerColor.addMix(Navy, LightSteelBlue, SlateBlue, 60);
        EnumFlowerColor.addMix(Navy, Magenta, DarkViolet, 85);
        EnumFlowerColor.addMix(Navy, Maroon, Purple, 85);
        EnumFlowerColor.addMix(Navy, MediumAquamarine, RoyalBlue, 50);
        EnumFlowerColor.addMix(Navy, MediumOrchid, DarkSlateBlue, 90);
        EnumFlowerColor.addMix(Navy, MediumPurple, DarkSlateBlue, 90);
        EnumFlowerColor.addMix(Navy, MediumVioletRed, Indigo, 95);
        EnumFlowerColor.addMix(Olive, Aquamarine, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(Olive, Blue, DarkSlateBlue, 45);
        EnumFlowerColor.addMix(Olive, Brown, Sienna, 80);
        EnumFlowerColor.addMix(Olive, CadetBlue, OliveDrab, 95);
        EnumFlowerColor.addMix(Olive, Chocolate, DarkGoldenrod, 95);
        EnumFlowerColor.addMix(Olive, Coral, Peru, 85);
        EnumFlowerColor.addMix(Olive, Crimson, Sienna, 75);
        EnumFlowerColor.addMix(Olive, Cyan, MediumSeaGreen, 80);
        EnumFlowerColor.addMix(Olive, DarkGray, OliveDrab, 95);
        EnumFlowerColor.addMix(Olive, DarkGreen, Green, 105);
        EnumFlowerColor.addMix(Olive, DarkKhaki, OliveDrab, 110);
        EnumFlowerColor.addMix(Olive, DarkOliveGreen, OliveDrab, 110);
        EnumFlowerColor.addMix(Olive, DarkOrange, DarkGoldenrod, 95);
        EnumFlowerColor.addMix(Olive, DarkSalmon, DarkGoldenrod, 90);
        EnumFlowerColor.addMix(Olive, DarkSeaGreen, OliveDrab, 100);
        EnumFlowerColor.addMix(Olive, DarkSlateBlue, DimGray, 60);
        EnumFlowerColor.addMix(Olive, DarkSlateGray, DarkOliveGreen, 90);
        EnumFlowerColor.addMix(Olive, DarkTurquoise, MediumSeaGreen, 85);
        EnumFlowerColor.addMix(Olive, DarkViolet, MediumVioletRed, 50);
        EnumFlowerColor.addMix(Olive, DeepPink, IndianRed, 60);
        EnumFlowerColor.addMix(Olive, DeepSkyBlue, MediumSeaGreen, 70);
        EnumFlowerColor.addMix(Olive, DimGray, DarkOliveGreen, 100);
        EnumFlowerColor.addMix(Olive, DodgerBlue, Teal, 60);
        EnumFlowerColor.addMix(Olive, Gold, Goldenrod, 95);
        EnumFlowerColor.addMix(Olive, Goldenrod, DarkGoldenrod, 105);
        EnumFlowerColor.addMix(Olive, Gray, OliveDrab, 100);
        EnumFlowerColor.addMix(Olive, Green, OliveDrab, 110);
        EnumFlowerColor.addMix(Olive, HotPink, IndianRed, 60);
        EnumFlowerColor.addMix(Olive, IndianRed, Peru, 80);
        EnumFlowerColor.addMix(Olive, Khaki, DarkKhaki, 95);
        EnumFlowerColor.addMix(Olive, Lavender, DarkKhaki, 75);
        EnumFlowerColor.addMix(Olive, LemonChiffon, DarkKhaki, 90);
        EnumFlowerColor.addMix(Olive, LightGray, DarkKhaki, 90);
        EnumFlowerColor.addMix(Olive, LightSeaGreen, SeaGreen, 90);
        EnumFlowerColor.addMix(Olive, LightSteelBlue, DarkKhaki, 80);
        EnumFlowerColor.addMix(Olive, Lime, LimeGreen, 90);
        EnumFlowerColor.addMix(Olive, LimeGreen, OliveDrab, 100);
        EnumFlowerColor.addMix(Olive, Magenta, MediumVioletRed, 45);
        EnumFlowerColor.addMix(Olive, Maroon, Sienna, 80);
        EnumFlowerColor.addMix(Olive, MediumAquamarine, OliveDrab, 95);
        EnumFlowerColor.addMix(Olive, MediumOrchid, IndianRed, 55);
        EnumFlowerColor.addMix(Olive, MediumPurple, Gray, 60);
        EnumFlowerColor.addMix(Olive, MediumSeaGreen, OliveDrab, 100);
        EnumFlowerColor.addMix(Olive, MediumVioletRed, Brown, 60);
        EnumFlowerColor.addMix(Olive, MistyRose, DarkKhaki, 85);
        EnumFlowerColor.addMix(Olive, Navy, Gray, 50);
        EnumFlowerColor.addMix(OliveDrab, Aquamarine, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(OliveDrab, Black, DarkOliveGreen, 75);
        EnumFlowerColor.addMix(OliveDrab, Brown, Sienna, 70);
        EnumFlowerColor.addMix(OliveDrab, CadetBlue, SeaGreen, 95);
        EnumFlowerColor.addMix(OliveDrab, Chocolate, DarkGoldenrod, 85);
        EnumFlowerColor.addMix(OliveDrab, Coral, DarkGoldenrod, 75);
        EnumFlowerColor.addMix(OliveDrab, Crimson, Sienna, 65);
        EnumFlowerColor.addMix(OliveDrab, Cyan, MediumAquamarine, 85);
        EnumFlowerColor.addMix(OliveDrab, DarkGoldenrod, Olive, 100);
        EnumFlowerColor.addMix(OliveDrab, DarkGray, DarkSeaGreen, 100);
        EnumFlowerColor.addMix(OliveDrab, DarkGreen, Green, 105);
        EnumFlowerColor.addMix(OliveDrab, DarkKhaki, Olive, 110);
        EnumFlowerColor.addMix(OliveDrab, DarkOliveGreen, Olive, 115);
        EnumFlowerColor.addMix(OliveDrab, DarkOrange, DarkGoldenrod, 85);
        EnumFlowerColor.addMix(OliveDrab, DarkSalmon, DarkGoldenrod, 85);
        EnumFlowerColor.addMix(OliveDrab, DarkSeaGreen, MediumSeaGreen, 110);
        EnumFlowerColor.addMix(OliveDrab, DarkSlateBlue, DimGray, 55);
        EnumFlowerColor.addMix(OliveDrab, DarkSlateGray, DarkOliveGreen, 90);
        EnumFlowerColor.addMix(OliveDrab, DarkTurquoise, MediumSeaGreen, 90);
        EnumFlowerColor.addMix(OliveDrab, DeepPink, IndianRed, 50);
        EnumFlowerColor.addMix(OliveDrab, DeepSkyBlue, LightSeaGreen, 70);
        EnumFlowerColor.addMix(OliveDrab, DimGray, DarkOliveGreen, 100);
        EnumFlowerColor.addMix(OliveDrab, DodgerBlue, CadetBlue, 65);
        EnumFlowerColor.addMix(OliveDrab, Gold, DarkKhaki, 95);
        EnumFlowerColor.addMix(OliveDrab, Goldenrod, Olive, 100);
        EnumFlowerColor.addMix(OliveDrab, Gray, DarkOliveGreen, 100);
        EnumFlowerColor.addMix(OliveDrab, Green, SeaGreen, 115);
        EnumFlowerColor.addMix(OliveDrab, HotPink, RosyBrown, 55);
        EnumFlowerColor.addMix(OliveDrab, IndianRed, DarkGoldenrod, 70);
        EnumFlowerColor.addMix(OliveDrab, Khaki, DarkKhaki, 100);
        EnumFlowerColor.addMix(OliveDrab, Lavender, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(OliveDrab, LemonChiffon, DarkKhaki, 90);
        EnumFlowerColor.addMix(OliveDrab, LightGray, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(OliveDrab, LightSeaGreen, MediumSeaGreen, 95);
        EnumFlowerColor.addMix(OliveDrab, LightSteelBlue, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(OliveDrab, Lime, LimeGreen, 95);
        EnumFlowerColor.addMix(OliveDrab, LimeGreen, MediumSeaGreen, 105);
        EnumFlowerColor.addMix(OliveDrab, Maroon, Sienna, 70);
        EnumFlowerColor.addMix(OliveDrab, MediumAquamarine, MediumSeaGreen, 100);
        EnumFlowerColor.addMix(OliveDrab, MediumOrchid, RosyBrown, 50);
        EnumFlowerColor.addMix(OliveDrab, MediumPurple, Gray, 55);
        EnumFlowerColor.addMix(OliveDrab, MediumSeaGreen, SeaGreen, 110);
        EnumFlowerColor.addMix(OliveDrab, MediumVioletRed, Brown, 50);
        EnumFlowerColor.addMix(OliveDrab, MistyRose, DarkKhaki, 80);
        EnumFlowerColor.addMix(Orange, Aquamarine, YellowGreen, 80);
        EnumFlowerColor.addMix(Orange, Blue, Plum, 45);
        EnumFlowerColor.addMix(Orange, Brown, Chocolate, 80);
        EnumFlowerColor.addMix(Orange, CadetBlue, DarkKhaki, 85);
        EnumFlowerColor.addMix(Orange, Chocolate, DarkOrange, 105);
        EnumFlowerColor.addMix(Orange, Coral, DarkOrange, 105);
        EnumFlowerColor.addMix(Orange, Crimson, Chocolate, 80);
        EnumFlowerColor.addMix(Orange, Cyan, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(Orange, DarkGoldenrod, Goldenrod, 110);
        EnumFlowerColor.addMix(Orange, DarkGray, Goldenrod, 95);
        EnumFlowerColor.addMix(Orange, DarkGreen, Olive, 70);
        EnumFlowerColor.addMix(Orange, DarkKhaki, Goldenrod, 105);
        EnumFlowerColor.addMix(Orange, DarkOliveGreen, DarkGoldenrod, 85);
        EnumFlowerColor.addMix(Orange, DarkOrange, SandyBrown, 120);
        EnumFlowerColor.addMix(Orange, DarkSalmon, SandyBrown, 105);
        EnumFlowerColor.addMix(Orange, DarkSeaGreen, DarkKhaki, 90);
        EnumFlowerColor.addMix(Orange, DarkSlateBlue, Peru, 55);
        EnumFlowerColor.addMix(Orange, DarkSlateGray, DarkGoldenrod, 70);
        EnumFlowerColor.addMix(Orange, DarkTurquoise, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(Orange, DarkViolet, IndianRed, 55);
        EnumFlowerColor.addMix(Orange, DeepPink, Salmon, 70);
        EnumFlowerColor.addMix(Orange, DeepSkyBlue, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(Orange, DimGray, DarkGoldenrod, 85);
        EnumFlowerColor.addMix(Orange, DodgerBlue, DarkSeaGreen, 65);
        EnumFlowerColor.addMix(Orange, Gold, Goldenrod, 110);
        EnumFlowerColor.addMix(Orange, Goldenrod, DarkGoldenrod, 120);
        EnumFlowerColor.addMix(Orange, Gray, DarkGoldenrod, 90);
        EnumFlowerColor.addMix(Orange, Green, OliveDrab, 75);
        EnumFlowerColor.addMix(Orange, HotPink, Coral, 75);
        EnumFlowerColor.addMix(Orange, IndianRed, Peru, 90);
        EnumFlowerColor.addMix(Orange, Khaki, Gold, 105);
        EnumFlowerColor.addMix(Orange, Lavender, Tan, 85);
        EnumFlowerColor.addMix(Orange, LemonChiffon, Gold, 100);
        EnumFlowerColor.addMix(Orange, LightGray, Goldenrod, 95);
        EnumFlowerColor.addMix(Orange, LightSeaGreen, DarkKhaki, 80);
        EnumFlowerColor.addMix(Orange, LightSteelBlue, Tan, 85);
        EnumFlowerColor.addMix(Orange, Lime, YellowGreen, 75);
        EnumFlowerColor.addMix(Orange, LimeGreen, YellowGreen, 80);
        EnumFlowerColor.addMix(Orange, Magenta, PaleVioletRed, 60);
        EnumFlowerColor.addMix(Orange, Maroon, Chocolate, 70);
        EnumFlowerColor.addMix(Orange, MediumAquamarine, DarkKhaki, 80);
        EnumFlowerColor.addMix(Orange, MediumOrchid, Salmon, 65);
        EnumFlowerColor.addMix(Orange, MediumPurple, DarkSalmon, 65);
        EnumFlowerColor.addMix(Orange, MediumSeaGreen, DarkKhaki, 80);
        EnumFlowerColor.addMix(Orange, MediumVioletRed, Red, 65);
        EnumFlowerColor.addMix(Orange, MistyRose, SandyBrown, 95);
        EnumFlowerColor.addMix(Orange, Olive, DarkGoldenrod, 95);
        EnumFlowerColor.addMix(Orange, OliveDrab, Goldenrod, 90);
        EnumFlowerColor.addMix(PaleGreen, Aquamarine, SpringGreen, 115);
        EnumFlowerColor.addMix(PaleGreen, Blue, SteelBlue, 50);
        EnumFlowerColor.addMix(PaleGreen, Brown, DarkKhaki, 45);
        EnumFlowerColor.addMix(PaleGreen, CadetBlue, MediumAquamarine, 95);
        EnumFlowerColor.addMix(PaleGreen, Chocolate, DarkKhaki, 65);
        EnumFlowerColor.addMix(PaleGreen, Coral, DarkKhaki, 65);
        EnumFlowerColor.addMix(PaleGreen, Cyan, Aquamarine, 100);
        EnumFlowerColor.addMix(PaleGreen, DarkGoldenrod, YellowGreen, 85);
        EnumFlowerColor.addMix(PaleGreen, DarkGray, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(PaleGreen, DarkGreen, MediumSeaGreen, 80);
        EnumFlowerColor.addMix(PaleGreen, DarkKhaki, YellowGreen, 105);
        EnumFlowerColor.addMix(PaleGreen, DarkOliveGreen, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(PaleGreen, DarkOrange, DarkKhaki, 75);
        EnumFlowerColor.addMix(PaleGreen, DarkSalmon, DarkKhaki, 75);
        EnumFlowerColor.addMix(PaleGreen, DarkSeaGreen, MediumAquamarine, 110);
        EnumFlowerColor.addMix(PaleGreen, DarkSlateBlue, CadetBlue, 55);
        EnumFlowerColor.addMix(PaleGreen, DarkSlateGray, MediumSeaGreen, 70);
        EnumFlowerColor.addMix(PaleGreen, DarkTurquoise, MediumAquamarine, 95);
        EnumFlowerColor.addMix(PaleGreen, DarkViolet, MediumPurple, 55);
        EnumFlowerColor.addMix(PaleGreen, DeepSkyBlue, Turquoise, 75);
        EnumFlowerColor.addMix(PaleGreen, DimGray, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(PaleGreen, DodgerBlue, DarkTurquoise, 65);
        EnumFlowerColor.addMix(PaleGreen, Gold, YellowGreen, 95);
        EnumFlowerColor.addMix(PaleGreen, Goldenrod, YellowGreen, 90);
        EnumFlowerColor.addMix(PaleGreen, Gray, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(PaleGreen, Green, LimeGreen, 90);
        EnumFlowerColor.addMix(PaleGreen, IndianRed, DarkKhaki, 55);
        EnumFlowerColor.addMix(PaleGreen, Khaki, YellowGreen, 105);
        EnumFlowerColor.addMix(PaleGreen, Lavender, Aquamarine, 90);
        EnumFlowerColor.addMix(PaleGreen, LightGray, DarkSeaGreen, 100);
        EnumFlowerColor.addMix(PaleGreen, LightSeaGreen, MediumAquamarine, 100);
        EnumFlowerColor.addMix(PaleGreen, LightSteelBlue, MediumAquamarine, 90);
        EnumFlowerColor.addMix(PaleGreen, Lime, SpringGreen, 115);
        EnumFlowerColor.addMix(PaleGreen, LimeGreen, SpringGreen, 115);
        EnumFlowerColor.addMix(PaleGreen, MediumAquamarine, Aquamarine, 110);
        EnumFlowerColor.addMix(PaleGreen, MediumOrchid, DarkGray, 65);
        EnumFlowerColor.addMix(PaleGreen, MediumPurple, CadetBlue, 65);
        EnumFlowerColor.addMix(PaleGreen, MediumSeaGreen, LimeGreen, 110);
        EnumFlowerColor.addMix(PaleGreen, MistyRose, LemonChiffon, 90);
        EnumFlowerColor.addMix(PaleGreen, Olive, YellowGreen, 90);
        EnumFlowerColor.addMix(PaleGreen, OliveDrab, LimeGreen, 95);
        EnumFlowerColor.addMix(PaleGreen, Orange, Khaki, 80);
        EnumFlowerColor.addMix(PaleTurquoise, Aquamarine, Turquoise, 110);
        EnumFlowerColor.addMix(PaleTurquoise, Blue, RoyalBlue, 65);
        EnumFlowerColor.addMix(PaleTurquoise, Brown, RosyBrown, 60);
        EnumFlowerColor.addMix(PaleTurquoise, CadetBlue, DarkTurquoise, 105);
        EnumFlowerColor.addMix(PaleTurquoise, Chocolate, Tan, 75);
        EnumFlowerColor.addMix(PaleTurquoise, Coral, Tan, 80);
        EnumFlowerColor.addMix(PaleTurquoise, Crimson, PaleVioletRed, 65);
        EnumFlowerColor.addMix(PaleTurquoise, Cyan, Turquoise, 115);
        EnumFlowerColor.addMix(PaleTurquoise, DarkGoldenrod, DarkKhaki, 85);
        EnumFlowerColor.addMix(PaleTurquoise, DarkGray, SkyBlue, 105);
        EnumFlowerColor.addMix(PaleTurquoise, DarkGreen, MediumSeaGreen, 75);
        EnumFlowerColor.addMix(PaleTurquoise, DarkKhaki, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(PaleTurquoise, DarkOliveGreen, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(PaleTurquoise, DarkOrange, DarkKhaki, 80);
        EnumFlowerColor.addMix(PaleTurquoise, DarkSalmon, LightGray, 85);
        EnumFlowerColor.addMix(PaleTurquoise, DarkSeaGreen, MediumAquamarine, 105);
        EnumFlowerColor.addMix(PaleTurquoise, DarkSlateBlue, SteelBlue, 65);
        EnumFlowerColor.addMix(PaleTurquoise, DarkSlateGray, CadetBlue, 75);
        EnumFlowerColor.addMix(PaleTurquoise, DarkTurquoise, Turquoise, 115);
        EnumFlowerColor.addMix(PaleTurquoise, DarkViolet, MediumPurple, 75);
        EnumFlowerColor.addMix(PaleTurquoise, DeepPink, Plum, 75);
        EnumFlowerColor.addMix(PaleTurquoise, DeepSkyBlue, SkyBlue, 105);
        EnumFlowerColor.addMix(PaleTurquoise, DimGray, CadetBlue, 85);
        EnumFlowerColor.addMix(PaleTurquoise, DodgerBlue, DeepSkyBlue, 90);
        EnumFlowerColor.addMix(PaleTurquoise, Gold, Khaki, 90);
        EnumFlowerColor.addMix(PaleTurquoise, Goldenrod, DarkKhaki, 85);
        EnumFlowerColor.addMix(PaleTurquoise, Gray, CadetBlue, 95);
        EnumFlowerColor.addMix(PaleTurquoise, Green, MediumSeaGreen, 80);
        EnumFlowerColor.addMix(PaleTurquoise, HotPink, Plum, 80);
        EnumFlowerColor.addMix(PaleTurquoise, IndianRed, RosyBrown, 70);
        EnumFlowerColor.addMix(PaleTurquoise, Indigo, MediumPurple, 50);
        EnumFlowerColor.addMix(PaleTurquoise, Khaki, LemonChiffon, 95);
        EnumFlowerColor.addMix(PaleTurquoise, Lavender, SkyBlue, 105);
        EnumFlowerColor.addMix(PaleTurquoise, LightGray, SkyBlue, 110);
        EnumFlowerColor.addMix(PaleTurquoise, LightSeaGreen, DarkTurquoise, 110);
        EnumFlowerColor.addMix(PaleTurquoise, LightSteelBlue, SkyBlue, 110);
        EnumFlowerColor.addMix(PaleTurquoise, Lime, SpringGreen, 95);
        EnumFlowerColor.addMix(PaleTurquoise, LimeGreen, PaleGreen, 95);
        EnumFlowerColor.addMix(PaleTurquoise, Magenta, Violet, 85);
        EnumFlowerColor.addMix(PaleTurquoise, Maroon, RosyBrown, 50);
        EnumFlowerColor.addMix(PaleTurquoise, MediumAquamarine, Turquoise, 110);
        EnumFlowerColor.addMix(PaleTurquoise, MediumOrchid, Plum, 85);
        EnumFlowerColor.addMix(PaleTurquoise, MediumPurple, LightSteelBlue, 85);
        EnumFlowerColor.addMix(PaleTurquoise, MediumSeaGreen, MediumAquamarine, 100);
        EnumFlowerColor.addMix(PaleTurquoise, MediumVioletRed, Plum, 70);
        EnumFlowerColor.addMix(PaleTurquoise, MistyRose, LightGray, 95);
        EnumFlowerColor.addMix(PaleTurquoise, Olive, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(PaleTurquoise, OliveDrab, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(PaleTurquoise, Orange, DarkKhaki, 85);
        EnumFlowerColor.addMix(PaleTurquoise, PaleGreen, Aquamarine, 100);
        EnumFlowerColor.addMix(PaleVioletRed, Aquamarine, DarkGray, 55);
        EnumFlowerColor.addMix(PaleVioletRed, Blue, DarkViolet, 85);
        EnumFlowerColor.addMix(PaleVioletRed, Brown, IndianRed, 100);
        EnumFlowerColor.addMix(PaleVioletRed, CadetBlue, RosyBrown, 80);
        EnumFlowerColor.addMix(PaleVioletRed, Chocolate, IndianRed, 95);
        EnumFlowerColor.addMix(PaleVioletRed, Coral, Salmon, 100);
        EnumFlowerColor.addMix(PaleVioletRed, Crimson, IndianRed, 105);
        EnumFlowerColor.addMix(PaleVioletRed, Cyan, SkyBlue, 50);
        EnumFlowerColor.addMix(PaleVioletRed, DarkGoldenrod, Chocolate, 80);
        EnumFlowerColor.addMix(PaleVioletRed, DarkGray, RosyBrown, 100);
        EnumFlowerColor.addMix(PaleVioletRed, DarkGreen, DarkOliveGreen, 55);
        EnumFlowerColor.addMix(PaleVioletRed, DarkKhaki, DarkSalmon, 75);
        EnumFlowerColor.addMix(PaleVioletRed, DarkOliveGreen, Sienna, 70);
        EnumFlowerColor.addMix(PaleVioletRed, DarkOrange, Coral, 85);
        EnumFlowerColor.addMix(PaleVioletRed, DarkSalmon, Salmon, 105);
        EnumFlowerColor.addMix(PaleVioletRed, DarkSeaGreen, RosyBrown, 70);
        EnumFlowerColor.addMix(PaleVioletRed, DarkSlateBlue, MediumVioletRed, 90);
        EnumFlowerColor.addMix(PaleVioletRed, DarkTurquoise, CadetBlue, 60);
        EnumFlowerColor.addMix(PaleVioletRed, DarkViolet, MediumOrchid, 95);
        EnumFlowerColor.addMix(PaleVioletRed, DeepPink, HotPink, 115);
        EnumFlowerColor.addMix(PaleVioletRed, DeepSkyBlue, DodgerBlue, 70);
        EnumFlowerColor.addMix(PaleVioletRed, DodgerBlue, MediumPurple, 85);
        EnumFlowerColor.addMix(PaleVioletRed, Gold, SandyBrown, 65);
        EnumFlowerColor.addMix(PaleVioletRed, Goldenrod, Peru, 80);
        EnumFlowerColor.addMix(PaleVioletRed, Gray, RosyBrown, 100);
        EnumFlowerColor.addMix(PaleVioletRed, Green, DarkOliveGreen, 55);
        EnumFlowerColor.addMix(PaleVioletRed, HotPink, DeepPink, 120);
        EnumFlowerColor.addMix(PaleVioletRed, Indigo, Purple, 85);
        EnumFlowerColor.addMix(PaleVioletRed, Khaki, DarkSalmon, 70);
        EnumFlowerColor.addMix(PaleVioletRed, Lavender, Thistle, 95);
        EnumFlowerColor.addMix(PaleVioletRed, LemonChiffon, Pink, 80);
        EnumFlowerColor.addMix(PaleVioletRed, LightGray, Pink, 95);
        EnumFlowerColor.addMix(PaleVioletRed, LightSeaGreen, SlateGray, 65);
        EnumFlowerColor.addMix(PaleVioletRed, LightSteelBlue, Plum, 90);
        EnumFlowerColor.addMix(PaleVioletRed, LimeGreen, DarkSeaGreen, 50);
        EnumFlowerColor.addMix(PaleVioletRed, Magenta, MediumOrchid, 105);
        EnumFlowerColor.addMix(PaleVioletRed, Maroon, Brown, 90);
        EnumFlowerColor.addMix(PaleVioletRed, MediumAquamarine, DarkGray, 60);
        EnumFlowerColor.addMix(PaleVioletRed, MediumOrchid, HotPink, 105);
        EnumFlowerColor.addMix(PaleVioletRed, MediumPurple, MediumOrchid, 100);
        EnumFlowerColor.addMix(PaleVioletRed, MediumSeaGreen, Gray, 55);
        EnumFlowerColor.addMix(PaleVioletRed, MediumVioletRed, DeepPink, 110);
        EnumFlowerColor.addMix(PaleVioletRed, MistyRose, Pink, 95);
        EnumFlowerColor.addMix(PaleVioletRed, Navy, Purple, 80);
        EnumFlowerColor.addMix(PaleVioletRed, Olive, Peru, 70);
        EnumFlowerColor.addMix(PaleVioletRed, OliveDrab, Peru, 65);
        EnumFlowerColor.addMix(PaleVioletRed, Orange, SandyBrown, 80);
        EnumFlowerColor.addMix(PaleVioletRed, PaleGreen, DarkKhaki, 55);
        EnumFlowerColor.addMix(PaleVioletRed, PaleTurquoise, Thistle, 80);
        EnumFlowerColor.addMix(Peru, Aquamarine, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(Peru, Blue, DarkSlateBlue, 60);
        EnumFlowerColor.addMix(Peru, Brown, Sienna, 95);
        EnumFlowerColor.addMix(Peru, Chocolate, DarkOrange, 120);
        EnumFlowerColor.addMix(Peru, Coral, Chocolate, 115);
        EnumFlowerColor.addMix(Peru, Crimson, IndianRed, 95);
        EnumFlowerColor.addMix(Peru, Cyan, MediumAquamarine, 75);
        EnumFlowerColor.addMix(Peru, DarkGoldenrod, Goldenrod, 115);
        EnumFlowerColor.addMix(Peru, DarkGray, Tan, 100);
        EnumFlowerColor.addMix(Peru, DarkGreen, DarkOliveGreen, 80);
        EnumFlowerColor.addMix(Peru, DarkKhaki, Goldenrod, 105);
        EnumFlowerColor.addMix(Peru, DarkOliveGreen, Olive, 90);
        EnumFlowerColor.addMix(Peru, DarkOrange, SandyBrown, 115);
        EnumFlowerColor.addMix(Peru, DarkSalmon, SandyBrown, 115);
        EnumFlowerColor.addMix(Peru, DarkSeaGreen, DarkKhaki, 90);
        EnumFlowerColor.addMix(Peru, DarkTurquoise, MediumSeaGreen, 80);
        EnumFlowerColor.addMix(Peru, DarkViolet, MediumVioletRed, 65);
        EnumFlowerColor.addMix(Peru, DeepPink, IndianRed, 85);
        EnumFlowerColor.addMix(Peru, DeepSkyBlue, CadetBlue, 75);
        EnumFlowerColor.addMix(Peru, DodgerBlue, SlateGray, 75);
        EnumFlowerColor.addMix(Peru, Gold, Goldenrod, 100);
        EnumFlowerColor.addMix(Peru, Goldenrod, DarkGoldenrod, 110);
        EnumFlowerColor.addMix(Peru, Green, OliveDrab, 80);
        EnumFlowerColor.addMix(Peru, HotPink, Salmon, 85);
        EnumFlowerColor.addMix(Peru, IndianRed, Chocolate, 100);
        EnumFlowerColor.addMix(Peru, Indigo, MediumVioletRed, 65);
        EnumFlowerColor.addMix(Peru, Khaki, Goldenrod, 95);
        EnumFlowerColor.addMix(Peru, Lavender, Tan, 90);
        EnumFlowerColor.addMix(Peru, LemonChiffon, Tan, 95);
        EnumFlowerColor.addMix(Peru, LightGray, Tan, 95);
        EnumFlowerColor.addMix(Peru, LightSeaGreen, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(Peru, LightSteelBlue, Tan, 90);
        EnumFlowerColor.addMix(Peru, Lime, LimeGreen, 75);
        EnumFlowerColor.addMix(Peru, LimeGreen, OliveDrab, 80);
        EnumFlowerColor.addMix(Peru, Magenta, DeepPink, 70);
        EnumFlowerColor.addMix(Peru, Maroon, Sienna, 90);
        EnumFlowerColor.addMix(Peru, MediumAquamarine, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(Peru, MediumOrchid, PaleVioletRed, 75);
        EnumFlowerColor.addMix(Peru, MediumPurple, PaleVioletRed, 75);
        EnumFlowerColor.addMix(Peru, MediumSeaGreen, OliveDrab, 80);
        EnumFlowerColor.addMix(Peru, MediumVioletRed, IndianRed, 80);
        EnumFlowerColor.addMix(Peru, MistyRose, Tan, 95);
        EnumFlowerColor.addMix(Peru, Olive, DarkGoldenrod, 100);
        EnumFlowerColor.addMix(Peru, OliveDrab, Olive, 95);
        EnumFlowerColor.addMix(Peru, Orange, DarkOrange, 115);
        EnumFlowerColor.addMix(Peru, PaleGreen, DarkKhaki, 80);
        EnumFlowerColor.addMix(Peru, PaleTurquoise, DarkKhaki, 85);
        EnumFlowerColor.addMix(Peru, PaleVioletRed, Salmon, 90);
        EnumFlowerColor.addMix(Pink, Aquamarine, PaleTurquoise, 75);
        EnumFlowerColor.addMix(Pink, Blue, SlateBlue, 70);
        EnumFlowerColor.addMix(Pink, Brown, IndianRed, 85);
        EnumFlowerColor.addMix(Pink, CadetBlue, DarkGray, 80);
        EnumFlowerColor.addMix(Pink, Chocolate, DarkSalmon, 90);
        EnumFlowerColor.addMix(Pink, Coral, DarkSalmon, 100);
        EnumFlowerColor.addMix(Pink, Crimson, PaleVioletRed, 90);
        EnumFlowerColor.addMix(Pink, Cyan, PaleTurquoise, 60);
        EnumFlowerColor.addMix(Pink, DarkGoldenrod, SandyBrown, 85);
        EnumFlowerColor.addMix(Pink, DarkGray, Thistle, 105);
        EnumFlowerColor.addMix(Pink, DarkGreen, OliveDrab, 60);
        EnumFlowerColor.addMix(Pink, DarkKhaki, Tan, 90);
        EnumFlowerColor.addMix(Pink, DarkOliveGreen, Tan, 70);
        EnumFlowerColor.addMix(Pink, DarkOrange, SandyBrown, 95);
        EnumFlowerColor.addMix(Pink, DarkSalmon, Salmon, 110);
        EnumFlowerColor.addMix(Pink, DarkSeaGreen, Tan, 80);
        EnumFlowerColor.addMix(Pink, DarkSlateGray, Gray, 65);
        EnumFlowerColor.addMix(Pink, DarkTurquoise, SkyBlue, 65);
        EnumFlowerColor.addMix(Pink, DarkViolet, MediumOrchid, 80);
        EnumFlowerColor.addMix(Pink, DeepPink, HotPink, 100);
        EnumFlowerColor.addMix(Pink, DeepSkyBlue, SkyBlue, 80);
        EnumFlowerColor.addMix(Pink, DimGray, RosyBrown, 90);
        EnumFlowerColor.addMix(Pink, DodgerBlue, LightSteelBlue, 85);
        EnumFlowerColor.addMix(Pink, Gold, Goldenrod, 80);
        EnumFlowerColor.addMix(Pink, Goldenrod, SandyBrown, 90);
        EnumFlowerColor.addMix(Pink, Gray, RosyBrown, 95);
        EnumFlowerColor.addMix(Pink, Green, DarkSeaGreen, 60);
        EnumFlowerColor.addMix(Pink, HotPink, PaleVioletRed, 105);
        EnumFlowerColor.addMix(Pink, IndianRed, Salmon, 100);
        EnumFlowerColor.addMix(Pink, Indigo, MediumOrchid, 60);
        EnumFlowerColor.addMix(Pink, Khaki, Wheat, 90);
        EnumFlowerColor.addMix(Pink, Lavender, Thistle, 105);
        EnumFlowerColor.addMix(Pink, LemonChiffon, MistyRose, 95);
        EnumFlowerColor.addMix(Pink, LightGray, MistyRose, 105);
        EnumFlowerColor.addMix(Pink, LightSeaGreen, CadetBlue, 70);
        EnumFlowerColor.addMix(Pink, LightSteelBlue, Thistle, 100);
        EnumFlowerColor.addMix(Pink, Lime, LimeGreen, 60);
        EnumFlowerColor.addMix(Pink, LimeGreen, DarkSeaGreen, 65);
        EnumFlowerColor.addMix(Pink, Magenta, Violet, 95);
        EnumFlowerColor.addMix(Pink, Maroon, IndianRed, 65);
        EnumFlowerColor.addMix(Pink, MediumAquamarine, LightGray, 75);
        EnumFlowerColor.addMix(Pink, MediumOrchid, Plum, 95);
        EnumFlowerColor.addMix(Pink, MediumPurple, Plum, 95);
        EnumFlowerColor.addMix(Pink, MediumSeaGreen, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(Pink, MediumVioletRed, HotPink, 90);
        EnumFlowerColor.addMix(Pink, MistyRose, Thistle, 115);
        EnumFlowerColor.addMix(Pink, Navy, SlateBlue, 50);
        EnumFlowerColor.addMix(Pink, Olive, Tan, 75);
        EnumFlowerColor.addMix(Pink, OliveDrab, DarkKhaki, 75);
        EnumFlowerColor.addMix(Pink, Orange, SandyBrown, 90);
        EnumFlowerColor.addMix(Pink, PaleGreen, LemonChiffon, 70);
        EnumFlowerColor.addMix(Pink, PaleTurquoise, LightGray, 80);
        EnumFlowerColor.addMix(Pink, PaleVioletRed, HotPink, 105);
        EnumFlowerColor.addMix(Pink, Peru, DarkSalmon, 95);
        EnumFlowerColor.addMix(Plum, Aquamarine, SkyBlue, 80);
        EnumFlowerColor.addMix(Plum, Blue, SlateBlue, 80);
        EnumFlowerColor.addMix(Plum, Brown, PaleVioletRed, 85);
        EnumFlowerColor.addMix(Plum, CadetBlue, LightSteelBlue, 90);
        EnumFlowerColor.addMix(Plum, Chocolate, Salmon, 85);
        EnumFlowerColor.addMix(Plum, Coral, Salmon, 90);
        EnumFlowerColor.addMix(Plum, Crimson, PaleVioletRed, 90);
        EnumFlowerColor.addMix(Plum, Cyan, SkyBlue, 75);
        EnumFlowerColor.addMix(Plum, DarkGoldenrod, DarkSalmon, 75);
        EnumFlowerColor.addMix(Plum, DarkGray, Thistle, 105);
        EnumFlowerColor.addMix(Plum, DarkKhaki, RosyBrown, 75);
        EnumFlowerColor.addMix(Plum, DarkOliveGreen, RosyBrown, 65);
        EnumFlowerColor.addMix(Plum, DarkOrange, DarkSalmon, 80);
        EnumFlowerColor.addMix(Plum, DarkSalmon, Pink, 95);
        EnumFlowerColor.addMix(Plum, DarkSeaGreen, DarkGray, 70);
        EnumFlowerColor.addMix(Plum, DarkSlateBlue, MediumPurple, 80);
        EnumFlowerColor.addMix(Plum, DarkTurquoise, SkyBlue, 80);
        EnumFlowerColor.addMix(Plum, DarkViolet, MediumOrchid, 90);
        EnumFlowerColor.addMix(Plum, DeepPink, HotPink, 105);
        EnumFlowerColor.addMix(Plum, DeepSkyBlue, DodgerBlue, 80);
        EnumFlowerColor.addMix(Plum, Gold, Tan, 65);
        EnumFlowerColor.addMix(Plum, Goldenrod, DarkSalmon, 75);
        EnumFlowerColor.addMix(Plum, Gray, RosyBrown, 100);
        EnumFlowerColor.addMix(Plum, Green, SeaGreen, 50);
        EnumFlowerColor.addMix(Plum, HotPink, Violet, 115);
        EnumFlowerColor.addMix(Plum, IndianRed, PaleVioletRed, 95);
        EnumFlowerColor.addMix(Plum, Indigo, MediumOrchid, 70);
        EnumFlowerColor.addMix(Plum, Khaki, MistyRose, 70);
        EnumFlowerColor.addMix(Plum, Lavender, Thistle, 105);
        EnumFlowerColor.addMix(Plum, LemonChiffon, MistyRose, 80);
        EnumFlowerColor.addMix(Plum, LightGray, Thistle, 100);
        EnumFlowerColor.addMix(Plum, LightSeaGreen, SkyBlue, 80);
        EnumFlowerColor.addMix(Plum, LightSteelBlue, Thistle, 105);
        EnumFlowerColor.addMix(Plum, Lime, LimeGreen, 45);
        EnumFlowerColor.addMix(Plum, LimeGreen, DarkSeaGreen, 50);
        EnumFlowerColor.addMix(Plum, Magenta, Violet, 105);
        EnumFlowerColor.addMix(Plum, Maroon, MediumVioletRed, 70);
        EnumFlowerColor.addMix(Plum, MediumAquamarine, LightSteelBlue, 85);
        EnumFlowerColor.addMix(Plum, MediumOrchid, Violet, 105);
        EnumFlowerColor.addMix(Plum, MediumPurple, Violet, 105);
        EnumFlowerColor.addMix(Plum, MediumSeaGreen, CadetBlue, 80);
        EnumFlowerColor.addMix(Plum, MediumVioletRed, MediumOrchid, 100);
        EnumFlowerColor.addMix(Plum, MistyRose, Thistle, 105);
        EnumFlowerColor.addMix(Plum, Navy, SlateBlue, 65);
        EnumFlowerColor.addMix(Plum, Olive, Tan, 65);
        EnumFlowerColor.addMix(Plum, OliveDrab, Tan, 60);
        EnumFlowerColor.addMix(Plum, Orange, SandyBrown, 75);
        EnumFlowerColor.addMix(Plum, PaleGreen, DarkSeaGreen, 55);
        EnumFlowerColor.addMix(Plum, PaleTurquoise, Lavender, 90);
        EnumFlowerColor.addMix(Plum, PaleVioletRed, HotPink, 110);
        EnumFlowerColor.addMix(Plum, Peru, RosyBrown, 85);
        EnumFlowerColor.addMix(Plum, Pink, Thistle, 110);
        EnumFlowerColor.addMix(Purple, Aquamarine, MediumPurple, 50);
        EnumFlowerColor.addMix(Purple, Black, Indigo, 95);
        EnumFlowerColor.addMix(Purple, Blue, Indigo, 105);
        EnumFlowerColor.addMix(Purple, Brown, MediumVioletRed, 95);
        EnumFlowerColor.addMix(Purple, CadetBlue, DarkSlateBlue, 80);
        EnumFlowerColor.addMix(Purple, Chocolate, Brown, 75);
        EnumFlowerColor.addMix(Purple, Coral, MediumVioletRed, 70);
        EnumFlowerColor.addMix(Purple, Crimson, MediumVioletRed, 95);
        EnumFlowerColor.addMix(Purple, Cyan, SteelBlue, 50);
        EnumFlowerColor.addMix(Purple, DarkGoldenrod, Brown, 60);
        EnumFlowerColor.addMix(Purple, DarkGray, MediumVioletRed, 80);
        EnumFlowerColor.addMix(Purple, DarkOrange, Crimson, 60);
        EnumFlowerColor.addMix(Purple, DarkSalmon, MediumVioletRed, 75);
        EnumFlowerColor.addMix(Purple, DarkSlateBlue, Indigo, 110);
        EnumFlowerColor.addMix(Purple, DarkSlateGray, Indigo, 105);
        EnumFlowerColor.addMix(Purple, DarkTurquoise, RoyalBlue, 60);
        EnumFlowerColor.addMix(Purple, DarkViolet, Indigo, 115);
        EnumFlowerColor.addMix(Purple, DeepPink, MediumVioletRed, 100);
        EnumFlowerColor.addMix(Purple, DeepSkyBlue, RoyalBlue, 60);
        EnumFlowerColor.addMix(Purple, DodgerBlue, SlateBlue, 80);
        EnumFlowerColor.addMix(Purple, Goldenrod, IndianRed, 50);
        EnumFlowerColor.addMix(Purple, HotPink, MediumVioletRed, 90);
        EnumFlowerColor.addMix(Purple, IndianRed, MediumVioletRed, 90);
        EnumFlowerColor.addMix(Purple, Lavender, MediumOrchid, 65);
        EnumFlowerColor.addMix(Purple, LemonChiffon, PaleVioletRed, 50);
        EnumFlowerColor.addMix(Purple, LightGray, MediumOrchid, 70);
        EnumFlowerColor.addMix(Purple, LightSeaGreen, DarkSlateBlue, 65);
        EnumFlowerColor.addMix(Purple, LightSteelBlue, MediumOrchid, 70);
        EnumFlowerColor.addMix(Purple, Magenta, DarkViolet, 95);
        EnumFlowerColor.addMix(Purple, MediumAquamarine, SlateBlue, 60);
        EnumFlowerColor.addMix(Purple, MediumOrchid, DarkViolet, 105);
        EnumFlowerColor.addMix(Purple, MediumPurple, DarkViolet, 100);
        EnumFlowerColor.addMix(Purple, MistyRose, PaleVioletRed, 65);
        EnumFlowerColor.addMix(Purple, Navy, Indigo, 110);
        EnumFlowerColor.addMix(Purple, Olive, Brown, 55);
        EnumFlowerColor.addMix(Purple, Orange, IndianRed, 50);
        EnumFlowerColor.addMix(Purple, PaleTurquoise, MediumPurple, 65);
        EnumFlowerColor.addMix(Purple, PaleVioletRed, MediumVioletRed, 95);
        EnumFlowerColor.addMix(Purple, Peru, MediumVioletRed, 70);
        EnumFlowerColor.addMix(Purple, Pink, MediumOrchid, 70);
        EnumFlowerColor.addMix(Purple, Plum, MediumOrchid, 80);
        EnumFlowerColor.addMix(Red, Aquamarine, DarkSalmon, 50);
        EnumFlowerColor.addMix(Red, Black, Maroon, 75);
        EnumFlowerColor.addMix(Red, Blue, Magenta, 70);
        EnumFlowerColor.addMix(Red, Brown, Crimson, 110);
        EnumFlowerColor.addMix(Red, CadetBlue, IndianRed, 75);
        EnumFlowerColor.addMix(Red, Crimson, IndianRed, 115);
        EnumFlowerColor.addMix(Red, DarkGoldenrod, Chocolate, 90);
        EnumFlowerColor.addMix(Red, DarkGray, IndianRed, 90);
        EnumFlowerColor.addMix(Red, DarkGreen, Maroon, 55);
        EnumFlowerColor.addMix(Red, DarkKhaki, Chocolate, 80);
        EnumFlowerColor.addMix(Red, DarkOliveGreen, Brown, 70);
        EnumFlowerColor.addMix(Red, DarkOrange, Coral, 100);
        EnumFlowerColor.addMix(Red, DarkSalmon, IndianRed, 105);
        EnumFlowerColor.addMix(Red, DarkSeaGreen, IndianRed, 65);
        EnumFlowerColor.addMix(Red, DarkSlateBlue, Brown, 80);
        EnumFlowerColor.addMix(Red, DarkSlateGray, Brown, 75);
        EnumFlowerColor.addMix(Red, DarkTurquoise, DimGray, 60);
        EnumFlowerColor.addMix(Red, DarkViolet, MediumVioletRed, 80);
        EnumFlowerColor.addMix(Red, DeepPink, Crimson, 95);
        EnumFlowerColor.addMix(Red, DeepSkyBlue, Plum, 60);
        EnumFlowerColor.addMix(Red, DimGray, Brown, 95);
        EnumFlowerColor.addMix(Red, DodgerBlue, MediumVioletRed, 75);
        EnumFlowerColor.addMix(Red, Gold, Chocolate, 75);
        EnumFlowerColor.addMix(Red, Goldenrod, Chocolate, 85);
        EnumFlowerColor.addMix(Red, Gray, Crimson, 95);
        EnumFlowerColor.addMix(Red, Green, Sienna, 50);
        EnumFlowerColor.addMix(Red, HotPink, IndianRed, 95);
        EnumFlowerColor.addMix(Red, IndianRed, Crimson, 110);
        EnumFlowerColor.addMix(Red, Indigo, Brown, 75);
        EnumFlowerColor.addMix(Red, Khaki, Coral, 75);
        EnumFlowerColor.addMix(Red, Lavender, Salmon, 80);
        EnumFlowerColor.addMix(Red, LemonChiffon, Salmon, 75);
        EnumFlowerColor.addMix(Red, LightGray, IndianRed, 85);
        EnumFlowerColor.addMix(Red, LightSeaGreen, Sienna, 60);
        EnumFlowerColor.addMix(Red, LightSteelBlue, IndianRed, 80);
        EnumFlowerColor.addMix(Red, Magenta, DeepPink, 85);
        EnumFlowerColor.addMix(Red, Maroon, Brown, 100);
        EnumFlowerColor.addMix(Red, MediumAquamarine, IndianRed, 60);
        EnumFlowerColor.addMix(Red, MediumOrchid, DeepPink, 85);
        EnumFlowerColor.addMix(Red, MediumPurple, MediumVioletRed, 80);
        EnumFlowerColor.addMix(Red, MediumSeaGreen, Sienna, 55);
        EnumFlowerColor.addMix(Red, MediumVioletRed, Crimson, 95);
        EnumFlowerColor.addMix(Red, MistyRose, Salmon, 85);
        EnumFlowerColor.addMix(Red, Olive, Sienna, 75);
        EnumFlowerColor.addMix(Red, OliveDrab, Sienna, 65);
        EnumFlowerColor.addMix(Red, Orange, Coral, 90);
        EnumFlowerColor.addMix(Red, PaleGreen, Peru, 50);
        EnumFlowerColor.addMix(Red, PaleTurquoise, IndianRed, 65);
        EnumFlowerColor.addMix(Red, PaleVioletRed, Crimson, 100);
        EnumFlowerColor.addMix(Red, Peru, Chocolate, 105);
        EnumFlowerColor.addMix(Red, Pink, Salmon, 90);
        EnumFlowerColor.addMix(Red, Plum, IndianRed, 85);
        EnumFlowerColor.addMix(Red, Purple, Crimson, 80);
        EnumFlowerColor.addMix(RosyBrown, Aquamarine, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(RosyBrown, Blue, SlateBlue, 80);
        EnumFlowerColor.addMix(RosyBrown, Brown, IndianRed, 95);
        EnumFlowerColor.addMix(RosyBrown, CadetBlue, DarkGray, 90);
        EnumFlowerColor.addMix(RosyBrown, Chocolate, Peru, 105);
        EnumFlowerColor.addMix(RosyBrown, Coral, DarkSalmon, 105);
        EnumFlowerColor.addMix(RosyBrown, Crimson, IndianRed, 100);
        EnumFlowerColor.addMix(RosyBrown, Cyan, DarkTurquoise, 75);
        EnumFlowerColor.addMix(RosyBrown, DarkGoldenrod, Peru, 95);
        EnumFlowerColor.addMix(RosyBrown, DarkGreen, DarkOliveGreen, 75);
        EnumFlowerColor.addMix(RosyBrown, DarkKhaki, Tan, 95);
        EnumFlowerColor.addMix(RosyBrown, DarkOrange, Peru, 100);
        EnumFlowerColor.addMix(RosyBrown, DarkSalmon, Salmon, 115);
        EnumFlowerColor.addMix(RosyBrown, DarkSeaGreen, DarkGray, 85);
        EnumFlowerColor.addMix(RosyBrown, DarkSlateGray, DimGray, 80);
        EnumFlowerColor.addMix(RosyBrown, DarkTurquoise, CadetBlue, 80);
        EnumFlowerColor.addMix(RosyBrown, DarkViolet, MediumOrchid, 85);
        EnumFlowerColor.addMix(RosyBrown, DeepPink, PaleVioletRed, 105);
        EnumFlowerColor.addMix(RosyBrown, DeepSkyBlue, SkyBlue, 85);
        EnumFlowerColor.addMix(RosyBrown, DimGray, Gray, 100);
        EnumFlowerColor.addMix(RosyBrown, DodgerBlue, SteelBlue, 90);
        EnumFlowerColor.addMix(RosyBrown, Gold, Goldenrod, 85);
        EnumFlowerColor.addMix(RosyBrown, Goldenrod, Peru, 95);
        EnumFlowerColor.addMix(RosyBrown, Green, OliveDrab, 75);
        EnumFlowerColor.addMix(RosyBrown, HotPink, PaleVioletRed, 105);
        EnumFlowerColor.addMix(RosyBrown, IndianRed, PaleVioletRed, 110);
        EnumFlowerColor.addMix(RosyBrown, Indigo, Purple, 80);
        EnumFlowerColor.addMix(RosyBrown, Khaki, Tan, 90);
        EnumFlowerColor.addMix(RosyBrown, Lavender, Thistle, 100);
        EnumFlowerColor.addMix(RosyBrown, LemonChiffon, Tan, 90);
        EnumFlowerColor.addMix(RosyBrown, LightGray, DarkGray, 105);
        EnumFlowerColor.addMix(RosyBrown, LightSeaGreen, CadetBlue, 85);
        EnumFlowerColor.addMix(RosyBrown, LightSteelBlue, Thistle, 100);
        EnumFlowerColor.addMix(RosyBrown, Lime, LimeGreen, 65);
        EnumFlowerColor.addMix(RosyBrown, LimeGreen, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(RosyBrown, Magenta, MediumOrchid, 95);
        EnumFlowerColor.addMix(RosyBrown, Maroon, Brown, 85);
        EnumFlowerColor.addMix(RosyBrown, MediumAquamarine, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(RosyBrown, MediumOrchid, PaleVioletRed, 100);
        EnumFlowerColor.addMix(RosyBrown, MediumPurple, Plum, 100);
        EnumFlowerColor.addMix(RosyBrown, MediumSeaGreen, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(RosyBrown, MediumVioletRed, DeepPink, 100);
        EnumFlowerColor.addMix(RosyBrown, MistyRose, Pink, 105);
        EnumFlowerColor.addMix(RosyBrown, Navy, DarkSlateBlue, 75);
        EnumFlowerColor.addMix(RosyBrown, Olive, DarkGoldenrod, 90);
        EnumFlowerColor.addMix(RosyBrown, OliveDrab, Olive, 85);
        EnumFlowerColor.addMix(RosyBrown, Orange, SandyBrown, 95);
        EnumFlowerColor.addMix(RosyBrown, PaleGreen, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(RosyBrown, PaleTurquoise, DarkGray, 85);
        EnumFlowerColor.addMix(RosyBrown, PaleVioletRed, HotPink, 115);
        EnumFlowerColor.addMix(RosyBrown, Peru, DarkSalmon, 105);
        EnumFlowerColor.addMix(RosyBrown, Pink, Thistle, 110);
        EnumFlowerColor.addMix(RosyBrown, Plum, Thistle, 105);
        EnumFlowerColor.addMix(RosyBrown, Purple, MediumVioletRed, 85);
        EnumFlowerColor.addMix(RosyBrown, Red, IndianRed, 100);
        EnumFlowerColor.addMix(RoyalBlue, Aquamarine, DeepSkyBlue, 70);
        EnumFlowerColor.addMix(RoyalBlue, Black, DarkSlateBlue, 80);
        EnumFlowerColor.addMix(RoyalBlue, Blue, SlateBlue, 105);
        EnumFlowerColor.addMix(RoyalBlue, Brown, DarkSlateBlue, 85);
        EnumFlowerColor.addMix(RoyalBlue, CadetBlue, SteelBlue, 95);
        EnumFlowerColor.addMix(RoyalBlue, Crimson, Purple, 85);
        EnumFlowerColor.addMix(RoyalBlue, Cyan, DeepSkyBlue, 75);
        EnumFlowerColor.addMix(RoyalBlue, DarkGoldenrod, Gray, 65);
        EnumFlowerColor.addMix(RoyalBlue, DarkGray, SteelBlue, 95);
        EnumFlowerColor.addMix(RoyalBlue, DarkGreen, DarkSlateGray, 70);
        EnumFlowerColor.addMix(RoyalBlue, DarkKhaki, SlateGray, 60);
        EnumFlowerColor.addMix(RoyalBlue, DarkOliveGreen, SteelBlue, 70);
        EnumFlowerColor.addMix(RoyalBlue, DarkOrange, RosyBrown, 65);
        EnumFlowerColor.addMix(RoyalBlue, DarkSalmon, MediumPurple, 80);
        EnumFlowerColor.addMix(RoyalBlue, DarkSeaGreen, SteelBlue, 75);
        EnumFlowerColor.addMix(RoyalBlue, DarkSlateBlue, SlateBlue, 110);
        EnumFlowerColor.addMix(RoyalBlue, DarkSlateGray, SlateBlue, 95);
        EnumFlowerColor.addMix(RoyalBlue, DarkTurquoise, DodgerBlue, 85);
        EnumFlowerColor.addMix(RoyalBlue, DarkViolet, Blue, 105);
        EnumFlowerColor.addMix(RoyalBlue, DeepPink, DarkViolet, 90);
        EnumFlowerColor.addMix(RoyalBlue, DeepSkyBlue, DodgerBlue, 95);
        EnumFlowerColor.addMix(RoyalBlue, DimGray, SlateBlue, 100);
        EnumFlowerColor.addMix(RoyalBlue, DodgerBlue, SteelBlue, 110);
        EnumFlowerColor.addMix(RoyalBlue, Gold, DarkKhaki, 50);
        EnumFlowerColor.addMix(RoyalBlue, Goldenrod, Gray, 60);
        EnumFlowerColor.addMix(RoyalBlue, Gray, SteelBlue, 100);
        EnumFlowerColor.addMix(RoyalBlue, Green, Teal, 65);
        EnumFlowerColor.addMix(RoyalBlue, HotPink, MediumPurple, 90);
        EnumFlowerColor.addMix(RoyalBlue, IndianRed, MediumPurple, 85);
        EnumFlowerColor.addMix(RoyalBlue, Indigo, DarkSlateBlue, 100);
        EnumFlowerColor.addMix(RoyalBlue, Khaki, DarkGray, 55);
        EnumFlowerColor.addMix(RoyalBlue, Lavender, LightSteelBlue, 85);
        EnumFlowerColor.addMix(RoyalBlue, LemonChiffon, LightSteelBlue, 65);
        EnumFlowerColor.addMix(RoyalBlue, LightGray, LightSteelBlue, 85);
        EnumFlowerColor.addMix(RoyalBlue, LightSeaGreen, SteelBlue, 85);
        EnumFlowerColor.addMix(RoyalBlue, LightSteelBlue, DodgerBlue, 100);
        EnumFlowerColor.addMix(RoyalBlue, Lime, MediumSeaGreen, 55);
        EnumFlowerColor.addMix(RoyalBlue, LimeGreen, LightSeaGreen, 60);
        EnumFlowerColor.addMix(RoyalBlue, Magenta, DarkViolet, 95);
        EnumFlowerColor.addMix(RoyalBlue, Maroon, Purple, 80);
        EnumFlowerColor.addMix(RoyalBlue, MediumAquamarine, DodgerBlue, 80);
        EnumFlowerColor.addMix(RoyalBlue, MediumOrchid, SlateBlue, 105);
        EnumFlowerColor.addMix(RoyalBlue, MediumPurple, SlateBlue, 115);
        EnumFlowerColor.addMix(RoyalBlue, MediumSeaGreen, SteelBlue, 75);
        EnumFlowerColor.addMix(RoyalBlue, MediumVioletRed, DarkViolet, 95);
        EnumFlowerColor.addMix(RoyalBlue, MistyRose, LightSteelBlue, 80);
        EnumFlowerColor.addMix(RoyalBlue, Navy, DarkSlateBlue, 95);
        EnumFlowerColor.addMix(RoyalBlue, Olive, DimGray, 60);
        EnumFlowerColor.addMix(RoyalBlue, OliveDrab, SlateGray, 65);
        EnumFlowerColor.addMix(RoyalBlue, PaleGreen, CadetBlue, 60);
        EnumFlowerColor.addMix(RoyalBlue, PaleTurquoise, DodgerBlue, 80);
        EnumFlowerColor.addMix(RoyalBlue, PaleVioletRed, MediumPurple, 90);
        EnumFlowerColor.addMix(RoyalBlue, Pink, MediumPurple, 85);
        EnumFlowerColor.addMix(RoyalBlue, Plum, MediumPurple, 95);
        EnumFlowerColor.addMix(RoyalBlue, Purple, DarkSlateBlue, 95);
        EnumFlowerColor.addMix(RoyalBlue, Red, MediumVioletRed, 75);
        EnumFlowerColor.addMix(RoyalBlue, RosyBrown, MediumPurple, 90);
        EnumFlowerColor.addMix(Salmon, Aquamarine, DarkKhaki, 60);
        EnumFlowerColor.addMix(Salmon, Black, Brown, 65);
        EnumFlowerColor.addMix(Salmon, Blue, DarkViolet, 70);
        EnumFlowerColor.addMix(Salmon, Brown, IndianRed, 95);
        EnumFlowerColor.addMix(Salmon, CadetBlue, RosyBrown, 80);
        EnumFlowerColor.addMix(Salmon, Chocolate, Coral, 110);
        EnumFlowerColor.addMix(Salmon, Coral, DarkSalmon, 120);
        EnumFlowerColor.addMix(Salmon, Crimson, IndianRed, 105);
        EnumFlowerColor.addMix(Salmon, Cyan, LightSeaGreen, 65);
        EnumFlowerColor.addMix(Salmon, DarkGoldenrod, Peru, 95);
        EnumFlowerColor.addMix(Salmon, DarkGray, RosyBrown, 100);
        EnumFlowerColor.addMix(Salmon, DarkGreen, Olive, 60);
        EnumFlowerColor.addMix(Salmon, DarkKhaki, SandyBrown, 90);
        EnumFlowerColor.addMix(Salmon, DarkOliveGreen, Peru, 75);
        EnumFlowerColor.addMix(Salmon, DarkOrange, Coral, 105);
        EnumFlowerColor.addMix(Salmon, DarkSalmon, Coral, 120);
        EnumFlowerColor.addMix(Salmon, DarkSeaGreen, Tan, 75);
        EnumFlowerColor.addMix(Salmon, DarkSlateBlue, MediumVioletRed, 75);
        EnumFlowerColor.addMix(Salmon, DarkTurquoise, CadetBlue, 70);
        EnumFlowerColor.addMix(Salmon, DarkViolet, MediumVioletRed, 80);
        EnumFlowerColor.addMix(Salmon, DeepPink, PaleVioletRed, 105);
        EnumFlowerColor.addMix(Salmon, DeepSkyBlue, SlateGray, 70);
        EnumFlowerColor.addMix(Salmon, DimGray, IndianRed, 95);
        EnumFlowerColor.addMix(Salmon, DodgerBlue, MediumPurple, 80);
        EnumFlowerColor.addMix(Salmon, Gold, Orange, 80);
        EnumFlowerColor.addMix(Salmon, Goldenrod, SandyBrown, 95);
        EnumFlowerColor.addMix(Salmon, Gray, RosyBrown, 100);
        EnumFlowerColor.addMix(Salmon, Green, Olive, 60);
        EnumFlowerColor.addMix(Salmon, HotPink, PaleVioletRed, 105);
        EnumFlowerColor.addMix(Salmon, IndianRed, DarkSalmon, 115);
        EnumFlowerColor.addMix(Salmon, Indigo, MediumVioletRed, 70);
        EnumFlowerColor.addMix(Salmon, Khaki, SandyBrown, 85);
        EnumFlowerColor.addMix(Salmon, Lavender, Pink, 95);
        EnumFlowerColor.addMix(Salmon, LemonChiffon, DarkSalmon, 85);
        EnumFlowerColor.addMix(Salmon, LightGray, DarkSalmon, 100);
        EnumFlowerColor.addMix(Salmon, LightSeaGreen, DarkGray, 70);
        EnumFlowerColor.addMix(Salmon, LightSteelBlue, RosyBrown, 90);
        EnumFlowerColor.addMix(Salmon, Lime, YellowGreen, 50);
        EnumFlowerColor.addMix(Salmon, LimeGreen, DarkKhaki, 55);
        EnumFlowerColor.addMix(Salmon, Magenta, HotPink, 90);
        EnumFlowerColor.addMix(Salmon, Maroon, Crimson, 85);
        EnumFlowerColor.addMix(Salmon, MediumAquamarine, Tan, 70);
        EnumFlowerColor.addMix(Salmon, MediumOrchid, PaleVioletRed, 90);
        EnumFlowerColor.addMix(Salmon, MediumPurple, PaleVioletRed, 90);
        EnumFlowerColor.addMix(Salmon, MediumSeaGreen, DarkKhaki, 65);
        EnumFlowerColor.addMix(Salmon, MediumVioletRed, DeepPink, 95);
        EnumFlowerColor.addMix(Salmon, MistyRose, Pink, 100);
        EnumFlowerColor.addMix(Salmon, Navy, Purple, 65);
        EnumFlowerColor.addMix(Salmon, Olive, Peru, 80);
        EnumFlowerColor.addMix(Salmon, OliveDrab, Peru, 75);
        EnumFlowerColor.addMix(Salmon, Orange, DarkOrange, 95);
        EnumFlowerColor.addMix(Salmon, PaleGreen, DarkKhaki, 60);
        EnumFlowerColor.addMix(Salmon, PaleTurquoise, MistyRose, 80);
        EnumFlowerColor.addMix(Salmon, PaleVioletRed, IndianRed, 110);
        EnumFlowerColor.addMix(Salmon, Peru, Coral, 105);
        EnumFlowerColor.addMix(Salmon, Pink, DarkSalmon, 110);
        EnumFlowerColor.addMix(Salmon, Plum, PaleVioletRed, 100);
        EnumFlowerColor.addMix(Salmon, Purple, MediumVioletRed, 80);
        EnumFlowerColor.addMix(Salmon, Red, IndianRed, 110);
        EnumFlowerColor.addMix(Salmon, RosyBrown, DarkSalmon, 110);
        EnumFlowerColor.addMix(Salmon, RoyalBlue, MediumPurple, 80);
        EnumFlowerColor.addMix(SandyBrown, Aquamarine, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(SandyBrown, Black, Sienna, 60);
        EnumFlowerColor.addMix(SandyBrown, Blue, SlateBlue, 55);
        EnumFlowerColor.addMix(SandyBrown, Brown, Chocolate, 85);
        EnumFlowerColor.addMix(SandyBrown, CadetBlue, Tan, 85);
        EnumFlowerColor.addMix(SandyBrown, Chocolate, Peru, 110);
        EnumFlowerColor.addMix(SandyBrown, Coral, DarkSalmon, 115);
        EnumFlowerColor.addMix(SandyBrown, Crimson, IndianRed, 90);
        EnumFlowerColor.addMix(SandyBrown, Cyan, MediumAquamarine, 75);
        EnumFlowerColor.addMix(SandyBrown, DarkGoldenrod, Peru, 110);
        EnumFlowerColor.addMix(SandyBrown, DarkGray, Tan, 100);
        EnumFlowerColor.addMix(SandyBrown, DarkGreen, Olive, 70);
        EnumFlowerColor.addMix(SandyBrown, DarkKhaki, Tan, 105);
        EnumFlowerColor.addMix(SandyBrown, DarkOliveGreen, DarkGoldenrod, 85);
        EnumFlowerColor.addMix(SandyBrown, DarkOrange, Orange, 120);
        EnumFlowerColor.addMix(SandyBrown, DarkSalmon, Coral, 115);
        EnumFlowerColor.addMix(SandyBrown, DarkSeaGreen, DarkKhaki, 90);
        EnumFlowerColor.addMix(SandyBrown, DarkSlateBlue, RosyBrown, 65);
        EnumFlowerColor.addMix(SandyBrown, DarkTurquoise, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(SandyBrown, DarkViolet, MediumVioletRed, 65);
        EnumFlowerColor.addMix(SandyBrown, DeepPink, PaleVioletRed, 80);
        EnumFlowerColor.addMix(SandyBrown, DeepSkyBlue, CadetBlue, 75);
        EnumFlowerColor.addMix(SandyBrown, DimGray, Peru, 90);
        EnumFlowerColor.addMix(SandyBrown, DodgerBlue, SlateGray, 75);
        EnumFlowerColor.addMix(SandyBrown, Gold, Goldenrod, 105);
        EnumFlowerColor.addMix(SandyBrown, Goldenrod, Orange, 115);
        EnumFlowerColor.addMix(SandyBrown, Gray, Peru, 95);
        EnumFlowerColor.addMix(SandyBrown, Green, OliveDrab, 75);
        EnumFlowerColor.addMix(SandyBrown, HotPink, Salmon, 85);
        EnumFlowerColor.addMix(SandyBrown, IndianRed, Coral, 100);
        EnumFlowerColor.addMix(SandyBrown, Indigo, MediumVioletRed, 55);
        EnumFlowerColor.addMix(SandyBrown, Khaki, Tan, 100);
        EnumFlowerColor.addMix(SandyBrown, Lavender, Tan, 95);
        EnumFlowerColor.addMix(SandyBrown, LemonChiffon, Wheat, 100);
        EnumFlowerColor.addMix(SandyBrown, LightGray, Tan, 100);
        EnumFlowerColor.addMix(SandyBrown, LightSeaGreen, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(SandyBrown, LightSteelBlue, Tan, 90);
        EnumFlowerColor.addMix(SandyBrown, Lime, YellowGreen, 75);
        EnumFlowerColor.addMix(SandyBrown, LimeGreen, YellowGreen, 80);
        EnumFlowerColor.addMix(SandyBrown, Magenta, HotPink, 70);
        EnumFlowerColor.addMix(SandyBrown, Maroon, Sienna, 75);
        EnumFlowerColor.addMix(SandyBrown, MediumAquamarine, DarkKhaki, 85);
        EnumFlowerColor.addMix(SandyBrown, MediumOrchid, PaleVioletRed, 75);
        EnumFlowerColor.addMix(SandyBrown, MediumPurple, RosyBrown, 75);
        EnumFlowerColor.addMix(SandyBrown, MediumSeaGreen, DarkKhaki, 80);
        EnumFlowerColor.addMix(SandyBrown, MediumVioletRed, IndianRed, 75);
        EnumFlowerColor.addMix(SandyBrown, MistyRose, Tan, 105);
        EnumFlowerColor.addMix(SandyBrown, Olive, DarkGoldenrod, 95);
        EnumFlowerColor.addMix(SandyBrown, OliveDrab, DarkGoldenrod, 90);
        EnumFlowerColor.addMix(SandyBrown, Orange, DarkOrange, 115);
        EnumFlowerColor.addMix(SandyBrown, PaleGreen, DarkKhaki, 80);
        EnumFlowerColor.addMix(SandyBrown, PaleTurquoise, Wheat, 85);
        EnumFlowerColor.addMix(SandyBrown, PaleVioletRed, Salmon, 90);
        EnumFlowerColor.addMix(SandyBrown, Peru, DarkOrange, 115);
        EnumFlowerColor.addMix(SandyBrown, Pink, DarkSalmon, 100);
        EnumFlowerColor.addMix(SandyBrown, Plum, DarkSalmon, 85);
        EnumFlowerColor.addMix(SandyBrown, Purple, PaleVioletRed, 60);
        EnumFlowerColor.addMix(SandyBrown, Red, Coral, 100);
        EnumFlowerColor.addMix(SandyBrown, RosyBrown, DarkSalmon, 105);
        EnumFlowerColor.addMix(SandyBrown, Salmon, DarkSalmon, 105);
        EnumFlowerColor.addMix(SeaGreen, Aquamarine, MediumAquamarine, 95);
        EnumFlowerColor.addMix(SeaGreen, Blue, DarkSlateBlue, 70);
        EnumFlowerColor.addMix(SeaGreen, CadetBlue, LightSeaGreen, 105);
        EnumFlowerColor.addMix(SeaGreen, Chocolate, Olive, 75);
        EnumFlowerColor.addMix(SeaGreen, Coral, Olive, 70);
        EnumFlowerColor.addMix(SeaGreen, Crimson, Brown, 55);
        EnumFlowerColor.addMix(SeaGreen, Cyan, MediumAquamarine, 90);
        EnumFlowerColor.addMix(SeaGreen, DarkGoldenrod, OliveDrab, 90);
        EnumFlowerColor.addMix(SeaGreen, DarkGray, CadetBlue, 100);
        EnumFlowerColor.addMix(SeaGreen, DarkGreen, Green, 110);
        EnumFlowerColor.addMix(SeaGreen, DarkKhaki, DarkSeaGreen, 100);
        EnumFlowerColor.addMix(SeaGreen, DarkOliveGreen, Green, 110);
        EnumFlowerColor.addMix(SeaGreen, DarkOrange, Olive, 75);
        EnumFlowerColor.addMix(SeaGreen, DarkSeaGreen, MediumSeaGreen, 110);
        EnumFlowerColor.addMix(SeaGreen, DarkSlateBlue, DarkSlateGray, 80);
        EnumFlowerColor.addMix(SeaGreen, DarkTurquoise, LightSeaGreen, 100);
        EnumFlowerColor.addMix(SeaGreen, DarkViolet, DarkSlateBlue, 75);
        EnumFlowerColor.addMix(SeaGreen, DeepPink, MediumVioletRed, 45);
        EnumFlowerColor.addMix(SeaGreen, DeepSkyBlue, CadetBlue, 85);
        EnumFlowerColor.addMix(SeaGreen, DimGray, Teal, 100);
        EnumFlowerColor.addMix(SeaGreen, DodgerBlue, SteelBlue, 80);
        EnumFlowerColor.addMix(SeaGreen, Gold, YellowGreen, 85);
        EnumFlowerColor.addMix(SeaGreen, Goldenrod, OliveDrab, 90);
        EnumFlowerColor.addMix(SeaGreen, Green, DarkGreen, 115);
        EnumFlowerColor.addMix(SeaGreen, HotPink, RosyBrown, 50);
        EnumFlowerColor.addMix(SeaGreen, IndianRed, DimGray, 65);
        EnumFlowerColor.addMix(SeaGreen, Indigo, DarkSlateBlue, 70);
        EnumFlowerColor.addMix(SeaGreen, Khaki, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(SeaGreen, Lavender, MediumAquamarine, 85);
        EnumFlowerColor.addMix(SeaGreen, LemonChiffon, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(SeaGreen, LightGray, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(SeaGreen, LightSeaGreen, MediumSeaGreen, 105);
        EnumFlowerColor.addMix(SeaGreen, LightSteelBlue, CadetBlue, 90);
        EnumFlowerColor.addMix(SeaGreen, Lime, LimeGreen, 95);
        EnumFlowerColor.addMix(SeaGreen, LimeGreen, MediumSeaGreen, 105);
        EnumFlowerColor.addMix(SeaGreen, Magenta, DarkViolet, 75);
        EnumFlowerColor.addMix(SeaGreen, MediumAquamarine, MediumSeaGreen, 105);
        EnumFlowerColor.addMix(SeaGreen, MediumPurple, SlateGray, 80);
        EnumFlowerColor.addMix(SeaGreen, MistyRose, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(SeaGreen, Navy, DarkSlateBlue, 70);
        EnumFlowerColor.addMix(SeaGreen, Olive, OliveDrab, 105);
        EnumFlowerColor.addMix(SeaGreen, OliveDrab, Green, 110);
        EnumFlowerColor.addMix(SeaGreen, Orange, Olive, 80);
        EnumFlowerColor.addMix(SeaGreen, PaleGreen, MediumSeaGreen, 95);
        EnumFlowerColor.addMix(SeaGreen, PaleTurquoise, MediumAquamarine, 90);
        EnumFlowerColor.addMix(SeaGreen, PaleVioletRed, Gray, 60);
        EnumFlowerColor.addMix(SeaGreen, Peru, OliveDrab, 85);
        EnumFlowerColor.addMix(SeaGreen, Pink, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(SeaGreen, Plum, SlateGray, 80);
        EnumFlowerColor.addMix(SeaGreen, Purple, DarkSlateBlue, 75);
        EnumFlowerColor.addMix(SeaGreen, Red, Sienna, 60);
        EnumFlowerColor.addMix(SeaGreen, RoyalBlue, SteelBlue, 80);
        EnumFlowerColor.addMix(SeaGreen, SandyBrown, OliveDrab, 80);
        EnumFlowerColor.addMix(Sienna, Aquamarine, DarkSeaGreen, 60);
        EnumFlowerColor.addMix(Sienna, Blue, DarkSlateBlue, 75);
        EnumFlowerColor.addMix(Sienna, Brown, Maroon, 115);
        EnumFlowerColor.addMix(Sienna, CadetBlue, Gray, 85);
        EnumFlowerColor.addMix(Sienna, Coral, Chocolate, 105);
        EnumFlowerColor.addMix(Sienna, Crimson, Brown, 110);
        EnumFlowerColor.addMix(Sienna, Cyan, LightSeaGreen, 60);
        EnumFlowerColor.addMix(Sienna, DarkGoldenrod, Peru, 100);
        EnumFlowerColor.addMix(Sienna, DarkGray, RosyBrown, 95);
        EnumFlowerColor.addMix(Sienna, DarkGreen, DarkOliveGreen, 80);
        EnumFlowerColor.addMix(Sienna, DarkKhaki, Peru, 90);
        EnumFlowerColor.addMix(Sienna, DarkOrange, Chocolate, 100);
        EnumFlowerColor.addMix(Sienna, DarkSalmon, Chocolate, 100);
        EnumFlowerColor.addMix(Sienna, DarkTurquoise, CadetBlue, 70);
        EnumFlowerColor.addMix(Sienna, DarkViolet, Purple, 80);
        EnumFlowerColor.addMix(Sienna, DeepPink, Crimson, 90);
        EnumFlowerColor.addMix(Sienna, DeepSkyBlue, CadetBlue, 70);
        EnumFlowerColor.addMix(Sienna, DodgerBlue, SlateGray, 75);
        EnumFlowerColor.addMix(Sienna, Gold, Goldenrod, 80);
        EnumFlowerColor.addMix(Sienna, Goldenrod, Peru, 95);
        EnumFlowerColor.addMix(Sienna, Green, DarkOliveGreen, 75);
        EnumFlowerColor.addMix(Sienna, HotPink, IndianRed, 90);
        EnumFlowerColor.addMix(Sienna, IndianRed, Brown, 110);
        EnumFlowerColor.addMix(Sienna, Indigo, Purple, 80);
        EnumFlowerColor.addMix(Sienna, Khaki, Tan, 80);
        EnumFlowerColor.addMix(Sienna, Lavender, RosyBrown, 80);
        EnumFlowerColor.addMix(Sienna, LemonChiffon, Tan, 75);
        EnumFlowerColor.addMix(Sienna, LightGray, RosyBrown, 85);
        EnumFlowerColor.addMix(Sienna, LightSeaGreen, SeaGreen, 75);
        EnumFlowerColor.addMix(Sienna, LightSteelBlue, RosyBrown, 80);
        EnumFlowerColor.addMix(Sienna, Lime, OliveDrab, 55);
        EnumFlowerColor.addMix(Sienna, LimeGreen, OliveDrab, 65);
        EnumFlowerColor.addMix(Sienna, Magenta, MediumVioletRed, 80);
        EnumFlowerColor.addMix(Sienna, Maroon, Brown, 110);
        EnumFlowerColor.addMix(Sienna, MediumOrchid, MediumVioletRed, 85);
        EnumFlowerColor.addMix(Sienna, MediumSeaGreen, DarkOliveGreen, 70);
        EnumFlowerColor.addMix(Sienna, MediumVioletRed, Crimson, 95);
        EnumFlowerColor.addMix(Sienna, MistyRose, DarkSalmon, 85);
        EnumFlowerColor.addMix(Sienna, Navy, Purple, 75);
        EnumFlowerColor.addMix(Sienna, Olive, DarkGoldenrod, 95);
        EnumFlowerColor.addMix(Sienna, OliveDrab, Olive, 85);
        EnumFlowerColor.addMix(Sienna, Orange, Peru, 95);
        EnumFlowerColor.addMix(Sienna, PaleGreen, DarkKhaki, 65);
        EnumFlowerColor.addMix(Sienna, PaleTurquoise, DarkGray, 70);
        EnumFlowerColor.addMix(Sienna, PaleVioletRed, IndianRed, 95);
        EnumFlowerColor.addMix(Sienna, Peru, Chocolate, 105);
        EnumFlowerColor.addMix(Sienna, Pink, DarkSalmon, 90);
        EnumFlowerColor.addMix(Sienna, Plum, PaleVioletRed, 85);
        EnumFlowerColor.addMix(Sienna, Purple, MediumVioletRed, 85);
        EnumFlowerColor.addMix(Sienna, Red, Crimson, 110);
        EnumFlowerColor.addMix(Sienna, RosyBrown, IndianRed, 100);
        EnumFlowerColor.addMix(Sienna, Salmon, IndianRed, 100);
        EnumFlowerColor.addMix(Sienna, SandyBrown, Peru, 100);
        EnumFlowerColor.addMix(Sienna, SeaGreen, DarkOliveGreen, 80);
        EnumFlowerColor.addMix(SkyBlue, Aquamarine, Turquoise, 100);
        EnumFlowerColor.addMix(SkyBlue, Black, DarkSlateGray, 55);
        EnumFlowerColor.addMix(SkyBlue, Blue, RoyalBlue, 75);
        EnumFlowerColor.addMix(SkyBlue, Brown, RosyBrown, 60);
        EnumFlowerColor.addMix(SkyBlue, CadetBlue, DarkTurquoise, 110);
        EnumFlowerColor.addMix(SkyBlue, Chocolate, Tan, 75);
        EnumFlowerColor.addMix(SkyBlue, Coral, RosyBrown, 75);
        EnumFlowerColor.addMix(SkyBlue, Crimson, PaleVioletRed, 60);
        EnumFlowerColor.addMix(SkyBlue, Cyan, DarkTurquoise, 110);
        EnumFlowerColor.addMix(SkyBlue, DarkGoldenrod, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(SkyBlue, DarkGray, LightSteelBlue, 105);
        EnumFlowerColor.addMix(SkyBlue, DarkGreen, SeaGreen, 70);
        EnumFlowerColor.addMix(SkyBlue, DarkKhaki, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(SkyBlue, DarkOliveGreen, CadetBlue, 80);
        EnumFlowerColor.addMix(SkyBlue, DarkOrange, Tan, 80);
        EnumFlowerColor.addMix(SkyBlue, DarkSalmon, DarkGray, 80);
        EnumFlowerColor.addMix(SkyBlue, DarkSeaGreen, MediumAquamarine, 95);
        EnumFlowerColor.addMix(SkyBlue, DarkSlateBlue, SteelBlue, 75);
        EnumFlowerColor.addMix(SkyBlue, DarkSlateGray, CadetBlue, 80);
        EnumFlowerColor.addMix(SkyBlue, DarkTurquoise, Turquoise, 115);
        EnumFlowerColor.addMix(SkyBlue, DarkViolet, MediumPurple, 80);
        EnumFlowerColor.addMix(SkyBlue, DeepPink, MediumOrchid, 65);
        EnumFlowerColor.addMix(SkyBlue, DimGray, CadetBlue, 90);
        EnumFlowerColor.addMix(SkyBlue, DodgerBlue, DeepSkyBlue, 105);
        EnumFlowerColor.addMix(SkyBlue, Gold, DarkKhaki, 75);
        EnumFlowerColor.addMix(SkyBlue, Goldenrod, DarkKhaki, 80);
        EnumFlowerColor.addMix(SkyBlue, Gray, CadetBlue, 100);
        EnumFlowerColor.addMix(SkyBlue, Green, MediumSeaGreen, 75);
        EnumFlowerColor.addMix(SkyBlue, HotPink, Plum, 75);
        EnumFlowerColor.addMix(SkyBlue, IndianRed, RosyBrown, 70);
        EnumFlowerColor.addMix(SkyBlue, Indigo, SlateBlue, 60);
        EnumFlowerColor.addMix(SkyBlue, Khaki, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(SkyBlue, Lavender, LightSteelBlue, 105);
        EnumFlowerColor.addMix(SkyBlue, LemonChiffon, PaleTurquoise, 95);
        EnumFlowerColor.addMix(SkyBlue, LightGray, LightSteelBlue, 110);
        EnumFlowerColor.addMix(SkyBlue, LightSeaGreen, DarkTurquoise, 110);
        EnumFlowerColor.addMix(SkyBlue, LightSteelBlue, DeepSkyBlue, 115);
        EnumFlowerColor.addMix(SkyBlue, Lime, SpringGreen, 80);
        EnumFlowerColor.addMix(SkyBlue, LimeGreen, MediumAquamarine, 80);
        EnumFlowerColor.addMix(SkyBlue, Magenta, MediumOrchid, 85);
        EnumFlowerColor.addMix(SkyBlue, MediumAquamarine, DarkTurquoise, 100);
        EnumFlowerColor.addMix(SkyBlue, MediumOrchid, MediumPurple, 90);
        EnumFlowerColor.addMix(SkyBlue, MediumPurple, LightSteelBlue, 95);
        EnumFlowerColor.addMix(SkyBlue, MediumSeaGreen, MediumAquamarine, 90);
        EnumFlowerColor.addMix(SkyBlue, MediumVioletRed, MediumOrchid, 70);
        EnumFlowerColor.addMix(SkyBlue, MistyRose, LightSteelBlue, 90);
        EnumFlowerColor.addMix(SkyBlue, Navy, RoyalBlue, 55);
        EnumFlowerColor.addMix(SkyBlue, Olive, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(SkyBlue, OliveDrab, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(SkyBlue, Orange, DarkKhaki, 80);
        EnumFlowerColor.addMix(SkyBlue, PaleGreen, MediumAquamarine, 85);
        EnumFlowerColor.addMix(SkyBlue, PaleTurquoise, DarkTurquoise, 115);
        EnumFlowerColor.addMix(SkyBlue, PaleVioletRed, Thistle, 75);
        EnumFlowerColor.addMix(SkyBlue, Peru, DarkGray, 80);
        EnumFlowerColor.addMix(SkyBlue, Pink, LightSteelBlue, 85);
        EnumFlowerColor.addMix(SkyBlue, Plum, LightSteelBlue, 90);
        EnumFlowerColor.addMix(SkyBlue, Purple, MediumPurple, 65);
        EnumFlowerColor.addMix(SkyBlue, Red, IndianRed, 65);
        EnumFlowerColor.addMix(SkyBlue, RosyBrown, LightSteelBlue, 85);
        EnumFlowerColor.addMix(SkyBlue, RoyalBlue, DodgerBlue, 95);
        EnumFlowerColor.addMix(SkyBlue, Salmon, RosyBrown, 75);
        EnumFlowerColor.addMix(SkyBlue, SandyBrown, DarkGray, 85);
        EnumFlowerColor.addMix(SkyBlue, SeaGreen, LightSeaGreen, 90);
        EnumFlowerColor.addMix(SkyBlue, Sienna, Gray, 70);
        EnumFlowerColor.addMix(SlateBlue, Aquamarine, DeepSkyBlue, 70);
        EnumFlowerColor.addMix(SlateBlue, Black, DarkSlateBlue, 85);
        EnumFlowerColor.addMix(SlateBlue, Blue, DarkViolet, 110);
        EnumFlowerColor.addMix(SlateBlue, Brown, Purple, 90);
        EnumFlowerColor.addMix(SlateBlue, CadetBlue, SteelBlue, 95);
        EnumFlowerColor.addMix(SlateBlue, Coral, PaleVioletRed, 75);
        EnumFlowerColor.addMix(SlateBlue, Crimson, MediumVioletRed, 90);
        EnumFlowerColor.addMix(SlateBlue, Cyan, DeepSkyBlue, 70);
        EnumFlowerColor.addMix(SlateBlue, DarkGoldenrod, RosyBrown, 65);
        EnumFlowerColor.addMix(SlateBlue, DarkGray, MediumPurple, 90);
        EnumFlowerColor.addMix(SlateBlue, DarkGreen, DarkSlateGray, 70);
        EnumFlowerColor.addMix(SlateBlue, DarkKhaki, Gray, 60);
        EnumFlowerColor.addMix(SlateBlue, DarkOrange, IndianRed, 65);
        EnumFlowerColor.addMix(SlateBlue, DarkSalmon, PaleVioletRed, 80);
        EnumFlowerColor.addMix(SlateBlue, DarkSeaGreen, SlateGray, 75);
        EnumFlowerColor.addMix(SlateBlue, DarkSlateGray, DarkSlateBlue, 100);
        EnumFlowerColor.addMix(SlateBlue, DarkTurquoise, DodgerBlue, 80);
        EnumFlowerColor.addMix(SlateBlue, DarkViolet, Blue, 115);
        EnumFlowerColor.addMix(SlateBlue, DeepPink, MediumOrchid, 95);
        EnumFlowerColor.addMix(SlateBlue, DeepSkyBlue, DodgerBlue, 90);
        EnumFlowerColor.addMix(SlateBlue, DimGray, DarkSlateBlue, 100);
        EnumFlowerColor.addMix(SlateBlue, DodgerBlue, RoyalBlue, 105);
        EnumFlowerColor.addMix(SlateBlue, Gold, Tan, 50);
        EnumFlowerColor.addMix(SlateBlue, Goldenrod, RosyBrown, 60);
        EnumFlowerColor.addMix(SlateBlue, Gray, MediumPurple, 100);
        EnumFlowerColor.addMix(SlateBlue, Green, Teal, 70);
        EnumFlowerColor.addMix(SlateBlue, HotPink, MediumOrchid, 95);
        EnumFlowerColor.addMix(SlateBlue, IndianRed, MediumOrchid, 90);
        EnumFlowerColor.addMix(SlateBlue, Indigo, DarkSlateBlue, 105);
        EnumFlowerColor.addMix(SlateBlue, Khaki, DarkGray, 55);
        EnumFlowerColor.addMix(SlateBlue, Lavender, LightSteelBlue, 85);
        EnumFlowerColor.addMix(SlateBlue, LemonChiffon, Thistle, 60);
        EnumFlowerColor.addMix(SlateBlue, LightGray, MediumPurple, 85);
        EnumFlowerColor.addMix(SlateBlue, LightSeaGreen, SteelBlue, 85);
        EnumFlowerColor.addMix(SlateBlue, LightSteelBlue, MediumPurple, 95);
        EnumFlowerColor.addMix(SlateBlue, Lime, MediumSeaGreen, 55);
        EnumFlowerColor.addMix(SlateBlue, LimeGreen, CadetBlue, 60);
        EnumFlowerColor.addMix(SlateBlue, Magenta, MediumOrchid, 100);
        EnumFlowerColor.addMix(SlateBlue, Maroon, Purple, 80);
        EnumFlowerColor.addMix(SlateBlue, MediumAquamarine, SteelBlue, 75);
        EnumFlowerColor.addMix(SlateBlue, MediumOrchid, MediumPurple, 110);
        EnumFlowerColor.addMix(SlateBlue, MediumPurple, RoyalBlue, 115);
        EnumFlowerColor.addMix(SlateBlue, MediumSeaGreen, SteelBlue, 75);
        EnumFlowerColor.addMix(SlateBlue, MediumVioletRed, DarkViolet, 100);
        EnumFlowerColor.addMix(SlateBlue, MistyRose, Plum, 80);
        EnumFlowerColor.addMix(SlateBlue, Navy, DarkSlateBlue, 100);
        EnumFlowerColor.addMix(SlateBlue, Olive, DimGray, 60);
        EnumFlowerColor.addMix(SlateBlue, OliveDrab, DimGray, 55);
        EnumFlowerColor.addMix(SlateBlue, Orange, DarkSalmon, 60);
        EnumFlowerColor.addMix(SlateBlue, PaleGreen, CadetBlue, 60);
        EnumFlowerColor.addMix(SlateBlue, PaleTurquoise, LightSteelBlue, 80);
        EnumFlowerColor.addMix(SlateBlue, PaleVioletRed, MediumOrchid, 95);
        EnumFlowerColor.addMix(SlateBlue, Pink, Plum, 85);
        EnumFlowerColor.addMix(SlateBlue, Plum, MediumPurple, 95);
        EnumFlowerColor.addMix(SlateBlue, Purple, DarkViolet, 105);
        EnumFlowerColor.addMix(SlateBlue, Red, MediumVioletRed, 80);
        EnumFlowerColor.addMix(SlateBlue, RosyBrown, MediumPurple, 90);
        EnumFlowerColor.addMix(SlateBlue, RoyalBlue, MediumPurple, 120);
        EnumFlowerColor.addMix(SlateBlue, Salmon, PaleVioletRed, 85);
        EnumFlowerColor.addMix(SlateBlue, SandyBrown, RosyBrown, 70);
        EnumFlowerColor.addMix(SlateBlue, SeaGreen, SteelBlue, 80);
        EnumFlowerColor.addMix(SlateBlue, SkyBlue, DodgerBlue, 90);
        EnumFlowerColor.addMix(SlateGray, Aquamarine, MediumAquamarine, 85);
        EnumFlowerColor.addMix(SlateGray, Black, DarkSlateGray, 85);
        EnumFlowerColor.addMix(SlateGray, Blue, DarkSlateBlue, 100);
        EnumFlowerColor.addMix(SlateGray, Chocolate, Sienna, 90);
        EnumFlowerColor.addMix(SlateGray, Coral, RosyBrown, 90);
        EnumFlowerColor.addMix(SlateGray, Crimson, MediumVioletRed, 90);
        EnumFlowerColor.addMix(SlateGray, Cyan, DarkTurquoise, 90);
        EnumFlowerColor.addMix(SlateGray, DarkGoldenrod, Olive, 90);
        EnumFlowerColor.addMix(SlateGray, DarkGray, Gray, 110);
        EnumFlowerColor.addMix(SlateGray, DarkGreen, SeaGreen, 90);
        EnumFlowerColor.addMix(SlateGray, DarkOrange, Peru, 85);
        EnumFlowerColor.addMix(SlateGray, DarkSalmon, RosyBrown, 90);
        EnumFlowerColor.addMix(SlateGray, DarkSeaGreen, CadetBlue, 95);
        EnumFlowerColor.addMix(SlateGray, DarkSlateBlue, SlateBlue, 105);
        EnumFlowerColor.addMix(SlateGray, DarkSlateGray, DimGray, 105);
        EnumFlowerColor.addMix(SlateGray, DarkTurquoise, CadetBlue, 100);
        EnumFlowerColor.addMix(SlateGray, DarkViolet, SlateBlue, 105);
        EnumFlowerColor.addMix(SlateGray, DeepPink, MediumVioletRed, 90);
        EnumFlowerColor.addMix(SlateGray, DeepSkyBlue, SteelBlue, 105);
        EnumFlowerColor.addMix(SlateGray, DimGray, Gray, 115);
        EnumFlowerColor.addMix(SlateGray, DodgerBlue, SteelBlue, 110);
        EnumFlowerColor.addMix(SlateGray, Gold, DarkKhaki, 75);
        EnumFlowerColor.addMix(SlateGray, Goldenrod, DarkGoldenrod, 85);
        EnumFlowerColor.addMix(SlateGray, Gray, DimGray, 120);
        EnumFlowerColor.addMix(SlateGray, Green, SeaGreen, 90);
        EnumFlowerColor.addMix(SlateGray, HotPink, PaleVioletRed, 95);
        EnumFlowerColor.addMix(SlateGray, IndianRed, RosyBrown, 95);
        EnumFlowerColor.addMix(SlateGray, Indigo, DarkSlateBlue, 95);
        EnumFlowerColor.addMix(SlateGray, Khaki, DarkKhaki, 80);
        EnumFlowerColor.addMix(SlateGray, Lavender, LightSteelBlue, 95);
        EnumFlowerColor.addMix(SlateGray, LemonChiffon, DarkGray, 85);
        EnumFlowerColor.addMix(SlateGray, LightGray, DarkGray, 100);
        EnumFlowerColor.addMix(SlateGray, LightSeaGreen, CadetBlue, 100);
        EnumFlowerColor.addMix(SlateGray, LightSteelBlue, DarkGray, 105);
        EnumFlowerColor.addMix(SlateGray, Lime, LimeGreen, 75);
        EnumFlowerColor.addMix(SlateGray, LimeGreen, MediumSeaGreen, 85);
        EnumFlowerColor.addMix(SlateGray, Magenta, MediumOrchid, 100);
        EnumFlowerColor.addMix(SlateGray, MediumAquamarine, CadetBlue, 95);
        EnumFlowerColor.addMix(SlateGray, MediumOrchid, MediumPurple, 110);
        EnumFlowerColor.addMix(SlateGray, MediumPurple, SlateBlue, 115);
        EnumFlowerColor.addMix(SlateGray, MediumSeaGreen, SeaGreen, 95);
        EnumFlowerColor.addMix(SlateGray, MistyRose, DarkGray, 90);
        EnumFlowerColor.addMix(SlateGray, Navy, DarkSlateBlue, 90);
        EnumFlowerColor.addMix(SlateGray, Olive, OliveDrab, 90);
        EnumFlowerColor.addMix(SlateGray, OliveDrab, SeaGreen, 90);
        EnumFlowerColor.addMix(SlateGray, Orange, DarkGoldenrod, 85);
        EnumFlowerColor.addMix(SlateGray, PaleGreen, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(SlateGray, PaleTurquoise, SkyBlue, 95);
        EnumFlowerColor.addMix(SlateGray, PaleVioletRed, RosyBrown, 95);
        EnumFlowerColor.addMix(SlateGray, Pink, RosyBrown, 90);
        EnumFlowerColor.addMix(SlateGray, Purple, DarkSlateBlue, 95);
        EnumFlowerColor.addMix(SlateGray, Red, Crimson, 85);
        EnumFlowerColor.addMix(SlateGray, RosyBrown, Gray, 100);
        EnumFlowerColor.addMix(SlateGray, RoyalBlue, SteelBlue, 115);
        EnumFlowerColor.addMix(SlateGray, Salmon, RosyBrown, 90);
        EnumFlowerColor.addMix(SlateGray, SandyBrown, Tan, 90);
        EnumFlowerColor.addMix(SlateGray, SeaGreen, Teal, 100);
        EnumFlowerColor.addMix(SlateGray, SkyBlue, CadetBlue, 100);
        EnumFlowerColor.addMix(SlateGray, SlateBlue, MediumPurple, 115);
        EnumFlowerColor.addMix(SpringGreen, Aquamarine, PaleGreen, 110);
        EnumFlowerColor.addMix(SpringGreen, Blue, SteelBlue, 45);
        EnumFlowerColor.addMix(SpringGreen, CadetBlue, MediumAquamarine, 90);
        EnumFlowerColor.addMix(SpringGreen, Chocolate, LimeGreen, 60);
        EnumFlowerColor.addMix(SpringGreen, Coral, DarkSeaGreen, 55);
        EnumFlowerColor.addMix(SpringGreen, Cyan, Aquamarine, 100);
        EnumFlowerColor.addMix(SpringGreen, DarkGoldenrod, LimeGreen, 80);
        EnumFlowerColor.addMix(SpringGreen, DarkGray, MediumAquamarine, 95);
        EnumFlowerColor.addMix(SpringGreen, DarkGreen, MediumSeaGreen, 80);
        EnumFlowerColor.addMix(SpringGreen, DarkKhaki, LimeGreen, 100);
        EnumFlowerColor.addMix(SpringGreen, DarkOliveGreen, MediumSeaGreen, 85);
        EnumFlowerColor.addMix(SpringGreen, DarkOrange, YellowGreen, 65);
        EnumFlowerColor.addMix(SpringGreen, DarkSalmon, DarkSeaGreen, 65);
        EnumFlowerColor.addMix(SpringGreen, DarkSeaGreen, PaleGreen, 105);
        EnumFlowerColor.addMix(SpringGreen, DarkSlateBlue, LightSeaGreen, 50);
        EnumFlowerColor.addMix(SpringGreen, DarkSlateGray, MediumSeaGreen, 65);
        EnumFlowerColor.addMix(SpringGreen, DarkTurquoise, MediumAquamarine, 95);
        EnumFlowerColor.addMix(SpringGreen, DarkViolet, SteelBlue, 55);
        EnumFlowerColor.addMix(SpringGreen, DeepSkyBlue, Turquoise, 75);
        EnumFlowerColor.addMix(SpringGreen, DimGray, MediumSeaGreen, 80);
        EnumFlowerColor.addMix(SpringGreen, DodgerBlue, DarkTurquoise, 65);
        EnumFlowerColor.addMix(SpringGreen, Gold, Lime, 90);
        EnumFlowerColor.addMix(SpringGreen, Goldenrod, LimeGreen, 85);
        EnumFlowerColor.addMix(SpringGreen, Gray, MediumSeaGreen, 85);
        EnumFlowerColor.addMix(SpringGreen, Green, LimeGreen, 90);
        EnumFlowerColor.addMix(SpringGreen, IndianRed, MediumSeaGreen, 45);
        EnumFlowerColor.addMix(SpringGreen, Khaki, PaleGreen, 100);
        EnumFlowerColor.addMix(SpringGreen, Lavender, Aquamarine, 90);
        EnumFlowerColor.addMix(SpringGreen, LemonChiffon, PaleGreen, 100);
        EnumFlowerColor.addMix(SpringGreen, LightGray, Aquamarine, 95);
        EnumFlowerColor.addMix(SpringGreen, LightSeaGreen, MediumAquamarine, 95);
        EnumFlowerColor.addMix(SpringGreen, LightSteelBlue, MediumAquamarine, 85);
        EnumFlowerColor.addMix(SpringGreen, Lime, PaleGreen, 120);
        EnumFlowerColor.addMix(SpringGreen, LimeGreen, Lime, 115);
        EnumFlowerColor.addMix(SpringGreen, Magenta, MediumPurple, 60);
        EnumFlowerColor.addMix(SpringGreen, MediumAquamarine, PaleGreen, 110);
        EnumFlowerColor.addMix(SpringGreen, MediumOrchid, CadetBlue, 65);
        EnumFlowerColor.addMix(SpringGreen, MediumPurple, LightSeaGreen, 65);
        EnumFlowerColor.addMix(SpringGreen, MediumSeaGreen, LimeGreen, 110);
        EnumFlowerColor.addMix(SpringGreen, MistyRose, Aquamarine, 80);
        EnumFlowerColor.addMix(SpringGreen, Olive, LimeGreen, 90);
        EnumFlowerColor.addMix(SpringGreen, OliveDrab, LimeGreen, 95);
        EnumFlowerColor.addMix(SpringGreen, Orange, YellowGreen, 75);
        EnumFlowerColor.addMix(SpringGreen, PaleGreen, Lime, 120);
        EnumFlowerColor.addMix(SpringGreen, PaleTurquoise, Aquamarine, 100);
        EnumFlowerColor.addMix(SpringGreen, Peru, LimeGreen, 75);
        EnumFlowerColor.addMix(SpringGreen, Pink, MediumAquamarine, 65);
        EnumFlowerColor.addMix(SpringGreen, Plum, MediumAquamarine, 75);
        EnumFlowerColor.addMix(SpringGreen, Purple, Teal, 50);
        EnumFlowerColor.addMix(SpringGreen, RosyBrown, MediumSeaGreen, 70);
        EnumFlowerColor.addMix(SpringGreen, RoyalBlue, LightSeaGreen, 60);
        EnumFlowerColor.addMix(SpringGreen, Salmon, DarkSeaGreen, 50);
        EnumFlowerColor.addMix(SpringGreen, SandyBrown, LimeGreen, 75);
        EnumFlowerColor.addMix(SpringGreen, SeaGreen, MediumSeaGreen, 95);
        EnumFlowerColor.addMix(SpringGreen, Sienna, MediumSeaGreen, 55);
        EnumFlowerColor.addMix(SpringGreen, SkyBlue, Aquamarine, 85);
        EnumFlowerColor.addMix(SpringGreen, SlateBlue, LightSeaGreen, 60);
        EnumFlowerColor.addMix(SpringGreen, SlateGray, MediumSeaGreen, 80);
        EnumFlowerColor.addMix(SteelBlue, Aquamarine, DarkTurquoise, 80);
        EnumFlowerColor.addMix(SteelBlue, Black, DarkSlateBlue, 85);
        EnumFlowerColor.addMix(SteelBlue, Blue, SlateBlue, 100);
        EnumFlowerColor.addMix(SteelBlue, CadetBlue, SlateGray, 105);
        EnumFlowerColor.addMix(SteelBlue, Chocolate, Gray, 80);
        EnumFlowerColor.addMix(SteelBlue, Coral, RosyBrown, 80);
        EnumFlowerColor.addMix(SteelBlue, Crimson, MediumVioletRed, 80);
        EnumFlowerColor.addMix(SteelBlue, Cyan, DarkTurquoise, 90);
        EnumFlowerColor.addMix(SteelBlue, DarkGray, SlateGray, 105);
        EnumFlowerColor.addMix(SteelBlue, DarkGreen, SeaGreen, 75);
        EnumFlowerColor.addMix(SteelBlue, DarkKhaki, CadetBlue, 75);
        EnumFlowerColor.addMix(SteelBlue, DarkOliveGreen, Teal, 80);
        EnumFlowerColor.addMix(SteelBlue, DarkOrange, DarkGoldenrod, 75);
        EnumFlowerColor.addMix(SteelBlue, DarkSalmon, Gray, 85);
        EnumFlowerColor.addMix(SteelBlue, DarkSeaGreen, CadetBlue, 85);
        EnumFlowerColor.addMix(SteelBlue, DarkSlateBlue, RoyalBlue, 100);
        EnumFlowerColor.addMix(SteelBlue, DarkSlateGray, RoyalBlue, 100);
        EnumFlowerColor.addMix(SteelBlue, DarkTurquoise, CadetBlue, 100);
        EnumFlowerColor.addMix(SteelBlue, DarkViolet, SlateBlue, 95);
        EnumFlowerColor.addMix(SteelBlue, DeepPink, MediumOrchid, 80);
        EnumFlowerColor.addMix(SteelBlue, DeepSkyBlue, DodgerBlue, 105);
        EnumFlowerColor.addMix(SteelBlue, DimGray, SlateGray, 105);
        EnumFlowerColor.addMix(SteelBlue, Gold, DarkKhaki, 60);
        EnumFlowerColor.addMix(SteelBlue, Gray, SlateGray, 110);
        EnumFlowerColor.addMix(SteelBlue, Green, SeaGreen, 75);
        EnumFlowerColor.addMix(SteelBlue, HotPink, MediumPurple, 80);
        EnumFlowerColor.addMix(SteelBlue, Indigo, DarkSlateBlue, 90);
        EnumFlowerColor.addMix(SteelBlue, Khaki, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(SteelBlue, Lavender, LightSteelBlue, 90);
        EnumFlowerColor.addMix(SteelBlue, LemonChiffon, SkyBlue, 75);
        EnumFlowerColor.addMix(SteelBlue, LightGray, LightSteelBlue, 95);
        EnumFlowerColor.addMix(SteelBlue, LightSeaGreen, CadetBlue, 100);
        EnumFlowerColor.addMix(SteelBlue, LightSteelBlue, DodgerBlue, 105);
        EnumFlowerColor.addMix(SteelBlue, Lime, MediumSeaGreen, 65);
        EnumFlowerColor.addMix(SteelBlue, LimeGreen, MediumSeaGreen, 70);
        EnumFlowerColor.addMix(SteelBlue, Magenta, MediumOrchid, 85);
        EnumFlowerColor.addMix(SteelBlue, MediumAquamarine, CadetBlue, 90);
        EnumFlowerColor.addMix(SteelBlue, MediumOrchid, MediumPurple, 95);
        EnumFlowerColor.addMix(SteelBlue, MediumPurple, RoyalBlue, 105);
        EnumFlowerColor.addMix(SteelBlue, MediumSeaGreen, CadetBlue, 85);
        EnumFlowerColor.addMix(SteelBlue, MediumVioletRed, DarkViolet, 80);
        EnumFlowerColor.addMix(SteelBlue, MistyRose, LightSteelBlue, 85);
        EnumFlowerColor.addMix(SteelBlue, Navy, DarkSlateBlue, 90);
        EnumFlowerColor.addMix(SteelBlue, Olive, SeaGreen, 75);
        EnumFlowerColor.addMix(SteelBlue, OliveDrab, SeaGreen, 75);
        EnumFlowerColor.addMix(SteelBlue, Orange, DarkKhaki, 75);
        EnumFlowerColor.addMix(SteelBlue, PaleGreen, MediumAquamarine, 70);
        EnumFlowerColor.addMix(SteelBlue, PaleTurquoise, SkyBlue, 90);
        EnumFlowerColor.addMix(SteelBlue, Peru, Gray, 80);
        EnumFlowerColor.addMix(SteelBlue, Pink, LightSteelBlue, 85);
        EnumFlowerColor.addMix(SteelBlue, Plum, MediumPurple, 90);
        EnumFlowerColor.addMix(SteelBlue, Purple, DarkSlateBlue, 85);
        EnumFlowerColor.addMix(SteelBlue, Red, MediumVioletRed, 75);
        EnumFlowerColor.addMix(SteelBlue, RosyBrown, SlateGray, 95);
        EnumFlowerColor.addMix(SteelBlue, RoyalBlue, DodgerBlue, 115);
        EnumFlowerColor.addMix(SteelBlue, Salmon, RosyBrown, 80);
        EnumFlowerColor.addMix(SteelBlue, SandyBrown, DarkGray, 80);
        EnumFlowerColor.addMix(SteelBlue, SeaGreen, Teal, 90);
        EnumFlowerColor.addMix(SteelBlue, Sienna, DimGray, 85);
        EnumFlowerColor.addMix(SteelBlue, SkyBlue, DeepSkyBlue, 105);
        EnumFlowerColor.addMix(SteelBlue, SlateBlue, RoyalBlue, 110);
        EnumFlowerColor.addMix(SteelBlue, SlateGray, RoyalBlue, 115);
        EnumFlowerColor.addMix(SteelBlue, SpringGreen, MediumAquamarine, 70);
        EnumFlowerColor.addMix(Tan, Aquamarine, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(Tan, Black, DimGray, 60);
        EnumFlowerColor.addMix(Tan, Blue, SlateBlue, 60);
        EnumFlowerColor.addMix(Tan, Brown, IndianRed, 85);
        EnumFlowerColor.addMix(Tan, CadetBlue, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(Tan, Chocolate, Peru, 105);
        EnumFlowerColor.addMix(Tan, Coral, DarkSalmon, 105);
        EnumFlowerColor.addMix(Tan, Crimson, IndianRed, 85);
        EnumFlowerColor.addMix(Tan, Cyan, Turquoise, 90);
        EnumFlowerColor.addMix(Tan, DarkGoldenrod, Goldenrod, 110);
        EnumFlowerColor.addMix(Tan, DarkGreen, OliveDrab, 80);
        EnumFlowerColor.addMix(Tan, DarkKhaki, Wheat, 115);
        EnumFlowerColor.addMix(Tan, DarkOliveGreen, Olive, 90);
        EnumFlowerColor.addMix(Tan, DarkOrange, SandyBrown, 105);
        EnumFlowerColor.addMix(Tan, DarkSalmon, SandyBrown, 110);
        EnumFlowerColor.addMix(Tan, DarkSeaGreen, DarkKhaki, 105);
        EnumFlowerColor.addMix(Tan, DarkSlateGray, Gray, 75);
        EnumFlowerColor.addMix(Tan, DarkTurquoise, MediumAquamarine, 90);
        EnumFlowerColor.addMix(Tan, DarkViolet, MediumOrchid, 65);
        EnumFlowerColor.addMix(Tan, DeepPink, PaleVioletRed, 80);
        EnumFlowerColor.addMix(Tan, DeepSkyBlue, CadetBlue, 85);
        EnumFlowerColor.addMix(Tan, DimGray, Gray, 95);
        EnumFlowerColor.addMix(Tan, DodgerBlue, SteelBlue, 80);
        EnumFlowerColor.addMix(Tan, Gold, Goldenrod, 105);
        EnumFlowerColor.addMix(Tan, Goldenrod, DarkKhaki, 110);
        EnumFlowerColor.addMix(Tan, Gray, DarkGray, 100);
        EnumFlowerColor.addMix(Tan, Green, OliveDrab, 85);
        EnumFlowerColor.addMix(Tan, HotPink, PaleVioletRed, 85);
        EnumFlowerColor.addMix(Tan, IndianRed, DarkSalmon, 95);
        EnumFlowerColor.addMix(Tan, Khaki, Wheat, 110);
        EnumFlowerColor.addMix(Tan, Lavender, LightGray, 100);
        EnumFlowerColor.addMix(Tan, LemonChiffon, Wheat, 110);
        EnumFlowerColor.addMix(Tan, LightGray, Wheat, 110);
        EnumFlowerColor.addMix(Tan, LightSeaGreen, MediumAquamarine, 95);
        EnumFlowerColor.addMix(Tan, LightSteelBlue, DarkGray, 100);
        EnumFlowerColor.addMix(Tan, Lime, LimeGreen, 90);
        EnumFlowerColor.addMix(Tan, LimeGreen, YellowGreen, 95);
        EnumFlowerColor.addMix(Tan, Magenta, HotPink, 75);
        EnumFlowerColor.addMix(Tan, Maroon, Sienna, 70);
        EnumFlowerColor.addMix(Tan, MediumAquamarine, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(Tan, MediumOrchid, PaleVioletRed, 75);
        EnumFlowerColor.addMix(Tan, MediumPurple, Plum, 80);
        EnumFlowerColor.addMix(Tan, MediumSeaGreen, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(Tan, MediumVioletRed, PaleVioletRed, 75);
        EnumFlowerColor.addMix(Tan, MistyRose, Wheat, 110);
        EnumFlowerColor.addMix(Tan, Navy, DarkSlateBlue, 50);
        EnumFlowerColor.addMix(Tan, Olive, DarkKhaki, 100);
        EnumFlowerColor.addMix(Tan, OliveDrab, DarkKhaki, 100);
        EnumFlowerColor.addMix(Tan, Orange, Goldenrod, 110);
        EnumFlowerColor.addMix(Tan, PaleGreen, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(Tan, PaleTurquoise, LightGray, 95);
        EnumFlowerColor.addMix(Tan, PaleVioletRed, RosyBrown, 90);
        EnumFlowerColor.addMix(Tan, Peru, SandyBrown, 110);
        EnumFlowerColor.addMix(Tan, Pink, DarkSalmon, 100);
        EnumFlowerColor.addMix(Tan, Plum, Pink, 90);
        EnumFlowerColor.addMix(Tan, Purple, MediumVioletRed, 60);
        EnumFlowerColor.addMix(Tan, Red, IndianRed, 90);
        EnumFlowerColor.addMix(Tan, RosyBrown, DarkSalmon, 105);
        EnumFlowerColor.addMix(Tan, RoyalBlue, SlateGray, 75);
        EnumFlowerColor.addMix(Tan, Salmon, DarkSalmon, 100);
        EnumFlowerColor.addMix(Tan, SandyBrown, Peru, 115);
        EnumFlowerColor.addMix(Tan, SeaGreen, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(Tan, Sienna, Peru, 95);
        EnumFlowerColor.addMix(Tan, SkyBlue, DarkGray, 95);
        EnumFlowerColor.addMix(Tan, SlateGray, DarkGray, 95);
        EnumFlowerColor.addMix(Tan, SpringGreen, PaleGreen, 90);
        EnumFlowerColor.addMix(Tan, SteelBlue, DarkGray, 85);
        EnumFlowerColor.addMix(Teal, Aquamarine, LightSeaGreen, 90);
        EnumFlowerColor.addMix(Teal, Black, DarkSlateGray, 85);
        EnumFlowerColor.addMix(Teal, Blue, DarkSlateBlue, 85);
        EnumFlowerColor.addMix(Teal, Brown, DimGray, 75);
        EnumFlowerColor.addMix(Teal, CadetBlue, LightSeaGreen, 115);
        EnumFlowerColor.addMix(Teal, Chocolate, DarkOliveGreen, 80);
        EnumFlowerColor.addMix(Teal, Coral, Gray, 75);
        EnumFlowerColor.addMix(Teal, Cyan, DarkTurquoise, 90);
        EnumFlowerColor.addMix(Teal, DarkGoldenrod, OliveDrab, 85);
        EnumFlowerColor.addMix(Teal, DarkGray, CadetBlue, 100);
        EnumFlowerColor.addMix(Teal, DarkGreen, SeaGreen, 100);
        EnumFlowerColor.addMix(Teal, DarkKhaki, SeaGreen, 90);
        EnumFlowerColor.addMix(Teal, DarkOliveGreen, SeaGreen, 100);
        EnumFlowerColor.addMix(Teal, DarkOrange, OliveDrab, 75);
        EnumFlowerColor.addMix(Teal, DarkSalmon, CadetBlue, 80);
        EnumFlowerColor.addMix(Teal, DarkSeaGreen, LightSeaGreen, 100);
        EnumFlowerColor.addMix(Teal, DarkTurquoise, LightSeaGreen, 105);
        EnumFlowerColor.addMix(Teal, DarkViolet, DarkSlateBlue, 90);
        EnumFlowerColor.addMix(Teal, DeepPink, Purple, 70);
        EnumFlowerColor.addMix(Teal, DeepSkyBlue, CadetBlue, 100);
        EnumFlowerColor.addMix(Teal, DodgerBlue, SteelBlue, 95);
        EnumFlowerColor.addMix(Teal, Gold, OliveDrab, 75);
        EnumFlowerColor.addMix(Teal, Goldenrod, OliveDrab, 80);
        EnumFlowerColor.addMix(Teal, Gray, CadetBlue, 105);
        EnumFlowerColor.addMix(Teal, Green, SeaGreen, 100);
        EnumFlowerColor.addMix(Teal, IndianRed, DimGray, 75);
        EnumFlowerColor.addMix(Teal, Indigo, DarkSlateBlue, 85);
        EnumFlowerColor.addMix(Teal, Khaki, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(Teal, Lavender, CadetBlue, 85);
        EnumFlowerColor.addMix(Teal, LemonChiffon, MediumAquamarine, 80);
        EnumFlowerColor.addMix(Teal, LightGray, CadetBlue, 90);
        EnumFlowerColor.addMix(Teal, LightSeaGreen, CadetBlue, 110);
        EnumFlowerColor.addMix(Teal, LightSteelBlue, CadetBlue, 95);
        EnumFlowerColor.addMix(Teal, Lime, LimeGreen, 80);
        EnumFlowerColor.addMix(Teal, LimeGreen, MediumSeaGreen, 90);
        EnumFlowerColor.addMix(Teal, Magenta, DarkViolet, 85);
        EnumFlowerColor.addMix(Teal, Maroon, Gray, 70);
        EnumFlowerColor.addMix(Teal, MediumAquamarine, LightSeaGreen, 100);
        EnumFlowerColor.addMix(Teal, MediumOrchid, RoyalBlue, 85);
        EnumFlowerColor.addMix(Teal, MediumPurple, SteelBlue, 90);
        EnumFlowerColor.addMix(Teal, MediumSeaGreen, SeaGreen, 100);
        EnumFlowerColor.addMix(Teal, MediumVioletRed, DarkSlateBlue, 75);
        EnumFlowerColor.addMix(Teal, MistyRose, CadetBlue, 75);
        EnumFlowerColor.addMix(Teal, Navy, DarkSlateBlue, 80);
        EnumFlowerColor.addMix(Teal, Olive, SeaGreen, 95);
        EnumFlowerColor.addMix(Teal, OliveDrab, SeaGreen, 95);
        EnumFlowerColor.addMix(Teal, Orange, OliveDrab, 75);
        EnumFlowerColor.addMix(Teal, PaleGreen, MediumSeaGreen, 85);
        EnumFlowerColor.addMix(Teal, PaleTurquoise, LightSeaGreen, 95);
        EnumFlowerColor.addMix(Teal, PaleVioletRed, SlateGray, 70);
        EnumFlowerColor.addMix(Teal, Peru, SeaGreen, 85);
        EnumFlowerColor.addMix(Teal, Pink, CadetBlue, 65);
        EnumFlowerColor.addMix(Teal, Plum, SteelBlue, 80);
        EnumFlowerColor.addMix(Teal, Purple, DarkSlateBlue, 80);
        EnumFlowerColor.addMix(Teal, Red, Brown, 70);
        EnumFlowerColor.addMix(Teal, RosyBrown, CadetBlue, 85);
        EnumFlowerColor.addMix(Teal, RoyalBlue, SteelBlue, 95);
        EnumFlowerColor.addMix(Teal, Salmon, Gray, 70);
        EnumFlowerColor.addMix(Teal, SandyBrown, SeaGreen, 80);
        EnumFlowerColor.addMix(Teal, Sienna, DarkOliveGreen, 80);
        EnumFlowerColor.addMix(Teal, SkyBlue, CadetBlue, 100);
        EnumFlowerColor.addMix(Teal, SlateBlue, SteelBlue, 95);
        EnumFlowerColor.addMix(Teal, SlateGray, CadetBlue, 105);
        EnumFlowerColor.addMix(Teal, SpringGreen, MediumSeaGreen, 85);
        EnumFlowerColor.addMix(Teal, Tan, CadetBlue, 85);
        EnumFlowerColor.addMix(Thistle, Aquamarine, PaleTurquoise, 85);
        EnumFlowerColor.addMix(Thistle, Black, DimGray, 55);
        EnumFlowerColor.addMix(Thistle, Blue, SlateBlue, 75);
        EnumFlowerColor.addMix(Thistle, Brown, PaleVioletRed, 80);
        EnumFlowerColor.addMix(Thistle, CadetBlue, LightSteelBlue, 90);
        EnumFlowerColor.addMix(Thistle, Chocolate, DarkSalmon, 90);
        EnumFlowerColor.addMix(Thistle, Coral, DarkSalmon, 95);
        EnumFlowerColor.addMix(Thistle, Crimson, PaleVioletRed, 85);
        EnumFlowerColor.addMix(Thistle, Cyan, DarkTurquoise, 80);
        EnumFlowerColor.addMix(Thistle, DarkGoldenrod, Tan, 85);
        EnumFlowerColor.addMix(Thistle, DarkGray, LightGray, 110);
        EnumFlowerColor.addMix(Thistle, DarkGreen, SeaGreen, 60);
        EnumFlowerColor.addMix(Thistle, DarkKhaki, Tan, 85);
        EnumFlowerColor.addMix(Thistle, DarkOliveGreen, DarkGray, 75);
        EnumFlowerColor.addMix(Thistle, DarkOrange, SandyBrown, 90);
        EnumFlowerColor.addMix(Thistle, DarkSalmon, Pink, 100);
        EnumFlowerColor.addMix(Thistle, DarkSeaGreen, DarkGray, 85);
        EnumFlowerColor.addMix(Thistle, DarkSlateBlue, MediumPurple, 75);
        EnumFlowerColor.addMix(Thistle, DarkSlateGray, SlateGray, 70);
        EnumFlowerColor.addMix(Thistle, DarkTurquoise, SkyBlue, 85);
        EnumFlowerColor.addMix(Thistle, DarkViolet, MediumOrchid, 85);
        EnumFlowerColor.addMix(Thistle, DeepPink, HotPink, 95);
        EnumFlowerColor.addMix(Thistle, DeepSkyBlue, SkyBlue, 85);
        EnumFlowerColor.addMix(Thistle, DimGray, DarkGray, 90);
        EnumFlowerColor.addMix(Thistle, DodgerBlue, LightSteelBlue, 90);
        EnumFlowerColor.addMix(Thistle, Gold, Khaki, 80);
        EnumFlowerColor.addMix(Thistle, Goldenrod, Tan, 85);
        EnumFlowerColor.addMix(Thistle, Gray, DarkGray, 100);
        EnumFlowerColor.addMix(Thistle, Green, MediumSeaGreen, 65);
        EnumFlowerColor.addMix(Thistle, HotPink, Plum, 105);
        EnumFlowerColor.addMix(Thistle, IndianRed, RosyBrown, 95);
        EnumFlowerColor.addMix(Thistle, Indigo, MediumOrchid, 60);
        EnumFlowerColor.addMix(Thistle, Khaki, Wheat, 85);
        EnumFlowerColor.addMix(Thistle, Lavender, MistyRose, 115);
        EnumFlowerColor.addMix(Thistle, LemonChiffon, MistyRose, 90);
        EnumFlowerColor.addMix(Thistle, LightGray, Lavender, 110);
        EnumFlowerColor.addMix(Thistle, LightSeaGreen, CadetBlue, 85);
        EnumFlowerColor.addMix(Thistle, LightSteelBlue, Lavender, 110);
        EnumFlowerColor.addMix(Thistle, Lime, LimeGreen, 65);
        EnumFlowerColor.addMix(Thistle, LimeGreen, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(Thistle, Magenta, Violet, 95);
        EnumFlowerColor.addMix(Thistle, Maroon, IndianRed, 65);
        EnumFlowerColor.addMix(Thistle, MediumAquamarine, PaleTurquoise, 90);
        EnumFlowerColor.addMix(Thistle, MediumOrchid, Plum, 95);
        EnumFlowerColor.addMix(Thistle, MediumPurple, Plum, 100);
        EnumFlowerColor.addMix(Thistle, MediumSeaGreen, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(Thistle, MediumVioletRed, HotPink, 90);
        EnumFlowerColor.addMix(Thistle, MistyRose, Pink, 115);
        EnumFlowerColor.addMix(Thistle, Navy, SlateBlue, 55);
        EnumFlowerColor.addMix(Thistle, Olive, DarkKhaki, 75);
        EnumFlowerColor.addMix(Thistle, OliveDrab, DarkKhaki, 75);
        EnumFlowerColor.addMix(Thistle, Orange, SandyBrown, 85);
        EnumFlowerColor.addMix(Thistle, PaleGreen, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(Thistle, PaleTurquoise, LightSteelBlue, 90);
        EnumFlowerColor.addMix(Thistle, PaleVioletRed, Plum, 105);
        EnumFlowerColor.addMix(Thistle, Peru, DarkSalmon, 90);
        EnumFlowerColor.addMix(Thistle, Pink, MistyRose, 115);
        EnumFlowerColor.addMix(Thistle, Plum, Pink, 115);
        EnumFlowerColor.addMix(Thistle, Purple, MediumOrchid, 75);
        EnumFlowerColor.addMix(Thistle, Red, IndianRed, 85);
        EnumFlowerColor.addMix(Thistle, RosyBrown, Pink, 110);
        EnumFlowerColor.addMix(Thistle, RoyalBlue, MediumPurple, 90);
        EnumFlowerColor.addMix(Thistle, Salmon, Pink, 100);
        EnumFlowerColor.addMix(Thistle, SandyBrown, DarkSalmon, 95);
        EnumFlowerColor.addMix(Thistle, SeaGreen, CadetBlue, 85);
        EnumFlowerColor.addMix(Thistle, Sienna, RosyBrown, 85);
        EnumFlowerColor.addMix(Thistle, SkyBlue, LightSteelBlue, 90);
        EnumFlowerColor.addMix(Thistle, SlateBlue, MediumPurple, 90);
        EnumFlowerColor.addMix(Thistle, SlateGray, DarkGray, 100);
        EnumFlowerColor.addMix(Thistle, SpringGreen, MediumAquamarine, 85);
        EnumFlowerColor.addMix(Thistle, SteelBlue, LightSteelBlue, 90);
        EnumFlowerColor.addMix(Thistle, Tan, MistyRose, 100);
        EnumFlowerColor.addMix(Thistle, Teal, CadetBlue, 80);
        EnumFlowerColor.addMix(Turquoise, Aquamarine, MediumAquamarine, 115);
        EnumFlowerColor.addMix(Turquoise, Black, Teal, 50);
        EnumFlowerColor.addMix(Turquoise, Blue, RoyalBlue, 60);
        EnumFlowerColor.addMix(Turquoise, Brown, Gray, 55);
        EnumFlowerColor.addMix(Turquoise, CadetBlue, LightSeaGreen, 110);
        EnumFlowerColor.addMix(Turquoise, Chocolate, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(Turquoise, Coral, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(Turquoise, Crimson, Gray, 50);
        EnumFlowerColor.addMix(Turquoise, Cyan, DarkTurquoise, 120);
        EnumFlowerColor.addMix(Turquoise, DarkGoldenrod, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(Turquoise, DarkGray, DarkTurquoise, 100);
        EnumFlowerColor.addMix(Turquoise, DarkGreen, MediumSeaGreen, 80);
        EnumFlowerColor.addMix(Turquoise, DarkKhaki, MediumAquamarine, 95);
        EnumFlowerColor.addMix(Turquoise, DarkOliveGreen, MediumSeaGreen, 85);
        EnumFlowerColor.addMix(Turquoise, DarkOrange, DarkKhaki, 75);
        EnumFlowerColor.addMix(Turquoise, DarkSalmon, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(Turquoise, DarkSeaGreen, MediumAquamarine, 110);
        EnumFlowerColor.addMix(Turquoise, DarkSlateBlue, SteelBlue, 65);
        EnumFlowerColor.addMix(Turquoise, DarkSlateGray, CadetBlue, 75);
        EnumFlowerColor.addMix(Turquoise, DarkTurquoise, Cyan, 120);
        EnumFlowerColor.addMix(Turquoise, DarkViolet, RoyalBlue, 65);
        EnumFlowerColor.addMix(Turquoise, DeepPink, MediumPurple, 55);
        EnumFlowerColor.addMix(Turquoise, DeepSkyBlue, DarkTurquoise, 100);
        EnumFlowerColor.addMix(Turquoise, DimGray, CadetBlue, 85);
        EnumFlowerColor.addMix(Turquoise, DodgerBlue, DeepSkyBlue, 90);
        EnumFlowerColor.addMix(Turquoise, Gold, YellowGreen, 85);
        EnumFlowerColor.addMix(Turquoise, Goldenrod, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(Turquoise, Gray, LightSeaGreen, 95);
        EnumFlowerColor.addMix(Turquoise, Green, MediumSeaGreen, 90);
        EnumFlowerColor.addMix(Turquoise, HotPink, LightSteelBlue, 65);
        EnumFlowerColor.addMix(Turquoise, IndianRed, CadetBlue, 60);
        EnumFlowerColor.addMix(Turquoise, Indigo, RoyalBlue, 50);
        EnumFlowerColor.addMix(Turquoise, Khaki, MediumAquamarine, 95);
        EnumFlowerColor.addMix(Turquoise, Lavender, PaleTurquoise, 95);
        EnumFlowerColor.addMix(Turquoise, LemonChiffon, Aquamarine, 100);
        EnumFlowerColor.addMix(Turquoise, LightGray, PaleTurquoise, 100);
        EnumFlowerColor.addMix(Turquoise, LightSeaGreen, DarkTurquoise, 115);
        EnumFlowerColor.addMix(Turquoise, LightSteelBlue, DarkTurquoise, 100);
        EnumFlowerColor.addMix(Turquoise, Lime, SpringGreen, 95);
        EnumFlowerColor.addMix(Turquoise, LimeGreen, MediumSeaGreen, 100);
        EnumFlowerColor.addMix(Turquoise, Magenta, MediumPurple, 75);
        EnumFlowerColor.addMix(Turquoise, Maroon, DimGray, 45);
        EnumFlowerColor.addMix(Turquoise, MediumAquamarine, DarkTurquoise, 120);
        EnumFlowerColor.addMix(Turquoise, MediumOrchid, DodgerBlue, 75);
        EnumFlowerColor.addMix(Turquoise, MediumPurple, DeepSkyBlue, 80);
        EnumFlowerColor.addMix(Turquoise, MediumSeaGreen, MediumAquamarine, 110);
        EnumFlowerColor.addMix(Turquoise, MediumVioletRed, MediumPurple, 60);
        EnumFlowerColor.addMix(Turquoise, MistyRose, PaleTurquoise, 90);
        EnumFlowerColor.addMix(Turquoise, Navy, SteelBlue, 45);
        EnumFlowerColor.addMix(Turquoise, Olive, MediumSeaGreen, 85);
        EnumFlowerColor.addMix(Turquoise, OliveDrab, MediumSeaGreen, 90);
        EnumFlowerColor.addMix(Turquoise, Orange, YellowGreen, 80);
        EnumFlowerColor.addMix(Turquoise, PaleGreen, Aquamarine, 105);
        EnumFlowerColor.addMix(Turquoise, PaleTurquoise, Cyan, 115);
        EnumFlowerColor.addMix(Turquoise, PaleVioletRed, DarkGray, 60);
        EnumFlowerColor.addMix(Turquoise, Peru, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(Turquoise, Pink, PaleTurquoise, 75);
        EnumFlowerColor.addMix(Turquoise, Plum, SkyBlue, 80);
        EnumFlowerColor.addMix(Turquoise, Purple, RoyalBlue, 55);
        EnumFlowerColor.addMix(Turquoise, Red, RosyBrown, 55);
        EnumFlowerColor.addMix(Turquoise, RosyBrown, CadetBlue, 80);
        EnumFlowerColor.addMix(Turquoise, RoyalBlue, DeepSkyBlue, 80);
        EnumFlowerColor.addMix(Turquoise, Salmon, DarkGray, 65);
        EnumFlowerColor.addMix(Turquoise, SandyBrown, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(Turquoise, SeaGreen, MediumAquamarine, 100);
        EnumFlowerColor.addMix(Turquoise, Sienna, DarkSeaGreen, 65);
        EnumFlowerColor.addMix(Turquoise, SkyBlue, DarkTurquoise, 110);
        EnumFlowerColor.addMix(Turquoise, SlateBlue, DodgerBlue, 75);
        EnumFlowerColor.addMix(Turquoise, SlateGray, LightSeaGreen, 95);
        EnumFlowerColor.addMix(Turquoise, SpringGreen, Aquamarine, 105);
        EnumFlowerColor.addMix(Turquoise, SteelBlue, CadetBlue, 90);
        EnumFlowerColor.addMix(Turquoise, Tan, MediumAquamarine, 95);
        EnumFlowerColor.addMix(Turquoise, Teal, LightSeaGreen, 100);
        EnumFlowerColor.addMix(Turquoise, Thistle, PaleTurquoise, 85);
        EnumFlowerColor.addMix(Violet, Aquamarine, LightSteelBlue, 75);
        EnumFlowerColor.addMix(Violet, Black, Purple, 60);
        EnumFlowerColor.addMix(Violet, Blue, SlateBlue, 85);
        EnumFlowerColor.addMix(Violet, Brown, PaleVioletRed, 85);
        EnumFlowerColor.addMix(Violet, CadetBlue, Plum, 95);
        EnumFlowerColor.addMix(Violet, Chocolate, PaleVioletRed, 80);
        EnumFlowerColor.addMix(Violet, Coral, PaleVioletRed, 85);
        EnumFlowerColor.addMix(Violet, Crimson, DeepPink, 90);
        EnumFlowerColor.addMix(Violet, Cyan, DeepSkyBlue, 70);
        EnumFlowerColor.addMix(Violet, DarkGoldenrod, Salmon, 65);
        EnumFlowerColor.addMix(Violet, DarkGray, Plum, 100);
        EnumFlowerColor.addMix(Violet, DarkKhaki, RosyBrown, 65);
        EnumFlowerColor.addMix(Violet, DarkOliveGreen, RosyBrown, 55);
        EnumFlowerColor.addMix(Violet, DarkOrange, Salmon, 75);
        EnumFlowerColor.addMix(Violet, DarkSalmon, HotPink, 90);
        EnumFlowerColor.addMix(Violet, DarkSeaGreen, Thistle, 60);
        EnumFlowerColor.addMix(Violet, DarkSlateBlue, MediumOrchid, 85);
        EnumFlowerColor.addMix(Violet, DarkSlateGray, MediumPurple, 80);
        EnumFlowerColor.addMix(Violet, DarkTurquoise, DodgerBlue, 75);
        EnumFlowerColor.addMix(Violet, DarkViolet, MediumOrchid, 95);
        EnumFlowerColor.addMix(Violet, DeepPink, HotPink, 110);
        EnumFlowerColor.addMix(Violet, DeepSkyBlue, DodgerBlue, 75);
        EnumFlowerColor.addMix(Violet, DimGray, MediumOrchid, 90);
        EnumFlowerColor.addMix(Violet, DodgerBlue, MediumPurple, 90);
        EnumFlowerColor.addMix(Violet, Gold, SandyBrown, 55);
        EnumFlowerColor.addMix(Violet, Goldenrod, DarkSalmon, 65);
        EnumFlowerColor.addMix(Violet, Gray, Plum, 95);
        EnumFlowerColor.addMix(Violet, HotPink, Plum, 115);
        EnumFlowerColor.addMix(Violet, IndianRed, PaleVioletRed, 95);
        EnumFlowerColor.addMix(Violet, Indigo, DarkViolet, 80);
        EnumFlowerColor.addMix(Violet, Khaki, Pink, 60);
        EnumFlowerColor.addMix(Violet, Lavender, Plum, 100);
        EnumFlowerColor.addMix(Violet, LemonChiffon, Pink, 70);
        EnumFlowerColor.addMix(Violet, LightGray, Plum, 95);
        EnumFlowerColor.addMix(Violet, LightSteelBlue, Plum, 100);
        EnumFlowerColor.addMix(Violet, Magenta, MediumOrchid, 115);
        EnumFlowerColor.addMix(Violet, Maroon, MediumVioletRed, 70);
        EnumFlowerColor.addMix(Violet, MediumAquamarine, Thistle, 80);
        EnumFlowerColor.addMix(Violet, MediumOrchid, Magenta, 115);
        EnumFlowerColor.addMix(Violet, MediumPurple, MediumOrchid, 110);
        EnumFlowerColor.addMix(Violet, MediumSeaGreen, DarkGray, 75);
        EnumFlowerColor.addMix(Violet, MediumVioletRed, MediumOrchid, 100);
        EnumFlowerColor.addMix(Violet, MistyRose, Plum, 95);
        EnumFlowerColor.addMix(Violet, Navy, DarkViolet, 75);
        EnumFlowerColor.addMix(Violet, Olive, RosyBrown, 55);
        EnumFlowerColor.addMix(Violet, OliveDrab, RosyBrown, 50);
        EnumFlowerColor.addMix(Violet, Orange, DarkSalmon, 65);
        EnumFlowerColor.addMix(Violet, PaleTurquoise, Thistle, 90);
        EnumFlowerColor.addMix(Violet, PaleVioletRed, HotPink, 110);
        EnumFlowerColor.addMix(Violet, Peru, PaleVioletRed, 80);
        EnumFlowerColor.addMix(Violet, Pink, Plum, 105);
        EnumFlowerColor.addMix(Violet, Plum, HotPink, 120);
        EnumFlowerColor.addMix(Violet, Purple, MediumOrchid, 85);
        EnumFlowerColor.addMix(Violet, Red, DeepPink, 85);
        EnumFlowerColor.addMix(Violet, RosyBrown, Plum, 100);
        EnumFlowerColor.addMix(Violet, RoyalBlue, MediumPurple, 95);
        EnumFlowerColor.addMix(Violet, Salmon, HotPink, 95);
        EnumFlowerColor.addMix(Violet, SandyBrown, PaleVioletRed, 80);
        EnumFlowerColor.addMix(Violet, Sienna, PaleVioletRed, 80);
        EnumFlowerColor.addMix(Violet, SkyBlue, Plum, 90);
        EnumFlowerColor.addMix(Violet, SlateBlue, MediumPurple, 100);
        EnumFlowerColor.addMix(Violet, SlateGray, Plum, 100);
        EnumFlowerColor.addMix(Violet, SpringGreen, LightSeaGreen, 70);
        EnumFlowerColor.addMix(Violet, SteelBlue, MediumPurple, 90);
        EnumFlowerColor.addMix(Violet, Tan, Plum, 80);
        EnumFlowerColor.addMix(Violet, Teal, MediumPurple, 80);
        EnumFlowerColor.addMix(Violet, Thistle, Plum, 105);
        EnumFlowerColor.addMix(Violet, Turquoise, LightSteelBlue, 75);
        EnumFlowerColor.addMix(Wheat, Aquamarine, PaleGreen, 100);
        EnumFlowerColor.addMix(Wheat, Blue, MediumPurple, 50);
        EnumFlowerColor.addMix(Wheat, Brown, DarkSalmon, 75);
        EnumFlowerColor.addMix(Wheat, CadetBlue, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(Wheat, Chocolate, SandyBrown, 95);
        EnumFlowerColor.addMix(Wheat, Coral, SandyBrown, 100);
        EnumFlowerColor.addMix(Wheat, Crimson, Salmon, 80);
        EnumFlowerColor.addMix(Wheat, Cyan, Turquoise, 90);
        EnumFlowerColor.addMix(Wheat, DarkGoldenrod, Goldenrod, 100);
        EnumFlowerColor.addMix(Wheat, DarkGray, Tan, 105);
        EnumFlowerColor.addMix(Wheat, DarkGreen, OliveDrab, 75);
        EnumFlowerColor.addMix(Wheat, DarkKhaki, Khaki, 110);
        EnumFlowerColor.addMix(Wheat, DarkOliveGreen, DarkKhaki, 85);
        EnumFlowerColor.addMix(Wheat, DarkOrange, Orange, 100);
        EnumFlowerColor.addMix(Wheat, DarkSalmon, Tan, 105);
        EnumFlowerColor.addMix(Wheat, DarkSeaGreen, DarkKhaki, 105);
        EnumFlowerColor.addMix(Wheat, DarkSlateBlue, RosyBrown, 60);
        EnumFlowerColor.addMix(Wheat, DarkSlateGray, DarkGray, 70);
        EnumFlowerColor.addMix(Wheat, DarkTurquoise, MediumAquamarine, 90);
        EnumFlowerColor.addMix(Wheat, DarkViolet, MediumOrchid, 60);
        EnumFlowerColor.addMix(Wheat, DeepPink, PaleVioletRed, 75);
        EnumFlowerColor.addMix(Wheat, DeepSkyBlue, SkyBlue, 80);
        EnumFlowerColor.addMix(Wheat, DimGray, Tan, 85);
        EnumFlowerColor.addMix(Wheat, DodgerBlue, SkyBlue, 75);
        EnumFlowerColor.addMix(Wheat, Gold, Khaki, 110);
        EnumFlowerColor.addMix(Wheat, Goldenrod, DarkKhaki, 105);
        EnumFlowerColor.addMix(Wheat, Gray, Tan, 95);
        EnumFlowerColor.addMix(Wheat, Green, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(Wheat, HotPink, Pink, 80);
        EnumFlowerColor.addMix(Wheat, IndianRed, DarkSalmon, 85);
        EnumFlowerColor.addMix(Wheat, Khaki, LemonChiffon, 115);
        EnumFlowerColor.addMix(Wheat, Lavender, LightGray, 100);
        EnumFlowerColor.addMix(Wheat, LemonChiffon, Khaki, 120);
        EnumFlowerColor.addMix(Wheat, LightGray, LemonChiffon, 110);
        EnumFlowerColor.addMix(Wheat, LightSeaGreen, MediumAquamarine, 90);
        EnumFlowerColor.addMix(Wheat, LightSteelBlue, LightGray, 95);
        EnumFlowerColor.addMix(Wheat, Lime, PaleGreen, 95);
        EnumFlowerColor.addMix(Wheat, LimeGreen, YellowGreen, 95);
        EnumFlowerColor.addMix(Wheat, Magenta, Violet, 70);
        EnumFlowerColor.addMix(Wheat, Maroon, IndianRed, 60);
        EnumFlowerColor.addMix(Wheat, MediumAquamarine, DarkSeaGreen, 100);
        EnumFlowerColor.addMix(Wheat, MediumOrchid, Plum, 70);
        EnumFlowerColor.addMix(Wheat, MediumPurple, Thistle, 75);
        EnumFlowerColor.addMix(Wheat, MediumSeaGreen, DarkSeaGreen, 95);
        EnumFlowerColor.addMix(Wheat, MediumVioletRed, PaleVioletRed, 70);
        EnumFlowerColor.addMix(Wheat, MistyRose, Tan, 110);
        EnumFlowerColor.addMix(Wheat, Olive, DarkKhaki, 95);
        EnumFlowerColor.addMix(Wheat, OliveDrab, DarkKhaki, 95);
        EnumFlowerColor.addMix(Wheat, Orange, Goldenrod, 105);
        EnumFlowerColor.addMix(Wheat, PaleGreen, LemonChiffon, 100);
        EnumFlowerColor.addMix(Wheat, PaleTurquoise, LemonChiffon, 100);
        EnumFlowerColor.addMix(Wheat, PaleVioletRed, Pink, 85);
        EnumFlowerColor.addMix(Wheat, Peru, Tan, 100);
        EnumFlowerColor.addMix(Wheat, Pink, MistyRose, 100);
        EnumFlowerColor.addMix(Wheat, Plum, Pink, 85);
        EnumFlowerColor.addMix(Wheat, Purple, PaleVioletRed, 55);
        EnumFlowerColor.addMix(Wheat, Red, Salmon, 85);
        EnumFlowerColor.addMix(Wheat, RosyBrown, Tan, 100);
        EnumFlowerColor.addMix(Wheat, RoyalBlue, LightSteelBlue, 70);
        EnumFlowerColor.addMix(Wheat, Salmon, DarkSalmon, 95);
        EnumFlowerColor.addMix(Wheat, SandyBrown, Tan, 110);
        EnumFlowerColor.addMix(Wheat, SeaGreen, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(Wheat, Sienna, Peru, 85);
        EnumFlowerColor.addMix(Wheat, SkyBlue, PaleTurquoise, 95);
        EnumFlowerColor.addMix(Wheat, SlateBlue, Plum, 65);
        EnumFlowerColor.addMix(Wheat, SlateGray, DarkGray, 90);
        EnumFlowerColor.addMix(Wheat, SpringGreen, PaleGreen, 95);
        EnumFlowerColor.addMix(Wheat, SteelBlue, DarkGray, 75);
        EnumFlowerColor.addMix(Wheat, Tan, DarkKhaki, 115);
        EnumFlowerColor.addMix(Wheat, Teal, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(Wheat, Thistle, MistyRose, 95);
        EnumFlowerColor.addMix(Wheat, Turquoise, MediumAquamarine, 95);
        EnumFlowerColor.addMix(Wheat, Violet, Pink, 75);
        EnumFlowerColor.addMix(White, Aquamarine, PaleTurquoise, 100);
        EnumFlowerColor.addMix(White, Blue, MediumPurple, 60);
        EnumFlowerColor.addMix(White, Brown, RosyBrown, 70);
        EnumFlowerColor.addMix(White, CadetBlue, PaleTurquoise, 95);
        EnumFlowerColor.addMix(White, Chocolate, Tan, 85);
        EnumFlowerColor.addMix(White, Coral, DarkSalmon, 90);
        EnumFlowerColor.addMix(White, Crimson, PaleVioletRed, 75);
        EnumFlowerColor.addMix(White, Cyan, PaleTurquoise, 100);
        EnumFlowerColor.addMix(White, DarkGoldenrod, Tan, 85);
        EnumFlowerColor.addMix(White, DarkGray, LightGray, 105);
        EnumFlowerColor.addMix(White, DarkGreen, DarkSeaGreen, 70);
        EnumFlowerColor.addMix(White, DarkKhaki, LemonChiffon, 100);
        EnumFlowerColor.addMix(White, DarkOliveGreen, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(White, DarkOrange, SandyBrown, 90);
        EnumFlowerColor.addMix(White, DarkSalmon, MistyRose, 95);
        EnumFlowerColor.addMix(White, DarkSlateGray, DarkGray, 70);
        EnumFlowerColor.addMix(White, DarkTurquoise, PaleTurquoise, 95);
        EnumFlowerColor.addMix(White, DarkViolet, Violet, 70);
        EnumFlowerColor.addMix(White, DeepPink, HotPink, 85);
        EnumFlowerColor.addMix(White, DeepSkyBlue, SkyBlue, 95);
        EnumFlowerColor.addMix(White, DimGray, DarkGray, 85);
        EnumFlowerColor.addMix(White, DodgerBlue, SkyBlue, 85);
        EnumFlowerColor.addMix(White, Gold, Khaki, 95);
        EnumFlowerColor.addMix(White, Goldenrod, Wheat, 95);
        EnumFlowerColor.addMix(White, Gray, LightGray, 95);
        EnumFlowerColor.addMix(White, Green, DarkSeaGreen, 75);
        EnumFlowerColor.addMix(White, HotPink, Pink, 90);
        EnumFlowerColor.addMix(White, IndianRed, Pink, 85);
        EnumFlowerColor.addMix(White, Indigo, MediumPurple, 50);
        EnumFlowerColor.addMix(White, Khaki, LemonChiffon, 105);
        EnumFlowerColor.addMix(White, Lavender, LightGray, 115);
        EnumFlowerColor.addMix(White, LemonChiffon, Wheat, 110);
        EnumFlowerColor.addMix(White, LightGray, Lavender, 120);
        EnumFlowerColor.addMix(White, LightSeaGreen, PaleTurquoise, 95);
        EnumFlowerColor.addMix(White, LightSteelBlue, Lavender, 110);
        EnumFlowerColor.addMix(White, Lime, PaleGreen, 95);
        EnumFlowerColor.addMix(White, LimeGreen, PaleGreen, 90);
        EnumFlowerColor.addMix(White, Magenta, Violet, 85);
        EnumFlowerColor.addMix(White, Maroon, RosyBrown, 55);
        EnumFlowerColor.addMix(White, MediumAquamarine, PaleTurquoise, 100);
        EnumFlowerColor.addMix(White, MediumOrchid, Plum, 80);
        EnumFlowerColor.addMix(White, MediumPurple, Thistle, 85);
        EnumFlowerColor.addMix(White, MediumSeaGreen, MediumAquamarine, 90);
        EnumFlowerColor.addMix(White, MediumVioletRed, Plum, 75);
        EnumFlowerColor.addMix(White, MistyRose, LightGray, 115);
        EnumFlowerColor.addMix(White, Olive, DarkKhaki, 85);
        EnumFlowerColor.addMix(White, OliveDrab, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(White, Orange, Wheat, 95);
        EnumFlowerColor.addMix(White, PaleGreen, Aquamarine, 100);
        EnumFlowerColor.addMix(White, PaleVioletRed, Pink, 90);
        EnumFlowerColor.addMix(White, Peru, Tan, 90);
        EnumFlowerColor.addMix(White, Pink, MistyRose, 105);
        EnumFlowerColor.addMix(White, Plum, Thistle, 100);
        EnumFlowerColor.addMix(White, Purple, Plum, 60);
        EnumFlowerColor.addMix(White, Red, Salmon, 80);
        EnumFlowerColor.addMix(White, RosyBrown, MistyRose, 95);
        EnumFlowerColor.addMix(White, RoyalBlue, LightSteelBlue, 80);
        EnumFlowerColor.addMix(White, Salmon, Pink, 95);
        EnumFlowerColor.addMix(White, SandyBrown, Wheat, 95);
        EnumFlowerColor.addMix(White, SeaGreen, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(White, Sienna, DarkSalmon, 75);
        EnumFlowerColor.addMix(White, SkyBlue, PaleTurquoise, 105);
        EnumFlowerColor.addMix(White, SlateBlue, LightSteelBlue, 75);
        EnumFlowerColor.addMix(White, SlateGray, LightGray, 90);
        EnumFlowerColor.addMix(White, SpringGreen, Aquamarine, 95);
        EnumFlowerColor.addMix(White, SteelBlue, LightSteelBlue, 85);
        EnumFlowerColor.addMix(White, Tan, Wheat, 105);
        EnumFlowerColor.addMix(White, Teal, DarkTurquoise, 80);
        EnumFlowerColor.addMix(White, Thistle, Lavender, 105);
        EnumFlowerColor.addMix(White, Turquoise, PaleTurquoise, 100);
        EnumFlowerColor.addMix(White, Violet, Plum, 95);
        EnumFlowerColor.addMix(White, Wheat, LemonChiffon, 110);
        EnumFlowerColor.addMix(Yellow, Aquamarine, PaleGreen, 95);
        EnumFlowerColor.addMix(Yellow, Brown, Goldenrod, 55);
        EnumFlowerColor.addMix(Yellow, CadetBlue, YellowGreen, 80);
        EnumFlowerColor.addMix(Yellow, Chocolate, Goldenrod, 80);
        EnumFlowerColor.addMix(Yellow, Coral, Goldenrod, 75);
        EnumFlowerColor.addMix(Yellow, Crimson, DarkOrange, 55);
        EnumFlowerColor.addMix(Yellow, Cyan, PaleGreen, 85);
        EnumFlowerColor.addMix(Yellow, DarkGoldenrod, Gold, 95);
        EnumFlowerColor.addMix(Yellow, DarkGray, Khaki, 90);
        EnumFlowerColor.addMix(Yellow, DarkGreen, YellowGreen, 70);
        EnumFlowerColor.addMix(Yellow, DarkKhaki, Khaki, 105);
        EnumFlowerColor.addMix(Yellow, DarkOliveGreen, YellowGreen, 80);
        EnumFlowerColor.addMix(Yellow, DarkOrange, Gold, 90);
        EnumFlowerColor.addMix(Yellow, DarkSalmon, Gold, 80);
        EnumFlowerColor.addMix(Yellow, DarkSeaGreen, YellowGreen, 95);
        EnumFlowerColor.addMix(Yellow, DarkSlateGray, DarkKhaki, 60);
        EnumFlowerColor.addMix(Yellow, DarkTurquoise, PaleGreen, 80);
        EnumFlowerColor.addMix(Yellow, DeepSkyBlue, PaleGreen, 60);
        EnumFlowerColor.addMix(Yellow, DimGray, DarkKhaki, 75);
        EnumFlowerColor.addMix(Yellow, DodgerBlue, DarkSeaGreen, 45);
        EnumFlowerColor.addMix(Yellow, Gold, Khaki, 115);
        EnumFlowerColor.addMix(Yellow, Goldenrod, Gold, 100);
        EnumFlowerColor.addMix(Yellow, Gray, DarkKhaki, 80);
        EnumFlowerColor.addMix(Yellow, Green, YellowGreen, 80);
        EnumFlowerColor.addMix(Yellow, HotPink, SandyBrown, 50);
        EnumFlowerColor.addMix(Yellow, IndianRed, Goldenrod, 65);
        EnumFlowerColor.addMix(Yellow, Khaki, Gold, 115);
        EnumFlowerColor.addMix(Yellow, Lavender, Khaki, 80);
        EnumFlowerColor.addMix(Yellow, LemonChiffon, Khaki, 105);
        EnumFlowerColor.addMix(Yellow, LightGray, Khaki, 95);
        EnumFlowerColor.addMix(Yellow, LightSeaGreen, YellowGreen, 80);
        EnumFlowerColor.addMix(Yellow, LightSteelBlue, Khaki, 75);
        EnumFlowerColor.addMix(Yellow, Lime, SpringGreen, 105);
        EnumFlowerColor.addMix(Yellow, LimeGreen, YellowGreen, 100);
        EnumFlowerColor.addMix(Yellow, Maroon, DarkGoldenrod, 45);
        EnumFlowerColor.addMix(Yellow, MediumAquamarine, YellowGreen, 90);
        EnumFlowerColor.addMix(Yellow, MediumSeaGreen, YellowGreen, 90);
        EnumFlowerColor.addMix(Yellow, MistyRose, Khaki, 90);
        EnumFlowerColor.addMix(Yellow, Olive, DarkKhaki, 90);
        EnumFlowerColor.addMix(Yellow, OliveDrab, YellowGreen, 90);
        EnumFlowerColor.addMix(Yellow, Orange, Gold, 95);
        EnumFlowerColor.addMix(Yellow, PaleGreen, YellowGreen, 105);
        EnumFlowerColor.addMix(Yellow, PaleTurquoise, Khaki, 90);
        EnumFlowerColor.addMix(Yellow, PaleVioletRed, Goldenrod, 55);
        EnumFlowerColor.addMix(Yellow, Peru, Gold, 90);
        EnumFlowerColor.addMix(Yellow, Pink, Gold, 75);
        EnumFlowerColor.addMix(Yellow, Plum, Khaki, 55);
        EnumFlowerColor.addMix(Yellow, Red, DarkOrange, 60);
        EnumFlowerColor.addMix(Yellow, RosyBrown, Gold, 75);
        EnumFlowerColor.addMix(Yellow, Salmon, Goldenrod, 70);
        EnumFlowerColor.addMix(Yellow, SandyBrown, Gold, 90);
        EnumFlowerColor.addMix(Yellow, SeaGreen, YellowGreen, 85);
        EnumFlowerColor.addMix(Yellow, Sienna, Goldenrod, 70);
        EnumFlowerColor.addMix(Yellow, SkyBlue, YellowGreen, 75);
        EnumFlowerColor.addMix(Yellow, SlateGray, DarkKhaki, 70);
        EnumFlowerColor.addMix(Yellow, SpringGreen, Lime, 100);
        EnumFlowerColor.addMix(Yellow, SteelBlue, YellowGreen, 55);
        EnumFlowerColor.addMix(Yellow, Tan, Gold, 100);
        EnumFlowerColor.addMix(Yellow, Teal, YellowGreen, 70);
        EnumFlowerColor.addMix(Yellow, Thistle, Khaki, 75);
        EnumFlowerColor.addMix(Yellow, Turquoise, PaleGreen, 85);
        EnumFlowerColor.addMix(Yellow, Wheat, Khaki, 105);
        EnumFlowerColor.addMix(Yellow, White, Khaki, 95);
        EnumFlowerColor.addMix(YellowGreen, Aquamarine, PaleGreen, 100);
        EnumFlowerColor.addMix(YellowGreen, Black, DarkOliveGreen, 55);
        EnumFlowerColor.addMix(YellowGreen, Brown, DarkGoldenrod, 55);
        EnumFlowerColor.addMix(YellowGreen, CadetBlue, DarkSeaGreen, 90);
        EnumFlowerColor.addMix(YellowGreen, Chocolate, Goldenrod, 75);
        EnumFlowerColor.addMix(YellowGreen, Coral, Goldenrod, 75);
        EnumFlowerColor.addMix(YellowGreen, Crimson, Chocolate, 50);
        EnumFlowerColor.addMix(YellowGreen, Cyan, SpringGreen, 90);
        EnumFlowerColor.addMix(YellowGreen, DarkGoldenrod, DarkKhaki, 95);
        EnumFlowerColor.addMix(YellowGreen, DarkGray, DarkKhaki, 100);
        EnumFlowerColor.addMix(YellowGreen, DarkGreen, OliveDrab, 85);
        EnumFlowerColor.addMix(YellowGreen, DarkOliveGreen, OliveDrab, 95);
        EnumFlowerColor.addMix(YellowGreen, DarkOrange, Goldenrod, 85);
        EnumFlowerColor.addMix(YellowGreen, DarkSalmon, DarkKhaki, 80);
        EnumFlowerColor.addMix(YellowGreen, DarkSeaGreen, LimeGreen, 110);
        EnumFlowerColor.addMix(YellowGreen, DarkSlateGray, OliveDrab, 70);
        EnumFlowerColor.addMix(YellowGreen, DarkTurquoise, MediumSeaGreen, 90);
        EnumFlowerColor.addMix(YellowGreen, DeepSkyBlue, MediumAquamarine, 70);
        EnumFlowerColor.addMix(YellowGreen, DimGray, OliveDrab, 85);
        EnumFlowerColor.addMix(YellowGreen, DodgerBlue, LightSeaGreen, 55);
        EnumFlowerColor.addMix(YellowGreen, Gold, Yellow, 105);
        EnumFlowerColor.addMix(YellowGreen, Goldenrod, DarkKhaki, 100);
        EnumFlowerColor.addMix(YellowGreen, Gray, OliveDrab, 90);
        EnumFlowerColor.addMix(YellowGreen, Green, OliveDrab, 100);
        EnumFlowerColor.addMix(YellowGreen, HotPink, Tan, 45);
        EnumFlowerColor.addMix(YellowGreen, IndianRed, DarkGoldenrod, 65);
        EnumFlowerColor.addMix(YellowGreen, Khaki, DarkKhaki, 110);
        EnumFlowerColor.addMix(YellowGreen, Lavender, DarkSeaGreen, 85);
        EnumFlowerColor.addMix(YellowGreen, LemonChiffon, Khaki, 105);
        EnumFlowerColor.addMix(YellowGreen, LightGray, DarkKhaki, 100);
        EnumFlowerColor.addMix(YellowGreen, LightSeaGreen, MediumSeaGreen, 95);
        EnumFlowerColor.addMix(YellowGreen, LightSteelBlue, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(YellowGreen, Lime, LimeGreen, 110);
        EnumFlowerColor.addMix(YellowGreen, LimeGreen, Lime, 115);
        EnumFlowerColor.addMix(YellowGreen, MediumAquamarine, LimeGreen, 105);
        EnumFlowerColor.addMix(YellowGreen, MediumPurple, DarkGray, 45);
        EnumFlowerColor.addMix(YellowGreen, MediumSeaGreen, LimeGreen, 110);
        EnumFlowerColor.addMix(YellowGreen, MistyRose, Khaki, 90);
        EnumFlowerColor.addMix(YellowGreen, Olive, OliveDrab, 105);
        EnumFlowerColor.addMix(YellowGreen, OliveDrab, LimeGreen, 110);
        EnumFlowerColor.addMix(YellowGreen, Orange, Gold, 90);
        EnumFlowerColor.addMix(YellowGreen, PaleGreen, LimeGreen, 110);
        EnumFlowerColor.addMix(YellowGreen, PaleTurquoise, PaleGreen, 95);
        EnumFlowerColor.addMix(YellowGreen, PaleVioletRed, Tan, 60);
        EnumFlowerColor.addMix(YellowGreen, Peru, DarkKhaki, 90);
        EnumFlowerColor.addMix(YellowGreen, Pink, DarkKhaki, 75);
        EnumFlowerColor.addMix(YellowGreen, Plum, DarkKhaki, 55);
        EnumFlowerColor.addMix(YellowGreen, Red, Chocolate, 55);
        EnumFlowerColor.addMix(YellowGreen, RosyBrown, DarkKhaki, 80);
        EnumFlowerColor.addMix(YellowGreen, RoyalBlue, CadetBlue, 55);
        EnumFlowerColor.addMix(YellowGreen, Salmon, Goldenrod, 70);
        EnumFlowerColor.addMix(YellowGreen, SandyBrown, DarkKhaki, 90);
        EnumFlowerColor.addMix(YellowGreen, SeaGreen, MediumSeaGreen, 100);
        EnumFlowerColor.addMix(YellowGreen, Sienna, Olive, 70);
        EnumFlowerColor.addMix(YellowGreen, SkyBlue, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(YellowGreen, SlateGray, DarkSeaGreen, 80);
        EnumFlowerColor.addMix(YellowGreen, SpringGreen, LimeGreen, 110);
        EnumFlowerColor.addMix(YellowGreen, SteelBlue, DarkSeaGreen, 65);
        EnumFlowerColor.addMix(YellowGreen, Tan, DarkKhaki, 100);
        EnumFlowerColor.addMix(YellowGreen, Teal, MediumSeaGreen, 85);
        EnumFlowerColor.addMix(YellowGreen, Thistle, DarkKhaki, 75);
        EnumFlowerColor.addMix(YellowGreen, Turquoise, PaleGreen, 95);
        EnumFlowerColor.addMix(YellowGreen, Wheat, Khaki, 100);
        EnumFlowerColor.addMix(YellowGreen, White, Khaki, 95);
        EnumFlowerColor.addMix(YellowGreen, Yellow, Khaki, 110);
    }

    @Override
    public String getName() {
        return Binnie.Language.translate(this.name);
    }

    public static EnumFlowerColor get(int i) {
        return EnumFlowerColor.values()[Math.max(0, i) % EnumFlowerColor.values().length];
    }

    public String getHTMLName() {
        return this.name();
    }
}

