/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gardening;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.EnumSoilType;
import binnie.botany.ceramic.BlockCeramic;
import binnie.botany.ceramic.BlockCeramicBrick;
import binnie.botany.ceramic.BlockCeramicPatterned;
import binnie.botany.ceramic.BlockStained;
import binnie.botany.ceramic.CeramicTileRecipe;
import binnie.botany.ceramic.PigmentRecipe;
import binnie.botany.farm.CircuitGarden;
import binnie.botany.flower.ItemInsulatedTube;
import binnie.botany.gardening.BlockPlant;
import binnie.botany.gardening.BlockSoil;
import binnie.botany.gardening.Gardening;
import binnie.botany.gardening.ItemSoil;
import binnie.botany.gardening.ItemSoilMeter;
import binnie.botany.gardening.ItemTrowel;
import binnie.botany.gardening.ItemWeed;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.items.BotanyItems;
import binnie.botany.items.ItemClay;
import binnie.botany.items.ItemPigment;
import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.core.Mods;
import binnie.core.block.ItemMetadata;
import binnie.core.block.ItemMetadataRenderer;
import binnie.core.block.MultipassItemRenderer;
import binnie.core.block.TileEntityMetadata;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ModuleGardening
implements IInitializable {
    @Override
    public void preInit() {
        Botany.soil = new BlockSoil(EnumSoilType.SOIL, "soil");
        Botany.loam = new BlockSoil(EnumSoilType.LOAM, "loam");
        Botany.flowerbed = new BlockSoil(EnumSoilType.FLOWERBED, "flowerbed");
        Botany.plant = new BlockPlant();
        GameRegistry.registerBlock((Block)Botany.plant, ItemWeed.class, (String)"plant");
        GameRegistry.registerBlock((Block)Botany.soil, ItemSoil.class, (String)"soil");
        GameRegistry.registerBlock((Block)Botany.loam, ItemSoil.class, (String)"loam");
        GameRegistry.registerBlock((Block)Botany.flowerbed, ItemSoil.class, (String)"flowerbed");
        Botany.soilMeter = new ItemSoilMeter();
        Botany.insulatedTube = new ItemInsulatedTube();
        Botany.trowelWood = new ItemTrowel(Item.ToolMaterial.WOOD, "Wood");
        Botany.trowelStone = new ItemTrowel(Item.ToolMaterial.STONE, "Stone");
        Botany.trowelIron = new ItemTrowel(Item.ToolMaterial.IRON, "Iron");
        Botany.trowelDiamond = new ItemTrowel(Item.ToolMaterial.EMERALD, "Diamond");
        Botany.trowelGold = new ItemTrowel(Item.ToolMaterial.GOLD, "Gold");
        Botany.misc = Binnie.Item.registerMiscItems(BotanyItems.values(), CreativeTabBotany.instance);
        Botany.pigment = new ItemPigment();
        Botany.clay = new ItemClay();
        Botany.ceramic = new BlockCeramic();
        Botany.stained = new BlockStained();
        GameRegistry.registerBlock((Block)Botany.ceramic, ItemMetadata.class, (String)"ceramic");
        BinnieCore.proxy.registerCustomItemRenderer(Item.func_150898_a((Block)Botany.ceramic), new ItemMetadataRenderer());
        GameRegistry.registerBlock((Block)Botany.stained, ItemMetadata.class, (String)"stained");
        BinnieCore.proxy.registerCustomItemRenderer(Item.func_150898_a((Block)Botany.stained), new ItemMetadataRenderer());
        Botany.ceramicTile = new BlockCeramicPatterned();
        Botany.ceramicBrick = new BlockCeramicBrick();
        GameRegistry.registerBlock((Block)Botany.ceramicTile, ItemMetadata.class, (String)"ceramicPattern");
        GameRegistry.registerBlock((Block)Botany.ceramicBrick, ItemMetadata.class, (String)"ceramicBrick");
        BinnieCore.proxy.registerCustomItemRenderer(Item.func_150898_a((Block)Botany.ceramicTile), new MultipassItemRenderer());
        BinnieCore.proxy.registerCustomItemRenderer(Item.func_150898_a((Block)Botany.ceramicBrick), new MultipassItemRenderer());
    }

    @Override
    public void init() {
        RecipeSorter.register((String)"botany:ceramictile", CeramicTileRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"botany:pigment", PigmentRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        ItemStack yellow = new ItemStack((Block)Blocks.field_150327_N, 1);
        ItemStack red = new ItemStack((Block)Blocks.field_150328_O, 1);
        ItemStack blue = new ItemStack((Block)Blocks.field_150328_O, 1, 7);
        for (boolean manual : new boolean[]{true, false}) {
            for (boolean fertilised : new boolean[]{true, false}) {
                for (EnumMoisture moist : EnumMoisture.values()) {
                    ItemStack icon = moist == EnumMoisture.Dry ? yellow : (moist == EnumMoisture.Normal ? red : blue);
                    int insulate = 2 - moist.ordinal();
                    if (fertilised) {
                        insulate += 3;
                    }
                    new CircuitGarden(moist, null, manual, fertilised, new ItemStack((Item)Botany.insulatedTube, 1, 0 + 128 * insulate), icon);
                    new CircuitGarden(moist, EnumAcidity.Acid, manual, fertilised, new ItemStack((Item)Botany.insulatedTube, 1, 1 + 128 * insulate), icon);
                    new CircuitGarden(moist, EnumAcidity.Neutral, manual, fertilised, new ItemStack((Item)Botany.insulatedTube, 1, 2 + 128 * insulate), icon);
                    new CircuitGarden(moist, EnumAcidity.Alkaline, manual, fertilised, new ItemStack((Item)Botany.insulatedTube, 1, 3 + 128 * insulate), icon);
                }
            }
        }
    }

    @Override
    public void postInit() {
        GameRegistry.addRecipe((IRecipe)new CeramicTileRecipe());
        for (int mat = 0; mat < 4; ++mat) {
            for (int insulate = 0; insulate < 6; ++insulate) {
                ItemStack tubes = new ItemStack((Item)Botany.insulatedTube, 2, mat + 128 * insulate);
                ItemStack insulateStack = ItemInsulatedTube.getInsulateStack(tubes);
                ItemStack forestryTube = new ItemStack(Mods.Forestry.item("thermionicTubes"), 1, mat);
                GameRegistry.addShapelessRecipe((ItemStack)tubes, (Object[])new Object[]{forestryTube, forestryTube, insulateStack});
            }
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)Botany.trowelWood, new Object[]{" x", "s ", Character.valueOf('s'), "stickWood", Character.valueOf('x'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)Botany.trowelStone, new Object[]{" x", "s ", Character.valueOf('s'), "stickWood", Character.valueOf('x'), "cobblestone"}));
        if (Mods.Chisel.active()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)Botany.trowelIron, new Object[]{"x ", " s", Character.valueOf('s'), "stickWood", Character.valueOf('x'), "ingotIron"}));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)Botany.trowelIron, new Object[]{" x", "s ", Character.valueOf('s'), "stickWood", Character.valueOf('x'), "ingotIron"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)Botany.trowelGold, new Object[]{" x", "s ", Character.valueOf('s'), "stickWood", Character.valueOf('x'), "ingotGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)Botany.trowelDiamond, new Object[]{" x", "s ", Character.valueOf('s'), "stickWood", Character.valueOf('x'), "gemDiamond"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)Botany.soilMeter, new Object[]{" gg", " rg", "i  ", Character.valueOf('g'), "ingotGold", Character.valueOf('r'), "dustRedstone", Character.valueOf('i'), "ingotIron"}));
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.AshPowder.get(4), (Object[])new Object[]{Mods.Forestry.stack("ash")});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.MulchPowder.get(4), (Object[])new Object[]{Mods.Forestry.stack("mulch")});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.CompostPowder.get(4), (Object[])new Object[]{Mods.Forestry.stack("fertilizerBio")});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.FertiliserPowder.get(4), (Object[])new Object[]{Mods.Forestry.stack("fertilizerCompound")});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.PulpPowder.get(4), (Object[])new Object[]{Mods.Forestry.stack("woodPulp")});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(BotanyItems.SulphurPowder.get(4), new Object[]{"dustSulphur"}));
        this.addAcidFertiliser(BotanyItems.SulphurPowder.get(1), 1);
        this.addAcidFertiliser(BotanyItems.MulchPowder.get(1), 1);
        this.addAcidFertiliser(new ItemStack(GameRegistry.findItem((String)"Forestry", (String)"mulch")), 2);
        for (ItemStack stack : OreDictionary.getOres((String)"dustSulfur")) {
            this.addAcidFertiliser(stack, 2);
        }
        this.addAlkalineFertiliser(BotanyItems.AshPowder.get(1), 1);
        this.addAlkalineFertiliser(BotanyItems.PulpPowder.get(1), 1);
        this.addAlkalineFertiliser(new ItemStack(GameRegistry.findItem((String)"Forestry", (String)"ash")), 2);
        this.addAlkalineFertiliser(new ItemStack(GameRegistry.findItem((String)"Forestry", (String)"woodPulp")), 2);
        this.addNutrientFertiliser(BotanyItems.CompostPowder.get(1), 1);
        this.addNutrientFertiliser(BotanyItems.FertiliserPowder.get(1), 1);
        this.addNutrientFertiliser(new ItemStack(GameRegistry.findItem((String)"Forestry", (String)"fertilizerBio")), 2);
        this.addNutrientFertiliser(new ItemStack(GameRegistry.findItem((String)"Forestry", (String)"fertilizerCompound")), 2);
        GameRegistry.addRecipe((ItemStack)BotanyItems.Mortar.get(6), (Object[])new Object[]{" c ", "cgc", " c ", Character.valueOf('c'), Items.field_151119_aD, Character.valueOf('g'), Blocks.field_150351_n});
        for (EnumFlowerColor c : EnumFlowerColor.values()) {
            ItemStack clay = new ItemStack((Item)Botany.clay, 1, c.ordinal());
            ItemStack pigment = new ItemStack((Item)Botany.pigment, 1, c.ordinal());
            GameRegistry.addShapelessRecipe((ItemStack)clay, (Object[])new Object[]{Items.field_151119_aD, Items.field_151119_aD, Items.field_151119_aD, pigment});
            GameRegistry.addSmelting((ItemStack)clay, (ItemStack)TileEntityMetadata.getItemStack(Botany.ceramic, c.ordinal()), (float)0.0f);
            ItemStack glass = TileEntityMetadata.getItemStack(Botany.stained, c.ordinal());
            glass.field_77994_a = 4;
            GameRegistry.addShapedRecipe((ItemStack)glass, (Object[])new Object[]{" g ", "gpg", " g ", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('p'), pigment});
        }
        GameRegistry.addRecipe((IRecipe)new PigmentRecipe());
    }

    private ItemStack getStack(int type, int pH, int moisture) {
        if (type < 0 || type > 2 || pH < 0 || pH > 2 || moisture < 0 || moisture > 2) {
            return null;
        }
        return new ItemStack(Gardening.getSoilBlock(EnumSoilType.values()[type]), 1, BlockSoil.getMeta(EnumAcidity.values()[pH], EnumMoisture.values()[moisture]));
    }

    private void addAcidFertiliser(ItemStack stack, int strengthMax) {
        if (stack == null) {
            return;
        }
        Gardening.fertiliserAcid.put(stack, strengthMax);
        for (int moisture = 0; moisture < 3; ++moisture) {
            for (int pH = 0; pH < 3; ++pH) {
                for (int type = 0; type < 3; ++type) {
                    int numOfBlocks = strengthMax * strengthMax;
                    for (int strength = 1; strength < strengthMax; ++strength) {
                        ItemStack start = this.getStack(type, pH, moisture);
                        ItemStack end = this.getStack(type, pH - strength, moisture);
                        if (end != null) {
                            end.field_77994_a = numOfBlocks;
                            Object[] stacks = new Object[numOfBlocks + 1];
                            for (int i = 0; i < numOfBlocks; ++i) {
                                stacks[i] = start;
                            }
                            stacks[numOfBlocks] = stack.func_77946_l();
                            GameRegistry.addShapelessRecipe((ItemStack)end, (Object[])stacks);
                        }
                        numOfBlocks /= 2;
                    }
                }
            }
        }
    }

    private void addAlkalineFertiliser(ItemStack stack, int strengthMax) {
        if (stack == null) {
            return;
        }
        Gardening.fertiliserAlkaline.put(stack, strengthMax);
        for (int moisture = 0; moisture < 3; ++moisture) {
            for (int pH = 0; pH < 3; ++pH) {
                for (int type = 0; type < 3; ++type) {
                    int numOfBlocks = strengthMax * strengthMax;
                    for (int strength = 1; strength < strengthMax; ++strength) {
                        ItemStack start = this.getStack(type, pH, moisture);
                        ItemStack end = this.getStack(type, pH + strength, moisture);
                        if (end != null) {
                            end.field_77994_a = numOfBlocks;
                            Object[] stacks = new Object[numOfBlocks + 1];
                            for (int i = 0; i < numOfBlocks; ++i) {
                                stacks[i] = start;
                            }
                            stacks[numOfBlocks] = stack.func_77946_l();
                            GameRegistry.addShapelessRecipe((ItemStack)end, (Object[])stacks);
                        }
                        numOfBlocks /= 2;
                    }
                }
            }
        }
    }

    private void addNutrientFertiliser(ItemStack stack, int strengthMax) {
        if (stack == null) {
            return;
        }
        Gardening.fertiliserNutrient.put(stack, strengthMax);
        for (int moisture = 0; moisture < 3; ++moisture) {
            for (int pH = 0; pH < 3; ++pH) {
                for (int type = 0; type < 3; ++type) {
                    int numOfBlocks = strengthMax * strengthMax;
                    for (int strength = 1; strength < strengthMax; ++strength) {
                        ItemStack start = this.getStack(type, pH, moisture);
                        ItemStack end = this.getStack(type + strength, pH, moisture);
                        if (end != null) {
                            end.field_77994_a = numOfBlocks;
                            Object[] stacks = new Object[numOfBlocks + 1];
                            for (int i = 0; i < numOfBlocks; ++i) {
                                stacks[i] = start;
                            }
                            stacks[numOfBlocks] = stack.func_77946_l();
                            GameRegistry.addShapelessRecipe((ItemStack)end, (Object[])stacks);
                        }
                        numOfBlocks /= 2;
                    }
                }
            }
        }
    }
}

