/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gardening;

import binnie.botany.Botany;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.IFlower;
import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.flower.TileEntityFlower;
import binnie.core.BinnieCore;
import com.mojang.authlib.GameProfile;
import forestry.api.core.EnumTemperature;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class Gardening {
    public static Map<ItemStack, Integer> fertiliserAcid = new LinkedHashMap<ItemStack, Integer>();
    public static Map<ItemStack, Integer> fertiliserAlkaline = new LinkedHashMap<ItemStack, Integer>();
    public static Map<ItemStack, Integer> fertiliserNutrient = new LinkedHashMap<ItemStack, Integer>();

    public static boolean isSoil(Block block) {
        return block instanceof IBlockSoil;
    }

    public static boolean isSoil(Item item) {
        return item instanceof ItemBlock && Gardening.isSoil(((ItemBlock)item).field_150939_a);
    }

    public static boolean isSoil(ItemStack item) {
        return Gardening.isSoil(item.func_77973_b());
    }

    public static EnumMoisture getNaturalMoisture(World world, int x, int y, int z) {
        int dz;
        int dx;
        float bias = Gardening.getBiomeMoisture(world.func_72807_a(x, z), y);
        for (dx = -1; dx < 2; ++dx) {
            for (dz = -1; dz < 2; ++dz) {
                if (dx == 0 && dz == 0) continue;
                if (world.func_147439_a(x + dx, y, z + dz) == Blocks.field_150354_m) {
                    bias = (float)((double)bias - 1.5);
                    continue;
                }
                if (world.func_147439_a(x + dx, y, z + dz) != Blocks.field_150355_j) continue;
                bias = (float)((double)bias + 1.5);
            }
        }
        if (world.func_72896_J() && world.func_72937_j(x, y + 1, z) && world.func_72874_g(x, z) <= y + 1) {
            bias = (float)((double)bias + 1.5);
        }
        for (dx = -1; dx < 2; ++dx) {
            for (dz = -1; dz < 2; ++dz) {
                if (dx == 0 && dz == 0 || world.func_147439_a(x + dx, y, z + dz) != Blocks.field_150351_n || !(bias > 0.0f)) continue;
                bias *= 0.4f;
            }
        }
        return bias <= -1.0f ? EnumMoisture.Dry : (bias >= 1.0f ? EnumMoisture.Damp : EnumMoisture.Normal);
    }

    public static EnumAcidity getNaturalPH(World world, int x, int y, int z) {
        float bias = Gardening.getBiomePH(world.func_72807_a(x, z), y);
        return bias <= -1.0f ? EnumAcidity.Acid : (bias >= 1.0f ? EnumAcidity.Alkaline : EnumAcidity.Neutral);
    }

    public static float getBiomeMoisture(BiomeGenBase biome, int H) {
        double R = biome.field_76751_G;
        double T = biome.field_76750_F;
        double m = 3.2 * (R - 0.5) - 0.4 * (1.0 + T + 0.5 * T * T) + 1.1 - 1.6 * (T - 0.9) * (T - 0.9) - 0.002 * (double)(H - 64);
        return (float)(m == 0.0 ? m : (m < 0.0 ? -Math.sqrt(m * m) : Math.sqrt(m * m)));
    }

    public static float getBiomePH(BiomeGenBase biome, int H) {
        double R = biome.field_76751_G;
        double T = biome.field_76750_F;
        return (float)(-3.0 * (R - 0.5) + 0.5 * (T - (double)0.7f) * (T - (double)0.7f) + (double)(0.02f * (float)(H - 64)) - (double)0.15f);
    }

    public static void createSoil(World world, int x, int y, int z, EnumSoilType soil, EnumMoisture moisture, EnumAcidity acidity) {
        int meta = moisture.ordinal() + acidity.ordinal() * 3;
        world.func_147465_d(x, y, z, Gardening.getSoilBlock(soil), meta, 2);
    }

    public static boolean plant(World world, int x, int y, int z, IFlower flower, GameProfile owner) {
        boolean set = world.func_147465_d(x, y, z, (Block)Botany.flower, 0, 2);
        if (!set) {
            return false;
        }
        TileEntity tileFlower = world.func_147438_o(x, y, z);
        TileEntity below = world.func_147438_o(x, y - 1, z);
        if (tileFlower != null && tileFlower instanceof TileEntityFlower) {
            if (below instanceof TileEntityFlower) {
                ((TileEntityFlower)tileFlower).setSection(((TileEntityFlower)below).getSection());
            } else {
                ((TileEntityFlower)tileFlower).create(flower, owner);
            }
        }
        Gardening.tryGrowSection(world, x, y, z);
        return true;
    }

    public static void tryGrowSection(World world, int x, int y, int z) {
        if (!BinnieCore.proxy.isSimulating(world)) {
            return;
        }
        TileEntity flower = world.func_147438_o(x, y, z);
        if (flower != null && flower instanceof TileEntityFlower) {
            IFlower iflower = ((TileEntityFlower)flower).getFlower();
            int section = ((TileEntityFlower)flower).getSection();
            if (iflower != null && section < iflower.getGenome().getPrimary().getType().getSections() - 1 && iflower.getAge() > 0) {
                world.func_147465_d(x, y + 1, z, (Block)Botany.flower, 0, 2);
                TileEntity tileFlower = world.func_147438_o(x, y + 1, z);
                if (tileFlower != null && tileFlower instanceof TileEntityFlower) {
                    ((TileEntityFlower)tileFlower).setSection(section + 1);
                }
            }
        }
    }

    public static void onGrowFromSeed(World world, int x, int y, int z) {
        Gardening.tryGrowSection(world, x, y, z);
    }

    public static Collection<ItemStack> getAcidFertilisers() {
        return fertiliserAcid.keySet();
    }

    public static Collection<ItemStack> getAlkalineFertilisers() {
        return fertiliserAlkaline.keySet();
    }

    public static Collection<ItemStack> getNutrientFertilisers() {
        return fertiliserNutrient.keySet();
    }

    public static boolean isAcidFertiliser(ItemStack itemstack) {
        for (ItemStack stack : Gardening.getAcidFertilisers()) {
            if (stack == null || !stack.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAlkalineFertiliser(ItemStack itemstack) {
        for (ItemStack stack : Gardening.getAlkalineFertilisers()) {
            if (stack == null || !stack.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNutrientFertiliser(ItemStack itemstack) {
        for (ItemStack stack : Gardening.getNutrientFertilisers()) {
            if (stack == null || !stack.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static int getFertiliserStrength(ItemStack stack) {
        if (stack == null) {
            return 1;
        }
        for (Map.Entry<ItemStack, Integer> entry : fertiliserAcid.entrySet()) {
            if (!entry.getKey().func_77969_a(stack)) continue;
            return entry.getValue();
        }
        for (Map.Entry<ItemStack, Integer> entry : fertiliserAlkaline.entrySet()) {
            if (!entry.getKey().func_77969_a(stack)) continue;
            return entry.getValue();
        }
        for (Map.Entry<ItemStack, Integer> entry : fertiliserNutrient.entrySet()) {
            if (!entry.getKey().func_77969_a(stack)) continue;
            return entry.getValue();
        }
        return 1;
    }

    public static boolean canTolerate(IFlower flower, World world, int x, int y, int z) {
        if (flower == null || flower.getGenome() == null) {
            return false;
        }
        Block soil = world.func_147439_a(x, y - 1, z);
        int soilMeta = world.func_72805_g(x, y - 1, z);
        BiomeGenBase biome = world.func_72807_a(x, z);
        return Gardening.canTolerate(flower, EnumAcidity.values()[soilMeta / 3 % 3], EnumMoisture.values()[soilMeta % 3], EnumTemperature.getFromValue((float)biome.field_76750_F));
    }

    public static EnumSoilType getSoilType(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) instanceof IBlockSoil) {
            return ((IBlockSoil)world.func_147439_a(x, y, z)).getType(world, x, y, z);
        }
        return EnumSoilType.SOIL;
    }

    public static Block getSoilBlock(EnumSoilType type) {
        switch (type) {
            case FLOWERBED: {
                return Botany.flowerbed;
            }
            case LOAM: {
                return Botany.loam;
            }
        }
        return Botany.soil;
    }

    public static boolean canTolerate(IFlower flower, EnumAcidity ePH, EnumMoisture eMoisture, EnumTemperature eTemp) {
        return flower.getGenome().canTolerate(ePH) && flower.getGenome().canTolerate(eMoisture) && flower.getGenome().canTolerate(eTemp);
    }
}

