/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.farm;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.core.BotanyCore;
import binnie.botany.farm.FarmLogic;
import binnie.botany.farm.FarmableFlower;
import binnie.botany.farm.FarmableVanillaFlower;
import binnie.botany.farm.Vect;
import binnie.botany.flower.TileEntityFlower;
import binnie.botany.gardening.Gardening;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.interfaces.IOwnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GardenLogic
extends FarmLogic {
    EnumMoisture moisture;
    EnumAcidity acidity;
    boolean fertilised;
    String name;
    ArrayList<ItemStack> produce = new ArrayList();
    private ItemStack icon;
    List<IFarmable> farmables = new ArrayList<IFarmable>();

    public GardenLogic(IFarmHousing housing) {
        super(housing);
        this.farmables.add(new FarmableFlower());
        this.farmables.add(new FarmableVanillaFlower());
    }

    public int getFertilizerConsumption() {
        return this.fertilised ? 8 : 2;
    }

    public int getWaterConsumption(float hydrationModifier) {
        return (int)((float)(this.moisture.ordinal() * 40) * hydrationModifier);
    }

    public boolean isAcceptedResource(ItemStack itemstack) {
        if (Gardening.isSoil(itemstack.func_77973_b()) || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m) || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d)) {
            return true;
        }
        return Gardening.isAcidFertiliser(itemstack) || Gardening.isAlkalineFertiliser(itemstack);
    }

    public Collection<ItemStack> collect() {
        ArrayList<ItemStack> products = this.produce;
        this.produce = new ArrayList();
        return products;
    }

    public boolean cultivate(int x, int y, int z, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        if (this.maintainSoil(x, y, z, direction, extent)) {
            return true;
        }
        if (!this.isManual && this.maintainWater(x, y, z, direction, extent)) {
            return true;
        }
        return this.maintainCrops(x, y + 1, z, direction, extent);
    }

    private boolean isWaste(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d);
    }

    private boolean maintainSoil(int x2, int y2, int z2, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            IBlockSoil soil;
            Vect position = this.translateWithOffset(x2, y2, z2, direction, i);
            if (this.fertilised && Gardening.isSoil(this.world.func_147439_a(position.x, position.y, position.z)) && (soil = (IBlockSoil)this.world.func_147439_a(position.x, position.y, position.z)).fertilise(this.world, position.x, position.y, position.z, EnumSoilType.FLOWERBED)) continue;
            if (this.world.func_147439_a(position.x, position.y + 1, position.z) == Botany.plant) {
                this.world.func_147468_f(position.x, position.y + 1, position.z);
                continue;
            }
            if (this.acidity != null && Gardening.isSoil(this.world.func_147439_a(position.x, position.y, position.z))) {
                ItemStack stack;
                soil = (IBlockSoil)this.world.func_147439_a(position.x, position.y, position.z);
                EnumAcidity pH = soil.getPH(this.world, position.x, position.y, position.z);
                if (pH.ordinal() < this.acidity.ordinal() && (stack = this.getAvailableAlkaline()) != null && soil.setPH(this.world, position.x, position.y, position.z, EnumAcidity.values()[pH.ordinal() + 1])) {
                    this.housing.removeResources(new ItemStack[]{stack});
                    continue;
                }
                if (pH.ordinal() > this.acidity.ordinal() && (stack = this.getAvailableAcid()) != null && soil.setPH(this.world, position.x, position.y, position.z, EnumAcidity.values()[pH.ordinal() - 1])) {
                    this.housing.removeResources(new ItemStack[]{stack});
                    continue;
                }
            }
            if (!this.isAirBlock(position) && !this.world.func_147439_a(position.x, position.y, position.z).isReplaceable((IBlockAccess)this.world, position.x, position.y, position.z)) {
                ItemStack block = this.getAsItemStack(position);
                ItemStack loam = this.getAvailableLoam();
                if (!this.isWaste(block) || loam == null) continue;
                this.produce.addAll(Blocks.field_150346_d.getDrops(this.world, position.x, position.y, position.z, block.func_77960_j(), 0));
                this.setBlock(position, Blocks.field_150350_a, 0);
                return this.trySetSoil(position, loam);
            }
            if (this.isManual || this.isWaterBlock(position)) continue;
            if (i % 2 != 0) {
                ForgeDirection cclock = ForgeDirection.EAST;
                if (direction == ForgeDirection.EAST) {
                    cclock = ForgeDirection.SOUTH;
                } else if (direction == ForgeDirection.SOUTH) {
                    cclock = ForgeDirection.EAST;
                } else if (direction == ForgeDirection.WEST) {
                    cclock = ForgeDirection.SOUTH;
                }
                Vect previous = this.translateWithOffset(position.x, position.y, position.z, cclock, 1);
                ItemStack soil2 = this.getAsItemStack(previous);
                if (Gardening.isSoil(soil2.func_77973_b())) continue;
                this.trySetSoil(position);
                continue;
            }
            return this.trySetSoil(position);
        }
        return false;
    }

    private boolean maintainWater(int x, int y, int z, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            if (!this.isAirBlock(position) && !this.world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.world, position.x, position.y, position.z) || this.isWaterBlock(position)) continue;
            boolean isEnclosed = true;
            if (this.world.func_147437_c(position.x + 1, position.y, position.z)) {
                isEnclosed = false;
            } else if (this.world.func_147437_c(position.x - 1, position.y, position.z)) {
                isEnclosed = false;
            } else if (this.world.func_147437_c(position.x, position.y, position.z + 1)) {
                isEnclosed = false;
            } else if (this.world.func_147437_c(position.x, position.y, position.z - 1)) {
                isEnclosed = false;
            }
            boolean bl = isEnclosed = isEnclosed || this.moisture != EnumMoisture.Damp;
            if (!isEnclosed) continue;
            return this.trySetWater(position);
        }
        return false;
    }

    private ItemStack getAvailableLoam() {
        EnumMoisture[] moistures = this.moisture == EnumMoisture.Damp ? new EnumMoisture[]{EnumMoisture.Damp, EnumMoisture.Normal, EnumMoisture.Dry} : (this.moisture == EnumMoisture.Damp ? new EnumMoisture[]{EnumMoisture.Dry, EnumMoisture.Damp, EnumMoisture.Dry} : new EnumMoisture[]{EnumMoisture.Dry, EnumMoisture.Normal, EnumMoisture.Damp});
        EnumAcidity[] acidities = new EnumAcidity[]{EnumAcidity.Neutral, EnumAcidity.Acid, EnumAcidity.Alkaline};
        for (EnumMoisture moist : moistures) {
            for (EnumAcidity acid : acidities) {
                for (Block type : new Block[]{Botany.flowerbed, Botany.loam, Botany.soil}) {
                    int meta = acid.ordinal() * 3 + moist.ordinal();
                    ItemStack[] resource = new ItemStack[]{new ItemStack(type, 1, meta)};
                    if (!this.housing.hasResources(resource)) continue;
                    return resource[0];
                }
            }
        }
        if (this.housing.hasResources(new ItemStack[]{new ItemStack(Blocks.field_150346_d)})) {
            return new ItemStack(Blocks.field_150346_d);
        }
        return null;
    }

    private boolean trySetSoil(Vect position) {
        return this.trySetSoil(position, this.getAvailableLoam());
    }

    private boolean trySetSoil(Vect position, ItemStack loam) {
        if (loam != null) {
            if (loam.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d)) {
                loam = new ItemStack((Block)Botany.soil, 0, 4);
            }
            this.setBlock(position, ((ItemBlock)loam.func_77973_b()).field_150939_a, loam.func_77960_j());
            this.housing.removeResources(new ItemStack[]{loam});
            return true;
        }
        return false;
    }

    private boolean trySetWater(Vect position) {
        FluidStack water = Binnie.Liquid.getLiquidStack("water", 1000);
        if (this.moisture == EnumMoisture.Damp) {
            if (!this.housing.hasLiquid(water)) {
                return false;
            }
            this.setBlock(position, Blocks.field_150355_j, 0);
            this.housing.removeLiquid(water);
            return true;
        }
        if (this.moisture == EnumMoisture.Dry) {
            ItemStack[] sand = new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m, 1)};
            if (!this.housing.hasResources(sand)) {
                return false;
            }
            this.setBlock(position, (Block)Blocks.field_150354_m, 0);
            this.housing.removeResources(sand);
            return true;
        }
        return this.trySetSoil(position);
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
    }

    public boolean isAcceptedGermling(ItemStack itemstack) {
        return BotanyCore.speciesRoot.isMember(itemstack);
    }

    public Collection<ICrop> harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.icon.func_77954_c();
    }

    public ResourceLocation getSpriteSheet() {
        return TextureMap.field_110575_b;
    }

    public String getName() {
        return this.name;
    }

    protected boolean maintainCrops(int x, int y, int z, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            ItemStack below;
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            if (!this.isAirBlock(position) && !this.world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.world, position.x, position.y, position.z) || !Gardening.isSoil((below = this.getAsItemStack(position.add(new Vect(0, -1, 0)))).func_77973_b())) continue;
            return this.trySetCrop(position);
        }
        return false;
    }

    private boolean trySetCrop(Vect position) {
        for (IFarmable farmable : this.farmables) {
            boolean success = this.housing.plantGermling(farmable, this.world, position.x, position.y, position.z);
            if (!success || !(this.housing instanceof IOwnable)) continue;
            TileEntity tile = this.housing.getWorld().func_147438_o(position.x, position.y, position.z);
            if (tile instanceof TileEntityFlower) {
                ((TileEntityFlower)tile).setOwner(((IOwnable)this.housing).getOwnerProfile());
            }
            return true;
        }
        return false;
    }

    public ItemStack getAvailableAcid() {
        for (ItemStack stack : Gardening.getAcidFertilisers()) {
            if (stack == null || stack.func_77973_b() == null || !this.housing.hasResources(new ItemStack[]{stack})) continue;
            return stack;
        }
        return null;
    }

    public ItemStack getAvailableAlkaline() {
        for (ItemStack stack : Gardening.getAlkalineFertilisers()) {
            if (stack == null || stack.func_77973_b() == null || !this.housing.hasResources(new ItemStack[]{stack})) continue;
            return stack;
        }
        return null;
    }

    public void setData(EnumMoisture moisture2, EnumAcidity acidity2, boolean isManual, boolean isFertilised, ItemStack icon2, String name2) {
        this.moisture = moisture2;
        this.acidity = acidity2;
        this.isManual = isManual;
        this.fertilised = isFertilised;
        this.icon = icon2;
        this.name = name2;
    }
}

