/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.farm;

import binnie.Binnie;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.farm.FarmLogic;
import binnie.botany.farm.GardenLogic;
import binnie.core.circuits.BinnieCircuit;
import forestry.api.circuits.ChipsetManager;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class CircuitGarden
extends BinnieCircuit {
    private Class<? extends FarmLogic> logicClass;
    private boolean isManual = false;
    private boolean isFertilised = false;
    private ItemStack icon;
    private EnumMoisture moisture;
    private EnumAcidity acidity;

    public CircuitGarden(EnumMoisture moisture, EnumAcidity ph, boolean manual, boolean fertilised, ItemStack recipe, ItemStack icon) {
        super("garden." + moisture.getID() + (ph != null ? "." + ph.getID() : "") + (manual ? ".manual" : "") + (fertilised ? ".fert" : ""), 4, manual ? ChipsetManager.circuitRegistry.getLayout("forestry.farms.manual") : ChipsetManager.circuitRegistry.getLayout("forestry.farms.managed"), recipe);
        this.isManual = manual;
        this.isFertilised = fertilised;
        this.moisture = moisture;
        this.acidity = ph;
        this.icon = icon;
        String info = "";
        if (moisture == EnumMoisture.Dry) {
            info = info + "\u00a7eDry\u00a7f";
        }
        if (moisture == EnumMoisture.Damp) {
            info = info + "\u00a79Damp\u00a7f";
        }
        if (this.acidity == EnumAcidity.Acid) {
            if (info.length() > 0) {
                info = info + ", ";
            }
            info = info + "\u00a7cAcidic\u00a7f";
        }
        if (this.acidity == EnumAcidity.Neutral) {
            if (info.length() > 0) {
                info = info + ", ";
            }
            info = info + "\u00a7aNeutral\u00a7f";
        }
        if (this.acidity == EnumAcidity.Alkaline) {
            if (info.length() > 0) {
                info = info + ", ";
            }
            info = info + "\u00a7bAlkaline\u00a7f";
        }
        if (info.length() > 0) {
            info = " (" + info + "\u00a7f)";
        }
        this.addTooltipString("Flowers" + info);
    }

    @Override
    public boolean isCircuitable(TileEntity tile) {
        return tile instanceof IFarmHousing;
    }

    @Override
    public void onInsertion(int slot, TileEntity tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        GardenLogic logic = new GardenLogic((IFarmHousing)tile);
        logic.setData(this.moisture, this.acidity, this.isManual, this.isFertilised, this.icon, Binnie.Language.translate(this.getName()));
        ((IFarmHousing)tile).setFarmLogic(ForgeDirection.values()[slot + 2], (IFarmLogic)logic);
    }

    @Override
    public void onLoad(int slot, TileEntity tile) {
        this.onInsertion(slot, tile);
    }

    @Override
    public void onRemoval(int slot, TileEntity tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        ((IFarmHousing)tile).resetFarmLogic(ForgeDirection.values()[slot + 2]);
    }

    @Override
    public void onTick(int slot, TileEntity tile) {
    }
}

