/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany;

import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.IFlower;
import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.ceramic.BlockCeramic;
import binnie.botany.ceramic.BlockCeramicBrick;
import binnie.botany.ceramic.BlockCeramicPatterned;
import binnie.botany.ceramic.BlockStained;
import binnie.botany.core.BotanyCore;
import binnie.botany.core.BotanyGUI;
import binnie.botany.core.ModuleCore;
import binnie.botany.flower.BlockFlower;
import binnie.botany.flower.ItemFlower;
import binnie.botany.flower.ItemInsulatedTube;
import binnie.botany.flower.TileEntityFlower;
import binnie.botany.gardening.BlockPlant;
import binnie.botany.gardening.BlockSoil;
import binnie.botany.gardening.Gardening;
import binnie.botany.gardening.ItemSoilMeter;
import binnie.botany.gardening.ItemTrowel;
import binnie.botany.gardening.ModuleGardening;
import binnie.botany.genetics.ItemDictionary;
import binnie.botany.genetics.ItemEncyclopedia;
import binnie.botany.genetics.ModuleGenetics;
import binnie.botany.items.ItemClay;
import binnie.botany.items.ItemPigment;
import binnie.botany.network.PacketID;
import binnie.botany.proxy.Proxy;
import binnie.core.BinnieCore;
import binnie.core.IBinnieMod;
import binnie.core.gui.IBinnieGUID;
import binnie.core.item.ItemMisc;
import binnie.core.network.BinniePacketHandler;
import binnie.core.network.IPacketID;
import binnie.core.network.packet.MessageNBT;
import binnie.core.proxy.IProxyCore;
import binnie.core.resource.IBinnieTexture;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

@Mod(modid="Botany", name="Botany", useMetadata=true, dependencies="after:BinnieCore")
public class Botany
extends IBinnieMod {
    public static final float AGE_CHANCE = 0.2f;
    @Mod.Instance(value="Botany")
    public static Botany instance;
    @SidedProxy(clientSide="binnie.botany.proxy.ProxyClient", serverSide="binnie.botany.proxy.ProxyServer")
    public static Proxy proxy;
    public static BlockFlower flower;
    public static Block loam;
    public static Item seed;
    public static Item pollen;
    public static ItemDictionary database;
    public static BlockPlant plant;
    public static ItemTrowel trowelWood;
    public static ItemTrowel trowelStone;
    public static ItemTrowel trowelIron;
    public static ItemTrowel trowelDiamond;
    public static ItemTrowel trowelGold;
    public static BlockSoil soil;
    public static BlockSoil flowerbed;
    public static ItemInsulatedTube insulatedTube;
    public static ItemSoilMeter soilMeter;
    public static ItemMisc misc;
    public static ItemEncyclopedia encyclopedia;
    public static ItemEncyclopedia encyclopediaIron;
    public static ItemFlower flowerItem;
    public static ItemPigment pigment;
    public static ItemClay clay;
    public static BlockCeramic ceramic;
    public static BlockCeramicPatterned ceramicTile;
    public static BlockStained stained;
    public static BlockCeramicBrick ceramicBrick;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.addModule(new ModuleCore());
        this.addModule(new ModuleGenetics());
        this.addModule(new ModuleGardening());
        this.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        this.postInit();
    }

    public Botany() {
        instance = this;
    }

    @Override
    public IBinnieGUID[] getGUIDs() {
        return BotanyGUI.values();
    }

    @Override
    public IBinnieTexture[] getTextures() {
        return new IBinnieTexture[0];
    }

    @Override
    public Class[] getConfigs() {
        return new Class[0];
    }

    @Override
    public IPacketID[] getPacketIDs() {
        return PacketID.values();
    }

    @Override
    public IProxyCore getProxy() {
        return proxy;
    }

    @Override
    public String getChannel() {
        return "BOT";
    }

    @Override
    public String getModID() {
        return "botany";
    }

    @Override
    protected Class<? extends BinniePacketHandler> getPacketHandler() {
        return PacketHandler.class;
    }

    @SubscribeEvent
    public void onShearFlower(PlayerInteractEvent event) {
        TileEntityFlower flower;
        TileEntity tile;
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.entityPlayer != null && event.entityPlayer.func_70694_bm() != null && event.entityPlayer.func_70694_bm().func_77973_b() == Items.field_151097_aZ && (tile = event.world.func_147438_o(event.x, event.y, event.z)) instanceof TileEntityFlower) {
            flower = (TileEntityFlower)tile;
            flower.onShear();
            event.entityPlayer.func_70694_bm().func_77972_a(1, (EntityLivingBase)event.entityPlayer);
        }
        if (event.entityPlayer != null && event.entityPlayer.func_70694_bm() != null && event.entityPlayer.func_70694_bm().func_77973_b() == pollen && (tile = event.world.func_147438_o(event.x, event.y, event.z)) instanceof TileEntityFlower) {
            flower = (TileEntityFlower)tile;
            IFlower pollen = BotanyCore.getFlowerRoot().getMember(event.entityPlayer.func_70694_bm());
            if (pollen != null && flower.canMateWith(pollen)) {
                flower.mateWith(pollen);
                if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                    --event.entityPlayer.func_70694_bm().field_77994_a;
                }
            }
        }
    }

    @SubscribeEvent
    public void onFertiliseSoil(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.world == null) {
            return;
        }
        if (event.entityPlayer != null && event.entityPlayer.func_70694_bm() != null) {
            int y = event.y;
            Block block = event.world.func_147439_a(event.x, y, event.z);
            if (block == null || !Gardening.isSoil(block)) {
                block = event.world.func_147439_a(event.x, --y, event.z);
            }
            if (block == null) {
                return;
            }
            if (Gardening.isSoil(block)) {
                EnumAcidity pH;
                int next;
                IBlockSoil soil = (IBlockSoil)block;
                if (Gardening.isNutrientFertiliser(event.entityPlayer.func_70694_bm()) && soil.getType(event.world, event.x, y, event.z) != EnumSoilType.FLOWERBED) {
                    EnumSoilType type = soil.getType(event.world, event.x, y, event.z);
                    next = Math.min(type.ordinal() + Gardening.getFertiliserStrength(event.entityPlayer.func_70694_bm()), 2);
                    if (soil.fertilise(event.world, event.x, y, event.z, EnumSoilType.values()[next]) && !event.entityPlayer.field_71075_bZ.field_75098_d) {
                        --event.entityPlayer.func_70694_bm().field_77994_a;
                        return;
                    }
                }
                if (Gardening.isAcidFertiliser(event.entityPlayer.func_70694_bm()) && soil.getPH(event.world, event.x, y, event.z) != EnumAcidity.Acid) {
                    pH = soil.getPH(event.world, event.x, y, event.z);
                    next = Math.max(pH.ordinal() - Gardening.getFertiliserStrength(event.entityPlayer.func_70694_bm()), 0);
                    if (soil.setPH(event.world, event.x, y, event.z, EnumAcidity.values()[next]) && !event.entityPlayer.field_71075_bZ.field_75098_d) {
                        --event.entityPlayer.func_70694_bm().field_77994_a;
                        return;
                    }
                }
                if (Gardening.isAlkalineFertiliser(event.entityPlayer.func_70694_bm()) && soil.getPH(event.world, event.x, y, event.z) != EnumAcidity.Alkaline) {
                    pH = soil.getPH(event.world, event.x, y, event.z);
                    next = Math.min(pH.ordinal() + Gardening.getFertiliserStrength(event.entityPlayer.func_70694_bm()), 2);
                    if (soil.setPH(event.world, event.x, y, event.z, EnumAcidity.values()[next]) && !event.entityPlayer.field_71075_bZ.field_75098_d) {
                        --event.entityPlayer.func_70694_bm().field_77994_a;
                        return;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void plantVanilla(BlockEvent.PlaceEvent event) {
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        Block block = world.func_147439_a(x, y - 1, z);
        if (!(block instanceof IBlockSoil)) {
            return;
        }
        IFlower flower = BotanyCore.getFlowerRoot().getConversion(event.itemInHand);
        if (flower != null) {
            Gardening.plant(world, x, y, z, flower, event.player.func_146103_bH());
        }
    }

    @Deprecated
    public void onPlantVanilla(PlayerInteractEvent event) {
        if (!BinnieCore.proxy.isSimulating(event.world)) {
            return;
        }
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.entityPlayer != null && event.entityPlayer.func_70694_bm() != null) {
            IFlower flower;
            World world = event.world;
            int x = event.x;
            int y = event.y;
            int z = event.z;
            Block block = world.func_147439_a(x, y, z);
            int py = -1;
            if (block instanceof IBlockSoil && (world.func_147437_c(x, y + 1, z) || world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z))) {
                py = 1;
            }
            if (py >= 0 && (flower = BotanyCore.getFlowerRoot().getConversion(event.entityPlayer.func_70694_bm())) != null && Gardening.plant(world, x, y + py, z, flower, event.entityPlayer.func_146103_bH()) && !event.entityPlayer.field_71075_bZ.field_75098_d) {
                --event.entityPlayer.func_70694_bm().field_77994_a;
            }
        }
    }

    @SubscribeEvent
    public void onBonemeal(BonemealEvent event) {
        TileEntity tile;
        IBlockSoil soil;
        Block block = event.world.func_147439_a(event.x, event.y, event.z);
        if (Gardening.isSoil(block) && (soil = (IBlockSoil)block).fertilise(event.world, event.x, event.y, event.z, EnumSoilType.LOAM)) {
            event.setResult(Event.Result.ALLOW);
        }
        if ((tile = event.world.func_147438_o(event.x, event.y, event.z)) instanceof TileEntityFlower && ((TileEntityFlower)tile).onBonemeal()) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onUseEncylopedia(PlayerInteractEvent event) {
        TileEntityFlower tileFlower;
        IFlower flower;
        TileEntity tile;
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.entityPlayer != null && event.entityPlayer.func_70694_bm() != null && event.entityPlayer.func_70694_bm().func_77973_b() instanceof ItemEncyclopedia && (tile = event.world.func_147438_o(event.x, event.y, event.z)) instanceof TileEntityFlower && (flower = (tileFlower = (TileEntityFlower)tile).getFlower()) != null) {
            NBTTagCompound info = new NBTTagCompound();
            info.func_74778_a("Species", flower.getGenome().getPrimary().getUID());
            info.func_74778_a("Species2", flower.getGenome().getSecondary().getUID());
            info.func_74776_a("Age", (float)flower.getAge() / (float)flower.getGenome().getLifespan());
            info.func_74777_a("Colour", (short)flower.getGenome().getPrimaryColor().getID());
            info.func_74777_a("Colour2", (short)flower.getGenome().getSecondaryColor().getID());
            info.func_74757_a("Wilting", flower.isWilted());
            info.func_74757_a("Flowered", flower.hasFlowered());
            proxy.sendToPlayer(new MessageNBT(PacketID.Encylopedia.ordinal(), info), event.entityPlayer);
            event.entityPlayer.func_70694_bm().func_77972_a(1, (EntityLivingBase)event.entityPlayer);
        }
    }

    @Override
    public boolean isActive() {
        return BinnieCore.isBotanyActive();
    }

    public static class PacketHandler
    extends BinniePacketHandler {
        public PacketHandler() {
            super(instance);
        }
    }
}

