/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.ColorUtils;
import buildcraft.transport.TileGenericPipeCompat;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerBundledInput
extends BCStatement
implements ITriggerExternal {
    private boolean active;

    public TriggerBundledInput(boolean active) {
        super(new String[]{"buildcraftcompat:bundled.input." + (active ? "active" : "inactive"), "buildcraftcompat.bundled.input." + (active ? "active" : "inactive")});
        this.active = active;
    }

    public String getDescription() {
        return "Bundled Signal " + (this.active ? "Active" : "Inactive");
    }

    public boolean isTriggerActive(TileEntity tileEntity, ForgeDirection side, IStatementContainer container, IStatementParameter[] parameter) {
        if (parameter == null || parameter.length < 1 || parameter[0] == null || parameter[0].getItemStack() == null) {
            return false;
        }
        int color = ColorUtils.getColorIDFromDye((ItemStack)parameter[0].getItemStack());
        if (color < 0) {
            return false;
        }
        TileEntity cTile = container.getTile();
        if (cTile instanceof TileGenericPipeCompat) {
            TileGenericPipeCompat tile = (TileGenericPipeCompat)cTile;
            return tile.getBundledCable(side.ordinal(), color) ^ !this.active;
        }
        return false;
    }

    public void registerIcons(IIconRegister r) {
        this.icon = r.func_94245_a("buildcraftcompat:trigger_bundled_" + (this.active ? "on" : "off"));
    }

    public int minParameters() {
        return 1;
    }

    public int maxParameters() {
        return 1;
    }

    public IStatementParameter createParameter(int var1) {
        return new StatementParameterItemStack();
    }
}

