/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.utils.ColorUtils;
import buildcraft.transport.TileGenericPipeCompat;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class ActionBundledOutput
extends BCStatement
implements IActionExternal {
    public ActionBundledOutput() {
        super(new String[]{"buildcraftcompat:bundled.output", "buildcraftcompat.bundled.output"});
    }

    public String getDescription() {
        return "Bundled Signal";
    }

    public void actionActivate(TileEntity tileEntity, ForgeDirection side, IStatementContainer container, IStatementParameter[] parameter) {
        if (parameter == null || parameter.length < 1 || parameter[0] == null || parameter[0].getItemStack() == null) {
            return;
        }
        int color = ColorUtils.getColorIDFromDye((ItemStack)parameter[0].getItemStack());
        if (color < 0) {
            return;
        }
        TileEntity cTile = container.getTile();
        if (cTile instanceof TileGenericPipeCompat) {
            TileGenericPipeCompat tile = (TileGenericPipeCompat)cTile;
            tile.setBundledCable(side.ordinal(), color, true);
        }
    }

    public void registerIcons(IIconRegister r) {
        this.icon = r.func_94245_a("buildcraftcompat:action_bundled");
    }

    public int minParameters() {
        return 1;
    }

    public int maxParameters() {
        return 1;
    }

    public IStatementParameter createParameter(int var1) {
        return new StatementParameterItemStack();
    }
}

