/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.nei;

import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IFlexibleRecipeViewable;
import buildcraft.compat.nei.RecipeHandlerBase;
import buildcraft.silicon.gui.GuiIntegrationTable;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class RecipeHandlerIntegrationTable
extends RecipeHandlerBase {
    private static Class<? extends GuiContainer> guiClass;

    @Override
    public void prepare() {
        guiClass = GuiIntegrationTable.class;
        API.setGuiOffset(guiClass, (int)5, (int)25);
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tile.integrationTableBlock.name");
    }

    @Override
    public String getRecipeID() {
        return "buildcraft.integrationTable";
    }

    public String getGuiTexture() {
        return "buildcraft:textures/gui/integration_table.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(89, 7, 6, 72);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiClass;
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)5, (int)5, (int)25, (int)166, (int)43);
    }

    public void drawExtras(int recipe) {
        GuiDraw.drawStringC((String)(((CachedIntegrationTableRecipe)((Object)this.arecipes.get((int)recipe))).energy + " RF"), (int)104, (int)8, (int)0x808080, (boolean)false);
    }

    @Override
    public void loadAllRecipes() {
        for (IFlexibleRecipe recipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
            ItemStack output;
            if (!(recipe instanceof IFlexibleRecipeViewable) || !(((IFlexibleRecipeViewable)recipe).getOutput() instanceof ItemStack) || (output = (ItemStack)((IFlexibleRecipeViewable)recipe).getOutput()).func_77973_b() instanceof IFacadeItem) continue;
            this.arecipes.add(new CachedIntegrationTableRecipe((IFlexibleRecipeViewable)recipe, true));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (IFlexibleRecipe recipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
            IFlexibleRecipeViewable recipeViewable;
            if (!(recipe instanceof IFlexibleRecipeViewable) || !((recipeViewable = (IFlexibleRecipeViewable)recipe).getOutput() instanceof ItemStack)) continue;
            ItemStack output = (ItemStack)recipeViewable.getOutput();
            if ((output.field_77990_d == null || !NEIServerUtils.areStacksSameType((ItemStack)output, (ItemStack)result)) && (output.field_77990_d != null || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result))) continue;
            this.arecipes.add(new CachedIntegrationTableRecipe((IFlexibleRecipeViewable)recipe, true));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (IFlexibleRecipe recipe : BuildcraftRecipeRegistry.integrationTable.getRecipes()) {
            CachedIntegrationTableRecipe crecipe;
            if (!(recipe instanceof IFlexibleRecipeViewable) || !(crecipe = new CachedIntegrationTableRecipe((IFlexibleRecipeViewable)recipe)).contains(crecipe.inputs, ingredient)) continue;
            crecipe.generatePermutations();
            crecipe.setIngredientPermutation(crecipe.inputs, ingredient);
            this.arecipes.add(crecipe);
        }
    }

    public class CachedIntegrationTableRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedStack> inputs;
        public PositionedStack output;
        public int energy;

        public CachedIntegrationTableRecipe(IFlexibleRecipeViewable recipe, boolean generatePermutations) {
            super(RecipeHandlerIntegrationTable.this);
            this.inputs = new ArrayList<PositionedStack>();
            if (recipe.getInputs() instanceof List) {
                this.setIngredients((List)recipe.getInputs());
            }
            if (recipe.getOutput() != null) {
                this.output = new PositionedStack(recipe.getOutput(), 138, 24);
            }
            this.energy = recipe.getEnergyCost();
            if (generatePermutations) {
                this.generatePermutations();
            }
        }

        public CachedIntegrationTableRecipe(IFlexibleRecipeViewable recipe) {
            this(recipe, false);
        }

        public void setIngredients(List<Object> inputs) {
            int i = 0;
            for (Object o : inputs) {
                this.inputs.add(new PositionedStack(o, 12 + i * 36, 8, false));
                ++i;
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerIntegrationTable.this.cycleticks / 20, this.inputs);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public void generatePermutations() {
            for (PositionedStack p : this.inputs) {
                p.generatePermutations();
            }
        }
    }
}

