/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.multipart;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.compat.multipart.SchematicPart;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class SchematicSimplePart<T extends TMultiPart>
extends SchematicPart<T> {
    public final String type;

    public SchematicSimplePart(String type) {
        this.type = type;
    }

    @Override
    public void placePart(IBuilderContext context, BlockCoord pos, NBTTagCompound tag, int rotation) {
        T part = this.create(tag, rotation);
        if (TileMultipart.canPlacePart((World)context.world(), (BlockCoord)pos, part)) {
            TileMultipart.addPart((World)context.world(), (BlockCoord)pos, part);
        }
    }

    public T create(NBTTagCompound tag, int rotation) {
        TMultiPart part = MultiPartRegistry.createPart((String)this.type, (boolean)false);
        part.load(tag);
        this.rotate(part, rotation);
        return (T)part;
    }

    public void rotate(T part, int rotation) {
        for (int i = 0; i < rotation; ++i) {
            this.rotateLeft(part);
        }
    }

    public void rotateLeft(T part) {
    }
}

