/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.minetweaker;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleRecipeViewable;
import buildcraft.api.recipes.IIntegrationRecipe;
import buildcraft.compat.minetweaker.IIntegrationRecipeFunction;
import buildcraft.silicon.TileIntegrationTable;
import buildcraft.transport.recipes.IntegrationTableRecipe;
import java.util.ArrayList;
import java.util.Collection;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.IntegrationTable")
@ModOnly(value={"BuildCraft|Silicon"})
public class IntegrationTable {
    @ZenMethod
    public static void addRecipe(String name, IItemStack output, int energy, int craftingTime, IIngredient inputA, IIngredient inputB, @Optional IIntegrationRecipeFunction function) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(name, output, energy, craftingTime, inputA, inputB, function));
    }

    private static class MTIntegrationRecipe
    extends IntegrationTableRecipe
    implements IFlexibleRecipeViewable {
        private final IIngredient inputA;
        private final IIngredient inputB;
        private final Collection<Object> inputs = new ArrayList<Object>();
        private final IIntegrationRecipeFunction function;

        private MTIntegrationRecipe(String id, IItemStack output, int energy, int craftingTime, IIngredient inputA, IIngredient inputB, IIntegrationRecipeFunction function) {
            this.inputA = inputA;
            this.inputB = inputB;
            this.inputs.add(MineTweakerMC.getExamples((IIngredient)inputA));
            this.inputs.add(MineTweakerMC.getExamples((IIngredient)inputB));
            this.function = function;
            this.setContents(id, MineTweakerMC.getItemStack((IItemStack)output), energy, craftingTime, new Object[0]);
        }

        public boolean isValidInputA(ItemStack is) {
            if (is == null || this.inputA == null) {
                return false;
            }
            return this.inputA.matches(MineTweakerMC.getIItemStack((ItemStack)is));
        }

        public boolean isValidInputB(ItemStack is) {
            if (is == null || this.inputB == null) {
                return false;
            }
            return this.inputB.matches(MineTweakerMC.getIItemStack((ItemStack)is));
        }

        public CraftingResult<ItemStack> craft(TileIntegrationTable crafter, boolean preview, ItemStack inputA, ItemStack inputB) {
            if (inputA == null) {
                return null;
            }
            CraftingResult result = super.craft(crafter, preview, inputA, inputB);
            if (result == null) {
                return null;
            }
            if (this.function != null) {
                IItemStack out = this.function.recipe(MineTweakerMC.getIItemStack((ItemStack)((ItemStack)this.output)), MineTweakerMC.getIItemStack((ItemStack)inputA), MineTweakerMC.getIItemStack((ItemStack)inputB));
                result.crafted = MineTweakerMC.getItemStack((IItemStack)out);
            } else {
                result.crafted = this.output;
            }
            return result;
        }

        public Collection<Object> getInputs() {
            return this.inputs;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final MTIntegrationRecipe recipe;

        public AddRecipeAction(String name, IItemStack output, int energy, int craftingTime, IIngredient inputA, IIngredient inputB, IIntegrationRecipeFunction function) {
            this.recipe = new MTIntegrationRecipe(name, output, energy, craftingTime, inputA, inputB, function);
        }

        public void apply() {
            BuildcraftRecipeRegistry.integrationTable.addRecipe((IIntegrationRecipe)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BuildcraftRecipeRegistry.integrationTable.getRecipes().remove((Object)this.recipe);
        }

        public String describe() {
            return "Adding integration table recipe for " + this.recipe.output;
        }

        public String describeUndo() {
            return "Removing integration table recipe for " + this.recipe.output;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

