/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.minetweaker;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IFlexibleRecipeViewable;
import java.util.ArrayList;
import java.util.Collection;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.AssemblyTable")
@ModOnly(value={"BuildCraft|Silicon"})
public class AssemblyTable {
    @ZenMethod
    public static void addRecipe(IItemStack output, int energy, IIngredient[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, energy, ingredients));
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        AssemblyTable.removeRecipe(output, null, false);
    }

    @ZenMethod
    public static void removeByName(String name) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeByNameAction(name));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output, @Optional IIngredient[] ingredients, @Optional boolean wildcard) {
        ArrayList<IFlexibleRecipe> toRemove = new ArrayList<IFlexibleRecipe>();
        for (IFlexibleRecipe recipe : BuildcraftRecipeRegistry.assemblyTable.getRecipes()) {
            if (!(recipe instanceof IFlexibleRecipeViewable) || !output.matches(MineTweakerMC.getIItemStack((ItemStack)((ItemStack)((IFlexibleRecipeViewable)recipe).getOutput()))) || !AssemblyTable.ingredientsMatch(((IFlexibleRecipeViewable)recipe).getInputs(), ingredients, wildcard)) continue;
            toRemove.add(recipe);
        }
        for (IFlexibleRecipe recipe : toRemove) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction((IFlexibleRecipe<ItemStack>)recipe));
        }
    }

    private static boolean ingredientsMatch(Collection<Object> recipeIngs, IIngredient[] ingredients, boolean wildcard) {
        if (ingredients == null) {
            return true;
        }
        int matchedIngredients = 0;
        boolean[] matched = new boolean[ingredients.length];
        block0: for (Object ingredientObject : recipeIngs) {
            if (ingredientObject instanceof Number) continue;
            IIngredient recipeIngredient = MineTweakerMC.getIIngredient((Object)ingredientObject);
            for (int j = 0; j < ingredients.length; ++j) {
                if (matched[j] || !ingredients[j].contains(recipeIngredient)) continue;
                matched[j] = true;
                ++matchedIngredients;
                continue block0;
            }
            if (wildcard) continue;
            return false;
        }
        return matchedIngredients == ingredients.length;
    }

    private static class RemoveRecipeByNameAction
    implements IUndoableAction {
        private final String name;

        public RemoveRecipeByNameAction(String name) {
            this.name = name;
        }

        public void apply() {
            BuildcraftRecipeRegistry.assemblyTable.removeRecipe(this.name);
        }

        public boolean canUndo() {
            return false;
        }

        public void undo() {
        }

        public String describe() {
            return "Removing assembly table recipe " + this.name;
        }

        public String describeUndo() {
            return "Restoring assembly table recipe " + this.name;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private final IFlexibleRecipe<ItemStack> recipe;

        public RemoveRecipeAction(IFlexibleRecipe<ItemStack> recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            BuildcraftRecipeRegistry.assemblyTable.removeRecipe(this.recipe);
        }

        public boolean canUndo() {
            return false;
        }

        public void undo() {
        }

        public String describe() {
            return "Removing assembly table recipe for " + ((ItemStack)((IFlexibleRecipeViewable)this.recipe).getOutput()).func_82833_r();
        }

        public String describeUndo() {
            return "Restoring assembly table recipe for " + ((ItemStack)((IFlexibleRecipeViewable)this.recipe).getOutput()).func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final IItemStack output;
        private final String name;
        private final int energy;
        private final Object[] mcIngredients;

        public AddRecipeAction(IItemStack output, int energy, IIngredient[] ingredients) {
            this.output = output;
            String _name = "MineTweaker:" + this.output.getName() + ":" + this.output.getDamage();
            this.mcIngredients = new Object[ingredients.length];
            for (int i = 0; i < ingredients.length; ++i) {
                this.mcIngredients[i] = ingredients[i].getInternal();
                if (this.mcIngredients[i] == null) {
                    throw new IllegalArgumentException("Not a valid assembly table ingredient");
                }
                _name = _name + ":" + ingredients[i].toString();
            }
            this.energy = energy;
            this.name = _name;
        }

        public void apply() {
            BuildcraftRecipeRegistry.assemblyTable.addRecipe(this.name, this.energy, MineTweakerMC.getItemStack((IItemStack)this.output), this.mcIngredients);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BuildcraftRecipeRegistry.assemblyTable.removeRecipe(this.name);
        }

        public String describe() {
            return "Adding assembly table recipe for " + this.output;
        }

        public String describeUndo() {
            return "Removing assembly table recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

