/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftMod;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IActionProvider;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerProvider;
import buildcraft.api.statements.StatementManager;
import buildcraft.compat.CompatUtils;
import buildcraft.compat.SchematicTileDrops;
import buildcraft.compat.carpentersblocks.SchematicCBBlock;
import buildcraft.compat.carpentersblocks.SchematicCBGate;
import buildcraft.compat.carpentersblocks.SchematicCBRotated;
import buildcraft.compat.carpentersblocks.SchematicCBRotatedTwo;
import buildcraft.compat.carpentersblocks.SchematicCBSafe;
import buildcraft.compat.ironchests.SchematicIronChest;
import buildcraft.compat.minetweaker.MineTweakerInit;
import buildcraft.compat.multipart.MultipartSchematics;
import buildcraft.compat.nei.NEIIntegrationBC;
import buildcraft.compat.redlogic.RedLogicProvider;
import buildcraft.core.triggers.ActionBundledOutput;
import buildcraft.core.triggers.TriggerBundledInput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

@Mod(name="BuildCraft Compat", version="6.3.0", useMetadata=false, modid="BuildCraft|Compat", acceptedMinecraftVersions="[1.7.10,1.8)", dependencies="required-after:Forge@[10.13.0.1179,);required-after:BuildCraft|Core@[6.3.0,6.4.0)")
public class BuildCraftCompat
extends BuildCraftMod {
    public static ITriggerExternal triggerBundledInputOff;
    public static ITriggerExternal triggerBundledInputOn;
    public static IActionExternal actionBundledOutput;
    public static boolean enableBundledRedstone;
    public static boolean enableNEI;
    public static boolean enableMultipart;
    private static Configuration config;

    private boolean getModBoolean(String modID, String name, String cat, boolean def, String comm) {
        if (Loader.isModLoaded((String)modID)) {
            return config.getBoolean(name, cat, def, comm);
        }
        return false;
    }

    @Mod.EventHandler
    public void loadConfig(FMLPreInitializationEvent evt) {
        config = new Configuration(new File(new File(evt.getSuggestedConfigurationFile().getParentFile(), "buildcraft"), "compat.cfg"));
        config.load();
        if (Loader.isModLoaded((String)"RedLogic")) {
            enableBundledRedstone = config.getBoolean("enableBundledRedstone", "compat", false, "RedLogic compatibility - bundled cables can be connected to pipes. WARNING: HIGHLY EXPERIMENTAL - MIGHT BE BROKEN");
        }
        enableNEI = this.getModBoolean("NotEnoughItems", "enableNEI", "compat", true, "NEI recipe and ledger integration.");
        enableMultipart = this.getModBoolean("ForgeMultipart", "enableMultipart", "compat", true, "ForgeMultipart schematic integration.");
        config.save();
    }

    @Mod.EventHandler
    public void initalize(FMLInitializationEvent evt) {
        if (enableBundledRedstone) {
            triggerBundledInputOff = new TriggerBundledInput(false);
            triggerBundledInputOn = new TriggerBundledInput(true);
            actionBundledOutput = new ActionBundledOutput();
            if (Loader.isModLoaded((String)"RedLogic")) {
                RedLogicProvider p = new RedLogicProvider();
                StatementManager.registerActionProvider((IActionProvider)p);
                StatementManager.registerTriggerProvider((ITriggerProvider)p);
            }
        }
        if (enableMultipart) {
            MultipartSchematics.init();
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && enableNEI) {
            new NEIIntegrationBC().load();
        }
        CompatUtils.registerSchematic("IronChest:BlockIronChest", SchematicIronChest.class, new Object[0]);
        CompatUtils.registerSchematic("CarpentersBlocks:blockCarpentersBlock", SchematicCBBlock.class, new Object[0]);
        CompatUtils.registerSchematic("CarpentersBlocks:blockCarpentersDaylightSensor", SchematicTileDrops.class, new Object[0]);
        CompatUtils.registerSchematic("CarpentersBlocks:blockCarpentersGate", SchematicCBGate.class, new Object[0]);
        CompatUtils.registerSchematic("CarpentersBlocks:blockCarpentersLadder", SchematicCBRotatedTwo.class, new Object[0]);
        CompatUtils.registerSchematic("CarpentersBlocks:blockCarpentersPressurePlate", SchematicTileDrops.class, new Object[0]);
        CompatUtils.registerSchematic("CarpentersBlocks:blockCarpentersSafe", SchematicCBSafe.class, new Object[0]);
        CompatUtils.registerSchematic("CarpentersBlocks:blockCarpentersSlope", SchematicCBRotated.class, new Object[0]);
        CompatUtils.registerSchematic("CarpentersBlocks:blockCarpentersStairs", SchematicCBRotated.class, new Object[0]);
    }

    @Mod.EventHandler
    public void postInitalize(FMLPostInitializationEvent evt) {
        if (Loader.isModLoaded((String)"MineTweaker3")) {
            MineTweakerInit.init();
        }
    }
}

