/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange.items;

import brad16840.balancedexchange.BalancedExchange;
import brad16840.balancedexchange.PacketHandler;
import brad16840.balancedexchange.gui.AreaUpgradeContainer;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.MessageChannel;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class AreaUpgrade
extends UniqueItem
implements UniqueItem.OpenableItem {
    public static int _maximumSideLength = 9;
    public static int maximumSideLength;
    public String field_77774_bZ;
    public static Translatable name;

    public AreaUpgrade(String unlocalizedName) {
        this.field_77774_bZ = unlocalizedName;
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77655_b(unlocalizedName);
        name = new Translatable("item." + unlocalizedName + ".name", new Object[0]);
        AreaUpgrade.name.toLowerCase = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("balancedexchange:" + this.field_77774_bZ);
    }

    private static NBTTagCompound getTagCompound(EntityPlayer player, ItemStack stack, String uuid) {
        NBTTagCompound tag = UniqueItemData.get((World)player.field_70170_p).getItemData(player, uuid);
        if (tag == null) {
            if (stack != null) {
                tag = stack.func_77978_p();
            }
            if (tag == null) {
                tag = new NBTTagCompound();
            }
        }
        return tag;
    }

    private static void markDirty(World world, String uuid) {
        UniqueItemData.get((World)world).markItemDirty(uuid);
    }

    public static void ensureNBTTags(EntityPlayer player, ItemStack stack) {
        String uuid = UniqueItem.getIdentifier((ItemStack)stack);
        NBTTagCompound tagCompound = AreaUpgrade.getTagCompound(player, stack, uuid);
        if (tagCompound == null) {
            return;
        }
        if (!tagCompound.func_74764_b("AreaOfEffect")) {
            NBTTagCompound area = new NBTTagCompound();
            area.func_74777_a("x+", (short)1);
            area.func_74777_a("x-", (short)1);
            area.func_74777_a("y+", (short)1);
            area.func_74777_a("y-", (short)1);
            area.func_74777_a("z+", (short)1);
            area.func_74777_a("z-", (short)1);
            area.func_74757_a("AbsoluteAxes", false);
            tagCompound.func_74782_a("AreaOfEffect", (NBTBase)area);
            AreaUpgrade.markDirty(player.field_70170_p, uuid);
        }
    }

    public static int[] getArea(EntityPlayer player, ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof AreaUpgrade)) {
            return new int[]{0, 0, 0, 0, 0, 0};
        }
        AreaUpgrade.ensureNBTTags(player, stack);
        String uuid = UniqueItem.getIdentifier((ItemStack)stack);
        NBTTagCompound area = AreaUpgrade.getTagCompound(player, stack, uuid).func_74775_l("AreaOfEffect");
        return new int[]{-area.func_74765_d("y-"), area.func_74765_d("y+"), -area.func_74765_d("z-"), area.func_74765_d("z+"), -area.func_74765_d("x-"), area.func_74765_d("x+")};
    }

    public static void changeArea(EntityPlayer player, ItemStack stack, int side, int delta, boolean triggerUpdate) {
        if (stack == null || !(stack.func_77973_b() instanceof AreaUpgrade)) {
            return;
        }
        AreaUpgrade.ensureNBTTags(player, stack);
        String uuid = UniqueItem.getIdentifier((ItemStack)stack);
        UniqueItemData data = UniqueItemData.get((World)player.field_70170_p);
        if (!data.hasRequiredPermission(player, uuid, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)name).send(player);
            return;
        }
        NBTTagCompound area = AreaUpgrade.getTagCompound(player, stack, uuid).func_74775_l("AreaOfEffect");
        String t = null;
        switch (side) {
            case 0: {
                t = "y-";
                break;
            }
            case 1: {
                t = "y+";
                break;
            }
            case 2: {
                t = "z-";
                break;
            }
            case 3: {
                t = "z+";
                break;
            }
            case 4: {
                t = "x-";
                break;
            }
            case 5: {
                t = "x+";
            }
        }
        if (t == null) {
            return;
        }
        int val = area.func_74765_d(t) + delta;
        if (val > maximumSideLength) {
            val = maximumSideLength;
        }
        if (val < 0) {
            val = 0;
        }
        area.func_74777_a(t, (short)val);
        if (triggerUpdate) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.AreaChange(uuid, AreaUpgrade.getTagCompound(player, stack, uuid)));
        }
        AreaUpgrade.markDirty(player.field_70170_p, uuid);
    }

    public static void toggleAbsoluteAxis(EntityPlayer player, ItemStack stack, boolean triggerUpdate) {
        NBTTagCompound area;
        if (stack == null || !(stack.func_77973_b() instanceof AreaUpgrade)) {
            return;
        }
        AreaUpgrade.ensureNBTTags(player, stack);
        String uuid = UniqueItem.getIdentifier((ItemStack)stack);
        UniqueItemData data = UniqueItemData.get((World)player.field_70170_p);
        if (!data.hasRequiredPermission(player, uuid, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)name).send(player);
            return;
        }
        area.func_74757_a("AbsoluteAxes", !(area = AreaUpgrade.getTagCompound(player, stack, uuid).func_74775_l("AreaOfEffect")).func_74767_n("AbsoluteAxes"));
        if (triggerUpdate) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.AreaChange(uuid, AreaUpgrade.getTagCompound(player, stack, uuid)));
        }
        AreaUpgrade.markDirty(player.field_70170_p, uuid);
    }

    public static boolean isAbsoluteAxes(EntityPlayer player, ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof AreaUpgrade)) {
            return false;
        }
        AreaUpgrade.ensureNBTTags(player, stack);
        String uuid = UniqueItem.getIdentifier((ItemStack)stack);
        NBTTagCompound area = AreaUpgrade.getTagCompound(player, stack, uuid).func_74775_l("AreaOfEffect");
        return area.func_74767_n("AbsoluteAxes");
    }

    public static int getAreaDirection(EntityPlayer player, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (AreaUpgrade.isAbsoluteAxes(player, stack)) {
            int p = MathHelper.func_76128_c((double)((double)(player.field_70125_A * 4.0f / 360.0f) + 0.5)) & 3;
            if (p == 1) {
                l += 5;
            } else if (p == 3) {
                l += 10;
            }
        }
        return l;
    }

    public static int[] orientateArea(EntityPlayer player, ItemStack stack) {
        int[] area = AreaUpgrade.getArea(player, stack);
        AreaUpgrade.orientateArea(player, stack, area);
        return area;
    }

    private static void swap(int[] area, int a, int b) {
        int temp = area[a];
        area[a] = area[b];
        area[b] = temp;
    }

    public static void orientateArea(EntityPlayer player, ItemStack stack, int[] area) {
        int l;
        if (AreaUpgrade.isAbsoluteAxes(player, stack)) {
            l = MathHelper.func_76128_c((double)((double)(player.field_70125_A * 4.0f / 360.0f) + 0.5)) & 3;
            if (l == 1 || l == 3) {
                AreaUpgrade.swap(area, 0, 2);
                AreaUpgrade.swap(area, 1, 3);
            }
            if (l == 1) {
                area[0] = -area[0];
                area[1] = -area[1];
                AreaUpgrade.swap(area, 0, 1);
            }
            if (l == 3) {
                area[2] = -area[2];
                area[3] = -area[3];
                AreaUpgrade.swap(area, 2, 3);
            }
        }
        if ((l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 1 || l == 3) {
            AreaUpgrade.swap(area, 2, 4);
            AreaUpgrade.swap(area, 3, 5);
        }
        if (l == 0 || l == 1) {
            area[4] = -area[4];
            area[5] = -area[5];
            AreaUpgrade.swap(area, 4, 5);
        }
        if (l == 1 || l == 2) {
            AreaUpgrade.swap(area, 2, 3);
            area[2] = -area[2];
            area[3] = -area[3];
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (AreaUpgrade.getArea(player, stack) == null) {
            return;
        }
        new Translatable("tooltip.areaupgrade", new Object[]{this.getAreaString(player, stack)}).addTo(list);
    }

    public Translatable getAreaString(EntityPlayer player, ItemStack stack) {
        int[] area = AreaUpgrade.getArea(player, stack);
        if (area == null) {
            return new Translatable("", new Object[0]);
        }
        return new Translatable("areaformat", new Object[]{1 + area[5] - area[4], 1 + area[1] - area[0], 1 + area[3] - area[2]});
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        this.open(player, stack, world);
        return super.func_77659_a(stack, world, player);
    }

    public boolean open(EntityPlayer player, ItemStack stack, World world) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (!UniqueItem.getIdentifier((ItemStack)player.func_71045_bC()).equals(UniqueItem.getIdentifier((ItemStack)stack))) {
            BalancedExchange.proxy.guiItem = stack;
        }
        ItemStack s = player.field_71071_by.func_70445_o();
        player.field_71071_by.func_70437_b(null);
        player.openGui((Object)BalancedExchange.instance, 2, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        if (player.field_71070_bA instanceof ContainerStack) {
            player.field_71071_by.func_70437_b(s);
            Common.channel.sendToPlayer(player, (MessageChannel.Message)new PacketHandler.TellTheClientTheHeldItemStackHasChanged(s));
        } else if (s != null) {
            player.func_71019_a(s, false);
        }
        return true;
    }

    public Integer getPreferreredStack(ContainerStack container, int stackId) {
        return null;
    }

    public StackableContainer openContainer(EntityPlayer player, IInventory parentInventory, int inventoryIndex, ItemStack stack, int stackId) {
        String guid = UniqueItem.getIdentifier((ItemStack)stack);
        if (!Common.ensureInventoryIdentifiers((EntityPlayer)player, (IInventory)parentInventory, (ItemStack)stack, (int)stackId, new ArrayList())) {
            return null;
        }
        if (UniqueItem.getInventoryContaining((EntityPlayer)player, (String)guid, null) == null) {
            return null;
        }
        return new AreaUpgradeContainer(player, guid);
    }

    public boolean ensureInventoryIdentifiers(EntityPlayer player, ItemStack stack) {
        return Common.ensureInventoryIdentifiers((EntityPlayer)player, (IInventory)player.field_71071_by, (ItemStack)stack, (int)-1, new ArrayList());
    }
}

