/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange.gui;

import brad16840.balancedexchange.AmuletStack;
import brad16840.balancedexchange.BalancedExchange;
import brad16840.balancedexchange.blocks.TransmutationChestTileEntity;
import brad16840.balancedexchange.gui.AmuletContainer;
import brad16840.balancedexchange.items.AmuletOfTransmutation;
import brad16840.common.BlockPos;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.MessageChannel;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.gui.CraftingContainer;
import brad16840.common.permissions.PacketHandler;
import brad16840.common.permissions.gui.ClientState;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class TransmutationChestContainer
extends StackableContainer
implements UniqueItem.BaseInventoryProvider {
    public TransmutationChestTileEntity entity;
    private int x;
    private int y;
    private int z;
    private String chestId;
    private static final ResourceLocation texture = new ResourceLocation("balancedexchange", "textures/gui/transmutation_chest.png");
    private AmuletStack amulet;
    private boolean readOnly;
    private boolean wasClosed = true;

    public TransmutationChestContainer(TransmutationChestTileEntity entity, EntityPlayer player, int x, int y, int z) {
        super(176, 128);
        this.x = x;
        this.y = y;
        this.z = z;
        this.chestId = TransmutationChestTileEntity.getChestId(new BlockPos(x, y, z), player.field_70170_p.field_73011_w.field_76574_g);
        this.entity = entity;
        UniqueItem.registerBaseInventoryProvider((UniqueItem.BaseInventoryProvider)this);
    }

    public boolean initContainer(EntityPlayer player) {
        TileEntity tileEntity = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
        if (!(tileEntity instanceof TransmutationChestTileEntity)) {
            return false;
        }
        this.entity = (TransmutationChestTileEntity)tileEntity;
        if (this.wasClosed && !player.field_70170_p.field_72995_K) {
            this.wasClosed = false;
            this.entity.func_70295_k_();
        }
        this.addSlotToContainer(ContainerStack.ContainerSection.CHEST, new AmuletSlot(player, this.entity, 0, 8, 16));
        this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_IN, new TargetSlot(player, this.entity, 2, 8, 104));
        this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_OUT, new StackableContainer.ContainerSlot((StackableContainer)this, player, (IInventory)this.entity, 1, 152, 104));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlotToContainer(ContainerStack.ContainerSection.CHEST, new StackableContainer.ContainerSlot((StackableContainer)this, player, (IInventory)this.entity, x + y * 9 + 3, 8 + x * 18, 38 + y * 18));
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (keyCode == Common.permissionKey.func_151463_i()) {
            if ((Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) && this.stackId == 0) {
                return false;
            }
            Common.channel.sendToServer((MessageChannel.Message)new PacketHandler.OpenGroup(0, new ClientState.PermissionGroupState(this.chestId, "I_" + this.chestId, 0, true), true));
            return true;
        }
        if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && keyCode == 18) {
            Common.channel.sendToServer((MessageChannel.Message)new PacketHandler.OpenEditorWindow("mpb", 1, false));
            return true;
        }
        return false;
    }

    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        for (int i = 0; i < containers.size(); ++i) {
            TransmutationChestContainer c = (TransmutationChestContainer)containers.get(i);
            TileEntity tileEntity = player.field_70170_p.func_147438_o(c.x, c.y, c.z);
            if (!(tileEntity instanceof TransmutationChestTileEntity)) {
                return false;
            }
            c.entity = (TransmutationChestTileEntity)tileEntity;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void static_addItemStackTooltip(List list, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        for (int i = 0; i < this.container.stacks.length; ++i) {
            if (!(this.container.getContainer(i) instanceof AmuletContainer)) continue;
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Translatable consumed = new Translatable("tooltip.mpb.inconsumable", new Object[0]);
        Translatable created = new Translatable("tooltip.mpb.uncreatable", new Object[0]);
        if (AmuletStack.canConsumeItemStack((EntityPlayer)player, itemStack)) {
            consumed = new Translatable("tooltip.mpb.consumable", new Object[]{AmuletStack.getMPBConsumed((EntityPlayer)player, player.field_70170_p, itemStack)});
        }
        if (AmuletOfTransmutation.canDispense(itemStack) || AmuletStack.canLearnItemStack(itemStack)) {
            created = new Translatable("tooltip.mpb.creatable", new Object[]{AmuletOfTransmutation.getMPBEntry((ItemStack)itemStack).created});
        }
        new Translatable("tooltip.mpb", new Object[]{consumed, created}).addTo(list);
    }

    public void onClosed(EntityPlayer player) {
        this.wasClosed = true;
        if (this.entity == null) {
            return;
        }
        if (!player.field_70170_p.field_72995_K) {
            this.entity.func_70305_f();
        }
        for (int i = 0; i < this.entity.func_70302_i_(); ++i) {
            ItemStack stack = this.entity.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof UniqueItem.UpdatableItem)) continue;
            ((UniqueItem.UpdatableItem)stack.func_77973_b()).updateItemStack(null, stack);
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        ItemStack itemstack = null;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (itemstack != null && itemstack.func_77973_b() instanceof AmuletOfTransmutation ? !this.container.mergeItemStack((StackableContainer)this, itemstack1, 0, 1, false) : !this.container.mergeItemStack((StackableContainer)this, itemstack1, 3, 30, false)) {
                return null;
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, itemstack);
        }
        return itemstack;
    }

    public boolean refreshAmulet(EntityPlayer player) {
        String id = this.getId();
        if (id.equals("none")) {
            this.amulet = null;
            return false;
        }
        this.amulet = AmuletStack.create(null, player.field_70170_p, id);
        if (this.amulet == null) {
            this.readOnly = true;
            return true;
        }
        this.readOnly = !UniqueItemData.get((World)player.field_70170_p).hasRequiredPermission(player, id, 2);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int mouseX, int mouseY) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (this.amulet != null && !this.getId().equals(this.amulet.getIdentifier())) {
            this.amulet = null;
        }
        this.gui.text((StackableContainer)this, new Translatable("gui.transmutationchest.amulet", new Object[0]).translate()).truncateString(52).drawCenteredString(88, 6, -12566464);
        this.gui.text((StackableContainer)this, new Translatable("gui.transmutationchest.create", new Object[0]).translate()).truncateString(100).drawCenteredString(88, 94, -12566464);
        if (this.amulet != null || this.refreshAmulet((EntityPlayer)player)) {
            try {
                int matter = this.amulet.getStoredMatter();
                this.gui.text((StackableContainer)this, new Translatable("gui.amulet.matter", new Object[]{matter}).translate()).truncateString(146).drawString(24, 24, -12566464, true);
            }
            catch (NullPointerException e) {
                this.gui.text((StackableContainer)this, new Translatable("gui.transmutationchest.amuletpermission", new Object[0]).translate()).truncateString(146).drawString(24, 24, -12566464, true);
                this.amulet = null;
            }
        } else {
            this.gui.text((StackableContainer)this, new Translatable("gui.transmutationchest.amuletempty", new Object[0]).translate()).truncateString(146).drawString(24, 24, -12566464, true);
        }
        if (this.entity.func_70301_a(2) != null) {
            ItemStack stack = this.entity.func_70301_a(2);
            int cost = 1000000001;
            if (this.amulet != null) {
                if (AmuletOfTransmutation.canDispense(stack) && AmuletOfTransmutation.allowQuickCreate || AmuletOfTransmutation.allowQuickCreate && this.amulet.hasLearnt(stack)) {
                    cost = this.amulet.getBlockCreationCost(stack, null);
                }
            } else {
                int baseCost = AmuletOfTransmutation.getMPBEntry((ItemStack)stack).created;
                if (baseCost == 0) {
                    baseCost = 1000000001;
                } else if (baseCost < 0) {
                    ++baseCost;
                }
                double efficiency = 1.0;
                if (AmuletStack.creationEfficiencyPerReactivityCore.length > 0) {
                    efficiency = AmuletStack.creationEfficiencyPerReactivityCore[0];
                }
                if (baseCost < 0 || baseCost == 1000000001) {
                    efficiency = 1.0;
                }
                if (stack.func_77973_b() == Item.func_150898_a((Block)BalancedExchange.blockOfReactivity)) {
                    baseCost = (int)((double)baseCost * efficiency);
                }
                if ((AmuletOfTransmutation.canDispense(stack) || AmuletStack.canLearnItemStack(stack)) && AmuletOfTransmutation.allowQuickCreate) {
                    cost = (int)((double)baseCost * efficiency);
                }
            }
            this.gui.text((StackableContainer)this, stack.func_82833_r()).truncateString(108).drawString(27, 104, -12566464);
            if (cost != 1000000001 && AmuletOfTransmutation.allowQuickCreate) {
                this.gui.text((StackableContainer)this, new Translatable("gui.amulet.mpbcreated", new Object[]{cost}).translate()).truncateString(108).drawString(27, 114, -12566464);
            } else if (this.amulet != null && AmuletOfTransmutation.allowQuickCreate && !this.amulet.hasLearnt(stack)) {
                if (this.amulet.getBlockCreationCost(stack, null) != 1000000001) {
                    this.gui.text((StackableContainer)this, new Translatable("gui.transmutationchest.notlearnt", new Object[0]).translate()).truncateString(108).drawString(27, 114, -2744288);
                } else {
                    this.gui.text((StackableContainer)this, new Translatable("gui.transmutationchest.uncreatable", new Object[0]).translate()).truncateString(108).drawString(27, 114, -2744288);
                }
            } else {
                this.gui.text((StackableContainer)this, new Translatable("gui.transmutationchest.uncreatable", new Object[0]).translate()).truncateString(108).drawString(27, 114, -2744288);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture((StackableContainer)this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
        if (this.entity != null && this.entity.percent > 0.1f) {
            this.gui.drawTexture((StackableContainer)this, 139, 108, (int)(10.0f * this.entity.percent), 8, 0, this.guiHeight);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        return false;
    }

    public String getId() {
        if (this.entity == null || this.entity.func_70301_a(0) == null) {
            return "none";
        }
        return UniqueItem.getIdentifier((ItemStack)this.entity.func_70301_a(0));
    }

    public boolean customRightClick(EntityPlayer player, int slot, boolean holdingShift) {
        ItemStack stack = this.container.func_75139_a(slot).func_75211_c();
        int openStackId = this.stackId;
        if (holdingShift && ++openStackId >= this.container.stacks.length) {
            openStackId = 0;
        }
        if (stack != null) {
            this.container.saveInventories(player);
            if (stack.func_77973_b() instanceof UniqueItem.OpenableItem) {
                UniqueItem.OpenableItem item = (UniqueItem.OpenableItem)stack.func_77973_b();
                StackableContainer c = item.openContainer(player, (IInventory)player.field_71071_by, this.container.func_75139_a(slot).getSlotIndex(), stack, openStackId);
                if (c != null) {
                    this.container.addContainer(player, item.getPreferreredStack(this.container, openStackId), c);
                } else if (this.isClient()) {
                    this.gui.overrideFailed = true;
                }
                return true;
            }
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150462_ai) && !Common.disableCraftingGui) {
                this.container.addContainer(player, Integer.valueOf(openStackId), (StackableContainer)new CraftingContainer(player));
                return true;
            }
        }
        return false;
    }

    public int getSlotCount() {
        if (this.entity == null) {
            return 0;
        }
        return this.entity.func_70302_i_();
    }

    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    public IInventory getInventory(EntityPlayer player) {
        return this.entity;
    }

    public int getRowSize() {
        return 9;
    }

    public void updateScreen() {
        if (this.isClient()) {
            this.gui.func_73876_c();
        }
    }

    private class TargetSlot
    extends StackableContainer.ContainerSlot {
        public TargetSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4) {
            super((StackableContainer)TransmutationChestContainer.this, player, inventory, par2, par3, par4);
            this.canEditInventory = UniqueItemData.get((World)player.field_70170_p).hasRequiredPermission(player, TransmutationChestContainer.this.chestId, 2);
        }
    }

    private class AmuletSlot
    extends StackableContainer.ContainerSlot {
        public AmuletSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4) {
            super((StackableContainer)TransmutationChestContainer.this, player, inventory, par2, par3, par4);
            this.canEditInventory = UniqueItemData.get((World)player.field_70170_p).hasRequiredPermission(player, TransmutationChestContainer.this.chestId, 2);
        }

        public boolean func_75214_a(ItemStack stack) {
            if (stack != null && !(stack.func_77973_b() instanceof AmuletOfTransmutation)) {
                return false;
            }
            if (stack != null && !UniqueItemData.get((World)this.player.field_70170_p).hasRequiredPermission(this.player, UniqueItem.getIdentifier((ItemStack)stack), 2)) {
                return false;
            }
            return super.func_75214_a(stack);
        }
    }
}

