/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange.gui;

import brad16840.balancedexchange.AmuletStack;
import brad16840.balancedexchange.BalancedExchange;
import brad16840.balancedexchange.PacketHandler;
import brad16840.balancedexchange.items.AmuletOfTransmutation;
import brad16840.common.ContainerStack;
import brad16840.common.MessageChannel;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.gui.BlockSelector;
import brad16840.common.gui.RadioButtonGroup;
import brad16840.common.gui.TitledImageButton;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MPBEditor
extends StackableContainer
implements BlockSelector.BlockSelectionListener {
    private static final ResourceLocation texture = new ResourceLocation("balancedexchange", "textures/gui/mpb_editor.png");
    @SideOnly(value=Side.CLIENT)
    private RadioButtonGroup consumableButton;
    @SideOnly(value=Side.CLIENT)
    private RadioButtonGroup learnableButton;
    @SideOnly(value=Side.CLIENT)
    private RadioButtonGroup dispensableButton;
    @SideOnly(value=Side.CLIENT)
    private YesNoButtonGroup consumableButtons;
    @SideOnly(value=Side.CLIENT)
    private YesNoButtonGroup learnableButtons;
    @SideOnly(value=Side.CLIENT)
    private YesNoButtonGroup dispensableButtons;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerTextField mpbCreated;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerTextField mpbConsumed;
    private String mpbCreatedText = "";
    private String mpbConsumedText = "";
    private String selectedId = null;
    private int selectedMetadata;
    @SideOnly(value=Side.CLIENT)
    private TitledImageButton saveButton;
    @SideOnly(value=Side.CLIENT)
    private TitledImageButton revertButton;
    private static HashMap<String, MPBState> mpbStates = new HashMap();

    public MPBEditor() {
        super(176, 122);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return;
        }
        this.consumableButtons = new YesNoButtonGroup();
        this.learnableButtons = new YesNoButtonGroup();
        this.dispensableButtons = new YesNoButtonGroup();
    }

    public boolean initContainer(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onChange() {
        int created;
        int consumed;
        MPBState state;
        boolean hasChanged;
        boolean canSave;
        block16: {
            AmuletOfTransmutation.MPBEntry entry;
            block15: {
                if (this.selectedId == null) {
                    if (this.revertButton != null) {
                        this.revertButton.field_146124_l = false;
                        this.saveButton.field_146124_l = false;
                    }
                    return;
                }
                String item = this.selectedId + ":" + this.selectedMetadata;
                entry = AmuletOfTransmutation.getMPBEntry(this.selectedId, this.selectedMetadata);
                if (!mpbStates.containsKey(item)) {
                    MPBState state2 = new MPBState();
                    state2.consumed = entry.consumed;
                    state2.created = entry.created;
                    state2.dispensable = AmuletOfTransmutation.dispensableItems.contains("item" + this.selectedId + "dam" + this.selectedMetadata);
                    mpbStates.put(item, state2);
                }
                canSave = true;
                hasChanged = false;
                state = mpbStates.get(item);
                consumed = 0;
                created = 0;
                try {
                    if (this.consumableButtons.yes && (consumed = Integer.parseInt(this.mpbConsumedText)) < 1) {
                        --consumed;
                    }
                    boolean bl = hasChanged = hasChanged || consumed != entry.consumed;
                    if (this.mpbConsumed != null) {
                        this.mpbConsumed.setTextColor(-1);
                    }
                }
                catch (NumberFormatException e) {
                    canSave = false;
                    if (this.mpbConsumed == null) break block15;
                    this.mpbConsumed.setTextColor(-2088928);
                }
            }
            try {
                if (this.learnableButtons.yes && (created = Integer.parseInt(this.mpbCreatedText)) < 1) {
                    --created;
                }
                boolean bl = hasChanged = hasChanged || created != entry.created;
                if (this.mpbCreated != null) {
                    this.mpbCreated.setTextColor(-1);
                }
            }
            catch (NumberFormatException e) {
                canSave = false;
                if (this.mpbCreated == null) break block16;
                this.mpbCreated.setTextColor(-2088928);
            }
        }
        boolean bl = hasChanged = hasChanged || this.dispensableButtons.yes != AmuletOfTransmutation.dispensableItems.contains("item" + this.selectedId + "dam" + this.selectedMetadata);
        if (hasChanged && canSave) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.OverrideMPBValue(this.selectedId, this.selectedMetadata, consumed, created, this.dispensableButtons.yes));
            if (this.revertButton != null) {
                this.revertButton.field_146124_l = true;
                this.saveButton.field_146124_l = true;
            }
        } else if (this.revertButton != null) {
            boolean p = consumed != state.consumed || created != state.created || this.dispensableButtons.yes != state.dispensable;
            this.saveButton.field_146124_l = p && canSave;
            this.revertButton.field_146124_l = !canSave || p;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateButtons() {
        if (!this.learnableButtons.yes) {
            this.dispensableButtons.yes = false;
            this.dispensableButtons.disabled = true;
        } else if (this.selectedMetadata == Short.MAX_VALUE) {
            this.dispensableButtons.disabled = true;
            this.dispensableButtons.yes = false;
        } else {
            this.dispensableButtons.disabled = false;
        }
        if (this.mpbCreated != null) {
            this.mpbCreated.disabled = !this.learnableButtons.yes;
            this.mpbCreated.setText(this.mpbCreatedText);
        }
        if (this.mpbConsumed != null) {
            this.mpbConsumed.disabled = !this.consumableButtons.yes;
            this.mpbConsumed.setText(this.mpbConsumedText);
        }
        if (this.saveButton != null) {
            boolean bl = this.saveButton.field_146124_l = this.selectedId != null;
        }
        if (this.revertButton != null) {
            this.revertButton.field_146124_l = this.selectedId != null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void selectionChanged(String id, int metadata) {
        if (id != null && id.equals(this.selectedId) && metadata == this.selectedMetadata) {
            return;
        }
        this.selectedId = id;
        this.selectedMetadata = metadata;
        this.consumableButtons.yes = AmuletOfTransmutation.getMPBEntry((String)this.selectedId, (int)this.selectedMetadata).consumed != 0;
        this.learnableButtons.yes = AmuletOfTransmutation.getMPBEntry((String)this.selectedId, (int)this.selectedMetadata).created != 0;
        this.dispensableButtons.yes = AmuletOfTransmutation.dispensableItems.contains("item" + this.selectedId + "dam" + this.selectedMetadata);
        if (this.selectedId == null) {
            this.dispensableButtons.disabled = true;
            this.learnableButtons.disabled = true;
            this.consumableButtons.disabled = true;
            this.dispensableButtons.yes = false;
            this.learnableButtons.yes = false;
            this.consumableButtons.yes = false;
        } else {
            this.dispensableButtons.disabled = false;
            this.learnableButtons.disabled = false;
            this.consumableButtons.disabled = false;
        }
        if (this.selectedMetadata == Short.MAX_VALUE) {
            this.dispensableButtons.disabled = true;
            this.dispensableButtons.yes = false;
        }
        AmuletOfTransmutation.MPBEntry entry = AmuletOfTransmutation.getMPBEntry(this.selectedId, this.selectedMetadata);
        this.mpbCreatedText = Integer.toString(entry.created < 0 ? entry.created + 1 : entry.created);
        this.mpbConsumedText = Integer.toString(entry.consumed < 0 ? entry.consumed + 1 : entry.consumed);
        this.updateButtons();
        this.onChange();
    }

    public void addCustomTabs(ArrayList<BlockSelector.CustomTab> list) {
    }

    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        this.consumableButton = new RadioButtonGroup(7, 16, 15, (RadioButtonGroup.RadioButtons)this.consumableButtons);
        this.learnableButton = new RadioButtonGroup(7, 62, 15, (RadioButtonGroup.RadioButtons)this.learnableButtons);
        this.dispensableButton = new RadioButtonGroup(94, 76, 15, (RadioButtonGroup.RadioButtons)this.dispensableButtons);
        this.saveButton = new TitledImageButton((StackableContainer)this, new Translatable("button.mpbeditor.save", new Object[0]).translate(), 1, 8, 96, 77, 18, texture, 0, this.guiHeight);
        this.revertButton = new TitledImageButton((StackableContainer)this, new Translatable("button.mpbeditor.revert", new Object[0]).translate(), 2, 91, 96, 77, 18, texture, 0, this.guiHeight);
        this.saveButton.callback = new ContainerStack.Callback(){

            public void call() {
                String item = MPBEditor.this.selectedId + ":" + MPBEditor.this.selectedMetadata;
                if (MPBEditor.this.selectedId == null || !mpbStates.containsKey(item)) {
                    return;
                }
                MPBState state = (MPBState)mpbStates.get(item);
                int consumed = 0;
                int created = 0;
                try {
                    if (((MPBEditor)MPBEditor.this).consumableButtons.yes && (consumed = Integer.parseInt(MPBEditor.this.mpbConsumedText)) < 1) {
                        --consumed;
                    }
                    if (((MPBEditor)MPBEditor.this).learnableButtons.yes && (created = Integer.parseInt(MPBEditor.this.mpbCreatedText)) < 1) {
                        --created;
                    }
                }
                catch (NumberFormatException e) {
                    return;
                }
                state.consumed = consumed;
                state.created = created;
                state.dispensable = ((MPBEditor)MPBEditor.this).dispensableButtons.yes;
                MPBEditor.this.updateButtons();
                MPBEditor.this.onChange();
            }
        };
        this.revertButton.callback = new ContainerStack.Callback(){

            public void call() {
                String item = MPBEditor.this.selectedId + ":" + MPBEditor.this.selectedMetadata;
                if (MPBEditor.this.selectedId == null || !mpbStates.containsKey(item)) {
                    return;
                }
                MPBState state = (MPBState)mpbStates.get(item);
                ((MPBEditor)MPBEditor.this).learnableButtons.yes = state.created != 0;
                ((MPBEditor)MPBEditor.this).consumableButtons.yes = state.consumed != 0;
                MPBEditor.this.mpbCreatedText = Integer.toString(state.created < 0 ? state.created + 1 : state.created);
                MPBEditor.this.mpbConsumedText = Integer.toString(state.consumed < 0 ? state.consumed + 1 : state.consumed);
                ((MPBEditor)MPBEditor.this).dispensableButtons.yes = ((MPBEditor)MPBEditor.this).learnableButtons.yes && state.dispensable;
                MPBEditor.this.updateButtons();
                MPBEditor.this.onChange();
            }
        };
        this.gui.addButton((StackableContainer.ContainerButton)this.saveButton);
        this.gui.addButton((StackableContainer.ContainerButton)this.revertButton);
        this.mpbConsumed = this.gui.addTextField((StackableContainer)this, 98, 20, 46, 9);
        this.mpbConsumed.rightClickClear = true;
        this.mpbConsumed.borderX = 3;
        this.mpbConsumed.borderY = 2;
        this.mpbConsumed.setText(this.mpbConsumedText);
        this.mpbCreated = this.gui.addTextField((StackableContainer)this, 98, 52, 46, 9);
        this.mpbCreated.rightClickClear = true;
        this.mpbCreated.borderX = 3;
        this.mpbCreated.borderY = 2;
        this.mpbCreated.setText(this.mpbCreatedText);
        this.updateButtons();
        this.onChange();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (this.mpbConsumed != null && this.mpbConsumed.keyPressed(key, keyCode)) {
            this.mpbConsumedText = this.mpbConsumed.getText();
            this.onChange();
            return true;
        }
        if (this.mpbCreated != null && this.mpbCreated.keyPressed(key, keyCode)) {
            this.mpbCreatedText = this.mpbCreated.getText();
            this.onChange();
            return true;
        }
        return false;
    }

    public int getSlotCount() {
        return 0;
    }

    public void onClosed(EntityPlayer player) {
    }

    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int mouseX, int mouseY) {
        this.consumableButton.drawForeground(mouseX, mouseY);
        this.learnableButton.drawForeground(mouseX, mouseY);
        this.dispensableButton.drawForeground(mouseX, mouseY);
        this.gui.text((StackableContainer)this, new Translatable("gui.mpbeditor.consumable", new Object[0]).translate()).truncateString(65).drawCenteredString(40, 8, -12566464);
        this.gui.text((StackableContainer)this, new Translatable("gui.mpbeditor.creatable", new Object[0]).translate()).truncateString(65).drawCenteredString(40, 54, -12566464);
        this.gui.text((StackableContainer)this, new Translatable("gui.mpbeditor.consumefor", new Object[0]).translate()).truncateString(82).drawCenteredString(130, 7, -12566464);
        this.gui.text((StackableContainer)this, new Translatable("gui.mpbeditor.createfor", new Object[0]).translate()).truncateString(82).drawCenteredString(130, 39, -12566464);
        this.gui.text((StackableContainer)this, new Translatable("gui.mpbeditor.dispensable", new Object[0]).translate()).truncateString(82).drawCenteredString(127, 68, -12566464);
        if (this.mpbConsumed.disabled) {
            this.gui.text((StackableContainer)this, new Translatable("gui.mpbeditor.inconsumable", new Object[0]).translate()).drawCenteredString(129, 20, -2744288);
        } else {
            this.gui.text((StackableContainer)this, new Translatable("gui.mpbeditor.mpb", new Object[0]).translate()).truncateString(25).drawString(149, 21, -12566464);
        }
        if (this.mpbCreated.disabled) {
            this.gui.text((StackableContainer)this, new Translatable("gui.mpbeditor.uncreatable", new Object[0]).translate()).drawCenteredString(129, 53, -2744288);
        } else {
            this.gui.text((StackableContainer)this, new Translatable("gui.mpbeditor.mpb", new Object[0]).translate()).truncateString(25).drawString(149, 53, -12566464);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture((StackableContainer)this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
        this.consumableButton.drawBackground(mouseX, mouseY);
        this.learnableButton.drawBackground(mouseX, mouseY);
        this.dispensableButton.drawBackground(mouseX, mouseY);
        if (this.mpbConsumed.disabled) {
            this.gui.drawRectangle((StackableContainer)this, 95, 17, 168, 32, -3552823);
        } else {
            this.mpbConsumed.drawBackground();
        }
        if (this.mpbCreated.disabled) {
            this.gui.drawRectangle((StackableContainer)this, 95, 49, 168, 64, -3552823);
        } else {
            this.mpbCreated.drawBackground();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void static_addItemStackTooltip(List list, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (AmuletOfTransmutation.getMPBEntry((ItemStack)itemStack).created == 0) {
            new Translatable("tooltip.mpb.uncreatable", new Object[0]).addTo(list);
        } else {
            new Translatable("tooltip.mpb.creatable", new Object[]{AmuletOfTransmutation.getMPBEntry((ItemStack)itemStack).created}).addTo(list);
        }
        if (!AmuletStack.canConsumeItemStack((EntityPlayer)player, itemStack)) {
            new Translatable("tooltip.mpb.inconsumable", new Object[0]).addTo(list);
        } else {
            new Translatable("tooltip.mpb.consumable", new Object[]{AmuletStack.getMPBConsumed((EntityPlayer)player, player.field_70170_p, itemStack)}).addTo(list);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        if (button == 0) {
            if (this.consumableButton.mouseDown(x, y)) {
                return true;
            }
            if (this.learnableButton.mouseDown(x, y)) {
                return true;
            }
            if (this.dispensableButton.mouseDown(x, y)) {
                return true;
            }
        }
        return false;
    }

    public String getId() {
        return "none";
    }

    public int getRowSize() {
        return 0;
    }

    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        return false;
    }

    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @SideOnly(value=Side.CLIENT)
    private class YesNoButtonGroup
    implements RadioButtonGroup.RadioButtons {
        public boolean yes = true;
        public boolean disabled = false;

        private YesNoButtonGroup() {
        }

        public int size() {
            return 2;
        }

        public int getButtonWidth(int i) {
            return 33;
        }

        public void drawButtonForeground(int button, int x, int y, int width, int height, int mx, int my) {
            int state;
            int n = button == 0 == this.yes ? 0 : (state = my > y && my < y + height && mx > x && mx < x + width ? 2 : 1);
            if (this.disabled) {
                state = button == 0 == this.yes ? 3 : 4;
            }
            int color = -11184811;
            if (state > 0) {
                color = -4210753;
            }
            if (state > 2) {
                color = -8355712;
            }
            MPBEditor.this.gui.text((StackableContainer)MPBEditor.this, new Translatable("button.mpbeditor." + (button == 0 ? "yes" : "no"), new Object[0]).translate()).truncateString(width).drawCenteredString(x + 2 - button + width / 2, y + 5, color);
        }

        public void drawButtonBackground(int button, int x, int y, int width, int height, int mx, int my) {
            int state;
            int n = button == 0 == this.yes ? 0 : (state = my > y && my < y + height && mx > x && mx < x + width ? 2 : 1);
            if (this.disabled) {
                state = button == 0 == this.yes ? 3 : 4;
            }
            MPBEditor.this.gui.bindTexture(texture);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            MPBEditor.this.gui.drawTexture((StackableContainer)MPBEditor.this, x + 1, y + 1, width, height, MPBEditor.this.guiWidth + button * width, state * height);
        }

        public void buttonClicked(int i) {
            if (this.disabled) {
                return;
            }
            this.yes = i == 0;
            MPBEditor.this.onChange();
            MPBEditor.this.updateButtons();
        }
    }

    private class MPBState {
        public int created;
        public int consumed;
        public boolean dispensable;

        private MPBState() {
        }
    }
}

