/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange.gui;

import brad16840.balancedexchange.AmuletStack;
import brad16840.balancedexchange.BalancedExchange;
import brad16840.balancedexchange.gui.AmuletContainer;
import brad16840.balancedexchange.items.AmuletOfTransmutation;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.MessageChannel;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.gui.EmptyRestorerView;
import brad16840.common.gui.ImageButton;
import brad16840.common.gui.RestorerContainer;
import brad16840.common.permissions.PacketHandler;
import brad16840.common.permissions.gui.ClientState;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class AmuletView
extends StackableContainer {
    @SideOnly(value=Side.CLIENT)
    private AmuletContainer.LearntInventory learntInventory;
    @SideOnly(value=Side.CLIENT)
    private ImageButton scrollUpButton;
    @SideOnly(value=Side.CLIENT)
    private ImageButton scrollDownButton;
    private boolean dragScrolling = false;
    private boolean scrollable = false;
    private int scrollOffset = 0;
    private UniqueItemInventory inventory;
    private String id;
    private boolean standalone;
    private int playerInventorySlot;
    private AmuletStack amulet;

    public AmuletView(EntityPlayer player, String id, int playerInventorySlot) {
        super(169, 113);
        this.id = id;
        this.playerInventorySlot = playerInventorySlot;
        this.idChain = new ArrayList();
    }

    private boolean closeContainer(EntityPlayer player) {
        if (this.container.stacks.length > 1 && this.container.getContainer(1) instanceof RestorerContainer) {
            boolean navigating;
            boolean bl = navigating = this.container.chainOrder.size() > 0 && this.container.chainOrder.get(this.container.chainOrder.size() - 1) != null;
            if (!navigating) {
                ((RestorerContainer)this.container.getContainer((int)1)).selectedStack = -1;
                this.container.replaceContainer(player, this.stackId, (StackableContainer)new EmptyRestorerView());
                this.container.reupdateContainers = true;
                return true;
            }
        }
        return false;
    }

    public boolean initContainer(EntityPlayer player) {
        if (this.isClient()) {
            Keyboard.enableRepeatEvents((boolean)true);
        }
        if (this.id == null) {
            return true;
        }
        this.amulet = AmuletStack.create(player, this.getId());
        if (this.amulet == null) {
            UniqueItemData.permissionError((String)"view", (Object)AmuletOfTransmutation.name).log(player);
            return this.closeContainer(player);
        }
        if (this.inventory == null) {
            this.inventory = UniqueItemInventory.createInventory((Item)BalancedExchange.amulet, (EntityPlayer)player, (String)this.id);
        }
        if (this.inventory == null) {
            new Translatable("problem.amuletgui404", new Object[0]).log(player);
            return this.closeContainer(player);
        }
        this.inventory.refreshInventory();
        for (int i = 0; i < 3; ++i) {
            this.addSlotToContainer(ContainerStack.ContainerSection.CHEST, new UpgradeSlot(player, (IInventory)this.inventory, i, 8 + i * 18, 10));
        }
        this.standalone = this.container.stacks.length < 2 || !(this.container.getContainer(1) instanceof RestorerContainer);
        if (this.guiHeight != 135 - (this.standalone ? 0 : 22)) {
            this.guiHeight = 135 - (this.standalone ? 0 : 22);
            this.container.reupdateContainers = true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (this.id == null || this.amulet == null && !this.refreshAmulet((EntityPlayer)player)) {
            return;
        }
        this.learntInventory = new AmuletContainer.LearntInventory((EntityPlayer)player, this.amulet);
        this.scrollUpButton = new ImageButton((StackableContainer)this, 2, 144, 29, 19, 18, AmuletContainer.texture, 176, 53);
        this.gui.addButton((StackableContainer.ContainerButton)this.scrollUpButton);
        this.scrollDownButton = new ImageButton((StackableContainer)this, 3, 144, 90, 19, 18, AmuletContainer.texture, 176, 71);
        this.gui.addButton((StackableContainer.ContainerButton)this.scrollDownButton);
        this.updateScrollButtons();
        final int cachedStackId = this.stackId;
        if (this.standalone) {
            this.gui.addButton(new StackableContainer.ContainerButton((StackableContainer)this, 0, 0, this.guiHeight - 20, this.guiWidth, 20, this.gui.getBackButtonText((StackableContainer)this), new ContainerStack.Callback(){

                public void call() {
                    AmuletView.this.gui.closeContainer(cachedStackId);
                }
            }, 68));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void actionPerformed(StackableContainer.ContainerButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.scrollUpButton.field_146127_k) {
                this.learntInventory.scroll(false, false);
            } else if (button.field_146127_k == this.scrollDownButton.field_146127_k) {
                this.learntInventory.scroll(true, false);
            } else {
                return;
            }
            this.updateScrollButtons();
            this.gui.func_73876_c();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (this.id == null) {
            this.gui.text((StackableContainer)this, new Translatable("gui.amuletview.noamulet", new Object[0]).translate()).truncateString(98).drawString(60, 8, -12566464, true);
            return;
        }
        if (this.amulet == null && !this.refreshAmulet((EntityPlayer)player)) {
            return;
        }
        int matter = this.amulet.getStoredMatter();
        this.gui.text((StackableContainer)this, new Translatable("gui.amulet.matter", new Object[]{matter}).translate()).truncateString(98).drawString(60, 8, -12566464, true);
        int xShift = this.container.getOffsetX((StackableContainer)this) - this.gui.getOffsetX((StackableContainer)this) - this.gui.getScrollX();
        int yShift = this.container.getOffsetY((StackableContainer)this) - this.gui.getOffsetY((StackableContainer)this) - this.gui.getScrollY();
        for (int yi = 0; yi < 4; ++yi) {
            for (int xi = 0; xi < 7; ++xi) {
                GL11.glEnable((int)2896);
                ItemStack stack = this.learntInventory.getStackAtIndex(yi * 7 + xi);
                this.gui.drawItemStack(stack, 10 + xi * 19 + this.container.getOffsetX((StackableContainer)this) - this.gui.getScrollX(), 32 + yi * 19 + this.container.getOffsetY((StackableContainer)this) - this.gui.getScrollY(), 100.0f, "");
                GL11.glDisable((int)2896);
                if (stack == null) continue;
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)3042);
                this.gui.bindTexture(AmuletContainer.texture);
                if (stack.field_77994_a < AmuletOfTransmutation.learnThreshold) {
                    for (int i = 0; i < (AmuletOfTransmutation.learnThreshold - stack.field_77994_a + 4) / 5; ++i) {
                        this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 1, 156, 250.0f);
                    }
                } else {
                    this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 22, 156, 240.0f);
                }
                GL11.glDisable((int)3042);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheel(int x, int y, int wheel) {
        if (x < 0 || x > this.guiWidth || y < 0 || y > this.guiHeight) {
            return false;
        }
        int oldScrollPos = this.learntInventory.scrollPos;
        if (wheel < 0) {
            this.learntInventory.scroll(true, false);
            this.updateScrollButtons();
        } else if (wheel > 0) {
            this.learntInventory.scroll(false, false);
            this.updateScrollButtons();
        }
        return oldScrollPos != this.learntInventory.scrollPos;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        int yPos;
        int barSize;
        if (this.id == null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.gui.bindTexture(AmuletContainer.texture);
            this.gui.drawTexture((StackableContainer)this, 0, 0, this.guiWidth, 109, 0, 0);
            this.gui.drawTexture((StackableContainer)this, 0, 109, this.guiWidth, 3, 0, 131);
            return;
        }
        if (this.amulet == null && !this.refreshAmulet((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(AmuletContainer.texture);
        this.gui.drawTexture((StackableContainer)this, 0, 0, this.guiWidth, 109, 0, 0);
        this.gui.drawTexture((StackableContainer)this, 0, 109, this.guiWidth, 4, 0, 130);
        int xShift = 0;
        int yShift = 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int yi = 0; yi < 4; ++yi) {
            for (int xi = 0; xi < 7; ++xi) {
                ItemStack stack = this.learntInventory.getStackAtIndex(yi * 7 + xi);
                if (stack == null) continue;
                if (x > 8 + xi * 19 && x < 27 + xi * 19 && y > 30 + yi * 19 && y < 49 + yi * 19) {
                    AmuletContainer.tooltipAmulet = this.amulet;
                    this.gui.customTooltipItem = stack;
                }
                if (stack.field_77994_a < AmuletOfTransmutation.learnThreshold) {
                    this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 1, 135, 50.0f);
                    continue;
                }
                this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 22, 135, 40.0f);
            }
        }
        int scrollbarSize = 41;
        float percent = 0.0f;
        if ((this.learntInventory.learntBlocks.size() + 6) / 7 != 4) {
            percent = (float)this.learntInventory.scrollPos / (float)((this.learntInventory.learntBlocks.size() + 6) / 7 - 4);
        }
        if ((barSize = 4 * scrollbarSize / ((this.learntInventory.learntBlocks.size() + 6) / 7)) < 7) {
            barSize = 7;
        }
        if (barSize > scrollbarSize) {
            barSize = scrollbarSize;
        }
        if ((yPos = (int)((float)(scrollbarSize - barSize) * percent)) + barSize > scrollbarSize) {
            yPos = scrollbarSize - barSize;
        }
        if (yPos < 0) {
            yPos = 0;
        }
        int state = 1;
        if (this.dragScrolling || x > 143 && x < 163 && y >= (yPos += 48) && y < yPos + barSize) {
            state = 2;
        }
        if (!this.scrollable) {
            state = 0;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.drawTexture((StackableContainer)this, 144, yPos, 19, barSize - 3, 176 + 19 * state, 0);
        this.gui.drawTexture((StackableContainer)this, 144, yPos + barSize - 3, 19, 3, 176 + 19 * state, 50);
    }

    @SideOnly(value=Side.CLIENT)
    public void static_addItemStackTooltip(List list, ItemStack itemStack) {
        AmuletContainer.addMPBTooltip(list, itemStack);
    }

    public void updateScrollButtons() {
        if (this.isClient()) {
            this.scrollUpButton.field_146124_l = this.learntInventory.canScrollUp();
            this.scrollDownButton.field_146124_l = this.learntInventory.canScrollDown();
            this.scrollable = this.learntInventory.canScroll();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        Minecraft mc = Minecraft.func_71410_x();
        if (keyCode == Common.permissionKey.func_151463_i()) {
            String id = this.getId();
            Common.channel.sendToServer((MessageChannel.Message)new PacketHandler.OpenGroup(0, new ClientState.PermissionGroupState(id, "I_" + id, 0, true), true));
            return true;
        }
        if (keyCode == 203) {
            keyCode = mc.field_71474_y.field_74370_x.func_151463_i();
        } else if (keyCode == 205) {
            keyCode = mc.field_71474_y.field_74366_z.func_151463_i();
        } else if (keyCode == 200) {
            keyCode = mc.field_71474_y.field_74351_w.func_151463_i();
        } else if (keyCode == 208) {
            keyCode = mc.field_71474_y.field_74368_y.func_151463_i();
        }
        if (keyCode == mc.field_71474_y.field_74370_x.func_151463_i() || keyCode == mc.field_71474_y.field_74351_w.func_151463_i()) {
            int oldScrollPos = this.learntInventory.scrollPos;
            this.learntInventory.scroll(false, keyCode == mc.field_71474_y.field_74370_x.func_151463_i());
            if (this.gui != null) {
                this.updateScrollButtons();
                this.gui.func_73876_c();
            }
            return oldScrollPos != this.learntInventory.scrollPos;
        }
        if (keyCode == mc.field_71474_y.field_74366_z.func_151463_i() || keyCode == mc.field_71474_y.field_74368_y.func_151463_i()) {
            int oldScrollPos = this.learntInventory.scrollPos;
            this.learntInventory.scroll(true, keyCode == mc.field_71474_y.field_74366_z.func_151463_i());
            if (this.gui != null) {
                this.updateScrollButtons();
                this.gui.func_73876_c();
            }
            return oldScrollPos != this.learntInventory.scrollPos;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean refreshAmulet(EntityPlayer player) {
        this.amulet = AmuletStack.create(player, this.getId());
        if (this.amulet == null) {
            UniqueItemData.permissionError((String)"view", (Object)AmuletOfTransmutation.name).log(player);
            this.gui.closeContainer(this.stackId);
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        ItemStack stack;
        boolean clicked;
        boolean bl = clicked = button == 0 || button == 1 || button == Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151463_i() + 100;
        if (clicked && y >= 9 && y < 27 && x >= 7 && x < 61 && (stack = this.inventory.func_70301_a((x - 7) / 18)) != null && stack.func_77973_b() instanceof UniqueItem.ViewableItem) {
            String uuid = UniqueItem.getIdentifier((ItemStack)stack);
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            UniqueItemData data = UniqueItemData.get((World)player.field_70170_p);
            if (!data.isSubscribed(uuid) || data.getItemData((EntityPlayer)player, uuid) == null) {
                UniqueItemData.permissionError((String)"view", (Object)UniqueItemData.genericItem).log((EntityPlayer)player);
                return true;
            }
            RestorerContainer.createView((EntityPlayer)player, (String)((UniqueItem.ContainerItem)stack.func_77973_b()).getContainerItemType(), (String)uuid, (boolean)false, (boolean)false, (boolean)true, (int)this.playerInventorySlot);
            return true;
        }
        if (x > 143 && x < 163 && y > 47 && y < 89) {
            int yPos;
            int barSize;
            int scrollbarSize = 41;
            float percent = 0.0f;
            if ((this.learntInventory.learntBlocks.size() + 6) / 7 != 4) {
                percent = (float)this.learntInventory.scrollPos / (float)((this.learntInventory.learntBlocks.size() + 6) / 7 - 4);
            }
            if ((barSize = 4 * scrollbarSize / ((this.learntInventory.learntBlocks.size() + 6) / 7)) < 7) {
                barSize = 7;
            }
            if (barSize > scrollbarSize) {
                barSize = scrollbarSize;
            }
            if ((yPos = (int)((float)(scrollbarSize - barSize) * percent)) + barSize > scrollbarSize) {
                yPos = scrollbarSize - barSize;
            }
            if (yPos < 0) {
                yPos = 0;
            }
            if (y >= (yPos += 48) && y < yPos + barSize) {
                if ((this.learntInventory.learntBlocks.size() + 6) / 7 <= 4) {
                    return false;
                }
                this.dragScrolling = true;
                this.scrollOffset = y - yPos;
                if (this.gui != null) {
                    this.gui.func_73876_c();
                }
                return true;
            }
            if (y < yPos) {
                this.learntInventory.scroll(false, true);
                if (this.gui != null) {
                    this.updateScrollButtons();
                    this.gui.func_73876_c();
                }
            } else {
                this.learntInventory.scroll(true, true);
                if (this.gui != null) {
                    this.updateScrollButtons();
                    this.gui.func_73876_c();
                }
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int x, int y, int button) {
        if (this.dragScrolling) {
            int scrollbarSize = 41;
            int barSize = 4 * scrollbarSize / ((this.learntInventory.learntBlocks.size() + 6) / 7);
            if (barSize < 7) {
                barSize = 7;
            }
            if (barSize > scrollbarSize) {
                barSize = scrollbarSize;
            }
            if (barSize != scrollbarSize) {
                this.learntInventory.setScrollPercent((float)(y - this.scrollOffset - 48) / (float)(scrollbarSize - barSize));
            } else {
                this.learntInventory.setScrollPercent(0.0f);
            }
            if (this.gui != null) {
                this.updateScrollButtons();
                this.gui.func_73876_c();
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseUp(int x, int y, int button) {
        if (this.dragScrolling) {
            this.dragScrolling = false;
            if (this.gui != null) {
                this.gui.func_73876_c();
            }
            return true;
        }
        return false;
    }

    public boolean customRightClick(EntityPlayer player, int slot, boolean holdingShift) {
        return false;
    }

    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        return null;
    }

    public void onClosed(EntityPlayer player) {
        if (this.isClient()) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    public void updateScreen() {
        if (this.isClient()) {
            this.gui.func_73876_c();
        }
    }

    public int getSlotCount() {
        return this.id == null ? 0 : 3;
    }

    public String getId() {
        return this.id;
    }

    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        for (StackableContainer container1 : containers) {
            if (((AmuletView)container1).inventory == null) continue;
            ((AmuletView)container1).inventory.refreshInventory();
        }
        return true;
    }

    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    public int getRowSize() {
        return this.id == null ? 0 : 3;
    }

    private class UpgradeSlot
    extends StackableContainer.ContainerSlot {
        public UpgradeSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4) {
            super((StackableContainer)AmuletView.this, player, inventory, par2, par3, par4);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public boolean func_82869_a(EntityPlayer player) {
            return false;
        }
    }
}

