/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange.gui;

import brad16840.balancedexchange.AmuletStack;
import brad16840.balancedexchange.BalancedExchange;
import brad16840.balancedexchange.ClientProxy;
import brad16840.balancedexchange.PacketHandler;
import brad16840.balancedexchange.Transmutation;
import brad16840.balancedexchange.blocks.BlockOfReactivity;
import brad16840.balancedexchange.items.AmuletOfTransmutation;
import brad16840.common.BlockPos;
import brad16840.common.Common;
import brad16840.common.ContainerStackGui;
import brad16840.common.MessageChannel;
import brad16840.common.PacketHandler;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AmuletGuiOverlay
extends Gui {
    private Minecraft mc;
    protected static final RenderItem itemRenderer = new RenderItem();
    public static int modeChangeTimer = 0;
    public static boolean modeChangeLeft = false;
    private static final String c = "gui.amuletoverlay.mode.";
    private static final String[] modetypes = new String[]{"chain", "area", "fill", "confined", "conversion", "survey"};
    private static boolean isSwitchingBlock = false;
    private static boolean isSwitchingMode = false;
    private static ArrayList<ItemStack> quickList;
    private static int leftIndex;
    private static int rightIndex;
    private static int amountChanged;
    private static ArrayList<Integer> leftModeList;
    private static ArrayList<Integer> rightModeList;
    private static int ticksHeld;
    private static boolean hasHeldUnshifted;
    private RenderBlocks renderBlocks;
    private static IIcon[] transmutationStages;
    private static IIcon[] reactivityTransmutationStages;
    private static final int[] xOffsets;
    private static final int[] yOffsets;

    public AmuletGuiOverlay(Minecraft mc) {
        this.mc = mc;
    }

    private static boolean startSwitchingBlock() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return false;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        ItemStack stack = player.func_71045_bC();
        if (stack == null || !(stack.func_77973_b() instanceof AmuletOfTransmutation)) {
            return false;
        }
        AmuletStack amulet = AmuletStack.create((EntityPlayer)player, UniqueItem.getIdentifier((ItemStack)stack));
        if (amulet == null) {
            return false;
        }
        amountChanged = 0;
        quickList = amulet.getQuickList();
        ItemStack left = amulet.getActiveItem(true);
        ItemStack right = amulet.getActiveItem(false);
        rightIndex = leftIndex = AmuletGuiOverlay.addToQuickList(left);
        if (AmuletOfTransmutation.valueOrder.compare(left, right) != 0) {
            rightIndex = AmuletGuiOverlay.addToQuickList(right);
        }
        if (quickList.size() < 2) {
            return false;
        }
        isSwitchingBlock = true;
        return true;
    }

    private static boolean startSwitchingMode() {
        int i;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return false;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        ItemStack stack = player.func_71045_bC();
        if (stack == null || !(stack.func_77973_b() instanceof AmuletOfTransmutation)) {
            return false;
        }
        AmuletStack amulet = AmuletStack.create((EntityPlayer)player, UniqueItem.getIdentifier((ItemStack)stack));
        if (amulet == null) {
            return false;
        }
        amountChanged = 0;
        leftModeList.clear();
        rightModeList.clear();
        rightIndex = 0;
        leftIndex = 0;
        String uuid = amulet.getIdentifier();
        UniqueItemInventory inventory = UniqueItemInventory.createInventory((Item)BalancedExchange.amulet, (EntityPlayer)player, (String)uuid);
        int mode = amulet.getMode(true);
        for (i = 0; i <= 6; ++i) {
            if (!amulet.isValidMode(inventory, uuid, i, true)) continue;
            if (i == mode) {
                leftIndex = leftModeList.size();
            }
            leftModeList.add(i);
        }
        mode = amulet.getMode(false);
        for (i = 0; i <= 6; ++i) {
            if (!amulet.isValidMode(inventory, uuid, i, false)) continue;
            if (i == mode) {
                rightIndex = rightModeList.size();
            }
            rightModeList.add(i);
        }
        ((ClientProxy.ModeKeyHandler)BalancedExchange.modeKeyHandler).beingHeld = false;
        isSwitchingMode = true;
        return true;
    }

    private static int addToQuickList(ItemStack stack) {
        for (int i = 0; i < quickList.size(); ++i) {
            int cmp = AmuletOfTransmutation.valueOrder.compare(quickList.get(i), stack);
            if (cmp < 0) continue;
            if (cmp > 0) {
                quickList.add(i, stack);
                return i;
            }
            return i;
        }
        quickList.add(stack);
        return quickList.size() - 1;
    }

    private ItemStack getQuickItem(int index) {
        if (quickList == null || quickList.size() == 0) {
            return AmuletOfTransmutation.defaultItem;
        }
        index += amountChanged;
        while (index >= quickList.size()) {
            index -= quickList.size();
        }
        while (index < 0) {
            index += quickList.size();
        }
        return quickList.get(index);
    }

    private int getMode(boolean left) {
        int index = left ? leftIndex : rightIndex;
        index -= amountChanged;
        int amount = (left ? leftModeList : rightModeList).size();
        while (index >= amount) {
            index -= amount;
        }
        while (index < 0) {
            index += amount;
        }
        return (left ? leftModeList : rightModeList).get(index);
    }

    public static void registerIcons(IIconRegister iconRegister) {
        int i;
        transmutationStages = new IIcon[8];
        reactivityTransmutationStages = new IIcon[6];
        for (i = 0; i < transmutationStages.length; ++i) {
            AmuletGuiOverlay.transmutationStages[i] = iconRegister.func_94245_a("balancedexchange:transmute_stage_" + (i + 1));
        }
        for (i = 0; i < reactivityTransmutationStages.length; ++i) {
            AmuletGuiOverlay.reactivityTransmutationStages[i] = iconRegister.func_94245_a("balancedexchange:transmute_reactivity_stage_" + (i + 1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public void render(DrawBlockHighlightEvent event) {
        if (event.currentItem != null && event.currentItem.func_77973_b() instanceof AmuletOfTransmutation) {
            Minecraft mc = Minecraft.func_71410_x();
            if (this.renderBlocks == null) {
                this.renderBlocks = new RenderBlocks((IBlockAccess)mc.field_71441_e);
            }
            EntityPlayer player = event.player;
            double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.partialTicks;
            double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.partialTicks;
            double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.partialTicks;
            Transmutation t = AmuletOfTransmutation.currentTransmutation;
            if (!mc.func_147113_T()) {
                AmuletOfTransmutation.canAmass = true;
            }
            if ((t = AmuletOfTransmutation.currentTransmutation) != null && t.pos != null && t.result != null && t.type != 1) {
                AmuletStack amulet = t.state != null ? t.state.amulet : AmuletStack.create(player, UniqueItem.getIdentifier((ItemStack)player.func_70694_bm()));
                Block activeBlock = Block.func_149634_a((Item)amulet.getActiveItem(t.isLeftClick).func_77973_b());
                IIcon[] icons = transmutationStages;
                if (activeBlock instanceof BlockOfReactivity && t.type != 3) {
                    icons = reactivityTransmutationStages;
                }
                if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    for (BlockPos blockPos : t.result.blocks) {
                        Block showBlock;
                        void var15_20;
                        GL11.glEnable((int)3042);
                        if (blockPos == null) {
                            BlockPos blockPos2 = t.pos;
                        }
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                        GL11.glPushMatrix();
                        GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
                        GL11.glEnable((int)32823);
                        GL11.glEnable((int)3008);
                        Tessellator par1Tessellator = Tessellator.field_78398_a;
                        par1Tessellator.func_78382_b();
                        par1Tessellator.func_78373_b(-playerX, -playerY, -playerZ);
                        Minecraft.func_71410_x().field_71460_t.func_78463_b(0.0);
                        double d3 = (double)var15_20.x - playerX;
                        double d4 = (double)var15_20.y - playerY;
                        double d5 = (double)var15_20.z - playerZ;
                        int stage = (t.chargeAmassed - 1) * icons.length / t.chargeRequired;
                        if (stage >= icons.length) {
                            stage = icons.length - 1;
                        }
                        if (stage < 0) {
                            stage = 0;
                        }
                        Block block = event.player.field_70170_p.func_147439_a(var15_20.x, var15_20.y, var15_20.z);
                        Block block2 = showBlock = stage < 4 || activeBlock instanceof BlockOfReactivity ? block : activeBlock;
                        if (t.type == 3) {
                            showBlock = block;
                            if (stage > 3) {
                                stage = icons.length - stage - 1;
                            }
                        }
                        if (d3 * d3 + d4 * d4 + d5 * d5 <= 1024.0) {
                            if (block instanceof BlockOfReactivity && (activeBlock instanceof BlockOfReactivity || !AmuletOfTransmutation.reactivityBlocksCanBeTransmuted)) {
                                this.renderBlocks.func_147792_a(Blocks.field_150346_d, var15_20.x, var15_20.y, var15_20.z, icons[5 - Math.max(5, stage)]);
                            } else if (showBlock.func_149688_o() != Material.field_151579_a) {
                                this.renderBlocks.func_147805_b(showBlock, var15_20.x, var15_20.y, var15_20.z);
                                par1Tessellator.func_78370_a(255, 255, 255, 255);
                                par1Tessellator.func_78383_c();
                                this.renderBlocks.func_147792_a(showBlock, var15_20.x, var15_20.y, var15_20.z, icons[stage]);
                            } else {
                                this.renderBlocks.func_147792_a(Blocks.field_150346_d, var15_20.x, var15_20.y, var15_20.z, icons[stage]);
                            }
                        }
                        par1Tessellator.func_78381_a();
                        par1Tessellator.func_78373_b(0.0, 0.0, 0.0);
                        GL11.glDisable((int)3008);
                        GL11.glPolygonOffset((float)0.0f, (float)0.0f);
                        GL11.glDisable((int)32823);
                        GL11.glEnable((int)3008);
                        GL11.glDepthMask((boolean)true);
                        GL11.glPopMatrix();
                    }
                }
            } else if (t != null && t.type == 2 && t.pos != null) {
                IIcon[] icons = reactivityTransmutationStages;
                BlockPos pos = t.pos;
                OpenGlHelper.func_148821_a((int)774, (int)768, (int)1, (int)0);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GL11.glPushMatrix();
                GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
                GL11.glEnable((int)32823);
                GL11.glEnable((int)3008);
                Tessellator par1Tessellator = Tessellator.field_78398_a;
                par1Tessellator.func_78382_b();
                par1Tessellator.func_78373_b(-playerX, -playerY, -playerZ);
                Minecraft.func_71410_x().field_71460_t.func_78463_b(0.0);
                double d3 = (double)pos.x - playerX;
                double d4 = (double)pos.y - playerY;
                double d5 = (double)pos.z - playerZ;
                int stage = (t.chargeAmassed - 1) * icons.length / t.chargeRequired;
                if (stage >= icons.length) {
                    stage = icons.length - 1;
                }
                if (stage < 0) {
                    stage = 0;
                }
                if (d3 * d3 + d4 * d4 + d5 * d5 <= 1024.0) {
                    this.renderBlocks.func_147792_a(Blocks.field_150359_w, pos.x, pos.y, pos.z, icons[5 - Math.min(5, stage)]);
                }
                par1Tessellator.func_78381_a();
                par1Tessellator.func_78373_b(0.0, 0.0, 0.0);
                GL11.glDisable((int)3008);
                GL11.glPolygonOffset((float)0.0f, (float)0.0f);
                GL11.glDisable((int)32823);
                GL11.glEnable((int)3008);
                GL11.glDepthMask((boolean)true);
                GL11.glPopMatrix();
            } else {
                EntityPlayer par1EntityPlayer = event.player;
                float par4 = event.partialTicks;
                if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    GL11.glLineWidth((float)2.0f);
                    GL11.glDisable((int)3553);
                    GL11.glDepthMask((boolean)false);
                    float f1 = 0.002f;
                    Block block = event.player.field_70170_p.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
                    double d = par1EntityPlayer.field_70142_S + (par1EntityPlayer.field_70165_t - par1EntityPlayer.field_70142_S) * (double)par4;
                    double d1 = par1EntityPlayer.field_70137_T + (par1EntityPlayer.field_70163_u - par1EntityPlayer.field_70137_T) * (double)par4;
                    double d2 = par1EntityPlayer.field_70136_U + (par1EntityPlayer.field_70161_v - par1EntityPlayer.field_70136_U) * (double)par4;
                    RenderGlobal.func_147590_a((AxisAlignedBB)block.func_149633_g(par1EntityPlayer.field_70170_p, event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d).func_72314_b((double)f1, (double)f1, (double)f1).func_72325_c(-d, -d1, -d2), (int)-1);
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)3553);
                    GL11.glDisable((int)3042);
                }
            }
        }
    }

    private void setBlock(boolean left) {
        AmuletStack stack = AmuletStack.create((EntityPlayer)this.mc.field_71439_g, UniqueItem.getIdentifier((ItemStack)this.mc.field_71439_g.func_71045_bC()));
        if (stack == null) {
            return;
        }
        boolean dualTransmutations = AmuletStack.isDualMode((EntityPlayer)this.mc.field_71439_g, stack.getIdentifier());
        boolean bl = left = left && dualTransmutations;
        if (stack.getMode(left) == 6) {
            stack.setSurveyMode(stack.getSurveyMode() - amountChanged, true);
            return;
        }
        stack.setActiveItemStack(this.getQuickItem(left ? leftIndex : rightIndex), true, left);
        ticksHeld = 0;
    }

    private void setMode(boolean left) {
        AmuletStack stack = AmuletStack.create((EntityPlayer)this.mc.field_71439_g, UniqueItem.getIdentifier((ItemStack)this.mc.field_71439_g.func_71045_bC()));
        if (stack == null) {
            return;
        }
        boolean dualTransmutations = AmuletStack.isDualMode((EntityPlayer)this.mc.field_71439_g, stack.getIdentifier());
        left = left && dualTransmutations;
        int mode = this.getMode(left);
        stack.setMode(left, mode);
        BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.ModeChange(stack.getIdentifier(), left, mode));
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        if (this.mc == null || this.mc.field_71439_g == null || this.mc.field_71462_r != null || ticksHeld < BalancedExchange.amuletScrollDelay || !hasHeldUnshifted) {
            return;
        }
        ItemStack currentItem = this.mc.field_71439_g.func_71045_bC();
        if (currentItem == null || !(currentItem.func_77973_b() instanceof AmuletOfTransmutation)) {
            isSwitchingMode = false;
            isSwitchingBlock = false;
            return;
        }
        if (isSwitchingMode && event.buttonstate) {
            if (event.button == 1) {
                this.setMode(false);
            } else if (event.button == 0) {
                this.setMode(true);
            }
            isSwitchingMode = false;
            isSwitchingBlock = false;
            event.setCanceled(true);
            return;
        }
        if (isSwitchingBlock && event.buttonstate) {
            if (event.button == 1) {
                this.setBlock(false);
            } else if (event.button == 0) {
                this.setBlock(true);
            }
            isSwitchingBlock = false;
            isSwitchingMode = false;
            event.setCanceled(true);
            return;
        }
        if (event.dwheel != 0) {
            if (isSwitchingMode || isSwitchingBlock && quickList.size() > 1) {
                amountChanged += event.dwheel > 0 != BalancedExchange.invertAmuletScrollDirection ? -1 : 1;
                event.setCanceled(true);
            } else {
                if (BalancedExchange.modeKeyHandler.keyBinding.func_151470_d()) {
                    AmuletGuiOverlay.startSwitchingMode();
                    amountChanged += event.dwheel > 0 != BalancedExchange.invertAmuletScrollDirection ? -1 : 1;
                    event.setCanceled(true);
                    return;
                }
                if (AmuletGuiOverlay.isKeyDown()) {
                    AmuletGuiOverlay.startSwitchingBlock();
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderHotBar(RenderGameOverlayEvent event) {
        if (event.isCancelable() && !BalancedExchange.dualHotbarSupport || event.type != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        ++ticksHeld;
        if (this.mc.field_71462_r != null && !(this.mc.field_71462_r instanceof ContainerStackGui)) {
            ticksHeld = 0;
            hasHeldUnshifted = false;
            return;
        }
        if (modeChangeTimer > 0) {
            --modeChangeTimer;
        }
        World world = this.mc.field_71439_g.field_70170_p;
        ItemStack currentItem = this.mc.field_71439_g.func_71045_bC();
        if (currentItem != null && currentItem.func_77973_b() == BalancedExchange.amulet) {
            int recharge;
            UniqueItemData data;
            String uuid = UniqueItem.getIdentifier((ItemStack)currentItem);
            if (uuid.equals("none")) {
                return;
            }
            if (!hasHeldUnshifted && !AmuletGuiOverlay.isKeyDown()) {
                hasHeldUnshifted = true;
            }
            if (!(data = UniqueItemData.get((World)world)).isSubscribed(uuid)) {
                Common.channel.sendToServer((MessageChannel.Message)new PacketHandler.SubscribeToItem(uuid));
                return;
            }
            int width = event.resolution.func_78326_a();
            int height = event.resolution.func_78328_b();
            int x = width / 2 + 5;
            int y = height / 2 + 5;
            AmuletStack stack = AmuletStack.create((EntityPlayer)this.mc.field_71439_g, uuid);
            if (stack == null) {
                return;
            }
            ItemStack active = stack.getActiveItem(true);
            active.field_77994_a = 1;
            int mode = stack.getMode(true);
            boolean dualTransmutations = AmuletStack.isDualMode((EntityPlayer)this.mc.field_71439_g, uuid);
            if (isSwitchingBlock && !AmuletGuiOverlay.isKeyDown()) {
                this.setBlock(false);
                isSwitchingBlock = false;
            }
            if (isSwitchingMode) {
                mode = this.getMode(true);
                if (!BalancedExchange.modeKeyHandler.keyBinding.func_151470_d()) {
                    this.setMode(false);
                    isSwitchingMode = false;
                }
            }
            if (dualTransmutations) {
                y -= 13;
                new Text(this.getModeString(stack, uuid, mode, true).translate(), this.mc.field_71466_p).setShadow(true).drawString(mode == 6 ? 3 : 19, height - 12 - BalancedExchange.screenOffset, 0xFFFFFF);
                if (mode != 6) {
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)32826);
                    RenderHelper.func_74520_c();
                    if (isSwitchingBlock) {
                        for (int i = 0; i < 7; ++i) {
                            ItemStack item = this.getQuickItem(leftIndex + i - 3).func_77946_l();
                            item.field_77994_a = 1;
                            itemRenderer.func_82406_b(this.mc.field_71466_p, this.mc.field_71446_o, item, x - xOffsets[i] - 28, y - yOffsets[6 - i]);
                            itemRenderer.func_77021_b(this.mc.field_71466_p, this.mc.field_71446_o, item, x - xOffsets[i] - 28, y - yOffsets[6 - i]);
                        }
                    }
                    itemRenderer.func_82406_b(this.mc.field_71466_p, this.mc.field_71446_o, active, 2, height - 18 - BalancedExchange.screenOffset);
                    itemRenderer.func_77021_b(this.mc.field_71466_p, this.mc.field_71446_o, active, 2, height - 18 - BalancedExchange.screenOffset);
                    RenderHelper.func_74518_a();
                    GL11.glDisable((int)32826);
                    if (isSwitchingBlock) {
                        new Text(this.getQuickItem(leftIndex).func_82833_r(), this.mc.field_71466_p).truncateString(180).setShadow(true).drawString(x - xOffsets[3] - 29 - 180, y + 5 - yOffsets[3], 0xFFFFFF, true);
                    }
                }
            }
            active = stack.getActiveItem(false);
            active.field_77994_a = 1;
            mode = stack.getMode(false);
            int matter = stack.getStoredMatter();
            Transmutation t = AmuletOfTransmutation.currentTransmutation;
            if (t != null) {
                matter += t.matterGain * t.chargeAmassed / t.chargeRequired;
            }
            if (isSwitchingMode) {
                mode = this.getMode(false);
                if (!BalancedExchange.modeKeyHandler.keyBinding.func_151470_d()) {
                    this.setMode(false);
                    isSwitchingMode = false;
                }
            }
            int px = width - 18;
            int py = height - 18;
            if (!dualTransmutations) {
                px = x;
                py = y;
                new Text(this.getModeString(stack, uuid, mode, false).translate(), this.mc.field_71466_p).setShadow(true).drawString(3, height - 20 - BalancedExchange.screenOffset, 0xFFFFFF);
                new Text(new Translatable("gui.amuletoverlay.matter", new Object[]{matter}).translate(), this.mc.field_71466_p).setShadow(true).drawString(3, height - 10 - BalancedExchange.screenOffset, 0xFFFFFF);
            } else {
                new Text(this.getModeString(stack, uuid, mode, false).translate(), this.mc.field_71466_p).setShadow(true).drawString(width - (mode == 6 ? 3 : 19), height - 12 - BalancedExchange.screenOffset, 0xFFFFFF, true);
                new Text(new Translatable("gui.amuletoverlay.matter", new Object[]{matter}).translate(), this.mc.field_71466_p).setShadow(true).drawString(width - 3, 3, 0xFFFFFF, true);
            }
            if (mode != 6) {
                GL11.glDisable((int)3042);
                GL11.glEnable((int)32826);
                RenderHelper.func_74520_c();
                if (isSwitchingBlock) {
                    for (int i = 0; i < 7; ++i) {
                        ItemStack item = this.getQuickItem(rightIndex + i - 3).func_77946_l();
                        item.field_77994_a = 1;
                        itemRenderer.func_82406_b(this.mc.field_71466_p, this.mc.field_71446_o, item, x + xOffsets[i], y + yOffsets[i]);
                        itemRenderer.func_77021_b(this.mc.field_71466_p, this.mc.field_71446_o, item, x + xOffsets[i], y + yOffsets[i]);
                    }
                }
                if (!isSwitchingBlock || dualTransmutations) {
                    itemRenderer.func_82406_b(this.mc.field_71466_p, this.mc.field_71446_o, active, px, py - (dualTransmutations ? BalancedExchange.screenOffset : 0));
                    itemRenderer.func_77021_b(this.mc.field_71466_p, this.mc.field_71446_o, active, px, py - (dualTransmutations ? BalancedExchange.screenOffset : 0));
                }
                RenderHelper.func_74518_a();
                GL11.glDisable((int)32826);
                if (isSwitchingBlock) {
                    new Text(this.getQuickItem(rightIndex).func_82833_r(), this.mc.field_71466_p).truncateString(180).setShadow(true).drawString(x + xOffsets[3] + 18, y + 5 + yOffsets[3], 0xFFFFFF);
                }
            }
            if ((recharge = stack.getRechargeTime()) > 0) {
                this.func_73731_b(this.mc.field_71466_p, new Translatable("gui.amuletoverlay.recharge", new Object[]{Float.valueOf((float)recharge / 20.0f)}).translate(), x, y + 18, 0xFFFFFF);
            }
        } else {
            ticksHeld = 0;
            hasHeldUnshifted = false;
            isSwitchingBlock = false;
            isSwitchingMode = false;
        }
    }

    private static boolean isKeyDown() {
        return Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151470_d();
    }

    public Translatable getModeString(AmuletStack stack, String uuid, int mode, boolean left) {
        Translatable modeString = new Translatable("gui.amuletoverlay.mode.block", new Object[0]);
        if (this.mc.field_71439_g.func_70093_af() && (modeChangeTimer < 1 || modeChangeLeft != left) && mode != 3 && mode != 6) {
            modeString.unlocalized = "gui.amuletoverlay.mode.air";
        } else if (mode != 0) {
            modeString.unlocalized = c + modetypes[mode - 1];
            if (mode == 2 || mode == 3 || mode == 4 || mode == 5) {
                modeString.args = new Object[]{stack.getAreaOfEffectString((EntityPlayer)this.mc.field_71439_g, uuid, left)};
            } else if (mode == 6) {
                int surveyMode = stack.getSurveyMode();
                if (isSwitchingBlock) {
                    surveyMode -= amountChanged;
                }
                modeString.args = new Object[]{stack.getSurveyAreaString((EntityPlayer)this.mc.field_71439_g, surveyMode)};
            }
        }
        if (mode == 0) {
            boolean buildMode;
            ItemStack s = AmuletStack.getUpgrade((EntityPlayer)this.mc.field_71439_g, uuid, AmuletStack.filter_productivityUpgrade, left);
            boolean bl = buildMode = s != null && s.func_77960_j() != 0;
            if (buildMode) {
                modeString.unlocalized = this.mc.field_71439_g.func_70093_af() && modeChangeTimer < 1 ? "gui.amuletoverlay.mode.transmute" : "gui.amuletoverlay.mode.build";
            }
        }
        return modeString;
    }

    static {
        amountChanged = 0;
        leftModeList = new ArrayList();
        rightModeList = new ArrayList();
        ticksHeld = 0;
        hasHeldUnshifted = false;
        xOffsets = new int[]{14, 9, 4, 0, 4, 9, 14};
        yOffsets = new int[]{-54, -36, -18, 0, 18, 36, 54};
    }

    public class Text {
        public int width;
        public String text;
        private FontRenderer fontRenderer;
        private boolean shadow = false;

        public Text(String text, FontRenderer fontRenderer) {
            this.text = text;
            this.width = 0;
            this.fontRenderer = fontRenderer;
        }

        public Text setShadow(boolean shadow) {
            this.shadow = shadow;
            return this;
        }

        public Text truncateString(int width) {
            this.width = width;
            int length = this.fontRenderer.func_78256_a(this.text);
            if (length > width) {
                this.text = this.fontRenderer.func_78269_a(this.text, width - this.fontRenderer.func_78256_a(ContainerStackGui.ellipsis)) + ContainerStackGui.ellipsis;
            }
            return this;
        }

        public Text drawString(int x, int y, int color) {
            if (this.shadow) {
                this.fontRenderer.func_78261_a(this.text, x, y, color);
            } else {
                this.fontRenderer.func_78276_b(this.text, x, y, color);
            }
            return this;
        }

        public Text drawString(int x, int y, int color, boolean rightAlign) {
            if (rightAlign) {
                int length = this.fontRenderer.func_78256_a(this.text);
                x = x + this.width - length;
            }
            return this.drawString(x, y, color);
        }

        public Text drawCenteredString(int x, int y, int color) {
            int length = this.fontRenderer.func_78256_a(this.text);
            return this.drawString(x - length / 2, y, color);
        }
    }
}

