/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange.gui;

import brad16840.balancedexchange.AmuletStack;
import brad16840.balancedexchange.BalancedExchange;
import brad16840.balancedexchange.PacketHandler;
import brad16840.balancedexchange.items.AmuletOfTransmutation;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.MessageChannel;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.gui.ImageButton;
import brad16840.common.permissions.PacketHandler;
import brad16840.common.permissions.gui.ClientState;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class AmuletContainer
extends StackableContainer {
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton consumeButton;
    @SideOnly(value=Side.CLIENT)
    private LearntInventory learntInventory;
    @SideOnly(value=Side.CLIENT)
    private ImageButton scrollUp;
    @SideOnly(value=Side.CLIENT)
    private ImageButton scrollDown;
    private boolean dragScrolling = false;
    private int scrollOffset = 0;
    private boolean scrollable = false;
    public static boolean alphabeticallySorted = false;
    public static boolean _canCreateItems = true;
    public static boolean canCreateItems;
    private UniqueItemInventory inventory;
    private String id;
    private ConsumptionInventory consumptionInventory;
    private CreationInventory creationInventory;
    private ItemCreationInventory itemCreationInventory;
    public ItemStack hoveredItemStack = null;
    private ConsumptionSlot consumptionSlot;
    private CreationSlot itemCreationSlot;
    private int itemShift = 0;
    private ItemStack lastItem = null;
    private Item oldItem = null;
    private int oldMeta = 0;
    private boolean readOnly = false;
    public static AmuletStack tooltipAmulet;
    private AmuletStack amulet;
    public static final ResourceLocation texture;

    public AmuletContainer(EntityPlayer player, UniqueItemInventory inventory) {
        super(169, 134);
        this.inventory = inventory;
        this.id = inventory.getIdentifier();
        this.idChain = new ArrayList();
        UniqueItem.refreshIdChain((EntityPlayer)player, (String)this.id, null, (ArrayList)this.idChain);
        if (this.isClient()) {
            this.consumeButton = null;
        }
        this.consumptionInventory = new ConsumptionInventory();
        this.creationInventory = new CreationInventory();
        this.itemCreationInventory = new ItemCreationInventory();
    }

    public boolean initContainer(EntityPlayer player) {
        if (this.isClient()) {
            Keyboard.enableRepeatEvents((boolean)true);
        }
        this.amulet = AmuletStack.create(player, this.getId());
        if (this.amulet == null) {
            UniqueItemData.permissionError((String)"use", (Object)AmuletOfTransmutation.name).log(player);
            return false;
        }
        boolean bl = this.readOnly = !UniqueItemData.get((World)player.field_70170_p).hasRequiredPermission(player, this.id, 2);
        if (this.inventory == null) {
            this.inventory = UniqueItemInventory.createInventory((Item)BalancedExchange.amulet, (EntityPlayer)player, (String)this.id);
        }
        if (this.inventory == null) {
            new Translatable("problem.amuletgui404", new Object[0]).log(player);
            return false;
        }
        this.inventory.refreshInventory();
        this.consumptionSlot = new ConsumptionSlot(player, this.consumptionInventory, 0, 8, 111);
        this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_OUT, this.consumptionSlot);
        this.itemCreationSlot = new CreationSlot(player, this.itemCreationInventory, 0, 147, 9);
        CreationSlot creationSlot = new CreationSlot(player, this.creationInventory, 0, 10000, 10000);
        this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_OUT, creationSlot);
        this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_OUT, new CreationSlot(player, this.itemCreationInventory, 0, 10000, 10000));
        for (int i = 0; i < 3; ++i) {
            this.addSlotToContainer(ContainerStack.ContainerSection.CHEST, new UpgradeSlot(player, (IInventory)this.inventory, i, 8 + i * 18, 10));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (this.amulet == null && !this.refreshAmulet((EntityPlayer)player)) {
            return;
        }
        int i = this.learntInventory != null ? this.learntInventory.scrollPos : -1;
        this.learntInventory = new LearntInventory((EntityPlayer)player, this.amulet);
        if (i < 0) {
            i = (this.learntInventory.learntBlocks.size() + 6) / 7 - 1;
            ItemStack activeItemA = this.amulet.getActiveItem(true);
            ItemStack activeItemB = this.amulet.getActiveItem(false);
            if (activeItemB == null) {
                activeItemB = activeItemA;
            } else if (activeItemA == null) {
                activeItemA = activeItemB;
            }
            if (activeItemA != null) {
                while (i > 0) {
                    boolean c = false;
                    for (int j = 0; j < 7; ++j) {
                        ItemStack stack = this.learntInventory.getStackAtIndex(i * 7 + j);
                        if (stack == null || !stack.func_77969_a(activeItemA) && !stack.func_77969_a(activeItemB)) continue;
                        i -= 2;
                        c = true;
                        break;
                    }
                    if (!c) {
                        --i;
                        continue;
                    }
                    break;
                }
            } else {
                i = 0;
            }
        }
        if (i + 4 > (this.learntInventory.learntBlocks.size() + 6) / 7) {
            i = (this.learntInventory.learntBlocks.size() + 6) / 7 - 4;
        }
        if (i < 0) {
            i = 0;
        }
        this.learntInventory.scrollPos = i;
        this.consumeButton = new StackableContainer.ContainerButton((StackableContainer)this, 0, 109, 109, 54, 20, new Translatable("button.consume", new Object[0]).translate());
        this.gui.addButton(this.consumeButton);
        this.scrollUp = new ImageButton((StackableContainer)this, 2, 144, 29, 19, 18, texture, 176, 53);
        this.gui.addButton((StackableContainer.ContainerButton)this.scrollUp);
        this.scrollDown = new ImageButton((StackableContainer)this, 3, 144, 90, 19, 18, texture, 176, 71);
        this.gui.addButton((StackableContainer.ContainerButton)this.scrollDown);
        this.updateScrollButtons();
        this.consumeButton.field_146124_l = !this.readOnly && AmuletStack.canConsumeItemStack((EntityPlayer)player, this.consumptionInventory.func_70301_a(0));
    }

    public void masterAmulet(EntityPlayer player, boolean fromHand, boolean triggerUpdate) {
        if (!this.refreshAmulet(player) || this.readOnly) {
            return;
        }
        NBTTagCompound learnedItems = this.amulet.getCompoundTag("LearnedItems");
        for (String id : AmuletOfTransmutation.MPB.keySet()) {
            if (id == null) {
                id = "null";
            }
            HashMap<Integer, AmuletOfTransmutation.MPBEntry> items = AmuletOfTransmutation.MPB.get(id);
            Item item = (Item)GameData.getItemRegistry().func_82594_a(id);
            if (item == null || items == null || item == Item.func_150898_a((Block)BalancedExchange.reactiveGlow)) continue;
            String itemDescriptor = AmuletStack.getDescriptor(item);
            for (Integer metadata : items.keySet()) {
                NBTTagCompound itemTag;
                ItemStack learnedItem;
                ItemStack stack;
                if (metadata == null || items.get(metadata) == null || items.get((Object)metadata).created == 0 || items.get((Object)metadata).created < -121 && items.get((Object)metadata).created > -125) continue;
                if (metadata == Short.MAX_VALUE) {
                    metadata = 0;
                }
                if (!((stack = new ItemStack(item, AmuletOfTransmutation.learnThreshold, metadata.intValue())).func_77973_b() instanceof ItemBlock)) continue;
                String itemKey = "item" + itemDescriptor + "dam" + stack.func_77960_j();
                if (!learnedItems.func_74764_b(itemKey)) {
                    NBTTagCompound newTag = new NBTTagCompound();
                    learnedItems.func_74782_a(itemKey, (NBTBase)newTag);
                    UniqueItem.setNBTId((NBTTagCompound)newTag, (String)itemDescriptor);
                    newTag.func_74774_a("Count", (byte)0);
                    newTag.func_74777_a("Damage", (short)stack.func_77960_j());
                }
                if ((learnedItem = UniqueItem.loadItemStackFromNBT((NBTTagCompound)(itemTag = learnedItems.func_74775_l(itemKey)))) == null || learnedItem.field_77994_a >= AmuletOfTransmutation.learnThreshold) continue;
                learnedItem.field_77994_a = AmuletOfTransmutation.learnThreshold;
                UniqueItem.writeItemStackToNBT((ItemStack)learnedItem, (NBTTagCompound)itemTag);
            }
        }
        this.amulet.markDirty();
        new Translatable("message.amuletmastered", new Object[0]).send(player);
        if (triggerUpdate) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.MasterAmulet(this.id, fromHand));
        }
        if (fromHand) {
            player.field_71071_by.func_70437_b(null);
        } else {
            this.consumptionSlot.func_75215_d(null);
        }
    }

    public void consumeItemStack(EntityPlayer player, boolean fromHand, boolean triggerUpdate) {
        if (!UniqueItemData.get((World)player.field_70170_p).hasRequiredPermission(player, this.id, 2)) {
            return;
        }
        ItemStack stack = this.consumptionInventory.func_70301_a(0);
        if (fromHand) {
            stack = player.field_71071_by.func_70445_o();
        }
        if (stack == null) {
            return;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150357_h)) {
            if (triggerUpdate) {
                this.masterAmulet(player, fromHand, true);
            }
            return;
        }
        if (stack.func_77973_b() instanceof AmuletOfTransmutation) {
            if (fromHand) {
                return;
            }
            if (!UniqueItem.hasIdentifier((ItemStack)stack)) {
                if (!triggerUpdate) {
                    Common.requestInventoryIdentifier((EntityPlayer)player, (IInventory)this.consumptionInventory, (int)0);
                    stack = this.consumptionInventory.func_70301_a(0);
                } else {
                    BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.IdentifyConsumptionSlotAmulet(this.id, null, triggerUpdate ? 1 : 2));
                    return;
                }
            }
        }
        if (stack == null) {
            return;
        }
        if (!this.refreshAmulet(player)) {
            return;
        }
        this.amulet.consumeItemStack(stack, fromHand, triggerUpdate);
        if (fromHand) {
            player.field_71071_by.func_70437_b(null);
            return;
        }
        if (!(stack.func_77973_b() instanceof AmuletOfTransmutation)) {
            this.consumptionSlot.func_75215_d(null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void actionPerformed(StackableContainer.ContainerButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                this.consumeItemStack((EntityPlayer)player, false, true);
                this.refreshAmulet((EntityPlayer)player);
                this.learntInventory.refreshLearntData((EntityPlayer)player, this.amulet);
            } else if (button.field_146127_k == 1 || button.field_146127_k == 2) {
                this.learntInventory.scroll(false, button.field_146127_k == 1);
            } else if (button.field_146127_k == 3 || button.field_146127_k == 4) {
                this.learntInventory.scroll(true, button.field_146127_k == 4);
            } else {
                return;
            }
            this.updateScrollButtons();
            this.gui.func_73876_c();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (this.amulet == null && !this.refreshAmulet((EntityPlayer)player)) {
            return;
        }
        int matter = this.amulet.getStoredMatter();
        this.gui.text((StackableContainer)this, new Translatable("gui.amulet.matter", new Object[]{matter}).translate()).truncateString(!this.readOnly && canCreateItems ? 86 : 98).drawString(60, !this.readOnly && canCreateItems ? 16 : 8, -12566464, true);
        if (!this.readOnly && canCreateItems) {
            ItemStack stack = AmuletOfTransmutation.getAffordableItem((EntityPlayer)player, this.amulet, matter, 0);
            if (stack != null && (stack.func_77973_b() != this.oldItem || stack.func_77960_j() != this.oldMeta) && player.field_71071_by.func_70445_o() == null) {
                this.itemShift = 0;
                this.oldItem = stack.func_77973_b();
                this.oldMeta = stack.func_77960_j();
                if (this.lastItem != null) {
                    for (int i = 0; i < AmuletOfTransmutation.dispensableItemList.size(); ++i) {
                        if (this.amulet.getBlockCreationCost(AmuletOfTransmutation.dispensableItemList.get(i), null) > matter) continue;
                        if (i >= AmuletOfTransmutation.dispensableItemList.size()) break;
                        while (i + this.itemShift < AmuletOfTransmutation.dispensableItemList.size()) {
                            if (AmuletOfTransmutation.dispensableItemList.get(i + this.itemShift).func_77969_a(this.lastItem)) {
                                ++this.itemShift;
                                break;
                            }
                            ++this.itemShift;
                        }
                        --this.itemShift;
                        if (AmuletOfTransmutation.dispensableItemList.get(i + this.itemShift).func_77969_a(this.lastItem)) break;
                        this.itemShift = 0;
                        break;
                    }
                }
            }
            if ((stack = AmuletOfTransmutation.getAffordableItem((EntityPlayer)player, this.amulet, matter, this.itemShift)) != null) {
                if (!(player.field_71071_by.func_70445_o() != null || this.lastItem != null && stack.func_77969_a(this.lastItem))) {
                    this.lastItem = stack;
                }
                this.itemCreationInventory.set((EntityPlayer)player, stack.func_77973_b(), stack.func_77960_j());
                GL11.glEnable((int)2896);
                this.gui.drawSlotInventory((StackableContainer)this, (Slot)this.itemCreationSlot);
                GL11.glDisable((int)2896);
                if (x >= this.itemCreationSlot.field_75223_e - 1 && y >= this.itemCreationSlot.field_75221_f - 1 && x < this.itemCreationSlot.field_75223_e + 17 && y < this.itemCreationSlot.field_75221_f + 17) {
                    tooltipAmulet = this.amulet;
                    this.gui.customTooltipItem = this.itemCreationSlot.func_75211_c();
                }
            }
        }
        if (this.consumptionInventory.func_70301_a(0) != null) {
            this.gui.text((StackableContainer)this, this.consumptionInventory.func_70301_a(0).func_82833_r()).truncateString(79).drawString(27, 110, -12566464);
            if (AmuletStack.canConsumeItemStack((EntityPlayer)player, this.consumptionInventory.func_70301_a(0))) {
                this.gui.text((StackableContainer)this, new Translatable("gui.amulet.mpbconsumed", new Object[]{AmuletStack.getMPBConsumed((EntityPlayer)player, player.field_70170_p, this.consumptionInventory.func_70301_a(0))}).translate()).truncateString(79).drawString(27, 120, -12566464);
            } else if (this.consumptionInventory.func_70301_a(0).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150357_h)) {
                this.gui.text((StackableContainer)this, new Translatable("gui.amulet.mpbbedrock", new Object[0]).translate()).truncateString(79).drawString(27, 120, -2744106);
            } else {
                this.gui.text((StackableContainer)this, new Translatable("gui.amulet.mpbinconsumable", new Object[0]).translate()).truncateString(79).drawString(27, 120, -2744288);
            }
        }
        boolean dualTransmutations = AmuletStack.isDualMode((EntityPlayer)player, this.getId());
        ItemStack activeItemA = this.amulet.getActiveItem(true);
        ItemStack activeItemB = this.amulet.getActiveItem(false);
        int xShift = this.container.getOffsetX((StackableContainer)this) - this.gui.getOffsetX((StackableContainer)this) - this.gui.getScrollX();
        int yShift = this.container.getOffsetY((StackableContainer)this) - this.gui.getOffsetY((StackableContainer)this) - this.gui.getScrollY();
        for (int yi = 0; yi < 4; ++yi) {
            for (int xi = 0; xi < 7; ++xi) {
                GL11.glEnable((int)2896);
                ItemStack stack = this.learntInventory.getStackAtIndex(yi * 7 + xi);
                this.gui.drawItemStack(stack, 10 + xi * 19 + this.container.getOffsetX((StackableContainer)this) - this.gui.getScrollX(), 32 + yi * 19 + this.container.getOffsetY((StackableContainer)this) - this.gui.getScrollY(), 100.0f, "");
                GL11.glDisable((int)2896);
                if (stack == null) {
                    stack = this.learntInventory.getItemAtIndex(yi * 7 + xi);
                    if (stack == null) continue;
                    GL11.glEnable((int)2896);
                    this.gui.drawItemStack(stack, 10 + xi * 19 + this.container.getOffsetX((StackableContainer)this) - this.gui.getScrollX(), 32 + yi * 19 + this.container.getOffsetY((StackableContainer)this) - this.gui.getScrollY(), 100.0f, "");
                    GL11.glDisable((int)2896);
                    continue;
                }
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)3042);
                this.gui.bindTexture(texture);
                if (stack.field_77994_a < AmuletOfTransmutation.learnThreshold) {
                    for (int i = 0; i < (AmuletOfTransmutation.learnThreshold - stack.field_77994_a + 4) / 5; ++i) {
                        this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 1, 156, 250.0f);
                    }
                } else if (this.hoveredItemStack == stack) {
                    this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 43, 156, 280.0f);
                } else {
                    this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 22, 156, 240.0f);
                }
                boolean isActiveA = activeItemA != null && stack.func_77973_b() == activeItemA.func_77973_b() && stack.func_77960_j() == activeItemA.func_77960_j() && dualTransmutations;
                boolean isActiveB = activeItemB != null && stack.func_77973_b() == activeItemB.func_77973_b() && stack.func_77960_j() == activeItemB.func_77960_j();
                boolean sided = false;
                if (isActiveA || isActiveB) {
                    if (dualTransmutations && isActiveA != isActiveB) {
                        this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, isActiveA ? 85 : 106, 156, 380.0f);
                        sided = true;
                    } else {
                        this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 64, 156, 380.0f);
                    }
                }
                if (this.learntInventory.quickList.contains("item" + AmuletStack.getDescriptor(stack.func_77973_b()) + "dam" + stack.func_77960_j())) {
                    this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 127, 156 + (sided ? (isActiveA ? 21 : 42) : 0), 390.0f);
                }
                GL11.glDisable((int)3042);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheel(int x, int y, int wheel) {
        if (x < 0 || x > this.guiWidth || y < 0 || y > this.guiHeight || wheel == 0) {
            return false;
        }
        if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E)) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (!this.refreshAmulet((EntityPlayer)player) || this.readOnly || this.hoveredItemStack == null) {
                return true;
            }
            this.amulet.toggleQuickListStack(this.hoveredItemStack, wheel > 0 ? 2 : 1, true);
            if (this.isClient()) {
                this.learntInventory.refreshLearntData((EntityPlayer)player, this.amulet);
                this.updateScrollButtons();
                this.gui.func_73876_c();
            }
            return true;
        }
        int oldScrollPos = this.learntInventory.scrollPos;
        if (wheel < 0) {
            this.learntInventory.scroll(true, false);
            this.updateScrollButtons();
        } else if (wheel > 0) {
            this.learntInventory.scroll(false, false);
            this.updateScrollButtons();
        }
        return oldScrollPos != this.learntInventory.scrollPos;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        int yPos;
        int barSize;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (this.amulet == null && !this.refreshAmulet((EntityPlayer)player)) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture((StackableContainer)this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
        ItemStack activeItemA = this.amulet.getActiveItem(true);
        ItemStack activeItemB = this.amulet.getActiveItem(false);
        this.hoveredItemStack = null;
        for (int i = 0; i < 3; ++i) {
            NBTTagCompound tag = this.amulet.getCompoundTag("handedness");
            short t = tag.func_74765_d("i" + i);
            if (t == 2 || t == 3) {
                this.gui.drawRectangle((StackableContainer)this, 8 + i * 18, 8, 8 + i * 18 + 7, 9, -5066062);
            }
            if (t != 1 && t != 3) continue;
            this.gui.drawRectangle((StackableContainer)this, 16 + i * 18, 8, 16 + i * 18 + 7, 9, -5066062);
        }
        boolean dualTransmutations = AmuletStack.isDualMode((EntityPlayer)player, this.getId());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xShift = 0;
        int yShift = 0;
        for (int yi = 0; yi < 4; ++yi) {
            for (int xi = 0; xi < 7; ++xi) {
                boolean isActiveB;
                ItemStack stack = this.learntInventory.getStackAtIndex(yi * 7 + xi);
                if (stack == null) {
                    stack = this.learntInventory.getItemAtIndex(yi * 7 + xi);
                    if (stack == null || x <= 8 + xi * 19 || x >= 27 + xi * 19 || y <= 30 + yi * 19 || y >= 49 + yi * 19) continue;
                    tooltipAmulet = this.amulet;
                    this.gui.customTooltipItem = stack;
                    if (this.readOnly) continue;
                    this.hoveredItemStack = stack;
                    continue;
                }
                if (x > 8 + xi * 19 && x < 27 + xi * 19 && y > 30 + yi * 19 && y < 49 + yi * 19) {
                    tooltipAmulet = this.amulet;
                    this.gui.customTooltipItem = stack;
                    if (!this.readOnly) {
                        this.hoveredItemStack = stack;
                    }
                }
                if (stack.field_77994_a < AmuletOfTransmutation.learnThreshold) {
                    this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 1, 135, 60.0f);
                } else if (this.hoveredItemStack == stack) {
                    this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 43, 135, 50.0f);
                } else {
                    this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 22, 135, 40.0f);
                }
                boolean isActiveA = activeItemA != null && stack.func_77973_b() == activeItemA.func_77973_b() && stack.func_77960_j() == activeItemA.func_77960_j() && dualTransmutations;
                boolean bl = isActiveB = activeItemB != null && stack.func_77973_b() == activeItemB.func_77973_b() && stack.func_77960_j() == activeItemB.func_77960_j();
                if (isActiveA || isActiveB) {
                    if (dualTransmutations && isActiveA != isActiveB) {
                        this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, isActiveA ? 85 : 106, 135, 80.0f);
                    } else {
                        this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 64, 135, 80.0f);
                    }
                }
                if (!this.learntInventory.quickList.contains("item" + AmuletStack.getDescriptor(stack.func_77973_b()) + "dam" + stack.func_77960_j())) continue;
                this.gui.drawTexture((StackableContainer)this, 8 + xi * 19 + xShift, 30 + yi * 19 + yShift, 20, 20, 127, 135, 90.0f);
            }
        }
        int scrollbarSize = 41;
        float percent = 0.0f;
        if ((this.learntInventory.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7 != 4) {
            percent = (float)this.learntInventory.scrollPos / (float)((this.learntInventory.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7 - 4);
        }
        if ((barSize = 4 * scrollbarSize / ((this.learntInventory.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7)) < 7) {
            barSize = 7;
        }
        if (barSize > scrollbarSize) {
            barSize = scrollbarSize;
        }
        if ((yPos = (int)((float)(scrollbarSize - barSize) * percent)) + barSize > scrollbarSize) {
            yPos = scrollbarSize - barSize;
        }
        if (yPos < 0) {
            yPos = 0;
        }
        int state = 1;
        if (this.dragScrolling || x > 143 && x < 163 && y >= (yPos += 48) && y < yPos + barSize) {
            state = 2;
        }
        if (!this.scrollable) {
            state = 0;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.drawTexture((StackableContainer)this, 144, yPos, 19, barSize - 3, 176 + 19 * state, 0);
        this.gui.drawTexture((StackableContainer)this, 144, yPos + barSize - 3, 19, 3, 176 + 19 * state, 50);
    }

    @SideOnly(value=Side.CLIENT)
    public void static_addItemStackTooltip(List list, ItemStack itemStack) {
        AmuletContainer.addMPBTooltip(list, itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addMPBTooltip(List list, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Translatable consumed = new Translatable("tooltip.mpb.inconsumable", new Object[0]);
        Translatable created = new Translatable("tooltip.mpb.uncreatable", new Object[0]);
        if (AmuletStack.canConsumeItemStack((EntityPlayer)player, itemStack)) {
            consumed = new Translatable("tooltip.mpb.consumable", new Object[]{AmuletStack.getMPBConsumed((EntityPlayer)player, player.field_70170_p, itemStack)});
        }
        if (AmuletOfTransmutation.canDispense(itemStack) || AmuletStack.canLearnItemStack(itemStack)) {
            created = new Translatable("tooltip.mpb.creatable", new Object[]{AmuletOfTransmutation.getMPBEntry((ItemStack)itemStack).created});
        }
        new Translatable("tooltip.mpb", new Object[]{consumed, created}).addTo(list);
        if (tooltipAmulet == null) {
            return;
        }
        String itemKey = "item" + AmuletStack.getDescriptor(itemStack.func_77973_b()) + "dam" + itemStack.func_77960_j();
        NBTTagCompound learnedItems = tooltipAmulet.getCompoundTag("LearnedItems");
        tooltipAmulet = null;
        if (!learnedItems.func_74764_b(itemKey)) {
            return;
        }
        NBTTagCompound itemTag = learnedItems.func_74775_l(itemKey);
        ItemStack learnedItem = UniqueItem.loadItemStackFromNBT((NBTTagCompound)itemTag);
        if (learnedItem.field_77994_a < AmuletOfTransmutation.learnThreshold) {
            new Translatable("gui.amulet.learning", new Object[]{learnedItem.field_77994_a * 100 / AmuletOfTransmutation.learnThreshold, AmuletOfTransmutation.learnThreshold - learnedItem.field_77994_a}).addTo(list);
        }
    }

    public void updateScrollButtons() {
        if (this.isClient()) {
            this.scrollUp.field_146124_l = this.learntInventory.canScrollUp();
            this.scrollDown.field_146124_l = this.learntInventory.canScrollDown();
            this.scrollable = this.learntInventory.canScroll();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        Minecraft mc = Minecraft.func_71410_x();
        if (keyCode == Common.permissionKey.func_151463_i()) {
            if ((Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) && this.stackId == 0) {
                return false;
            }
            String id = this.getId();
            Common.channel.sendToServer((MessageChannel.Message)new PacketHandler.OpenGroup(0, new ClientState.PermissionGroupState(id, "I_" + id, 0, true), true));
            return true;
        }
        if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && keyCode == 18) {
            Common.channel.sendToServer((MessageChannel.Message)new PacketHandler.OpenEditorWindow("mpb", 1, false));
            return true;
        }
        if (keyCode == 28 && this.consumeButton.field_146124_l) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            this.consumeItemStack((EntityPlayer)player, false, true);
            this.refreshAmulet((EntityPlayer)player);
            this.learntInventory.refreshLearntData((EntityPlayer)player, this.amulet);
            this.updateScrollButtons();
            this.gui.func_73876_c();
            return true;
        }
        if (keyCode == 199) {
            if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
                return true;
            }
            new Translatable("message.savingmpb", new Object[0]).log((EntityPlayer)mc.field_71439_g);
            BalancedExchange.saveMPBValues("Assigned", new BalancedExchange.MPBFilter(){
                ArrayList<ItemStack> items = new ArrayList();

                @Override
                public void filterItems(Item item, String id, ArrayList<AmuletOfTransmutation.MPBEntry> values) {
                    this.items.clear();
                    item.func_150895_a(item, null, this.items);
                    for (ItemStack stack : this.items) {
                        AmuletOfTransmutation.MPBEntry entry = AmuletOfTransmutation.getMPBEntry(stack);
                        if (entry.consumed == 0 && entry.created == 0) continue;
                        values.add(new AmuletOfTransmutation.MPBEntry(stack.func_77960_j(), entry.consumed, entry.created));
                    }
                }
            });
            BalancedExchange.saveMPBValues("Unassigned", new BalancedExchange.MPBFilter(){
                ArrayList<ItemStack> items = new ArrayList();

                @Override
                public void filterItems(Item item, String id, ArrayList<AmuletOfTransmutation.MPBEntry> values) {
                    this.items.clear();
                    item.func_150895_a(item, null, this.items);
                    for (ItemStack stack : this.items) {
                        AmuletOfTransmutation.MPBEntry entry = AmuletOfTransmutation.getMPBEntry(stack);
                        if (entry.consumed != 0 || entry.created != 0) continue;
                        values.add(new AmuletOfTransmutation.MPBEntry(stack.func_77960_j(), entry.consumed, entry.created));
                    }
                }
            });
            new Translatable("message.savedmpb", new Object[0]).log((EntityPlayer)mc.field_71439_g);
            return true;
        }
        if (keyCode == 203) {
            keyCode = mc.field_71474_y.field_74370_x.func_151463_i();
        } else if (keyCode == 205) {
            keyCode = mc.field_71474_y.field_74366_z.func_151463_i();
        } else if (keyCode == 200) {
            keyCode = mc.field_71474_y.field_74351_w.func_151463_i();
        } else if (keyCode == 208) {
            keyCode = mc.field_71474_y.field_74368_y.func_151463_i();
        }
        if (keyCode == mc.field_71474_y.field_74370_x.func_151463_i() || keyCode == mc.field_71474_y.field_74351_w.func_151463_i()) {
            int oldScrollPos = this.learntInventory.scrollPos;
            this.learntInventory.scroll(false, keyCode == mc.field_71474_y.field_74370_x.func_151463_i());
            if (this.gui != null) {
                this.updateScrollButtons();
                this.gui.func_73876_c();
            }
            return oldScrollPos != this.learntInventory.scrollPos;
        }
        if (keyCode == mc.field_71474_y.field_74366_z.func_151463_i() || keyCode == mc.field_71474_y.field_74368_y.func_151463_i()) {
            int oldScrollPos = this.learntInventory.scrollPos;
            this.learntInventory.scroll(true, keyCode == mc.field_71474_y.field_74366_z.func_151463_i());
            if (this.gui != null) {
                this.updateScrollButtons();
                this.gui.func_73876_c();
            }
            return oldScrollPos != this.learntInventory.scrollPos;
        }
        return false;
    }

    public boolean refreshAmulet(EntityPlayer player) {
        this.amulet = AmuletStack.create(player, this.getId());
        if (this.amulet == null) {
            UniqueItemData.permissionError((String)"use", (Object)AmuletOfTransmutation.name).log(player);
            this.container.closeContainer(player, this.stackId);
            return false;
        }
        this.readOnly = !UniqueItemData.get((World)player.field_70170_p).hasRequiredPermission(player, this.id, 2);
        return true;
    }

    public void quickCreate(EntityPlayer player, Item item, int metadata, int count, boolean triggerUpdate) {
        int matter;
        if (!this.refreshAmulet(player) || this.readOnly) {
            return;
        }
        if (!this.amulet.canQuickCreateBlocks(null)) {
            return;
        }
        int amount = count;
        ItemStack stack = new ItemStack(item, count, metadata);
        int cost = this.amulet.getBlockCreationCost(stack, null);
        if (cost * amount > (matter = this.amulet.getStoredMatter())) {
            amount = matter / cost;
        }
        stack.field_77994_a = amount;
        if (amount < 1) {
            new Translatable("problem.unaffordable", new Object[0]).log(player);
            return;
        }
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (heldItem != null) {
            stack.field_77994_a += heldItem.field_77994_a;
        }
        player.field_71071_by.func_70437_b(stack);
        this.amulet.setStoredMatter(matter - cost * amount);
        if (triggerUpdate) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.QuickCreate(this.getId(), Item.func_150891_b((Item)item), metadata, amount));
        }
    }

    public void quickCreateItem(EntityPlayer player, ItemStack stack) {
        if (!AmuletOfTransmutation.canDispense(stack)) {
            return;
        }
        if (!this.refreshAmulet(player) || this.readOnly) {
            return;
        }
        UniqueItemData data = UniqueItemData.get((World)player.field_70170_p);
        if (!data.hasRequiredPermission(player, this.id, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).send(player);
            return;
        }
        int matter = this.amulet.getStoredMatter();
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (stack != null && (heldItem == null || stack.func_77969_a(heldItem))) {
            if (heldItem != null) {
                stack.field_77994_a += heldItem.field_77994_a;
            }
            if (stack.field_77994_a > player.field_71071_by.func_70297_j_() || stack.field_77994_a > stack.func_77976_d()) {
                return;
            }
            int cost = this.amulet.getBlockCreationCost(stack, null);
            if (cost > matter) {
                return;
            }
            this.amulet.setStoredMatter(matter - cost);
            player.field_71071_by.func_70437_b(stack);
        }
    }

    public void setHandedness(EntityPlayer player, int slot, int handedness, boolean update) {
        if (!this.refreshAmulet(player) || this.readOnly) {
            return;
        }
        NBTTagCompound tag = this.amulet.getCompoundTag("handedness");
        tag.func_74777_a("i" + slot, (short)handedness);
        this.amulet.markDirty();
        if (update) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.SetHandedness(this.amulet.getIdentifier(), slot, handedness));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleDispenserClick(boolean shiftIsDown) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        int matter = this.amulet.getStoredMatter();
        ItemStack stack = AmuletOfTransmutation.getAffordableItem((EntityPlayer)player, this.amulet, matter, this.itemShift);
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (stack != null && (heldItem == null || stack.func_77969_a(heldItem))) {
            if (!this.refreshAmulet((EntityPlayer)player)) {
                return;
            }
            UniqueItemData data = UniqueItemData.get((World)player.field_70170_p);
            if (!data.hasRequiredPermission((EntityPlayer)player, this.id, 2)) {
                UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log((EntityPlayer)player);
                return;
            }
            if (shiftIsDown) {
                this.setCreationInventory((EntityPlayer)player, stack.func_77973_b(), stack.func_77960_j(), true);
                BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.QuickCreateMulti(this.id, Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77960_j(), true, false));
                this.container.triggerSlotClick((StackableContainer)this, 2, 0, 1, (EntityPlayer)player);
            } else {
                stack = stack.func_77946_l();
                stack.field_77994_a = 1;
                BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.QuickCreateItem(this.id, stack, false));
                if (heldItem != null) {
                    stack.field_77994_a += heldItem.field_77994_a;
                }
                if (stack.field_77994_a > player.field_71071_by.func_70297_j_() || stack.field_77994_a > stack.func_77976_d()) {
                    return;
                }
                int cost = this.amulet.getBlockCreationCost(stack, null);
                if (cost > matter) {
                    return;
                }
                this.amulet.setStoredMatter(matter - cost);
                player.field_71071_by.func_70437_b(stack);
                this.refreshAmulet((EntityPlayer)player);
                this.learntInventory.refreshLearntData((EntityPlayer)player, this.amulet);
                this.updateScreen();
            }
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        block34: {
            block36: {
                EntityClientPlayerMP player;
                ItemStack stack;
                int yi;
                int xi;
                block37: {
                    block40: {
                        block39: {
                            block38: {
                                block35: {
                                    boolean clicked;
                                    boolean bl = clicked = button == 0 || button == 1 || button == Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151463_i() + 100;
                                    if (!this.readOnly && clicked && x >= 7 && x < 61 && y >= 7 && y < 9) {
                                        boolean left;
                                        if (!this.refreshAmulet((EntityPlayer)Minecraft.func_71410_x().field_71439_g) || this.readOnly) {
                                            return false;
                                        }
                                        int slot = (x - 7) / 18;
                                        NBTTagCompound tag = this.amulet.getCompoundTag("handedness");
                                        int t = tag.func_74765_d("i" + slot);
                                        boolean bl2 = left = x - 7 - slot * 18 < 9;
                                        t = t == 0 ? (left ? 2 : 1) : (t == 1 ? (left ? 3 : 0) : (t == 2 ? (left ? 0 : 3) : (left ? 1 : 2)));
                                        this.setHandedness((EntityPlayer)Minecraft.func_71410_x().field_71439_g, slot, t, true);
                                        return true;
                                    }
                                    if (!this.readOnly && clicked && canCreateItems && x > this.itemCreationSlot.field_75223_e - 2 && x < this.itemCreationSlot.field_75223_e + 17 && y > this.itemCreationSlot.field_75221_f - 2 && y < this.itemCreationSlot.field_75221_f + 17) {
                                        EntityClientPlayerMP player2 = Minecraft.func_71410_x().field_71439_g;
                                        int matter = this.amulet.getStoredMatter();
                                        if (button == 1 && player2.field_71071_by.func_70445_o() == null) {
                                            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                                                --this.itemShift;
                                                if (this.itemShift < 0) {
                                                    this.itemShift = AmuletOfTransmutation.getNextAffordableItemShift((EntityPlayer)player2, this.amulet, matter, -1);
                                                }
                                            } else {
                                                this.itemShift = AmuletOfTransmutation.getNextAffordableItemShift((EntityPlayer)player2, this.amulet, matter, this.itemShift);
                                            }
                                            this.updateScreen();
                                            return true;
                                        }
                                        this.handleDispenserClick(Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                                        return true;
                                    }
                                    if (this.readOnly || !clicked || x <= 8 || x >= 141 || y <= 30 || y >= 106) break block34;
                                    xi = (x - 8) / 19;
                                    yi = (y - 30) / 19;
                                    if (x - xi * 19 == 8 || y - yi * 19 == 30) {
                                        yi = -1;
                                        xi = -1;
                                    }
                                    stack = this.learntInventory.getStackAtIndex(yi * 7 + xi);
                                    player = Minecraft.func_71410_x().field_71439_g;
                                    if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) || player.field_71071_by.func_70445_o() == null) break block35;
                                    if (!(player.field_71071_by.func_70445_o().func_77973_b() instanceof AmuletOfTransmutation)) {
                                        this.consumeItemStack((EntityPlayer)player, true, true);
                                    }
                                    this.refreshAmulet((EntityPlayer)player);
                                    this.learntInventory.refreshLearntData((EntityPlayer)player, this.amulet);
                                    this.updateScrollButtons();
                                    this.gui.func_73876_c();
                                    break block36;
                                }
                                if (stack == null) break block37;
                                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)211)) break block38;
                                if (!this.refreshAmulet((EntityPlayer)player)) break block36;
                                this.amulet.setActiveItemStack(stack, true, AmuletStack.isDualMode((EntityPlayer)player, this.getId()) && button != 1);
                                break block36;
                            }
                            if (!Keyboard.isKeyDown((int)211)) break block39;
                            if (this.refreshAmulet((EntityPlayer)player)) {
                                this.amulet.forgetItemStack(stack, true);
                            }
                            this.learntInventory.refreshLearntData((EntityPlayer)player, this.amulet);
                            break block36;
                        }
                        if (stack.field_77994_a < AmuletOfTransmutation.learnThreshold || stack.func_77973_b() == Item.func_150898_a((Block)BalancedExchange.reactiveGlow)) break block36;
                        if (button != 0) break block40;
                        this.setCreationInventory((EntityPlayer)player, stack.func_77973_b(), stack.func_77960_j(), false);
                        BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.QuickCreateMulti(this.id, Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77960_j(), false, false));
                        this.container.triggerSlotClick((StackableContainer)this, 1, 0, 1, (EntityPlayer)player);
                        break block36;
                    }
                    int toCreate = 1;
                    ItemStack heldItem = player.field_71071_by.func_70445_o();
                    if (heldItem != null && (heldItem.func_77973_b() != stack.func_77973_b() || heldItem.func_77960_j() != stack.func_77960_j() || !heldItem.func_77985_e())) break block36;
                    int heldSize = 0;
                    if (heldItem != null) {
                        heldSize = heldItem.field_77994_a;
                    }
                    stack.field_77994_a = toCreate + heldSize;
                    if (stack.field_77994_a > stack.func_77976_d()) {
                        stack.field_77994_a = stack.func_77976_d();
                        toCreate = stack.field_77994_a - heldSize;
                        if (toCreate < 1) {
                            return true;
                        }
                    }
                    this.quickCreate((EntityPlayer)player, stack.func_77973_b(), stack.func_77960_j(), toCreate, true);
                    this.refreshAmulet((EntityPlayer)player);
                    this.learntInventory.refreshLearntData((EntityPlayer)player, this.amulet);
                    this.updateScrollButtons();
                    break block36;
                }
                if (!this.readOnly && canCreateItems) {
                    int matter = this.amulet.getStoredMatter();
                    stack = this.learntInventory.getItemAtIndex(yi * 7 + xi);
                    if (stack != null && this.amulet.getBlockCreationCost(stack, null) <= matter) {
                        int i;
                        boolean found = false;
                        for (i = 0; i < AmuletOfTransmutation.dispensableItemList.size(); ++i) {
                            if (!AmuletOfTransmutation.dispensableItemList.get(i).func_77969_a(stack)) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            this.itemShift = 0;
                            this.lastItem = stack;
                            this.oldItem = stack.func_77973_b();
                            this.oldMeta = stack.func_77960_j();
                            for (i = 0; i < AmuletOfTransmutation.dispensableItemList.size(); ++i) {
                                if (this.amulet.getBlockCreationCost(AmuletOfTransmutation.dispensableItemList.get(i), null) > matter) continue;
                                if (i >= AmuletOfTransmutation.dispensableItemList.size()) break;
                                while (i + this.itemShift < AmuletOfTransmutation.dispensableItemList.size()) {
                                    if (AmuletOfTransmutation.dispensableItemList.get(i + this.itemShift).func_77969_a(this.lastItem)) {
                                        ++this.itemShift;
                                        break;
                                    }
                                    ++this.itemShift;
                                }
                                --this.itemShift;
                                if (!AmuletOfTransmutation.dispensableItemList.get(i + this.itemShift).func_77969_a(this.lastItem)) {
                                    this.itemShift = 0;
                                    break;
                                }
                                if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54) || player.field_71071_by.func_70445_o() != null && !player.field_71071_by.func_70445_o().func_77969_a(this.lastItem)) break;
                                this.handleDispenserClick(button == 0);
                                break;
                            }
                        }
                    }
                }
            }
            this.updateScreen();
            return true;
        }
        if (x > 143 && x < 163 && y > 47 && y < 89) {
            int yPos;
            int barSize;
            int scrollbarSize = 41;
            float percent = 0.0f;
            if ((this.learntInventory.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7 != 4) {
                percent = (float)this.learntInventory.scrollPos / (float)((this.learntInventory.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7 - 4);
            }
            if ((barSize = 4 * scrollbarSize / ((this.learntInventory.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7)) < 7) {
                barSize = 7;
            }
            if (barSize > scrollbarSize) {
                barSize = scrollbarSize;
            }
            if ((yPos = (int)((float)(scrollbarSize - barSize) * percent)) + barSize > scrollbarSize) {
                yPos = scrollbarSize - barSize;
            }
            if (yPos < 0) {
                yPos = 0;
            }
            if (y >= (yPos += 48) && y < yPos + barSize) {
                if ((this.learntInventory.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7 <= 4) {
                    return false;
                }
                this.dragScrolling = true;
                this.scrollOffset = y - yPos;
                if (this.gui != null) {
                    this.gui.func_73876_c();
                }
                return true;
            }
            if (y < yPos) {
                this.learntInventory.scroll(false, true);
                if (this.gui != null) {
                    this.updateScrollButtons();
                    this.gui.func_73876_c();
                }
            } else {
                this.learntInventory.scroll(true, true);
                if (this.gui != null) {
                    this.updateScrollButtons();
                    this.gui.func_73876_c();
                }
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int x, int y, int button) {
        if (this.dragScrolling) {
            int scrollbarSize = 41;
            int barSize = 4 * scrollbarSize / ((this.learntInventory.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7);
            if (barSize < 7) {
                barSize = 7;
            }
            if (barSize > scrollbarSize) {
                barSize = scrollbarSize;
            }
            if (barSize != scrollbarSize) {
                this.learntInventory.setScrollPercent((float)(y - this.scrollOffset - 48) / (float)(scrollbarSize - barSize));
            } else {
                this.learntInventory.setScrollPercent(0.0f);
            }
            if (this.gui != null) {
                this.updateScrollButtons();
                this.gui.func_73876_c();
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseUp(int x, int y, int button) {
        if (this.dragScrolling) {
            this.dragScrolling = false;
            if (this.gui != null) {
                this.gui.func_73876_c();
            }
            return true;
        }
        return false;
    }

    public boolean customRightClickOnEmpty() {
        return false;
    }

    public boolean customRightClick(EntityPlayer player, int slot, boolean holdingShift) {
        if (!(this.container.func_75139_a(slot) instanceof UpgradeSlot)) {
            return false;
        }
        ItemStack stack = this.container.func_75139_a(slot).func_75211_c();
        int openStackId = this.stackId;
        if (holdingShift && ++openStackId >= this.container.stacks.length) {
            openStackId = 0;
        }
        if (stack != null) {
            this.container.saveInventories(player);
            if (stack.func_77973_b() instanceof UniqueItem.OpenableItem) {
                UniqueItem.OpenableItem item = (UniqueItem.OpenableItem)stack.func_77973_b();
                StackableContainer c = item.openContainer(player, (IInventory)this.inventory, this.container.func_75139_a(slot).getSlotIndex(), stack, openStackId);
                if (c != null) {
                    this.container.addContainer(player, item.getPreferreredStack(this.container, openStackId), c);
                } else if (this.isClient()) {
                    this.gui.overrideFailed = true;
                }
                return true;
            }
        } else {
            slot -= 3;
            if (!this.refreshAmulet(player) || this.readOnly) {
                return false;
            }
            NBTTagCompound tag = this.amulet.getCompoundTag("handedness");
            short t = tag.func_74765_d("i" + slot);
            if ((t = (short)(t + 1)) > 3) {
                t = 0;
            }
            tag.func_74777_a("i" + slot, t);
            this.amulet.markDirty();
            return true;
        }
        return false;
    }

    public ItemStack transferStackInSlot(EntityPlayer player, StackableContainer.ContainerSlot slot) {
        ItemStack itemstack = null;
        if (this.readOnly) {
            return null;
        }
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (itemstack1 != null && itemstack1.func_77973_b() instanceof AmuletOfTransmutation || !AmuletStack.canConsumeItemStack(player, itemstack1)) {
                if (!this.container.mergeItemStack((StackableContainer)this, itemstack1, 3, 6, false)) {
                    return null;
                }
                slot.func_75220_a(itemstack1, itemstack);
                if (itemstack1.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
                if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                    return null;
                }
                slot.func_82870_a(player, itemstack);
                return itemstack;
            }
            if (this.consumptionInventory.func_70301_a(0) != null) {
                ItemStack toConsume = this.consumptionInventory.func_70301_a(0);
                if (toConsume != null && toConsume.func_77973_b() instanceof AmuletOfTransmutation || !AmuletStack.canConsumeItemStack(player, toConsume)) {
                    return null;
                }
                boolean merged = this.container.mergeItemStack((StackableContainer)this, itemstack1, 0, 1, true);
                if (merged) {
                    int t = itemstack1.field_77994_a;
                    itemstack1.field_77994_a = toConsume.field_77994_a;
                    toConsume.field_77994_a = t;
                    if (toConsume.field_77994_a < 1) {
                        toConsume = null;
                        this.consumptionInventory.func_70299_a(0, toConsume);
                    }
                }
                if (toConsume != null) {
                    this.consumeItemStack(player, false, false);
                    if (this.isClient()) {
                        this.refreshAmulet(player);
                        this.learntInventory.refreshLearntData(player, this.amulet);
                        this.updateScrollButtons();
                        this.gui.func_73876_c();
                    }
                }
            }
            if (!this.container.mergeItemStack((StackableContainer)this, itemstack1, 0, 1, true)) {
                return null;
            }
            slot.func_75220_a(itemstack1, itemstack);
            this.consumptionSlot.shiftTransferred = true;
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, itemstack);
        }
        return itemstack;
    }

    public void onClosed(EntityPlayer player) {
        ItemStack itemstack;
        if (this.isClient()) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
        if ((itemstack = this.consumptionInventory.func_70304_b(0)) != null) {
            if (this.consumptionSlot.shiftTransferred && !(itemstack.func_77973_b() instanceof AmuletOfTransmutation) && this.refreshAmulet(player) && !this.readOnly && this.amulet.consumeItemStack(itemstack, false, false)) {
                this.inventory.saveInventory();
                return;
            }
            player.func_71019_a(itemstack, false);
        }
        this.inventory.saveInventory();
    }

    public void updateScreen() {
        if (this.isClient()) {
            this.gui.func_73876_c();
        }
    }

    public void toggleQuickList(EntityPlayer player, boolean triggerUpdate) {
        if (!this.refreshAmulet(player) || this.readOnly || this.hoveredItemStack == null) {
            return;
        }
        this.amulet.toggleQuickListStack(this.hoveredItemStack, 0, triggerUpdate);
        if (this.isClient()) {
            this.learntInventory.refreshLearntData(player, this.amulet);
            this.updateScrollButtons();
            this.gui.func_73876_c();
        }
    }

    public int getSlotCount() {
        return 6;
    }

    public String getId() {
        return this.id;
    }

    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        for (StackableContainer container1 : containers) {
            if (!UniqueItem.refreshIdChain((EntityPlayer)player, (String)this.id, null, (ArrayList)container1.idChain)) {
                return false;
            }
            if (((AmuletContainer)container1).inventory == null) continue;
            ((AmuletContainer)container1).inventory.refreshInventory();
        }
        return true;
    }

    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        for (StackableContainer container1 : containers) {
            if (((AmuletContainer)container1).inventory == null) continue;
            ((AmuletContainer)container1).inventory.saveInventory();
        }
    }

    public void identifyConsumptionSlotAmulet(EntityPlayer player, int type) {
        ItemStack stack = this.consumptionInventory.func_70301_a(0);
        if (stack == null || !(stack.func_77973_b() instanceof AmuletOfTransmutation)) {
            return;
        }
        String id = Common.requestInventoryIdentifier((EntityPlayer)player, (IInventory)this.consumptionInventory, (int)0);
        BalancedExchange.channel.sendToPlayer(player, (MessageChannel.Message)new PacketHandler.IdentifyConsumptionSlotAmulet(this.getId(), id, type));
    }

    @SideOnly(value=Side.CLIENT)
    public void setConsumptionSlotAmuletIdentifier(EntityPlayer player, String identifier, int type) {
        ItemStack stack = this.consumptionInventory.func_70301_a(0);
        if (stack == null || !(stack.func_77973_b() instanceof AmuletOfTransmutation)) {
            return;
        }
        Common.setInventoryIdentifier((EntityPlayer)player, (IInventory)this.consumptionInventory, (int)0, (String)identifier);
        if (type == 0) {
            this.shareMatter();
        } else if (type == 1) {
            this.consumeItemStack(player, false, true);
        } else if (type == 2) {
            this.consumeItemStack(player, false, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void shareMatter() {
        if (this.readOnly) {
            return;
        }
        ItemStack stack = this.consumptionInventory.func_70301_a(0);
        if (stack == null || !(stack.func_77973_b() instanceof AmuletOfTransmutation)) {
            return;
        }
        if (!UniqueItem.hasIdentifier((ItemStack)stack)) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.IdentifyConsumptionSlotAmulet(this.id, null, 0));
            return;
        }
        if (this.refreshAmulet((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            this.amulet.shareMatter(UniqueItem.getIdentifier((ItemStack)stack), true);
        }
    }

    public void setCreationInventory(EntityPlayer player, Item item, int metadata, boolean isItem) {
        if (isItem) {
            this.itemCreationInventory.set(player, item, metadata);
        } else {
            this.creationInventory.set(player, item, metadata);
        }
    }

    public int getRowSize() {
        return 3;
    }

    static {
        tooltipAmulet = null;
        texture = new ResourceLocation("balancedexchange", "textures/gui/amulet.png");
    }

    private class UpgradeSlot
    extends StackableContainer.ContainerSlot {
        public UpgradeSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4) {
            super((StackableContainer)AmuletContainer.this, player, inventory, par2, par3, par4);
        }

        public void func_75218_e() {
            if (AmuletContainer.this.inventory != null) {
                AmuletContainer.this.inventory.saveInventory();
                if (AmuletContainer.this.isClient()) {
                    AmuletContainer.this.refreshAmulet(this.player);
                    AmuletContainer.this.learntInventory.refreshLearntData(this.player, AmuletContainer.this.amulet);
                }
            }
        }
    }

    private class ItemCreationInventory
    extends CreationInventory {
        private ItemCreationInventory() {
        }

        @Override
        public ItemStack canCreateBlock(int amount) {
            this.createdStack = null;
            if (!canCreateItems) {
                return null;
            }
            if (this.item != null) {
                int matter;
                if (!AmuletContainer.this.refreshAmulet(this.player)) {
                    return null;
                }
                UniqueItemData data = UniqueItemData.get((World)this.player.field_70170_p);
                if (!data.hasRequiredPermission(this.player, AmuletContainer.this.id, 2)) {
                    UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log(this.player);
                    return null;
                }
                this.createdStack = new ItemStack(this.item, amount, this.metadata);
                int cost = AmuletContainer.this.amulet.getBlockCreationCost(this.createdStack, null);
                if (cost * amount > (matter = AmuletContainer.this.amulet.getStoredMatter())) {
                    amount = matter / cost;
                }
                if (this.created + amount > this.createdStack.func_77976_d()) {
                    amount = this.createdStack.func_77976_d() - this.created;
                }
                this.createdStack.field_77994_a = amount;
                if (amount < 1) {
                    this.createdStack = null;
                }
            }
            return this.createdStack;
        }

        @Override
        public void createdBlocks(int amount) {
            if (this.item != null) {
                if (!AmuletContainer.this.refreshAmulet(this.player)) {
                    return;
                }
                UniqueItemData data = UniqueItemData.get((World)this.player.field_70170_p);
                if (!data.hasRequiredPermission(this.player, AmuletContainer.this.id, 2)) {
                    UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log(this.player);
                    return;
                }
                ItemStack createdStack = new ItemStack(this.item, amount, this.metadata);
                int cost = AmuletContainer.this.amulet.getBlockCreationCost(createdStack, null);
                int matter = AmuletContainer.this.amulet.getStoredMatter();
                AmuletContainer.this.amulet.setStoredMatter(matter - cost * amount);
                this.created += amount;
            }
        }
    }

    private class CreationInventory
    extends ConsumptionInventory {
        protected Item item;
        protected int metadata;
        protected int created;
        protected EntityPlayer player;
        protected ItemStack createdStack;

        private CreationInventory() {
            this.item = null;
            this.created = 0;
        }

        public void set(EntityPlayer player, Item item, int metadata) {
            this.player = player;
            this.item = item;
            this.metadata = metadata;
            this.created = 0;
        }

        @Override
        public ItemStack func_70301_a(int i) {
            if (this.item == null) {
                return null;
            }
            return this.canCreateBlock(1);
        }

        public void onSlotChange(ItemStack par1ItemStack, ItemStack par2ItemStack) {
            int i;
            if (par1ItemStack != null && par2ItemStack != null && par1ItemStack.func_77973_b() == par2ItemStack.func_77973_b() && (i = par2ItemStack.field_77994_a - par1ItemStack.field_77994_a) > 0) {
                this.createdBlocks(i);
            }
        }

        @Override
        public ItemStack func_70298_a(int slot, int amounto) {
            this.createdStack = this.canCreateBlock(amounto);
            if (this.createdStack != null) {
                this.createdBlocks(this.createdStack.field_77994_a);
            }
            return this.createdStack;
        }

        public ItemStack canCreateBlock(int amounto) {
            this.createdStack = null;
            if (this.item != null) {
                int matter;
                int amount = amounto;
                if (!AmuletContainer.this.refreshAmulet(this.player) || !AmuletContainer.this.amulet.canQuickCreateBlocks(null)) {
                    return this.createdStack;
                }
                this.createdStack = new ItemStack(this.item, amount, this.metadata);
                int cost = AmuletContainer.this.amulet.getBlockCreationCost(this.createdStack, null);
                if (cost * amount > (matter = AmuletContainer.this.amulet.getStoredMatter())) {
                    amount = matter / cost;
                }
                if (this.created + amount > this.createdStack.func_77976_d()) {
                    amount = this.createdStack.func_77976_d() - this.created;
                }
                this.createdStack.field_77994_a = amount;
                if (amount < 1) {
                    this.createdStack = null;
                    return this.createdStack;
                }
            }
            return this.createdStack;
        }

        public void createdBlocks(int amount) {
            if (this.item != null) {
                if (!AmuletContainer.this.refreshAmulet(this.player)) {
                    return;
                }
                ItemStack createdStack = new ItemStack(this.item, amount, this.metadata);
                int cost = AmuletContainer.this.amulet.getBlockCreationCost(createdStack, null);
                int matter = AmuletContainer.this.amulet.getStoredMatter();
                AmuletContainer.this.amulet.setStoredMatter(matter - cost * amount);
                this.created += amount;
            }
        }

        @Override
        public ItemStack func_70304_b(int i) {
            return null;
        }

        @Override
        public String func_145825_b() {
            return "CreationSlot-Inventory";
        }

        @Override
        public boolean func_94041_b(int slot, ItemStack stack) {
            return false;
        }
    }

    private class CreationSlot
    extends StackableContainer.ContainerSlot {
        public CreationSlot(EntityPlayer player, CreationInventory inventory, int par2, int par3, int par4) {
            super((StackableContainer)AmuletContainer.this, player, (IInventory)inventory, par2, par3, par4);
        }

        public void func_75220_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
            ((CreationInventory)this.field_75224_c).onSlotChange(par1ItemStack, par2ItemStack);
        }
    }

    private class ConsumptionInventory
    implements IInventory {
        private ItemStack stack;

        private ConsumptionInventory() {
        }

        public int func_70302_i_() {
            return 1;
        }

        public ItemStack func_70301_a(int i) {
            return this.stack;
        }

        public ItemStack func_70298_a(int slot, int amount) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack != null) {
                if (stack.field_77994_a <= amount) {
                    this.func_70299_a(slot, null);
                } else {
                    stack = stack.func_77979_a(amount);
                    if (stack.field_77994_a == 0) {
                        this.func_70299_a(slot, null);
                    }
                }
            }
            return stack;
        }

        public ItemStack func_70304_b(int i) {
            ItemStack s = this.stack;
            this.stack = null;
            return s;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.stack = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
        }

        public String func_145825_b() {
            return "ConsumptionSlot-Inventory";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer entityplayer) {
            return true;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return true;
        }
    }

    public class ConsumptionSlot
    extends StackableContainer.ContainerSlot {
        public String lastUuid;
        public boolean shiftTransferred;

        public ConsumptionSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4) {
            super((StackableContainer)AmuletContainer.this, player, inventory, par2, par3, par4);
            this.lastUuid = "none";
            this.shiftTransferred = false;
        }

        public boolean func_75214_a(ItemStack stack) {
            return !AmuletContainer.this.readOnly && super.func_75214_a(stack);
        }

        public void func_75218_e() {
            super.func_75218_e();
            AmuletContainer.this.updateScreen();
            this.shiftTransferred = false;
            if (AmuletContainer.this.isClient()) {
                ((AmuletContainer)AmuletContainer.this).consumeButton.field_146126_j = new Translatable("button.consume", new Object[0]).translate();
            }
            if (AmuletContainer.this.amulet == null) {
                return;
            }
            ItemStack consumptionStack = this.func_75211_c();
            if (consumptionStack == null) {
                this.lastUuid = "none";
                if (AmuletContainer.this.isClient()) {
                    ((AmuletContainer)AmuletContainer.this).consumeButton.field_146124_l = false;
                }
                return;
            }
            if (consumptionStack.func_77973_b() == BalancedExchange.amulet) {
                String uuid = UniqueItem.getIdentifier((ItemStack)consumptionStack);
                if (uuid.equals(this.lastUuid)) {
                    return;
                }
                this.lastUuid = uuid;
                if (AmuletContainer.this.isClient()) {
                    AmuletContainer.this.shareMatter();
                }
                AmuletContainer.this.updateScreen();
            } else {
                this.lastUuid = "none";
            }
            if (AmuletContainer.this.isClient()) {
                ((AmuletContainer)AmuletContainer.this).consumeButton.field_146124_l = AmuletStack.canConsumeItemStack(this.player, consumptionStack);
                if (consumptionStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150357_h)) {
                    ((AmuletContainer)AmuletContainer.this).consumeButton.field_146124_l = true;
                    ((AmuletContainer)AmuletContainer.this).consumeButton.field_146126_j = new Translatable("button.master", new Object[0]).translate();
                }
            }
            AmuletContainer.this.updateScreen();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LearntInventory {
        public static final int pageSize = 4;
        public int scrollPos = 0;
        public ArrayList<ItemStack> learntBlocks = new ArrayList();
        private Set<String> quickList = new HashSet<String>();

        public LearntInventory(EntityPlayer player, AmuletStack amulet) {
            this.refreshLearntData(player, amulet);
        }

        public void refreshLearntData(EntityPlayer player, AmuletStack amulet) {
            this.learntBlocks.clear();
            if (amulet == null) {
                return;
            }
            amulet.getLearnedItems(this.learntBlocks);
            this.quickList.clear();
            ArrayList<ItemStack> t = amulet.getQuickList();
            for (ItemStack aT : t) {
                this.quickList.add("item" + AmuletStack.getDescriptor(aT.func_77973_b()) + "dam" + aT.func_77960_j());
            }
            if (this.learntBlocks.isEmpty()) {
                this.learntBlocks.add(AmuletOfTransmutation.defaultItem);
            }
            Comparator<ItemStack> _order = AmuletOfTransmutation.valueOrder;
            if (alphabeticallySorted) {
                _order = AmuletOfTransmutation.alphabeticalOrder;
            }
            final Comparator<ItemStack> order = _order;
            Collections.sort(this.learntBlocks, new Comparator<ItemStack>(){

                @Override
                public int compare(ItemStack o1, ItemStack o2) {
                    if (o1.field_77994_a < o2.field_77994_a) {
                        return 1;
                    }
                    if (o1.field_77994_a > o2.field_77994_a) {
                        return -1;
                    }
                    return order.compare(o1, o2);
                }
            });
            if (this.scrollPos + 4 > (this.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7) {
                this.scrollPos = (this.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7 - 4;
            }
            if (this.scrollPos < 0) {
                this.scrollPos = 0;
            }
        }

        public ItemStack getStackAtIndex(int i) {
            if (i >= 0 && i + this.scrollPos * 7 < this.learntBlocks.size()) {
                return this.learntBlocks.get(i + this.scrollPos * 7);
            }
            return null;
        }

        public ItemStack getItemAtIndex(int i) {
            if (i + this.scrollPos * 7 >= this.learntBlocks.size() && i + this.scrollPos * 7 - this.learntBlocks.size() < AmuletOfTransmutation.dispensableItemList.size()) {
                return AmuletOfTransmutation.dispensableItemList.get(i + this.scrollPos * 7 - this.learntBlocks.size());
            }
            return null;
        }

        public void scroll(boolean scrollDown, boolean scrollPage) {
            if (scrollDown) {
                if (scrollPage) {
                    this.scrollBy(3);
                } else {
                    this.scrollBy(1);
                }
            } else if (scrollPage) {
                this.scrollBy(-3);
            } else {
                this.scrollBy(-1);
            }
        }

        private void scrollBy(int i) {
            this.scrollPos += i;
            if (this.scrollPos + 4 > (this.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7) {
                this.scrollPos = (this.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7 - 4;
            }
            if (this.scrollPos < 0) {
                this.scrollPos = 0;
            }
        }

        public void setScrollPercent(float i) {
            if (i < 0.0f) {
                i = 0.0f;
            }
            if (i > 1.0f) {
                i = 1.0f;
            }
            this.scrollPos = Math.round((float)((this.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7 - 4) * i);
            if (this.scrollPos + 4 > (this.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7) {
                this.scrollPos = (this.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7 - 4;
            }
            if (this.scrollPos < 0) {
                this.scrollPos = 0;
            }
        }

        public boolean canScrollUp() {
            return this.scrollPos > 0;
        }

        public boolean canScrollDown() {
            return this.scrollPos + 4 < (this.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7;
        }

        public boolean canScroll() {
            return 4 < (this.learntBlocks.size() + 6 + AmuletOfTransmutation.dispensableItemList.size()) / 7;
        }
    }
}

