/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange.blocks;

import brad16840.balancedexchange.BalancedExchange;
import brad16840.balancedexchange.items.AmuletOfTransmutation;
import brad16840.common.BlockPos;
import brad16840.common.Translatable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockOfReactivity
extends Block {
    public static boolean isDestroyingChain = false;
    public static int blocksDestroyed = 0;
    public static boolean transparent = true;
    public static boolean _canClimbReactivityBlocks = false;
    public static boolean canClimbReactivityBlocks;
    public static boolean renderRadiationBlocks;
    public static boolean useAlternateSound;
    public String field_149770_b;
    public static final Material reactiveMaterial;

    public BlockOfReactivity(String unlocalizedName) {
        super(reactiveMaterial);
        this.field_149770_b = unlocalizedName;
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149711_c(0.5f);
        if (useAlternateSound) {
            this.func_149672_a(Block.field_149775_l);
        } else {
            this.func_149672_a(new Block.SoundType("stone", -0.75f, 1.5f){

                public String func_150495_a() {
                    return "dig.glass";
                }

                public String func_150496_b() {
                    return "step.stone";
                }

                public float func_150497_c() {
                    return 0.5f / (float)Math.min(blocksDestroyed * blocksDestroyed, 1) - 1.0f;
                }
            });
        }
        this.func_149663_c(unlocalizedName);
        this.func_149713_g(1);
        this.setHarvestLevel("pickaxe", 0);
        this.setHarvestLevel("shovel", 0);
        this.setHarvestLevel("axe", 0);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("balancedexchange:" + this.field_149770_b + (transparent ? ".transparent" : ""));
        BalancedExchange.reactiveGlow.func_149651_a(iconRegister);
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)this);
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public boolean func_149662_c() {
        if (transparent) {
            return false;
        }
        return super.func_149662_c();
    }

    public boolean func_149686_d() {
        if (transparent) {
            return false;
        }
        return super.func_149686_d();
    }

    public int func_149701_w() {
        if (transparent) {
            return 1;
        }
        return super.func_149701_w();
    }

    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (transparent && par1IBlockAccess.func_147439_a(par2, par3, par4) == this) {
            return false;
        }
        return super.func_149646_a(par1IBlockAccess, par2, par3, par4, par5);
    }

    public void func_149695_a(World world, int x, int y, int z, Block otherBlock) {
        Block block = world.func_147439_a(x, y, z);
        if (block != this) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (otherBlock == this) {
            if (isDestroyingChain) {
                return;
            }
            if (AmuletOfTransmutation.reactivityBlocksCanBeTransmuted && world.func_147439_a(x + 1, y, z) != Blocks.field_150350_a && world.func_147439_a(x - 1, y, z) != Blocks.field_150350_a && world.func_147439_a(x, y + 1, z) != Blocks.field_150350_a && world.func_147439_a(x, y - 1, z) != Blocks.field_150350_a && world.func_147439_a(x, y, z + 1) != Blocks.field_150350_a && world.func_147439_a(x, y, z - 1) != Blocks.field_150350_a) {
                return;
            }
            isDestroyingChain = true;
            blocksDestroyed = 1;
            LinkedList<BlockPos> unvisited = new LinkedList<BlockPos>();
            unvisited.add(new BlockPos(x, y, z));
            HashSet<BlockPos> known = new HashSet<BlockPos>();
            while (unvisited.size() > 0) {
                BlockPos current = (BlockPos)unvisited.pop();
                BlockPos neighbour = null;
                for (int side = 0; side < 6; ++side) {
                    neighbour = current.getNeighbour(side);
                    if (!neighbour.blockEquals(world, block, 0, true) || known.contains(neighbour)) continue;
                    known.add(neighbour);
                    unvisited.add(neighbour);
                }
                world.func_147480_a(current.x, current.y, current.z, false);
                ++blocksDestroyed;
            }
            isDestroyingChain = false;
        } else {
            this.createReactivity(world, x, y, z);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        blocksDestroyed = 1;
        if (super.removedByPlayer(world, player, x, y, z, willHarvest)) {
            if (blocksDestroyed > 50) {
                new Translatable("message.destroyedblocks", new Object[]{blocksDestroyed}).send(player);
            }
            return true;
        }
        return false;
    }

    private void createReactivity(World world, int x, int y, int z) {
        if (world.func_147439_a(x + 1, y, z) == Blocks.field_150350_a) {
            world.func_147465_d(x + 1, y, z, (Block)BalancedExchange.reactiveGlow, 0, 2);
        }
        if (world.func_147439_a(x - 1, y, z) == Blocks.field_150350_a) {
            world.func_147465_d(x - 1, y, z, (Block)BalancedExchange.reactiveGlow, 0, 2);
        }
        if (world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a) {
            world.func_147465_d(x, y + 1, z, (Block)BalancedExchange.reactiveGlow, 0, 2);
        }
        if (world.func_147439_a(x, y - 1, z) == Blocks.field_150350_a) {
            world.func_147465_d(x, y - 1, z, (Block)BalancedExchange.reactiveGlow, 0, 2);
        }
        if (world.func_147439_a(x, y, z + 1) == Blocks.field_150350_a) {
            world.func_147465_d(x, y, z + 1, (Block)BalancedExchange.reactiveGlow, 0, 2);
        }
        if (world.func_147439_a(x, y, z - 1) == Blocks.field_150350_a) {
            world.func_147465_d(x, y, z - 1, (Block)BalancedExchange.reactiveGlow, 0, 2);
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float par6, float par7, float par8, int par9) {
        this.createReactivity(world, x, y, z);
        return par9;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    static {
        renderRadiationBlocks = false;
        useAlternateSound = false;
        reactiveMaterial = new ReactiveMaterial(MapColor.field_151669_i);
    }

    public static class Radiation
    extends Block {
        public String field_149770_b;

        public Radiation(String unlocalizedName) {
            super(Material.field_151579_a);
            this.field_149770_b = unlocalizedName;
            this.func_149663_c(unlocalizedName);
        }

        public boolean func_149686_d() {
            return false;
        }

        public void func_149651_a(IIconRegister iconRegister) {
            this.field_149761_L = iconRegister.func_94245_a("balancedexchange:" + this.field_149770_b);
        }

        public int func_149701_w() {
            if (renderRadiationBlocks) {
                return 0;
            }
            return -1;
        }

        public boolean canHarvestBlock(EntityPlayer player, int meta) {
            return false;
        }

        public int func_149745_a(Random par1Random) {
            return 0;
        }

        public Item func_149650_a(int par1, Random par2Random, int par3) {
            return Item.func_150898_a((Block)Blocks.field_150346_d);
        }

        protected ItemStack func_149644_j(int par1) {
            return null;
        }

        public boolean func_149659_a(Explosion par1Explosion) {
            return false;
        }

        public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
            return canClimbReactivityBlocks;
        }

        public boolean isAir(IBlockAccess world, int x, int y, int z) {
            return true;
        }

        public boolean func_149662_c() {
            return false;
        }

        public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
            return null;
        }

        public void func_149695_a(World world, int x, int y, int z, Block otherBlock) {
            Block block = world.func_147439_a(x, y, z);
            if (block != this) {
                return;
            }
            if (world.field_72995_K) {
                return;
            }
            if (otherBlock == BalancedExchange.blockOfReactivity) {
                if (world.func_147439_a(x + 1, y, z) == BalancedExchange.blockOfReactivity || world.func_147439_a(x - 1, y, z) == BalancedExchange.blockOfReactivity || world.func_147439_a(x, y + 1, z) == BalancedExchange.blockOfReactivity || world.func_147439_a(x, y - 1, z) == BalancedExchange.blockOfReactivity || world.func_147439_a(x, y, z + 1) == BalancedExchange.blockOfReactivity || world.func_147439_a(x, y, z - 1) == BalancedExchange.blockOfReactivity) {
                    return;
                }
                world.func_147468_f(x, y, z);
            }
        }

        public int func_149645_b() {
            return -1;
        }

        public boolean func_149678_a(int p_149678_1_, boolean p_149678_2_) {
            return false;
        }

        public void func_149690_a(World p_149690_1_, int p_149690_2_, int p_149690_3_, int p_149690_4_, int p_149690_5_, float p_149690_6_, int p_149690_7_) {
        }
    }

    public static class ReactiveMaterial
    extends Material {
        private boolean isTranslucent = !transparent;

        public ReactiveMaterial(MapColor par1MapColor) {
            super(par1MapColor);
        }

        public boolean func_76228_b() {
            return false;
        }
    }
}

