/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange;

import brad16840.balancedexchange.AmuletStack;
import brad16840.balancedexchange.BalancedExchange;
import brad16840.balancedexchange.items.AmuletOfTransmutation;
import brad16840.balancedexchange.items.AreaUpgrade;
import brad16840.common.BlockPos;
import brad16840.common.Translatable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TransmutationBlockPos
extends BlockPos {
    public TransmutationBlockPos(int x, int y, int z) {
        super(x, y, z);
    }

    public static TransmutationBlockPos create(BlockPos block) {
        return new TransmutationBlockPos(block.x, block.y, block.z);
    }

    public boolean canBecomeBlock(TransmutationState state, Block newBlock, boolean allowCollisions, Entity allowCollisionsWithEntity, TransmutationResult result) {
        AmuletOfTransmutation.MPBEntry e = AmuletOfTransmutation.getMPBEntry(AmuletStack.getDescriptor(state.block), state.metadata);
        if (e.created < -121 && e.created > -125) {
            result.customErrorMessage = new Translatable("problem.transmute.untransmutable", new Object[0]);
            return false;
        }
        if (!AmuletOfTransmutation.canPlayerDestroyBlock(state.stack, state.player, this.x, this.y, this.z, 0)) {
            result.customErrorMessage = new Translatable("problem.transmute.indestructable", new Object[0]);
            return false;
        }
        Block oldBlock = state.world.func_147439_a(this.x, this.y, this.z);
        AxisAlignedBB axisalignedbb = newBlock.func_149668_a(state.world, this.x, this.y, this.z);
        if (allowCollisions) {
            axisalignedbb = null;
        }
        if (axisalignedbb != null && !state.world.func_72917_a(axisalignedbb, allowCollisionsWithEntity)) {
            result.customErrorMessage = new Translatable("problem.transmute.occupied", new Object[0]);
            return false;
        }
        if (oldBlock != null && (oldBlock == Blocks.field_150358_i || oldBlock == Blocks.field_150355_j || oldBlock == Blocks.field_150356_k || oldBlock == Blocks.field_150353_l || oldBlock == Blocks.field_150480_ab || oldBlock.func_149688_o().func_76222_j())) {
            oldBlock = null;
        }
        if (oldBlock != null && oldBlock.isReplaceable((IBlockAccess)state.world, this.x, this.y, this.z)) {
            oldBlock = null;
        }
        return oldBlock != null && oldBlock.func_149688_o() == Material.field_151594_q && newBlock == Blocks.field_150467_bQ ? true : newBlock != null;
    }

    public void getTransmutation(TransmutationState state, TransmutationResult result, boolean left) {
        state.setBlockType(this);
        ItemStack activeBlock = state.amulet.getActiveItem(left);
        Block block = Block.func_149634_a((Item)activeBlock.func_77973_b());
        if (!(state.block != block || state.metadata != activeBlock.func_77960_j() || state.block instanceof BlockRotatedPillar || state.block instanceof BlockStairs || state.amuletHasStabilityUpgrade(left))) {
            return;
        }
        int cost = state.amulet.getBlockCreationCost(activeBlock, left);
        if (state.block == BalancedExchange.blockOfStability) {
            if (result.blocks.size() > 0 || block == BalancedExchange.reactiveGlow) {
                return;
            }
            if (state.currentMatter + result.matterGained < cost) {
                ++result.unaffordableBlocks;
            } else {
                activeBlock.field_77994_a = 1;
                result.itemsDropped.add(activeBlock);
                ++result.blocksCreated;
                result.matterGained -= cost;
                result.matterInvolved += cost;
                result.blocks.add(null);
            }
            return;
        }
        if (!this.canBecomeBlock(state, block, false, null, result)) {
            ++result.blocksFailed;
            return;
        }
        this.canTransmuteBlock(state, cost + result.blocks.size(), result, new Translatable(activeBlock.func_77977_a() + ".name", new Object[0]), left);
    }

    public void getTransmutationChain(TransmutationState state, int maximumBlocks, TransmutationResult result, boolean left) {
        state.setBlockType(this);
        ItemStack activeBlock = state.amulet.getActiveItem(left);
        Block block = Block.func_149634_a((Item)activeBlock.func_77973_b());
        if (state.block == block && state.metadata == activeBlock.func_77960_j() && !(state.block instanceof BlockRotatedPillar) && !(state.block instanceof BlockStairs)) {
            return;
        }
        ItemStack s = AmuletStack.getUpgrade(state.player, state.amulet.getIdentifier(), AmuletStack.filter_chainUpgrade, left);
        boolean wildcardMode = s != null && s.func_77960_j() != 0;
        HashSet<TransmutationBlockPos> known = new HashSet<TransmutationBlockPos>(result.blocks);
        if (known.contains((Object)this)) {
            return;
        }
        known.add(this);
        LinkedList<TransmutationBlockPos> unvisited = new LinkedList<TransmutationBlockPos>();
        unvisited.add(this);
        int cost = state.amulet.getBlockCreationCost(activeBlock, left);
        if (state.block == BalancedExchange.blockOfStability) {
            int volume;
            if (result.blocks.size() > 0 || block == BalancedExchange.reactiveGlow) {
                return;
            }
            int canAfford = volume = this.getChain(state.world, maximumBlocks, wildcardMode).size();
            if (state.currentMatter + result.matterGained < cost * volume) {
                canAfford = (state.currentMatter + result.matterGained) / cost;
                result.unaffordableBlocks += volume - canAfford;
            }
            if (canAfford > 0) {
                activeBlock.field_77994_a = canAfford;
                result.itemsDropped.add(activeBlock);
                result.blocksCreated += canAfford;
                result.matterGained -= cost * canAfford;
                result.matterInvolved += cost * canAfford;
                result.blocks.add(null);
            }
            return;
        }
        Translatable targetName = new Translatable(activeBlock.func_77977_a() + ".name", new Object[0]);
        while (unvisited.size() > 0) {
            TransmutationBlockPos current = (TransmutationBlockPos)((Object)unvisited.pop());
            if (!current.canBecomeBlock(state, block, false, null, result)) {
                ++result.blocksFailed;
                continue;
            }
            if (!current.canTransmuteBlock(state, cost + result.blocks.size() / 2, result, targetName, left)) continue;
            if (result.blocks.size() >= maximumBlocks) {
                return;
            }
            for (int side = 0; side < 6; ++side) {
                TransmutationBlockPos neighbour = TransmutationBlockPos.create(current.getNeighbour(side));
                if (!neighbour.blockEquals(state.world, state.block, state.metadata, wildcardMode) || known.contains((Object)neighbour)) continue;
                known.add(neighbour);
                unvisited.add(neighbour);
            }
        }
    }

    public void getTransmutationConfinedChain(TransmutationState state, TransmutationResult result, boolean left) {
        state.setBlockType(this);
        ItemStack activeBlock = state.amulet.getActiveItem(left);
        Block block = Block.func_149634_a((Item)activeBlock.func_77973_b());
        if (state.block == block && state.metadata == activeBlock.func_77960_j() && !(state.block instanceof BlockRotatedPillar) && !(state.block instanceof BlockStairs)) {
            return;
        }
        ItemStack s = AmuletStack.getUpgrade(state.player, state.amulet.getIdentifier(), AmuletStack.filter_chainUpgrade, left);
        boolean wildcardMode = s != null && s.func_77960_j() != 0;
        HashSet<TransmutationBlockPos> known = new HashSet<TransmutationBlockPos>(result.blocks);
        if (known.contains((Object)this)) {
            return;
        }
        known.add(this);
        LinkedList<TransmutationBlockPos> unvisited = new LinkedList<TransmutationBlockPos>();
        unvisited.add(this);
        ItemStack areaUpgrade = state.amulet.getAreaOfEffect(state.player, state.amulet.getIdentifier(), left);
        state.areaDirection = AreaUpgrade.getAreaDirection(state.player, areaUpgrade);
        int[] area = AreaUpgrade.orientateArea(state.player, areaUpgrade);
        for (int i = 0; i < area.length; ++i) {
            int n = i;
            area[n] = area[n] + this.getPositionOfSide(i);
        }
        int cost = state.amulet.getBlockCreationCost(activeBlock, left);
        if (state.block == BalancedExchange.blockOfStability) {
            int volume;
            if (result.blocks.size() > 0 || block == BalancedExchange.reactiveGlow) {
                return;
            }
            int canAfford = volume = this.getChain(state.world, 729, wildcardMode).size();
            if (state.currentMatter + result.matterGained < cost * volume) {
                canAfford = (state.currentMatter + result.matterGained) / cost;
                result.unaffordableBlocks += volume - canAfford;
            }
            if (canAfford > 0) {
                activeBlock.field_77994_a = canAfford;
                result.itemsDropped.add(activeBlock);
                result.blocksCreated += canAfford;
                result.matterGained -= cost * canAfford;
                result.matterInvolved += cost * canAfford;
                result.blocks.add(null);
            }
            return;
        }
        Translatable targetName = new Translatable(activeBlock.func_77977_a() + ".name", new Object[0]);
        while (unvisited.size() > 0) {
            TransmutationBlockPos current = (TransmutationBlockPos)((Object)unvisited.pop());
            if (!current.withinArea(area)) continue;
            if (!current.canBecomeBlock(state, block, false, null, result)) {
                ++result.blocksFailed;
                continue;
            }
            if (!current.canTransmuteBlock(state, cost + (int)Math.pow(result.blocks.size() * 2 / 3, 0.5), result, targetName, left)) continue;
            if (result.blocks.size() >= 729) {
                return;
            }
            for (int side = 0; side < 6; ++side) {
                TransmutationBlockPos neighbour = TransmutationBlockPos.create(current.getNeighbour(side));
                if (!neighbour.blockEquals(state.world, state.block, state.metadata, wildcardMode) || known.contains((Object)neighbour)) continue;
                known.add(neighbour);
                unvisited.add(neighbour);
            }
        }
    }

    public int getAreaCost(TransmutationBlockPos other) {
        return Math.abs(this.x - other.x) + Math.abs(this.y - other.y) + Math.abs(this.z - other.z);
    }

    public int getRestrictedAreaCost(TransmutationBlockPos other) {
        return Math.max(Math.max(Math.abs(this.x - other.x), Math.abs(this.y - other.y)), Math.abs(this.z - other.z));
    }

    public void getTransmutationArea(TransmutationState state, TransmutationResult result, boolean fillAir, boolean left) {
        state.setBlockType(this);
        ItemStack activeBlock = state.amulet.getActiveItem(left);
        Block block = Block.func_149634_a((Item)activeBlock.func_77973_b());
        int activeMetadata = activeBlock.func_77960_j();
        ItemStack areaUpgrade = state.amulet.getAreaOfEffect(state.player, state.amulet.getIdentifier(), left);
        state.areaDirection = AreaUpgrade.getAreaDirection(state.player, areaUpgrade);
        int[] area = AreaUpgrade.orientateArea(state.player, areaUpgrade);
        for (int i = 0; i < area.length; ++i) {
            int n = i;
            area[n] = area[n] + this.getPositionOfSide(i);
        }
        int[] shifts = new int[]{-1, 1, -1, 1, -1, 1};
        HashSet<TransmutationBlockPos> known = new HashSet<TransmutationBlockPos>(result.blocks);
        known.add(this);
        LinkedList<TransmutationBlockPos> unvisited = new LinkedList<TransmutationBlockPos>();
        unvisited.add(this);
        int cost = state.amulet.getBlockCreationCost(activeBlock, left);
        if (state.block == BalancedExchange.blockOfStability) {
            int volume;
            if (result.blocks.size() > 0 || block == BalancedExchange.reactiveGlow) {
                return;
            }
            int canAfford = volume = (1 + area[1] - area[0]) * (1 + area[3] - area[2]) * (1 + area[5] - area[4]);
            if (state.currentMatter + result.matterGained < cost * volume) {
                canAfford = (state.currentMatter + result.matterGained) / cost;
                result.unaffordableBlocks += volume - canAfford;
            }
            if (canAfford > 0) {
                activeBlock.field_77994_a = canAfford;
                result.itemsDropped.add(activeBlock);
                result.blocksCreated += canAfford;
                result.matterGained -= cost * canAfford;
                result.matterInvolved += cost * canAfford;
                result.blocks.add(null);
            }
            return;
        }
        Translatable targetName = new Translatable(activeBlock.func_77977_a() + ".name", new Object[0]);
        while (unvisited.size() > 0) {
            TransmutationBlockPos current = (TransmutationBlockPos)((Object)unvisited.pop());
            state.setBlockType(current);
            if (state.block == block && state.metadata == activeMetadata && !(state.block instanceof BlockRotatedPillar) && !(state.block instanceof BlockStairs) || (state.block == Blocks.field_150350_a || state.block == null) && !fillAir) {
                ++result.blocksSkipped;
            } else if (state.block == BalancedExchange.blockOfStability || !current.canBecomeBlock(state, block, false, null, result)) {
                ++result.blocksFailed;
            } else {
                current.canTransmuteBlock(state, cost + this.getAreaCost(current), result, targetName, left);
            }
            for (int side = 0; side < 6; ++side) {
                int neighbourPos = current.getPositionOfSide(side) + shifts[side];
                if (side % 2 == 1 ? neighbourPos > area[side] : neighbourPos < area[side]) continue;
                TransmutationBlockPos neighbour = new TransmutationBlockPos(current.x, current.y, current.z);
                neighbour.setPositionOfSide(side, neighbourPos);
                if (known.contains((Object)neighbour)) continue;
                known.add(neighbour);
                unvisited.add(neighbour);
            }
        }
    }

    public void getTransmutationConversion(TransmutationState state, TransmutationResult result, boolean left) {
        state.setBlockType(this);
        ItemStack activeBlock = state.amulet.getActiveItem(left);
        Block block = Block.func_149634_a((Item)activeBlock.func_77973_b());
        Block target = state.world.func_147439_a(this.x, this.y, this.z);
        int targetMetadata = state.world.func_72805_g(this.x, this.y, this.z);
        if (target.isAir((IBlockAccess)state.world, this.x, this.y, this.z)) {
            target = Blocks.field_150350_a;
            targetMetadata = 0;
        }
        if (target == block && targetMetadata == activeBlock.func_77960_j() && !(block instanceof BlockRotatedPillar) && !(block instanceof BlockStairs)) {
            return;
        }
        ItemStack s = AmuletStack.getUpgrade(state.player, state.amulet.getIdentifier(), AmuletStack.filter_chainUpgrade, left);
        boolean wildcardMode = s != null && s.func_77960_j() != 0;
        ItemStack areaUpgrade = state.amulet.getAreaOfEffect(state.player, state.amulet.getIdentifier(), left);
        state.areaDirection = AreaUpgrade.getAreaDirection(state.player, areaUpgrade);
        int[] area = AreaUpgrade.orientateArea(state.player, areaUpgrade);
        for (int i = 0; i < area.length; ++i) {
            int n = i;
            area[n] = area[n] + this.getPositionOfSide(i);
        }
        int[] shifts = new int[]{-1, 1, -1, 1, -1, 1};
        HashSet<TransmutationBlockPos> known = new HashSet<TransmutationBlockPos>(result.blocks);
        known.add(this);
        LinkedList<TransmutationBlockPos> unvisited = new LinkedList<TransmutationBlockPos>();
        unvisited.add(this);
        int cost = state.amulet.getBlockCreationCost(activeBlock, left);
        if (state.block == BalancedExchange.blockOfStability) {
            int volume;
            if (result.blocks.size() > 0 || block == BalancedExchange.reactiveGlow) {
                return;
            }
            int canAfford = volume = (1 + area[1] - area[0]) * (1 + area[3] - area[2]) * (1 + area[5] - area[4]);
            if (state.currentMatter + result.matterGained < cost * volume) {
                canAfford = (state.currentMatter + result.matterGained) / cost;
                result.unaffordableBlocks += volume - canAfford;
            }
            if (canAfford > 0) {
                activeBlock.field_77994_a = canAfford;
                result.itemsDropped.add(activeBlock);
                result.blocksCreated += canAfford;
                result.matterGained -= cost * canAfford;
                result.matterInvolved += cost * canAfford;
                result.blocks.add(null);
            }
            return;
        }
        Translatable targetName = new Translatable(activeBlock.func_77977_a() + ".name", new Object[0]);
        while (unvisited.size() > 0) {
            TransmutationBlockPos current = (TransmutationBlockPos)((Object)unvisited.pop());
            state.setBlockType(current);
            if (state.block == target && (wildcardMode || state.metadata == targetMetadata)) {
                if (!current.canBecomeBlock(state, block, false, null, result)) {
                    ++result.blocksFailed;
                } else {
                    current.canTransmuteBlock(state, cost + this.getRestrictedAreaCost(current), result, targetName, left);
                }
            }
            for (int side = 0; side < 6; ++side) {
                int neighbourPos = current.getPositionOfSide(side) + shifts[side];
                if (side % 2 == 1 ? neighbourPos > area[side] : neighbourPos < area[side]) continue;
                TransmutationBlockPos neighbour = new TransmutationBlockPos(current.x, current.y, current.z);
                neighbour.setPositionOfSide(side, neighbourPos);
                if (known.contains((Object)neighbour)) continue;
                known.add(neighbour);
                unvisited.add(neighbour);
            }
        }
    }

    public static int getSurveyRechargeAmount(TransmutationState state, int cost, boolean left) {
        int amount = (int)(4.0 * Math.sqrt(cost) * AmuletOfTransmutation.rechargeScale * state.amulet.getRechargeEfficiency(left));
        if (amount < AmuletOfTransmutation.minimumRechargeTime) {
            amount = AmuletOfTransmutation.minimumRechargeTime;
        }
        return amount;
    }

    public void surveyArea(TransmutationState state, int sideHit, boolean left) {
        int blocks = 0;
        int emptyBlocks = 0;
        int liquidBlocks = 0;
        int maximumDrop = 0;
        int matter = 0;
        int cost = state.amulet.getSurveyCost(state.player);
        if (cost > state.currentMatter) {
            new Translatable("problem.cantaffordsurvey", new Object[]{cost}).send(state.player);
            return;
        }
        state.setBlockType(this);
        state.amulet.setStoredMatter(state.currentMatter - cost);
        int[] area = state.amulet.getSurveyArea(state.player, this, sideHit);
        for (int x = area[0]; x <= area[3]; ++x) {
            for (int y = area[1]; y <= area[4]; ++y) {
                for (int z = area[2]; z <= area[5]; ++z) {
                    ++blocks;
                    state.setBlockType(new TransmutationBlockPos(x, y, z));
                    if (state.block == null || state.block.isAir((IBlockAccess)state.world, x, y, z)) {
                        ++emptyBlocks;
                        continue;
                    }
                    if (state.block.func_149688_o().func_76224_d()) {
                        ++liquidBlocks;
                        continue;
                    }
                    ArrayList newItems = state.block.getDrops(state.world, x, y, z, state.metadata, 0);
                    int drop = 0;
                    for (ItemStack item1 : newItems) {
                        if (!AmuletStack.canConsumeItemStack(state.player, item1)) continue;
                        drop += AmuletStack.getMPBConsumed(state.player, state.world, item1) * item1.field_77994_a;
                    }
                    matter += drop;
                    if (drop <= maximumDrop) continue;
                    maximumDrop = drop;
                }
            }
        }
        int solidBlocks = blocks - emptyBlocks - liquidBlocks;
        new Translatable("message.surveyresult", new Object[]{100 * emptyBlocks / blocks, 100 * liquidBlocks / blocks, 100 * solidBlocks / blocks, (double)matter / (double)(solidBlocks == 0 ? 1 : solidBlocks), maximumDrop}).send(state.player);
    }

    public static ItemStack createStackedBlock(Block block, int par1) {
        if (block instanceof BlockQuartz) {
            if (par1 == 3 || par1 == 4) {
                return new ItemStack(block, 1, 2);
            }
        } else if (block == Blocks.field_150346_d) {
            if (par1 == 1) {
                par1 = 0;
            }
        } else {
            if (block instanceof BlockWoodSlab) {
                return new ItemStack((Block)Blocks.field_150376_bx, 2, par1 & 7);
            }
            if (block instanceof BlockStoneSlab) {
                return new ItemStack((Block)Blocks.field_150333_U, 2, par1 & 7);
            }
            if (block instanceof BlockSilverfish) {
                switch (par1) {
                    case 1: {
                        return new ItemStack(Blocks.field_150347_e);
                    }
                    case 2: {
                        return new ItemStack(Blocks.field_150417_aV);
                    }
                    case 3: {
                        return new ItemStack(Blocks.field_150417_aV, 1, 1);
                    }
                    case 4: {
                        return new ItemStack(Blocks.field_150417_aV, 1, 2);
                    }
                    case 5: {
                        return new ItemStack(Blocks.field_150417_aV, 1, 3);
                    }
                }
                return new ItemStack(Blocks.field_150348_b);
            }
            if (block instanceof BlockRotatedPillar) {
                return new ItemStack(block, 1, ((BlockRotatedPillar)block).func_150162_k(par1));
            }
            if (block instanceof BlockRedstoneOre) {
                return new ItemStack(Blocks.field_150450_ax);
            }
            if (block instanceof BlockRedstoneLight) {
                return new ItemStack(Blocks.field_150379_bu);
            }
            if (block instanceof BlockPane) {
                return new ItemStack(block, 1, par1);
            }
            if (block instanceof BlockLeaves) {
                return new ItemStack(block, 1, par1 & 3);
            }
        }
        int j = 0;
        Item item = Item.func_150898_a((Block)block);
        if (block != null && item != null && item.func_77614_k()) {
            j = par1;
        }
        return new ItemStack(block, 1, j);
    }

    public boolean canTransmuteBlock(TransmutationState state, int cost, TransmutationResult result, Translatable targetName, boolean left) {
        ArrayList<ItemStack> newItems;
        if (state.block == Blocks.field_150350_a || state.block == null) {
            if (state.currentMatter + result.matterGained < cost) {
                ++result.unaffordableBlocks;
                result.customErrorMessage = new Translatable("problem.transmute.cantafford", new Object[]{targetName, cost});
                return false;
            }
            result.matterGained -= cost;
            result.matterInvolved += cost;
            ++result.blocksCreated;
            result.blocks.add(this);
            return true;
        }
        if (state.amuletHasSilkTouch(left) && state.block.canSilkHarvest(state.world, state.player, this.x, this.y, this.z, state.metadata)) {
            ItemStack itemstack = TransmutationBlockPos.createStackedBlock(state.block, state.metadata);
            newItems = new ArrayList<ItemStack>();
            if (itemstack != null) {
                newItems.add(itemstack);
            }
        } else {
            newItems = state.block.getDrops(state.world, this.x, this.y, this.z, state.metadata, 0);
        }
        if (state.block == BalancedExchange.blockOfReactivity) {
            newItems.clear();
        }
        int currentGain = 0;
        boolean canConsume = true;
        for (ItemStack item1 : newItems) {
            if (!AmuletStack.canConsumeItemStack(state.player, item1)) {
                canConsume = false;
                result.customErrorMessage = new Translatable("problem.transmute.inconsumabledrop", new Object[]{new Translatable(item1.func_77977_a() + ".name", new Object[0])});
                break;
            }
            currentGain += AmuletStack.getMPBConsumed(state.player, state.world, item1) * item1.field_77994_a;
        }
        if (!canConsume) {
            ++result.blocksFailed;
            return false;
        }
        if (state.amuletHasStabilityUpgrade(left)) {
            currentGain = 0;
        }
        if (state.currentMatter + result.matterGained + currentGain < cost) {
            ++result.unaffordableBlocks;
            result.customErrorMessage = new Translatable("problem.transmute.cantafford", new Object[]{targetName, cost});
            return false;
        }
        result.matterGained += currentGain - cost;
        result.matterInvolved += currentGain + cost;
        result.itemsDropped.addAll(newItems);
        ++result.blocksSuccessful;
        result.blocks.add(this);
        return true;
    }

    public static class TransmutationState {
        public World world;
        public EntityPlayer player;
        public ItemStack stack;
        public AmuletStack amulet;
        public int metadata;
        public int currentMatter;
        public Block block;
        private Boolean hasSilkTouch;
        private Boolean hasStabilityUpgrade;
        public int areaDirection;

        public TransmutationState(World world, EntityPlayer player, ItemStack stack, AmuletStack amulet) {
            this.world = world;
            this.player = player;
            this.stack = stack;
            this.amulet = amulet;
            this.block = null;
            this.metadata = 0;
            this.currentMatter = amulet.getStoredMatter();
        }

        public boolean amuletHasSilkTouch(boolean left) {
            if (this.hasSilkTouch == null) {
                this.hasSilkTouch = AmuletStack.hasUpgrade(this.player, this.world, this.amulet.getIdentifier(), AmuletStack.filter_silkTouch, left);
            }
            return this.hasSilkTouch;
        }

        public boolean amuletHasStabilityUpgrade(boolean left) {
            if (this.hasStabilityUpgrade == null) {
                this.hasStabilityUpgrade = AmuletStack.hasUpgrade(this.player, this.world, this.amulet.getIdentifier(), AmuletStack.filter_stabilityUpgrade, left);
            }
            return this.hasStabilityUpgrade;
        }

        public void setBlockType(TransmutationBlockPos newBlock) {
            this.block = this.world.func_147439_a(newBlock.x, newBlock.y, newBlock.z);
            this.metadata = this.world.func_72805_g(newBlock.x, newBlock.y, newBlock.z);
            if (this.block != null && this.block.isAir((IBlockAccess)this.world, newBlock.x, newBlock.y, newBlock.z)) {
                this.block = Blocks.field_150350_a;
                this.metadata = 0;
            }
        }
    }

    public static class TransmutationResult {
        public ArrayList<TransmutationBlockPos> blocks = new ArrayList();
        public ArrayList<ItemStack> itemsDropped = new ArrayList();
        public int matterInvolved;
        public int matterGained;
        public int blocksSuccessful;
        public int blocksCreated;
        public int blocksFailed;
        public int blocksSkipped;
        public int unaffordableBlocks;
        public Translatable customErrorMessage = null;
    }
}

