/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange;

import brad16840.balancedexchange.AmuletStack;
import brad16840.balancedexchange.BalancedExchange;
import brad16840.balancedexchange.ClientProxy;
import brad16840.balancedexchange.TransmutationBlockPos;
import brad16840.balancedexchange.items.AmuletOfTransmutation;
import brad16840.common.BlockPos;
import brad16840.common.Common;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class Transmutation {
    public Translatable message;
    public int mode;
    public int chargeRequired;
    public int chargeAmassed;
    public int matterGain;
    public int type = 0;
    public TransmutationBlockPos.TransmutationState state;
    public TransmutationBlockPos.TransmutationResult result;
    public BlockPos pos;
    public String uuid;
    public boolean airMode;
    public TransmutationBlockPos traceBlock;
    public int traceSideHit;
    public boolean isLeftClick;
    public boolean needsLeftClick;

    public static Transmutation getTransmutation(EntityPlayer player, ItemStack stack, boolean airMode, boolean left) {
        TransmutationBlockPos blockHit;
        MovingObjectPosition trace;
        if (!player.field_70170_p.field_72995_K) {
            return null;
        }
        String uuid = UniqueItem.getIdentifier((ItemStack)stack);
        boolean dualTransmutations = AmuletStack.isDualMode(player, uuid);
        if (GameSettings.func_100015_a((KeyBinding)BalancedExchange.modeKeyHandler.keyBinding) && dualTransmutations) {
            ((ClientProxy.ModeKeyHandler)BalancedExchange.modeKeyHandler).trigger(left);
            return null;
        }
        if (GameSettings.func_100015_a((KeyBinding)BalancedExchange.pickKeyHandler.keyBinding) && dualTransmutations) {
            ((ClientProxy.PickBlockKeyHandler)BalancedExchange.pickKeyHandler).trigger(left);
            return null;
        }
        if (GameSettings.func_100015_a((KeyBinding)BalancedExchange.prevFavouriteKeyHandler.keyBinding) && dualTransmutations) {
            ((ClientProxy.QuickKeyHandler)BalancedExchange.prevFavouriteKeyHandler).trigger(left);
            return null;
        }
        if (GameSettings.func_100015_a((KeyBinding)BalancedExchange.nextFavouriteKeyHandler.keyBinding) && dualTransmutations) {
            ((ClientProxy.QuickKeyHandler)BalancedExchange.nextFavouriteKeyHandler).trigger(left);
            return null;
        }
        Transmutation transmutation = new Transmutation();
        transmutation.isLeftClick = left;
        transmutation.uuid = uuid;
        if (uuid.equals("none")) {
            Common.ensureInventoryIdentifiers((EntityPlayer)player, (IInventory)player.field_71071_by, null, (int)-1, new ArrayList());
            return null;
        }
        AmuletStack amulet = AmuletStack.create(player, uuid);
        UniqueItemData data = UniqueItemData.get((World)player.field_70170_p);
        if (!data.hasRequiredPermission(player, uuid, 2) || amulet == null) {
            transmutation.message = UniqueItemData.permissionError((String)"use", (Object)AmuletOfTransmutation.name);
            transmutation.type = 1;
            transmutation.chargeRequired = 8;
            return transmutation;
        }
        if (amulet.getRechargeTime() > 0) {
            return null;
        }
        if (amulet.getMode(left) == 0) {
            boolean buildMode;
            ItemStack s = AmuletStack.getUpgrade(player, uuid, AmuletStack.filter_productivityUpgrade, left);
            boolean bl = buildMode = s != null && s.func_77960_j() != 0;
            if (buildMode) {
                boolean bl2 = airMode = !airMode;
            }
        }
        if ((trace = player.func_70614_a(amulet.getRange(left), 1.0f)) == null || trace.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || trace.field_72310_e < 0) {
            return null;
        }
        int sideHit = trace.field_72310_e;
        float hitX = (float)trace.field_72307_f.field_72450_a - (float)trace.field_72311_b;
        float hitY = (float)trace.field_72307_f.field_72448_b - (float)trace.field_72312_c;
        float hitZ = (float)trace.field_72307_f.field_72449_c - (float)trace.field_72309_d;
        if (!airMode && hitY < AmuletOfTransmutation.borderThreshold && trace.field_72310_e != 0 && trace.field_72310_e != 1) {
            sideHit = 0;
        } else if (!airMode && (double)hitY > 1.0 - (double)AmuletOfTransmutation.borderThreshold && trace.field_72310_e != 0 && trace.field_72310_e != 1) {
            sideHit = 1;
        } else if (!airMode && hitZ < AmuletOfTransmutation.borderThreshold && trace.field_72310_e != 2 && trace.field_72310_e != 3) {
            sideHit = 2;
        } else if (!airMode && (double)hitZ > 1.0 - (double)AmuletOfTransmutation.borderThreshold && trace.field_72310_e != 2 && trace.field_72310_e != 3) {
            sideHit = 3;
        } else if (!airMode && hitX < AmuletOfTransmutation.borderThreshold && trace.field_72310_e != 4 && trace.field_72310_e != 5) {
            sideHit = 4;
        } else if (!airMode && (double)hitX > 1.0 - (double)AmuletOfTransmutation.borderThreshold && trace.field_72310_e != 4 && trace.field_72310_e != 5) {
            sideHit = 5;
        }
        transmutation.traceBlock = blockHit = new TransmutationBlockPos(trace.field_72311_b, trace.field_72312_c, trace.field_72309_d);
        transmutation.traceSideHit = sideHit;
        transmutation.airMode = airMode;
        TransmutationBlockPos.TransmutationState state = new TransmutationBlockPos.TransmutationState(player.field_70170_p, player, stack, amulet);
        state.setBlockType(blockHit);
        if (state.block == Blocks.field_150431_aC && (state.metadata & 7) < 1) {
            --blockHit.y;
            sideHit = 1;
            state.setBlockType(blockHit);
        }
        if (airMode) {
            blockHit = TransmutationBlockPos.create(blockHit.getNeighbour(sideHit));
            state.setBlockType(blockHit);
            if (state.block != null && (state.block.func_149688_o().func_76222_j() || state.block.func_149688_o() instanceof MaterialLiquid || state.block.func_149688_o() == Material.field_151597_y)) {
                state.block = Blocks.field_150350_a;
            }
        }
        transmutation.pos = blockHit;
        int mode = state.amulet.getMode(left);
        if (mode == 6) {
            transmutation.mode = 6;
            transmutation.matterGain = state.amulet.getSurveyCost(state.player);
            transmutation.chargeRequired = Math.min(TransmutationBlockPos.getSurveyRechargeAmount(state, -transmutation.matterGain, left), AmuletOfTransmutation.minimumRechargeTime - 1);
            return transmutation;
        }
        if (!left && state.world.func_147438_o(blockHit.x, blockHit.y, blockHit.z) != null) {
            return null;
        }
        if (airMode && (mode == 1 || mode == 2 || mode == 4 || mode == 5)) {
            mode = 0;
        }
        if (!airMode && state.block == Blocks.field_150350_a) {
            transmutation.message = new Translatable("problem.airblocktransmute", new Object[0]);
            transmutation.type = 1;
            transmutation.chargeRequired = 8;
            return transmutation;
        }
        ItemStack proxy = state.amulet.getActiveItem(left);
        proxy.field_77994_a = 1;
        if (!(proxy.func_77973_b() instanceof ItemBlock)) {
            return null;
        }
        ItemBlock item = (ItemBlock)proxy.func_77973_b();
        if (!(state.block != BalancedExchange.blockOfReactivity || AmuletOfTransmutation.reactivityBlocksCanBeTransmuted && item != Item.func_150898_a((Block)BalancedExchange.blockOfReactivity))) {
            transmutation.type = 2;
            transmutation.chargeRequired = AmuletOfTransmutation.minimumRechargeTime;
            return transmutation;
        }
        TransmutationBlockPos.TransmutationResult result = new TransmutationBlockPos.TransmutationResult();
        if (mode == 0) {
            blockHit.getTransmutation(state, result, left);
        } else if (mode == 1) {
            blockHit.getTransmutationChain(state, AmuletOfTransmutation.maximumChainLength, result, left);
        } else if (mode == 2) {
            blockHit.getTransmutationArea(state, result, false, left);
        } else if (mode == 3) {
            blockHit.getTransmutationArea(state, result, true, left);
        } else if (mode == 4) {
            blockHit.getTransmutationConfinedChain(state, result, left);
        } else if (mode == 5) {
            blockHit.getTransmutationConversion(state, result, left);
        } else {
            blockHit.getTransmutation(state, result, left);
        }
        transmutation.result = result;
        if (result.blocks.size() < 1) {
            transmutation.message = AmuletOfTransmutation.getResultData(state, result, left);
            if (transmutation.message == null) {
                return null;
            }
            transmutation.type = 1;
            transmutation.chargeRequired = 8;
            return transmutation;
        }
        transmutation.mode = mode;
        transmutation.matterGain = result.matterGained;
        transmutation.chargeRequired = AmuletOfTransmutation.getRechargeTime(state, result, left);
        transmutation.state = state;
        if (result.blocks.get(0) == null) {
            transmutation.type = 3;
            return transmutation;
        }
        return transmutation;
    }

    public boolean isSame(Transmutation t) {
        if (t == null) {
            return false;
        }
        if (t.needsLeftClick && Minecraft.func_71410_x().field_71442_b.func_78758_h()) {
            return true;
        }
        if (this.mode != t.mode || this.type != t.type) {
            return false;
        }
        if (this.state != null || t.state != null) {
            if (this.state == null || t.state == null) {
                return false;
            }
            if (this.state.block != t.state.block || this.state.areaDirection != t.state.areaDirection) {
                return false;
            }
        }
        if (this.pos != null || t.pos != null) {
            if (this.pos == null || t.pos == null) {
                return false;
            }
            if (this.pos.x != t.pos.x || this.pos.y != t.pos.y || this.pos.z != t.pos.z) {
                return false;
            }
        }
        return true;
    }

    public boolean isSimilar(Transmutation t) {
        if (t == null) {
            return false;
        }
        if (t.needsLeftClick && Minecraft.func_71410_x().field_71442_b.func_78758_h()) {
            return true;
        }
        if (this.mode != t.mode || this.type != t.type) {
            return false;
        }
        if (this.state != null || t.state != null) {
            if (this.state == null || t.state == null) {
                return false;
            }
            if (this.state.block != t.state.block || this.state.areaDirection != t.state.areaDirection) {
                return false;
            }
        }
        return true;
    }
}

