/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange;

import brad16840.balancedexchange.AmuletStack;
import brad16840.balancedexchange.BalancedExchange;
import brad16840.balancedexchange.ClientProxy;
import brad16840.balancedexchange.MPBValues;
import brad16840.balancedexchange.TransmutationBlockPos;
import brad16840.balancedexchange.blocks.BlockOfReactivity;
import brad16840.balancedexchange.blocks.TransmutationChest;
import brad16840.balancedexchange.gui.AmuletContainer;
import brad16840.balancedexchange.gui.TransmutationChestContainer;
import brad16840.balancedexchange.items.AmuletOfTransmutation;
import brad16840.balancedexchange.items.AreaUpgrade;
import brad16840.common.BlockPos;
import brad16840.common.ContainerStack;
import brad16840.common.CustomPacket;
import brad16840.common.MessageChannel;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UnknownItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class PacketHandler {
    public static AmuletContainer getAmuletContainer(EntityPlayer player, String uuid) {
        if (!(player.field_71070_bA instanceof ContainerStack)) {
            return null;
        }
        ContainerStack stack = (ContainerStack)player.field_71070_bA;
        for (int i = 0; i < stack.stacks.length; ++i) {
            StackableContainer container = stack.getContainer(i);
            if (!(container instanceof AmuletContainer) || !container.getId().equals(uuid)) continue;
            return (AmuletContainer)container;
        }
        return null;
    }

    public static TransmutationChestContainer getTransmutationChestContainer(EntityPlayer player, String uuid) {
        if (!(player.field_71070_bA instanceof ContainerStack)) {
            return null;
        }
        ContainerStack stack = (ContainerStack)player.field_71070_bA;
        for (int i = 0; i < stack.stacks.length; ++i) {
            StackableContainer container = stack.getContainer(i);
            if (!(container instanceof TransmutationChestContainer) || !container.getId().equals(uuid)) continue;
            return (TransmutationChestContainer)container;
        }
        return null;
    }

    public static void registerMessages(MessageChannel channel) {
        channel.registerMessage(InitializePlayer.class);
        channel.registerMessage(QuickCreate.class);
        channel.registerMessage(QuickCreateItem.class);
        channel.registerMessage(QuickCreateMulti.class);
        channel.registerMessage(IdentifyConsumptionSlotAmulet.class);
        channel.registerMessage(AreaChange.class);
        channel.registerMessage(ShareMatter.class);
        channel.registerMessage(ConsumeItemStack.class);
        channel.registerMessage(ConsumeItemStacks.class);
        channel.registerMessage(MasterAmulet.class);
        channel.registerMessage(ModeChange.class);
        channel.registerMessage(SurveyModeChange.class);
        channel.registerMessage(ToggleQuickList.class);
        channel.registerMessage(Transmute.class);
        channel.registerMessage(ActivateItemStack.class);
        channel.registerMessage(OverrideMPBValue.class);
        channel.registerMessage(SetHandedness.class);
        channel.registerMessage(ForgetItemStack.class);
        channel.registerMessage(SetGuiItem.class);
    }

    public static class SetGuiItem
    extends MessageChannel.Message {
        public SetGuiItem() {
        }

        public SetGuiItem(ItemStack stack) {
            super(new Object[]{stack != null, stack != null ? stack : Integer.valueOf(0)});
            this.setClasses(new Class[]{Boolean.class, stack != null ? ItemStack.class : Integer.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                if (reader.readBoolean()) {
                    ((ClientProxy)BalancedExchange.proxy).guiItemClient = reader.readItemStack();
                } else {
                    reader.readInt();
                    ((ClientProxy)BalancedExchange.proxy).guiItemClient = null;
                }
            }
        }
    }

    public static class ForgetItemStack
    extends MessageChannel.Message {
        public ForgetItemStack() {
        }

        public ForgetItemStack(String identifier, ItemStack stack) {
            super(new Object[]{identifier, stack});
            this.setClasses(new Class[]{String.class, ItemStack.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                ItemStack stack = reader.readItemStack();
                AmuletStack amulet = AmuletStack.create(player, uuid);
                if (amulet == null) {
                    new Translatable("problem.forgetlearneditem", new Object[0]).send(player);
                } else {
                    amulet.forgetItemStack(stack, false);
                }
            }
        }
    }

    public static class InitializePlayer
    extends MessageChannel.Message {
        public void send(CustomPacket packet) {
            int i;
            for (String id : AmuletOfTransmutation.MPB_ServerSide.keySet()) {
                HashMap<Integer, AmuletOfTransmutation.MPBEntry> map = AmuletOfTransmutation.MPB_ServerSide.get(id);
                packet.write(id);
                packet.write(map.size());
                for (int metadata : map.keySet()) {
                    AmuletOfTransmutation.MPBEntry entry = map.get(metadata);
                    packet.write(metadata).write(entry.consumed).write(entry.created);
                }
            }
            packet.write((String)null);
            packet.write(AmuletContainer._canCreateItems);
            packet.write(AmuletOfTransmutation._allowQuickCreate);
            packet.write(AmuletOfTransmutation._allowTransmutationOfRadiation);
            packet.write(AmuletOfTransmutation._allowSurveying);
            packet.write(AmuletOfTransmutation._reactivityBlocksCanBeTransmuted);
            packet.write(AmuletOfTransmutation._learnThreshold);
            packet.write(AmuletOfTransmutation._rechargeScale);
            packet.write(AmuletOfTransmutation._upgradedRange);
            packet.write((double)AmuletOfTransmutation._borderThreshold);
            packet.write(AmuletOfTransmutation._maximumChainLength);
            packet.write(AmuletOfTransmutation._defaultItem);
            packet.write(BlockOfReactivity._canClimbReactivityBlocks);
            packet.write(AreaUpgrade._maximumSideLength);
            packet.write(AmuletStack._forceRechargeMode == null ? 0 : (AmuletStack._forceRechargeMode != false ? 1 : 2));
            packet.write(TransmutationChest._requirePermissionToDestroyTransmutationChest);
            packet.write(AmuletOfTransmutation.dispensableItemListServerSide.size());
            for (i = 0; i < AmuletOfTransmutation.dispensableItemListServerSide.size(); ++i) {
                packet.write(AmuletOfTransmutation.dispensableItemListServerSide.get(i));
            }
            packet.write(AmuletStack._creationEfficiencyPerReactivityCore.length);
            for (i = 0; i < AmuletStack._creationEfficiencyPerReactivityCore.length; ++i) {
                packet.write(AmuletStack._creationEfficiencyPerReactivityCore[i]);
            }
            packet.write(AmuletStack._rechargeEfficiencyPerReactivityBlock.length);
            for (i = 0; i < AmuletStack._rechargeEfficiencyPerReactivityBlock.length; ++i) {
                packet.write(AmuletStack._rechargeEfficiencyPerReactivityBlock[i]);
            }
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (!serverSide) {
                AmuletOfTransmutation.MPB.clear();
                String id = reader.readString();
                int size = 0;
                int i = 0;
                while (id != null) {
                    size = reader.readInt();
                    HashMap<Integer, AmuletOfTransmutation.MPBEntry> map = new HashMap<Integer, AmuletOfTransmutation.MPBEntry>(size);
                    for (i = 0; i < size; ++i) {
                        int metadata = reader.readInt();
                        map.put(metadata, new AmuletOfTransmutation.MPBEntry(metadata, reader.readInt(), reader.readInt()));
                    }
                    AmuletOfTransmutation.MPB.put(id, map);
                    id = reader.readString();
                }
                AmuletContainer.canCreateItems = reader.readBoolean();
                AmuletOfTransmutation.allowQuickCreate = reader.readBoolean();
                AmuletOfTransmutation.allowTransmutationOfRadiation = reader.readBoolean();
                AmuletOfTransmutation.allowSurveying = reader.readBoolean();
                AmuletOfTransmutation.reactivityBlocksCanBeTransmuted = reader.readBoolean();
                AmuletOfTransmutation.learnThreshold = reader.readInt();
                AmuletOfTransmutation.rechargeScale = reader.readDouble();
                AmuletOfTransmutation.upgradedRange = reader.readDouble();
                AmuletOfTransmutation.borderThreshold = (float)reader.readDouble();
                AmuletOfTransmutation.maximumChainLength = reader.readInt();
                AmuletOfTransmutation.defaultItem = reader.readItemStack();
                BlockOfReactivity.canClimbReactivityBlocks = reader.readBoolean();
                AreaUpgrade.maximumSideLength = reader.readInt();
                int t = reader.readInt();
                AmuletStack.forceRechargeMode = t == 0 ? null : Boolean.valueOf(t == 1);
                TransmutationChest.requirePermissionToDestroyTransmutationChest = reader.readBoolean();
                int length = reader.readInt();
                AmuletOfTransmutation.dispensableItems.clear();
                AmuletOfTransmutation.dispensableItemList.clear();
                for (i = 0; i < length; ++i) {
                    ItemStack stack = reader.readItemStack();
                    AmuletOfTransmutation.dispensableItems.add("item" + AmuletStack.getDescriptor(stack.func_77973_b()) + "dam" + stack.func_77960_j());
                    AmuletOfTransmutation.insertStack(AmuletOfTransmutation.dispensableItemList, stack);
                }
                AmuletStack.creationEfficiencyPerReactivityCore = new double[reader.readInt()];
                for (i = 0; i < AmuletStack.creationEfficiencyPerReactivityCore.length; ++i) {
                    AmuletStack.creationEfficiencyPerReactivityCore[i] = reader.readDouble();
                }
                AmuletStack.rechargeEfficiencyPerReactivityBlock = new double[reader.readInt()];
                for (i = 0; i < AmuletStack.rechargeEfficiencyPerReactivityBlock.length; ++i) {
                    AmuletStack.rechargeEfficiencyPerReactivityBlock[i] = reader.readDouble();
                }
            }
        }
    }

    public static class IdentifyConsumptionSlotAmulet
    extends MessageChannel.Message {
        public IdentifyConsumptionSlotAmulet() {
        }

        public IdentifyConsumptionSlotAmulet(String uuid, String id, int type) {
            super(new Object[]{uuid, id, type});
            this.setClasses(new Class[]{String.class, String.class, Integer.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                reader.readString();
                AmuletContainer container = PacketHandler.getAmuletContainer(player, uuid);
                if (container == null) {
                    reader.readInt();
                    new Translatable("problem.identifyotheramulet", new Object[0]).send(player);
                } else {
                    container.identifyConsumptionSlotAmulet(player, reader.readInt());
                }
            } else {
                String uuid = reader.readString();
                AmuletContainer container = PacketHandler.getAmuletContainer(player, uuid);
                if (container == null) {
                    reader.readString();
                    reader.readInt();
                    new Translatable("problem.identifyotheramulet", new Object[0]).log(player);
                } else {
                    container.setConsumptionSlotAmuletIdentifier(player, reader.readString(), reader.readInt());
                }
            }
        }
    }

    public static class ShareMatter
    extends MessageChannel.Message {
        public ShareMatter() {
        }

        public ShareMatter(String uuid, String otherUuid) {
            super(new Object[]{uuid, otherUuid});
            this.setClasses(new Class[]{String.class, String.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                String otherUuid = reader.readString();
                UniqueItemData data = UniqueItemData.get((World)player.field_70170_p);
                if (!data.hasRequiredPermission(player, uuid, 2) || !data.hasRequiredPermission(player, otherUuid, 2)) {
                    return;
                }
                AmuletStack amulet = AmuletStack.create(player, uuid);
                if (amulet == null) {
                    return;
                }
                int matter = amulet.getStoredMatter();
                int give = matter / 2;
                AmuletStack otherAmulet = AmuletStack.create(player, otherUuid);
                if (otherAmulet == null) {
                    return;
                }
                otherAmulet.setStoredMatter(otherAmulet.getStoredMatter() + give);
                amulet.setStoredMatter(matter - give);
            }
        }
    }

    public static class MasterAmulet
    extends MessageChannel.Message {
        public MasterAmulet() {
        }

        public MasterAmulet(String uuid, boolean fromHand) {
            super(new Object[]{uuid, fromHand});
            this.setClasses(new Class[]{String.class, Boolean.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                AmuletContainer container = PacketHandler.getAmuletContainer(player, uuid);
                if (container == null) {
                    reader.readBoolean();
                    new Translatable("problem.consumefailed", new Object[0]).send(player);
                } else {
                    container.masterAmulet(player, reader.readBoolean(), false);
                }
            }
        }
    }

    public static class OverrideMPBValue
    extends MessageChannel.Message {
        public OverrideMPBValue() {
        }

        public OverrideMPBValue(String id, int metadata, int mpbConsumed, int mpbCreated, boolean dispensable) {
            super(new Object[]{id, metadata, mpbConsumed, mpbCreated, dispensable});
            this.setClasses(new Class[]{String.class, Integer.class, Integer.class, Integer.class, Boolean.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String id = reader.readString();
                int metadata = reader.readInt();
                int mpbConsumed = reader.readInt();
                int mpbCreated = reader.readInt();
                boolean dispensable = reader.readBoolean();
                AmuletOfTransmutation.settingOverriddenMPBValues = true;
                MPBValues.setMPBValue(id, metadata, mpbConsumed, mpbCreated);
                AmuletOfTransmutation.settingOverriddenMPBValues = false;
                if (dispensable) {
                    AmuletOfTransmutation.addDispensableItem(id, metadata);
                } else if (AmuletOfTransmutation.dispensableItems.contains("item" + id + "dam" + metadata)) {
                    String t;
                    ItemStack stack;
                    Iterator<ItemStack> iterator = AmuletOfTransmutation.dispensableItemList.iterator();
                    while (iterator.hasNext()) {
                        stack = iterator.next();
                        t = UnknownItem.getItemDescriptor((ItemStack)stack);
                        if (!t.equals(id) || stack.func_77960_j() != metadata) continue;
                        iterator.remove();
                    }
                    iterator = AmuletOfTransmutation.dispensableItemListServerSide.iterator();
                    while (iterator.hasNext()) {
                        stack = iterator.next();
                        t = UnknownItem.getItemDescriptor((ItemStack)stack);
                        if (!t.equals(id) || stack.func_77960_j() != metadata) continue;
                        iterator.remove();
                    }
                    AmuletOfTransmutation.dispensableItems.remove("item" + id + "dam" + metadata);
                }
                BalancedExchange.channel.sendToAll((MessageChannel.Message)new OverrideMPBValue(id, metadata, mpbConsumed, mpbCreated, dispensable));
                BalancedExchange.saveOverriddenMPBValues();
            } else {
                String id = reader.readString();
                int metadata = reader.readInt();
                int mpbConsumed = reader.readInt();
                int mpbCreated = reader.readInt();
                AmuletOfTransmutation.settingOverriddenMPBValues = true;
                MPBValues.setMPBValue(id, metadata, mpbConsumed, mpbCreated);
                AmuletOfTransmutation.settingOverriddenMPBValues = false;
                if (reader.readBoolean()) {
                    AmuletOfTransmutation.addDispensableItem(id, metadata);
                } else if (AmuletOfTransmutation.dispensableItems.contains("item" + id + "dam" + metadata)) {
                    Iterator<ItemStack> iterator = AmuletOfTransmutation.dispensableItemList.iterator();
                    while (iterator.hasNext()) {
                        ItemStack stack = iterator.next();
                        String t = UnknownItem.getItemDescriptor((ItemStack)stack);
                        if (!t.equals(id) || stack.func_77960_j() != metadata) continue;
                        iterator.remove();
                    }
                    AmuletOfTransmutation.dispensableItems.remove("item" + id + "dam" + metadata);
                }
            }
        }
    }

    public static class ConsumeItemStacks
    extends MessageChannel.Message {
        public ConsumeItemStacks() {
        }

        public ConsumeItemStacks(String uuid, List<ItemStack> stacks, int x, int y, int z, Boolean left) {
            super(new Object[]{uuid, left == null ? 0 : (left != false ? 1 : 2), stacks, x, y, z});
            this.setClasses(new Class[]{String.class, Integer.class, ItemStack.class, Integer.class, Integer.class, Integer.class});
        }

        public static void safeConsume(String uuid, ArrayList<ItemStack> ostacks, int x, int y, int z, Boolean left, EntityPlayer player) {
            List<ItemStack> stacks;
            for (int i = 0; i < ostacks.size(); i += stacks.size()) {
                stacks = ostacks.subList(i, Math.min(i + 1000, ostacks.size()));
                BalancedExchange.channel.sendToPlayer(player, (MessageChannel.Message)new ConsumeItemStacks(uuid, stacks, x, y, z, left));
            }
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            String uuid = reader.readString();
            int left = reader.readInt();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            int size = reader.readInt();
            for (int i = 0; i < size; ++i) {
                stacks.add(reader.readItemStack());
            }
            AmuletStack amulet = AmuletStack.create(player, uuid);
            if (amulet == null) {
                reader.readInt();
                reader.readInt();
                reader.readInt();
                return;
            }
            amulet.consumeItemStacks(stacks, false, reader.readInt(), reader.readInt(), reader.readInt(), left == 0 ? null : Boolean.valueOf(left == 1));
        }
    }

    public static class SetHandedness
    extends MessageChannel.Message {
        public SetHandedness() {
        }

        public SetHandedness(String uuid, int slot, int handedness) {
            super(new Object[]{uuid, slot, handedness});
            this.setClasses(new Class[]{String.class, Integer.class, Integer.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                AmuletContainer container = PacketHandler.getAmuletContainer(player, uuid);
                if (container == null) {
                    reader.readInt();
                    reader.readInt();
                    new Translatable("problem.consumefailed", new Object[0]).send(player);
                } else {
                    container.setHandedness(player, reader.readInt(), reader.readInt(), false);
                }
            }
        }
    }

    public static class ConsumeItemStack
    extends MessageChannel.Message {
        public ConsumeItemStack() {
        }

        public ConsumeItemStack(String uuid, boolean fromHand) {
            super(new Object[]{uuid, fromHand});
            this.setClasses(new Class[]{String.class, Boolean.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                AmuletContainer container = PacketHandler.getAmuletContainer(player, uuid);
                if (container == null) {
                    reader.readBoolean();
                    new Translatable("problem.consumefailed", new Object[0]).send(player);
                } else {
                    container.consumeItemStack(player, reader.readBoolean(), false);
                }
            }
        }
    }

    public static class ActivateItemStack
    extends MessageChannel.Message {
        public ActivateItemStack() {
        }

        public ActivateItemStack(String uuid, ItemStack stack, boolean left) {
            super(new Object[]{uuid, stack, left});
            this.setClasses(new Class[]{String.class, ItemStack.class, Boolean.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                AmuletStack amulet = AmuletStack.create(player, uuid);
                if (amulet == null) {
                    reader.readItemStack();
                    reader.readBoolean();
                    return;
                }
                amulet.setActiveItemStack(reader.readItemStack(), false, reader.readBoolean());
            }
        }
    }

    public static class Transmute
    extends MessageChannel.Message {
        public Transmute() {
        }

        public Transmute(BlockPos blockHit, int side, String uuid, boolean airMode, boolean precharged, boolean left) {
            super(new Object[]{uuid, blockHit, side, airMode, precharged, left});
            this.setClasses(new Class[]{String.class, BlockPos.class, Integer.class, Boolean.class, Boolean.class, Boolean.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                AmuletStack amulet = AmuletStack.create(player, uuid);
                if (amulet == null) {
                    reader.readBlockPos();
                    reader.readInt();
                    reader.readBoolean();
                    reader.readBoolean();
                    reader.readBoolean();
                    return;
                }
                ItemStack stack = UniqueItem.findItem((EntityPlayer)player, (String)uuid);
                AmuletOfTransmutation.transmute(player, stack, TransmutationBlockPos.create(reader.readBlockPos()), reader.readInt(), reader.readBoolean(), reader.readBoolean(), reader.readBoolean());
            }
        }
    }

    public static class AreaChange
    extends MessageChannel.Message {
        public AreaChange() {
        }

        public AreaChange(String uuid, NBTTagCompound data) {
            super(new Object[]{uuid, data});
            this.setClasses(new Class[]{String.class, NBTTagCompound.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                final NBTTagCompound tag = reader.readNBTTagCompound();
                UniqueItemData.get((World)player.field_70170_p).setItemData(uuid, tag);
                if (UniqueItem.modifyItems((EntityPlayer)player, (String)uuid, null, (UniqueItem.ItemStackCallback)new UniqueItem.ItemStackCallback(){

                    public void callback(ItemStack stack) {
                        NBTTagCompound tagCompound = stack.func_77978_p();
                        if (tagCompound == null) {
                            return;
                        }
                        tagCompound.func_74782_a("AreaOfEffect", (NBTBase)tag.func_74775_l("AreaOfEffect"));
                    }
                }) == 0) {
                    new Translatable("problem.changearea404", new Object[0]).send(player);
                    return;
                }
            }
        }
    }

    public static class ToggleQuickList
    extends MessageChannel.Message {
        public ToggleQuickList() {
        }

        public ToggleQuickList(ItemStack stack, int toggle, String uuid) {
            super(new Object[]{uuid, toggle, stack});
            this.setClasses(new Class[]{String.class, Integer.class, ItemStack.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                int toggle = reader.readInt();
                AmuletStack amulet = AmuletStack.create(player, uuid);
                if (amulet == null) {
                    reader.readItemStack();
                    return;
                }
                amulet.toggleQuickListStack(reader.readItemStack(), toggle, false);
            }
        }
    }

    public static class QuickCreateMulti
    extends MessageChannel.Message {
        public QuickCreateMulti() {
        }

        public QuickCreateMulti(String uuid, int id, int metadata, boolean isItem, boolean isChest) {
            super(new Object[]{uuid, isChest, id, metadata, isItem});
            this.setClasses(new Class[]{String.class, Boolean.class, Integer.class, Integer.class, Boolean.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                if (reader.readBoolean()) {
                    reader.readInt();
                    reader.readInt();
                    reader.readBoolean();
                } else {
                    AmuletContainer container = PacketHandler.getAmuletContainer(player, uuid);
                    if (container == null) {
                        reader.readInt();
                        reader.readInt();
                        reader.readBoolean();
                        new Translatable("problem.createblock", new Object[0]).send(player);
                    } else {
                        container.setCreationInventory(player, Item.func_150899_d((int)reader.readInt()), reader.readInt(), reader.readBoolean());
                    }
                }
            }
        }
    }

    public static class QuickCreate
    extends MessageChannel.Message {
        public QuickCreate() {
        }

        public QuickCreate(String uuid, int id, int metadata, int count) {
            super(new Object[]{uuid, id, metadata, count});
            this.setClasses(new Class[]{String.class, Integer.class, Integer.class, Integer.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                AmuletContainer container = PacketHandler.getAmuletContainer(player, uuid);
                if (container == null) {
                    reader.readInt();
                    reader.readInt();
                    reader.readInt();
                    new Translatable("problem.createblock", new Object[0]).send(player);
                } else {
                    container.quickCreate(player, Item.func_150899_d((int)reader.readInt()), reader.readInt(), reader.readInt(), false);
                }
            }
        }
    }

    public static class QuickCreateItem
    extends MessageChannel.Message {
        public QuickCreateItem() {
        }

        public QuickCreateItem(String uuid, ItemStack stack, boolean isChest) {
            super(new Object[]{uuid, isChest, stack});
            this.setClasses(new Class[]{String.class, Boolean.class, ItemStack.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                if (reader.readBoolean()) {
                    reader.readItemStack();
                } else {
                    AmuletContainer container = PacketHandler.getAmuletContainer(player, uuid);
                    if (container == null) {
                        new Translatable("problem.createitem", new Object[0]).send(player);
                    } else {
                        container.quickCreateItem(player, reader.readItemStack());
                    }
                }
            }
        }
    }

    public static class SurveyModeChange
    extends MessageChannel.Message {
        public SurveyModeChange() {
        }

        public SurveyModeChange(String uuid, int mode) {
            super(new Object[]{uuid, mode});
            this.setClasses(new Class[]{String.class, Integer.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                AmuletStack amulet = AmuletStack.create(player, uuid);
                if (amulet == null) {
                    reader.readInt();
                    return;
                }
                amulet.setSurveyMode(reader.readInt(), false);
            }
        }
    }

    public static class ModeChange
    extends MessageChannel.Message {
        public ModeChange() {
        }

        public ModeChange(String uuid, boolean left, int mode) {
            super(new Object[]{uuid, left, mode});
            this.setClasses(new Class[]{String.class, Boolean.class, Integer.class});
        }

        public void receive(EntityPlayer player, CustomPacket.CustomPacketReader reader, boolean serverSide) {
            if (serverSide) {
                String uuid = reader.readString();
                AmuletStack amulet = AmuletStack.create(player, uuid);
                if (amulet == null) {
                    reader.readBoolean();
                    reader.readInt();
                    return;
                }
                amulet.setMode(reader.readBoolean(), reader.readInt());
            }
        }
    }
}

