/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange;

import brad16840.balancedexchange.AmuletStack;
import brad16840.balancedexchange.BalancedExchange;
import brad16840.balancedexchange.Proxy;
import brad16840.balancedexchange.blocks.TransmutationChestRenderer;
import brad16840.balancedexchange.blocks.TransmutationChestTileEntity;
import brad16840.balancedexchange.gui.AmuletContainer;
import brad16840.balancedexchange.gui.AmuletGuiOverlay;
import brad16840.balancedexchange.gui.TransmutationChestContainer;
import brad16840.balancedexchange.items.AmuletOfTransmutation;
import brad16840.balancedexchange.items.AreaUpgrade;
import brad16840.common.ContainerStack;
import brad16840.common.ContainerStackGui;
import brad16840.common.KeyBindingRegistry;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.gui.PlayerContainer;
import brad16840.common.gui.RestorerContainer;
import cpw.mods.fml.client.registry.ClientRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ClientProxy
extends Proxy {
    public ItemStack guiItemClient;

    @Override
    public void init(BalancedExchange b) {
        BalancedExchange.nextFavouriteKeyHandler = new QuickKeyHandler(new KeyBinding("key.balancedexchange.nextblock", 45, "Balanced Exchange"), false);
        BalancedExchange.prevFavouriteKeyHandler = new QuickKeyHandler(new KeyBinding("key.balancedexchange.previousblock", 0, "Balanced Exchange"), true);
        BalancedExchange.modeKeyHandler = new ModeKeyHandler(new KeyBinding("key.balancedexchange.changemode", 46, "Balanced Exchange"));
        BalancedExchange.pickKeyHandler = new PickBlockKeyHandler(new KeyBinding("key.balancedexchange.pickblock", -98, "Balanced Exchange"));
        KeyBindingRegistry.registerKeyHandler((KeyBindingRegistry.KeyHandler)BalancedExchange.modeKeyHandler);
        KeyBindingRegistry.registerKeyHandler((KeyBindingRegistry.KeyHandler)BalancedExchange.nextFavouriteKeyHandler);
        KeyBindingRegistry.registerKeyHandler((KeyBindingRegistry.KeyHandler)BalancedExchange.prevFavouriteKeyHandler);
        KeyBindingRegistry.registerKeyHandler((KeyBindingRegistry.KeyHandler)BalancedExchange.pickKeyHandler);
        ClientRegistry.bindTileEntitySpecialRenderer(TransmutationChestTileEntity.class, (TileEntitySpecialRenderer)new TransmutationChestRenderer());
    }

    @Override
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        ItemStack stack = player.func_71045_bC();
        if (this.guiItemClient != null) {
            stack = this.guiItemClient;
        }
        if (id == 1) {
            if (stack != null && stack.func_77973_b() instanceof AmuletOfTransmutation) {
                StackableContainer c = ((AmuletOfTransmutation)stack.func_77973_b()).openContainer(player, (IInventory)player.field_71071_by, player.field_71071_by.field_70461_c, stack, 0);
                if (c != null) {
                    return ContainerStackGui.create((EntityPlayer)player, (StackableContainer[])new StackableContainer[]{c, new PlayerContainer(player.field_71071_by)});
                }
            } else {
                new Translatable("problem.openamulet404", new Object[0]).log(player);
            }
        } else if (id == 2) {
            if (stack != null && stack.func_77973_b() instanceof AreaUpgrade) {
                StackableContainer c = ((AreaUpgrade)stack.func_77973_b()).openContainer(player, (IInventory)player.field_71071_by, player.field_71071_by.field_70461_c, stack, 0);
                if (c != null) {
                    return ContainerStackGui.create((EntityPlayer)player, (StackableContainer[])new StackableContainer[]{c});
                }
            } else {
                new Translatable("problem.openareaupgrade404", new Object[0]).log(player);
            }
        } else if (id == 3) {
            StackableContainer c = BalancedExchange.amulet.viewItem(player, null, x);
            if (c != null) {
                return ContainerStackGui.create((EntityPlayer)player, (StackableContainer[])new StackableContainer[]{c, new RestorerContainer("amulet", x)});
            }
        } else if (id == 4) {
            TileEntity entity = world.func_147438_o(x, y, z);
            if (!(entity instanceof TransmutationChestTileEntity)) {
                return null;
            }
            TransmutationChestContainer c = new TransmutationChestContainer((TransmutationChestTileEntity)entity, player, x, y, z);
            if (c != null) {
                return ContainerStackGui.create((EntityPlayer)player, (StackableContainer[])new StackableContainer[]{c, new PlayerContainer(player.field_71071_by)});
            }
        }
        return null;
    }

    public static class QuickKeyHandler
    extends KeyBindingRegistry.KeyHandler {
        private boolean reverse;
        private long lastTime = 0L;
        public boolean beingHeld = false;

        public QuickKeyHandler(KeyBinding keyBinding, boolean reverse) {
            super(keyBinding);
            this.reverse = reverse;
        }

        public void keyPressed() {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.field_71439_g == null || mc.field_71462_r != null) {
                return;
            }
            boolean dualTransmutations = AmuletStack.isDualMode((EntityPlayer)mc.field_71439_g, UniqueItem.getIdentifier((ItemStack)mc.field_71439_g.func_70694_bm()));
            if (!dualTransmutations) {
                this.trigger(false);
            } else {
                this.beingHeld = true;
            }
        }

        public void keyReleased() {
            super.keyReleased();
            if (this.beingHeld) {
                this.trigger(false);
            }
        }

        public void trigger(boolean left) {
            this.beingHeld = false;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.field_71439_g == null || mc.field_71462_r != null) {
                return;
            }
            long time = Minecraft.func_71386_F();
            if (this.lastTime + 150L > time) {
                return;
            }
            this.lastTime = time;
            EntityClientPlayerMP player = mc.field_71439_g;
            this.alreadyTriggered = true;
            if (player.field_71070_bA instanceof ContainerStack) {
                ContainerStack stack = (ContainerStack)player.field_71070_bA;
                for (int i = 0; i < stack.stacks.length; ++i) {
                    StackableContainer container = stack.getContainer(i);
                    if (!(container instanceof AmuletContainer) || ((AmuletContainer)container).hoveredItemStack == null) continue;
                    ((AmuletContainer)container).toggleQuickList((EntityPlayer)player, true);
                    return;
                }
            } else {
                if (mc.field_71462_r != null) {
                    return;
                }
                if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof AmuletOfTransmutation) {
                    String uuid = UniqueItem.getIdentifier((ItemStack)player.func_71045_bC());
                    if (uuid.equals("none")) {
                        return;
                    }
                    AmuletStack amulet = AmuletStack.create((EntityPlayer)player, uuid);
                    if (amulet == null) {
                        UniqueItemData.permissionError((String)"use", (Object)AmuletOfTransmutation.name).log((EntityPlayer)player);
                        return;
                    }
                    if (player.func_70093_af() != this.reverse) {
                        amulet.prevQuick(left);
                    } else {
                        amulet.nextQuick(left);
                    }
                }
            }
        }
    }

    public static class PickBlockKeyHandler
    extends KeyBindingRegistry.KeyHandler {
        public boolean beingHeld = false;

        public PickBlockKeyHandler(KeyBinding keyBinding) {
            super(keyBinding);
        }

        public void keyPressed() {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.field_71439_g == null || mc.field_71462_r != null) {
                return;
            }
            boolean dualTransmutations = AmuletStack.isDualMode((EntityPlayer)mc.field_71439_g, UniqueItem.getIdentifier((ItemStack)mc.field_71439_g.func_70694_bm()));
            if (!dualTransmutations) {
                this.trigger(false);
            } else {
                this.beingHeld = true;
            }
        }

        public void keyReleased() {
            super.keyReleased();
            if (this.beingHeld) {
                this.trigger(false);
            }
        }

        public void trigger(boolean left) {
            this.beingHeld = false;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.field_71439_g == null || mc.field_71462_r != null) {
                return;
            }
            EntityClientPlayerMP player = mc.field_71439_g;
            ItemStack stack = player.func_71045_bC();
            if (stack == null || mc.field_71462_r != null) {
                return;
            }
            if (stack.func_77973_b() instanceof AmuletOfTransmutation) {
                AmuletStack amulet = AmuletStack.create((EntityPlayer)player, UniqueItem.getIdentifier((ItemStack)stack));
                if (amulet == null) {
                    return;
                }
                MovingObjectPosition trace = player.func_70614_a(amulet.getRange(left), 1.0f);
                if (trace == null || trace.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || trace.field_72310_e < 0) {
                    return;
                }
                Block block = player.field_70170_p.func_147439_a(trace.field_72311_b, trace.field_72312_c, trace.field_72309_d);
                int metadata = block.func_149643_k(player.field_70170_p, trace.field_72311_b, trace.field_72312_c, trace.field_72309_d);
                amulet.setActiveItemStack(new ItemStack(block, 1, metadata), true, left);
                if (block == Blocks.field_150349_c && amulet.getActiveItem(left).func_77973_b() != Item.func_150898_a((Block)block)) {
                    amulet.setActiveItemStack(new ItemStack(Blocks.field_150346_d, 1, 0), true, left);
                }
            }
        }
    }

    public static class ModeKeyHandler
    extends KeyBindingRegistry.KeyHandler {
        public long lastTime = 0L;
        public boolean beingHeld = false;

        public ModeKeyHandler(KeyBinding keyBinding) {
            super(keyBinding);
        }

        public void keyPressed() {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.field_71439_g == null || mc.field_71462_r != null) {
                return;
            }
            this.beingHeld = true;
        }

        public void keyReleased() {
            super.keyReleased();
            if (this.beingHeld) {
                this.trigger(false);
            }
        }

        public void trigger(boolean left) {
            this.beingHeld = false;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.field_71439_g == null || mc.field_71462_r != null) {
                return;
            }
            long time = Minecraft.func_71386_F();
            if (this.lastTime + 150L > time) {
                return;
            }
            this.lastTime = time;
            EntityClientPlayerMP player = mc.field_71439_g;
            this.alreadyTriggered = true;
            if (player.func_71045_bC() == null || mc.field_71462_r != null) {
                return;
            }
            if (player.func_71045_bC().func_77973_b() instanceof AmuletOfTransmutation) {
                this.alreadyTriggered = true;
                String uuid = UniqueItem.getIdentifier((ItemStack)player.func_71045_bC());
                if (uuid.equals("none")) {
                    return;
                }
                AmuletStack stack = AmuletStack.create((EntityPlayer)player, uuid);
                if (stack == null) {
                    UniqueItemData.permissionError((String)"use", (Object)AmuletOfTransmutation.name).log((EntityPlayer)player);
                    return;
                }
                if (player.func_70093_af()) {
                    stack.prevValidMode(left, true);
                } else {
                    stack.nextValidMode(left, true);
                }
                AmuletGuiOverlay.modeChangeTimer = 30;
                AmuletGuiOverlay.modeChangeLeft = left;
            }
        }
    }
}

