/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange;

import brad16840.balancedexchange.AmuletStack;
import brad16840.balancedexchange.MPBValues;
import brad16840.balancedexchange.PacketHandler;
import brad16840.balancedexchange.Proxy;
import brad16840.balancedexchange.blocks.BlockOfReactivity;
import brad16840.balancedexchange.blocks.BlockOfStability;
import brad16840.balancedexchange.blocks.TransmutationChest;
import brad16840.balancedexchange.blocks.TransmutationChestTileEntity;
import brad16840.balancedexchange.gui.AmuletContainer;
import brad16840.balancedexchange.gui.AmuletGuiOverlay;
import brad16840.balancedexchange.gui.MPBEditor;
import brad16840.balancedexchange.items.AmuletOfTransmutation;
import brad16840.balancedexchange.items.AmuletRestorer;
import brad16840.balancedexchange.items.AreaUpgrade;
import brad16840.balancedexchange.items.ChainUpgrade;
import brad16840.balancedexchange.items.CoreUpgrade;
import brad16840.balancedexchange.items.OtherUpgrade;
import brad16840.balancedexchange.items.ProductivityUpgrade;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.DynamicRecipes;
import brad16840.common.EntityBlock164;
import brad16840.common.GenericBlock164;
import brad16840.common.KeyBindingRegistry;
import brad16840.common.Logger;
import brad16840.common.MessageChannel;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.UniqueItem;
import brad16840.common.UnknownItem;
import brad16840.common.gui.BlockSelector;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

@Mod(modid="balancedexchange", name="Balanced Exchange", version="3.0.1", dependencies="required-after:backpacks16840")
public class BalancedExchange
implements Common.RecipeInstantiator {
    public static final String modId = "balancedexchange";
    @Mod.Instance(value="balancedexchange")
    public static BalancedExchange instance;
    public static String fileVersion;
    @SidedProxy(clientSide="brad16840.balancedexchange.ClientProxy", serverSide="brad16840.balancedexchange.Proxy")
    public static Proxy proxy;
    public static final MessageChannel channel;
    public static AmuletOfTransmutation amulet;
    public static AreaUpgrade areaUpgrade;
    public static ChainUpgrade chainUpgrade;
    public static OtherUpgrade rangeUpgrade;
    public static CoreUpgrade coreUpgrade;
    public static ProductivityUpgrade productivityUpgrade;
    public static OtherUpgrade surveyorUpgrade;
    public static AmuletRestorer amuletRestorer;
    public static OtherUpgrade prechargerUpgrade;
    public static BlockOfStability blockOfStability;
    public static BlockOfReactivity blockOfReactivity;
    public static BlockOfReactivity.Radiation reactiveGlow;
    public static TransmutationChest transmutationChest;
    @SideOnly(value=Side.CLIENT)
    public static KeyBindingRegistry.KeyHandler nextFavouriteKeyHandler;
    @SideOnly(value=Side.CLIENT)
    public static KeyBindingRegistry.KeyHandler prevFavouriteKeyHandler;
    @SideOnly(value=Side.CLIENT)
    public static KeyBindingRegistry.KeyHandler modeKeyHandler;
    @SideOnly(value=Side.CLIENT)
    public static KeyBindingRegistry.KeyHandler pickKeyHandler;
    public static String[] mpbFilenames;
    public static boolean invertAmuletScrollDirection;
    public static int amuletScrollDelay;
    public static int screenOffset;
    public static boolean dualHotbarSupport;
    private static String configDirectory;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Common.ensureCompatibleWith((String)"Balanced Exchange", (String)"1.7.10 - 3.0");
        Common.recipeInstantiators.add(this);
        configDirectory = event.getModConfigurationDirectory().getAbsolutePath();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        File file = new File(configDirectory + File.separator + "MPB_values");
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        if ((mpbFilenames = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.equalsIgnoreCase("assigned.mpb") || name.equalsIgnoreCase("unassigned.mpb") || name.equalsIgnoreCase("overridden.mpb")) {
                    return false;
                }
                if (name.toLowerCase().startsWith("default")) {
                    return false;
                }
                return name.toLowerCase().endsWith(".mpb");
            }
        })) == null) {
            mpbFilenames = new String[0];
        }
        AmuletContainer.canCreateItems = AmuletContainer._canCreateItems = config.get("general", "amulets_can_dispense_items", AmuletContainer._canCreateItems, "If set to false amulets won't be able to dispense items like iron ingots or diamonds").getBoolean(AmuletContainer._canCreateItems);
        AmuletOfTransmutation.learnThreshold = AmuletOfTransmutation._learnThreshold = config.get("general", "consumptions_needed_to_learn_block", AmuletOfTransmutation._learnThreshold, "The number of blocks an amulet must consume before it learns how to create that block").getInt(AmuletOfTransmutation._learnThreshold);
        AmuletOfTransmutation.limitTransmutationSpeedByFPS = config.get("general", "limit_transmutation_speed_by_fps", AmuletOfTransmutation.limitTransmutationSpeedByFPS, "If this is true transmutation charging will count frames rendered rather than ticks passed, which causes the transmutation charge rate to lag when your computer lags, giving you more control during lag spikes").getBoolean(AmuletOfTransmutation.limitTransmutationSpeedByFPS);
        String defaultId = config.get("general", "default_transmutation_block_id", AmuletStack.getDescriptor(AmuletOfTransmutation._defaultItem.func_77973_b()), "The id of the block that amulet's will always know how to transmute (defaults to minecraft:dirt)").getString();
        int defaultMeta = config.get("general", "default_transmutation_block_metadata", AmuletOfTransmutation._defaultItem.func_77960_j(), "The metadata of the block that amulet's will always know how to transmute").getInt(AmuletOfTransmutation._defaultItem.func_77960_j());
        AmuletOfTransmutation.defaultItem = AmuletOfTransmutation._defaultItem = UniqueItem.getItemStack((String)defaultId, (int)defaultMeta, (int)AmuletOfTransmutation.learnThreshold);
        AmuletOfTransmutation.maximumChainLength = AmuletOfTransmutation._maximumChainLength = config.get("general", "maximum_chain_length", AmuletOfTransmutation._maximumChainLength, "Maximum number of blocks a chain transmutation can transmute").getInt(AmuletOfTransmutation._maximumChainLength);
        AmuletOfTransmutation.minimumRechargeTime = config.get("general", "minimum_recharge_time", AmuletOfTransmutation.minimumRechargeTime, "Minimum number of ticks (1/20th of a second) an amulet will take to recharge (used to prevent lag triggering multiple transmutations)").getInt(AmuletOfTransmutation.minimumRechargeTime);
        AmuletOfTransmutation.upgradedRange = AmuletOfTransmutation._upgradedRange = config.get("general", "upgraded_range", AmuletOfTransmutation._upgradedRange, "How far an amulet with a range upgrade will be able to transmute from").getDouble(AmuletOfTransmutation._upgradedRange);
        AmuletOfTransmutation.borderThreshold = AmuletOfTransmutation._borderThreshold = (float)config.get("general", "border_threshold", (double)AmuletOfTransmutation._borderThreshold, "How much of each side of a block will be treated as the adjacent side when placing/transmuting blocks").getDouble((double)AmuletOfTransmutation._borderThreshold);
        AmuletOfTransmutation.rechargeScale = AmuletOfTransmutation._rechargeScale = config.get("general", "recharge_scale", AmuletOfTransmutation._rechargeScale, "Scales how long an amulet will take to recharge (larger values will take longer)").getDouble(AmuletOfTransmutation._rechargeScale);
        AmuletOfTransmutation.allowTransmutationOfRadiation = AmuletOfTransmutation._allowTransmutationOfRadiation = config.get("general", "allow_transmutation_to_air", AmuletOfTransmutation._allowTransmutationOfRadiation, "If true amulets will know how to transmute blocks into 'radiation' (a placeholder for 'air')").getBoolean(AmuletOfTransmutation._allowTransmutationOfRadiation);
        BlockOfReactivity.useAlternateSound = config.get("general", "use_alternate_block_of_reactivity_sounds", BlockOfReactivity.useAlternateSound, "If set to true blocks of reactivity will sound like wool rather than glass").getBoolean(BlockOfReactivity.useAlternateSound);
        AmuletOfTransmutation.allowQuickCreate = AmuletOfTransmutation._allowQuickCreate = config.get("general", "allow_quick_create_blocks", AmuletOfTransmutation._allowQuickCreate, "If true and the amulet has a productivity upgrade, learnt blocks can be created by right-clicking them within the amulet interface").getBoolean(AmuletOfTransmutation._allowQuickCreate);
        AmuletOfTransmutation.allowSurveying = AmuletOfTransmutation._allowSurveying = config.get("general", "allow_surveying", AmuletOfTransmutation._allowSurveying, "If set to false, amulets will not be able to survey areas").getBoolean(AmuletOfTransmutation._allowSurveying);
        AmuletContainer.alphabeticallySorted = !config.get("general", "sort_blocks_by_mpb", !AmuletContainer.alphabeticallySorted, "If true, the blocks an amulet has learnt will be sorted by MPB value, otherwise they will be sorted by name").getBoolean(!AmuletContainer.alphabeticallySorted);
        AreaUpgrade.maximumSideLength = AreaUpgrade._maximumSideLength = config.get("general", "maximum_area_length_per_direction", AreaUpgrade._maximumSideLength, "Maximum distance an area upgrade can be set to in any direction").getInt(AreaUpgrade._maximumSideLength);
        AmuletStack._creationEfficiencyPerReactivityCore = config.get("general", "creation_efficiency_per_reactivity_core", AmuletStack._creationEfficiencyPerReactivityCore, "How efficient an amulet with X reactivity cores will be at creating blocks, (1.0: no wastage, 2.0: blocks costs twice as much to create). Efficiency should not be less than 1.0 or you could have infinite matter").getDoubleList();
        AmuletStack.creationEfficiencyPerReactivityCore = AmuletStack._creationEfficiencyPerReactivityCore;
        AmuletStack._rechargeEfficiencyPerReactivityBlock = config.get("general", "recharge_efficiency_per_reactivity_block", AmuletStack._rechargeEfficiencyPerReactivityBlock, "How efficient an amulet with X blocks of reactivity (as upgrades) will be at recharging, (smaller numbers recharges faster, 1.0 is the default recharge speed). This is essentially a dynamic recharge scale").getDoubleList();
        AmuletStack.rechargeEfficiencyPerReactivityBlock = AmuletStack._rechargeEfficiencyPerReactivityBlock;
        BlockOfReactivity.transparent = config.get("general", "blocks_of_reactivity_are_transparent", BlockOfReactivity.transparent, "If this is false blocks of reactivity will be opaque").getBoolean(BlockOfReactivity.transparent);
        BlockOfReactivity.canClimbReactivityBlocks = BlockOfReactivity._canClimbReactivityBlocks = config.get("general", "blocks_of_reactivity_are_climbable", BlockOfReactivity._canClimbReactivityBlocks, "If true blocks of reactivity can be climbed like ladders or vines").getBoolean(BlockOfReactivity._canClimbReactivityBlocks);
        AmuletOfTransmutation.reactivityBlocksCanBeTransmuted = AmuletOfTransmutation._reactivityBlocksCanBeTransmuted = config.get("general", "blocks_of_reactivity_can_be_transmuted", AmuletOfTransmutation._reactivityBlocksCanBeTransmuted, "If true a block of reactivity will not be destroyed when you try to transmute it into a different type of block").getBoolean(AmuletOfTransmutation._reactivityBlocksCanBeTransmuted);
        TransmutationChest.requirePermissionToDestroyTransmutationChest = TransmutationChest._requirePermissionToDestroyTransmutationChest = config.get("general", "require_permission_to_destroy_transmutation_chests", TransmutationChest._requirePermissionToDestroyTransmutationChest, "If this is true, only players with permission to edit a transmutation chest will be able to destroy it").getBoolean(TransmutationChest._requirePermissionToDestroyTransmutationChest);
        AmuletStack.dualTransmutations = config.get("general", "always_use_dual_transmutation", AmuletStack.dualTransmutations, "Dual transmutation allows your left and right mouse buttons to perform different transmutations, you can set this to true to make dual transmutation the default").getBoolean(AmuletStack.dualTransmutations);
        invertAmuletScrollDirection = config.get("general", "invert_amulet_scroll_direction", invertAmuletScrollDirection, "Inverts the direction shift+scrolling scrolls through your favourite blocks").getBoolean(invertAmuletScrollDirection);
        amuletScrollDelay = config.get("general", "amulet_scroll_delay", amuletScrollDelay, "How many frames/ticks an amulet should be held before shift+scroll will scroll through the amulet's favourite blocks").getInt(amuletScrollDelay);
        dualHotbarSupport = config.get("general", "dual_hotbar_compatibility_enabled", dualHotbarSupport, "Changes when the amulet overlay gets drawn to prevent being cancelled by the dual hotbar mod").getBoolean(dualHotbarSupport);
        screenOffset = config.get("general", "amulet_text_offset", screenOffset, "How far the text that appears at the bottom of the screen while you're holding an amulet should get moved up (22 should accommodate for a double length hotbar)").getInt(screenOffset);
        int forceMode = config.get("general", "force_transmutation_charge_mode", 0, "Set to 1 to make amulets always precharge, set to 2 to make amulets always recharge, set to 0 to allow both").getInt(0);
        AmuletStack._forceRechargeMode = forceMode == 0 ? null : Boolean.valueOf(forceMode == 2);
        AmuletStack.forceRechargeMode = AmuletStack._forceRechargeMode;
        config.save();
        amulet = new AmuletOfTransmutation("amulet");
        GameRegistry.registerItem((Item)amulet, (String)BalancedExchange.amulet.field_77774_bZ);
        areaUpgrade = new AreaUpgrade("area_upgrade");
        GameRegistry.registerItem((Item)areaUpgrade, (String)BalancedExchange.areaUpgrade.field_77774_bZ);
        chainUpgrade = new ChainUpgrade("chain_upgrade");
        GameRegistry.registerItem((Item)chainUpgrade, (String)BalancedExchange.chainUpgrade.field_77774_bZ);
        rangeUpgrade = new OtherUpgrade("range_upgrade");
        GameRegistry.registerItem((Item)rangeUpgrade, (String)BalancedExchange.rangeUpgrade.field_77774_bZ);
        coreUpgrade = new CoreUpgrade("core_upgrade");
        GameRegistry.registerItem((Item)coreUpgrade, (String)BalancedExchange.coreUpgrade.field_77774_bZ);
        productivityUpgrade = new ProductivityUpgrade("productivity_upgrade");
        GameRegistry.registerItem((Item)productivityUpgrade, (String)BalancedExchange.productivityUpgrade.field_77774_bZ);
        surveyorUpgrade = new OtherUpgrade("surveyor_upgrade");
        GameRegistry.registerItem((Item)surveyorUpgrade, (String)BalancedExchange.surveyorUpgrade.field_77774_bZ);
        amuletRestorer = new AmuletRestorer("amulet_restorer");
        GameRegistry.registerItem((Item)amuletRestorer, (String)BalancedExchange.amuletRestorer.field_77774_bZ);
        prechargerUpgrade = new OtherUpgrade("precharger_upgrade");
        GameRegistry.registerItem((Item)prechargerUpgrade, (String)BalancedExchange.prechargerUpgrade.field_77774_bZ);
        blockOfStability = new BlockOfStability("stability_block");
        GameRegistry.registerBlock((Block)blockOfStability, (String)BalancedExchange.blockOfStability.field_149770_b);
        GameRegistry.registerBlock((Block)new GenericBlock164((Block)blockOfStability), GenericBlock164.ItemBlock164.class, (String)(BalancedExchange.blockOfStability.field_149770_b + "164"));
        blockOfReactivity = new BlockOfReactivity("reactivity_block");
        GameRegistry.registerBlock((Block)blockOfReactivity, (String)BalancedExchange.blockOfReactivity.field_149770_b);
        GameRegistry.registerBlock((Block)new GenericBlock164((Block)blockOfReactivity), GenericBlock164.ItemBlock164.class, (String)(BalancedExchange.blockOfReactivity.field_149770_b + "164"));
        reactiveGlow = new BlockOfReactivity.Radiation("radiation");
        GameRegistry.registerBlock((Block)reactiveGlow, (String)BalancedExchange.reactiveGlow.field_149770_b);
        GameRegistry.registerBlock((Block)new GenericBlock164((Block)reactiveGlow), GenericBlock164.ItemBlock164.class, (String)(BalancedExchange.reactiveGlow.field_149770_b + "164"));
        transmutationChest = new TransmutationChest("transmutation_chest");
        GameRegistry.registerBlock((Block)transmutationChest, (String)BalancedExchange.transmutationChest.field_149770_b);
        GameRegistry.registerBlock((Block)new EntityBlock164((Block)transmutationChest), EntityBlock164.ItemBlock164.class, (String)(BalancedExchange.transmutationChest.field_149770_b + "164"));
        UniqueItem.registerProtectedBlockType((UniqueItem.ProtectedBlock)transmutationChest);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.init(this);
        UniqueItem.registerContainerItem((UniqueItem.ContainerItem)amulet);
        AmuletStack.filter_bedrockUpgrade.item = Item.func_150898_a((Block)Blocks.field_150357_h);
        AmuletStack.filter_prechargeUpgrade.item = prechargerUpgrade;
        AmuletStack.filter_efficiencyUpgrade.item = coreUpgrade;
        AmuletStack.filter_reactivityUpgrade.item = Item.func_150898_a((Block)blockOfReactivity);
        AmuletStack.filter_rangeUpgrade.item = rangeUpgrade;
        AmuletStack.filter_productivityUpgrade.item = productivityUpgrade;
        AmuletStack.filter_surveyorUpgrade.item = surveyorUpgrade;
        AmuletStack.filter_stabilityUpgrade.item = Item.func_150898_a((Block)blockOfStability);
        AmuletStack.filter_chainUpgrade.item = chainUpgrade;
        AmuletStack.filter_areaUpgrade.item = areaUpgrade;
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        channel.initialize(modId);
        PacketHandler.registerMessages(channel);
        GameRegistry.registerTileEntity(TransmutationChestTileEntity.class, (String)BalancedExchange.transmutationChest.field_149770_b);
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        ItemStack stack = event.entityPlayer.func_71045_bC();
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && stack != null && stack.func_77973_b() instanceof AmuletOfTransmutation) {
            event.setCanceled(true);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Logger.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            AmuletGuiOverlay overlay = new AmuletGuiOverlay(Minecraft.func_71410_x());
            FMLCommonHandler.instance().bus().register((Object)overlay);
            MinecraftForge.EVENT_BUS.register((Object)overlay);
            BlockSelector.additionalItemProviders.add(new BlockSelector.AdditionalItemProvider(){

                public void addItems(HashMap<String, HashSet<Integer>> additionalItems) {
                    for (String id : AmuletOfTransmutation.MPB.keySet()) {
                        Item item;
                        if (id == null) {
                            id = "null";
                        }
                        if ((item = (Item)GameData.getItemRegistry().func_82594_a(id)) == null) {
                            if (!additionalItems.containsKey(id)) {
                                additionalItems.put(id, new HashSet());
                            }
                            for (Integer metadata : AmuletOfTransmutation.MPB.get(id).keySet()) {
                                additionalItems.get(id).add(metadata);
                            }
                            continue;
                        }
                        ArrayList items = new ArrayList();
                        item.func_150895_a(item, CreativeTabs.field_78027_g, items);
                        for (Integer metadata : AmuletOfTransmutation.MPB.get(id).keySet()) {
                            boolean exists = false;
                            for (ItemStack stack : items) {
                                if (stack.func_77960_j() != metadata.intValue()) continue;
                                exists = true;
                                break;
                            }
                            if (exists) continue;
                            if (!additionalItems.containsKey(id)) {
                                additionalItems.put(id, new HashSet());
                            }
                            additionalItems.get(id).add(metadata);
                        }
                    }
                    for (ItemStack stack : AmuletOfTransmutation.dispensableItemList) {
                        String id;
                        if (!(stack.func_77973_b() instanceof UnknownItem) || AmuletStack.getItem(id = UnknownItem.getItemDescriptor((ItemStack)stack)) == Common.unknownItem) continue;
                        if (!additionalItems.containsKey(id)) {
                            additionalItems.put(id, new HashSet());
                        }
                        additionalItems.get(id).add(stack.func_77960_j());
                    }
                }
            });
        }
        MPBValues.setMPBValue((Object)blockOfStability, 32768);
        MPBValues.setMPBValue((Object)blockOfReactivity, 3, 3);
        MPBValues.setMPBValue((Object)reactiveGlow, -1, 8);
        AmuletOfTransmutation.dispensableItemList.clear();
        AmuletOfTransmutation.dispensableItemListServerSide.clear();
        if (!BalancedExchange.loadMPBValues("default " + fileVersion + ".mpb")) {
            MPBValues.setDefaultMPBValues();
            File file = new File(configDirectory + File.separator + "MPB_values" + File.separator + "default " + fileVersion + ".mpb");
            if (!file.exists()) {
                FMLLog.warning((String)("Balanced Exchange: 'default " + fileVersion + ".mpb' did not exist, so it has been created with the default MPB values"), (Object[])new Object[0]);
                BalancedExchange.saveMPBValues("default " + fileVersion, new MPBFilter(){

                    @Override
                    public void filterItems(Item item, String id, ArrayList<AmuletOfTransmutation.MPBEntry> items) {
                        HashMap<Integer, AmuletOfTransmutation.MPBEntry> map = AmuletOfTransmutation.MPB_ServerSide.get(id);
                        if (map == null) {
                            return;
                        }
                        for (Integer metadata : map.keySet()) {
                            AmuletOfTransmutation.MPBEntry entry = map.get(metadata);
                            if (entry == null || entry.consumed == 0 && entry.created == 0) continue;
                            items.add(entry);
                        }
                    }
                });
            } else {
                FMLLog.warning((String)("Balanced Exchange: Couldn't load 'default " + fileVersion + ".mpb', so using default MPB values"), (Object[])new Object[0]);
            }
        }
        for (int file = 0; file < mpbFilenames.length; ++file) {
            BalancedExchange.loadMPBValues(mpbFilenames[file]);
        }
        AmuletOfTransmutation.settingOverriddenMPBValues = true;
        BalancedExchange.loadMPBValues("overridden.mpb");
        AmuletOfTransmutation.settingOverriddenMPBValues = false;
        PacketHandler.OpenEditorWindow.editors.add(new PacketHandler.OpenEditorWindow.CustomEditor(){

            public boolean loadEditor(String type, int stackId, ContainerStack container, EntityPlayer player) {
                if (type.equals("mpb")) {
                    container.addContainers(player, new StackableContainer[]{new BlockSelector(), new MPBEditor()});
                    return true;
                }
                return false;
            }
        });
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        channel.sendToPlayer(event.player, (MessageChannel.Message)new PacketHandler.InitializePlayer());
    }

    public static String getNamesOfItem(Item item) {
        HashSet<String> names = new HashSet<String>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            item.func_150895_a(item, null, items);
        } else {
            items.add(new ItemStack(item));
        }
        if (items.size() < 1) {
            return null;
        }
        for (int j = 0; j < items.size(); ++j) {
            names.add(((ItemStack)items.get(j)).func_82833_r());
        }
        String name = null;
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            if (name == null) {
                name = (String)iterator.next();
                continue;
            }
            name = name + ", " + (String)iterator.next();
        }
        return name;
    }

    private static void reportMPBError(String message) {
        FMLLog.severe((String)"%s", (Object[])new Object[]{message});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadMPBValues(String filename) {
        block42: {
            boolean bl;
            BufferedReader buffer = null;
            Configuration.UnicodeInputStreamReader input = null;
            try {
                File file = new File(configDirectory + File.separator + "MPB_values" + File.separator + filename);
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists()) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (!file.canRead()) break block42;
                input = new Configuration.UnicodeInputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                buffer = new BufferedReader((Reader)input);
                String line = null;
                String[] parts = null;
                int lineNum = 0;
                do {
                    int mpbCreated;
                    int mpbConsumed;
                    if ((line = buffer.readLine()) != null) {
                        line = line.trim();
                    }
                    ++lineNum;
                    if (line == null || line.length() <= 0 || line.charAt(0) == '#' || (parts = line.split("\t")).length == 0) continue;
                    if (parts.length != 3 && parts.length != 4) {
                        BalancedExchange.reportMPBError("Error in MPB config file \"" + filename + "\", line " + lineNum + ": Entry must have 3 or 4 tab separated values (id, mpb-consumed, mpb-created, is-dispensable)");
                        continue;
                    }
                    ItemStack stack = DynamicRecipes.processItem((String)parts[0], (int)Short.MAX_VALUE);
                    if (stack == null) {
                        BalancedExchange.reportMPBError("Error in MPB config file \"" + filename + "\", line " + lineNum + ": '" + parts[0] + "' is an invalid item");
                        continue;
                    }
                    try {
                        mpbConsumed = Integer.parseInt(parts[1]);
                        mpbCreated = Integer.parseInt(parts[2]);
                    }
                    catch (NumberFormatException e) {
                        BalancedExchange.reportMPBError("Error in MPB config file \"" + filename + "\", line " + lineNum + ": An mpb value wasn't a valid number");
                        continue;
                    }
                    MPBValues.setMPBValue(stack.func_77973_b(), DynamicRecipes.lastMetadata, mpbConsumed, mpbCreated);
                    if (parts.length != 4 || !parts[3].equals("1") && !parts[3].toLowerCase().equals("true")) continue;
                    AmuletOfTransmutation.addDispensableItem(UnknownItem.getItemDescriptor((ItemStack)stack), DynamicRecipes.lastMetadata == Short.MAX_VALUE ? 0 : DynamicRecipes.lastMetadata);
                } while (line != null);
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                bl = true;
            }
            catch (IOException e) {
                BalancedExchange.reportMPBError("Failed to load MPB values from " + filename);
                e.printStackTrace();
                break block42;
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException e) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        return false;
    }

    public void instantiateRecipes(ArrayList<String> files) {
        Iterator<String> iterator = files.iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            if (!name.toLowerCase().startsWith(modId) && !name.toLowerCase().startsWith("default")) continue;
            iterator.remove();
        }
        final ArrayList recipes = new ArrayList();
        if (!Common.loadDynamicRecipes((String)("balancedexchange " + fileVersion + ".drd"), (boolean)false)) {
            try {
                DynamicRecipes.buildRecipe(recipes, (Object)((Object)amulet), (String)"121345161", (Object[])new Object[]{Items.field_151042_j, Items.field_151133_ar, Items.field_151129_at, Items.field_151079_bi, Items.field_151131_as, Blocks.field_150346_d});
                DynamicRecipes.buildRecipe(recipes, (Object)((Object)amuletRestorer), (String)"121345161", (Object[])new Object[]{Items.field_151043_k, Items.field_151133_ar, Items.field_151129_at, Items.field_151061_bv, Items.field_151131_as, Blocks.field_150346_d});
                DynamicRecipes.buildRecipe(recipes, (Object)((Object)transmutationChest), (String)"111121111", (Object[])new Object[]{Blocks.field_150344_f, amulet});
                DynamicRecipes.buildRecipe(recipes, (Object)((Object)areaUpgrade), (String)"121212121", (Object[])new Object[]{blockOfStability, blockOfReactivity});
                DynamicRecipes.buildRecipe(recipes, (Object)((Object)chainUpgrade), (String)"121212121", (Object[])new Object[]{blockOfReactivity, blockOfStability});
                DynamicRecipes.buildRecipe(recipes, (Object)((Object)rangeUpgrade), (String)"121343151", (Object[])new Object[]{blockOfReactivity, Blocks.field_150359_w, blockOfStability, Items.field_151079_bi, amulet});
                DynamicRecipes.buildRecipe(recipes, (Object)((Object)coreUpgrade), (String)"121232121", (Object[])new Object[]{Items.field_151042_j, blockOfReactivity, Items.field_151079_bi});
                DynamicRecipes.buildRecipe(recipes, (Object)((Object)productivityUpgrade), (String)"111121111", (Object[])new Object[]{blockOfReactivity, blockOfStability});
                DynamicRecipes.buildRecipe(recipes, (Object)((Object)surveyorUpgrade), (String)"121313323", (Object[])new Object[]{blockOfStability, Items.field_151079_bi, blockOfReactivity});
                DynamicRecipes.buildRecipe(recipes, (Object)((Object)prechargerUpgrade), (String)"001323330", (Object[])new Object[]{blockOfStability, transmutationChest, Blocks.field_150438_bZ});
                DynamicRecipes.buildRecipe(recipes, (Object)((Object)blockOfStability), (Object[])new Object[]{amulet, 4, Items.field_151045_i});
                DynamicRecipes.buildRecipe(recipes, (Object)new ItemStack(Items.field_151045_i, 4), (Object[])new Object[]{amulet, blockOfStability});
                DynamicRecipes.buildRecipe(recipes, (Object)Items.field_151045_i, (Object[])new Object[]{amulet, 4, Items.field_151043_k});
                DynamicRecipes.buildRecipe(recipes, (Object)new ItemStack(Items.field_151043_k, 4), (Object[])new Object[]{amulet, Items.field_151045_i});
                DynamicRecipes.buildRecipe(recipes, (Object)Items.field_151043_k, (Object[])new Object[]{amulet, 8, Items.field_151042_j});
                DynamicRecipes.buildRecipe(recipes, (Object)new ItemStack(Items.field_151042_j, 8), (Object[])new Object[]{amulet, Items.field_151043_k});
                DynamicRecipes.buildRecipe(recipes, (Object)Items.field_151042_j, (Object[])new Object[]{amulet, 8, Blocks.field_150364_r});
                DynamicRecipes.buildRecipe(recipes, (Object)Items.field_151042_j, (Object[])new Object[]{amulet, 8, Blocks.field_150363_s});
                DynamicRecipes.buildRecipe(recipes, (Object)new ItemStack((Block)blockOfReactivity, 10), (Object[])new Object[]{amulet, Items.field_151042_j});
                for (int i = 0; i < 16; ++i) {
                    DynamicRecipes.buildRecipe(recipes, (Object)new ItemStack(Items.field_151100_aR, 1, 15 - i), (Object[])new Object[]{amulet, Blocks.field_150325_L, Integer.toString(i)});
                }
            }
            catch (DynamicRecipes.DynamicRecipeException e) {
                throw new RuntimeException("Balanced Exchange's default recipes couldn't be processed! " + e.getMessage(), e);
            }
            if (!Common.drdExists((String)("balancedexchange " + fileVersion + ".drd"))) {
                FMLLog.warning((String)("Balanced Exchange: 'balancedexchange " + fileVersion + ".drd' did not exist, so has been created using the default recipe definitions"), (Object[])new Object[0]);
                Common.saveDynamicRecipes((String)("balancedexchange " + fileVersion), (Common.DRDFilter)new Common.DRDFilter(){

                    public boolean includeRecipe(DynamicRecipes.Recipe recipe, boolean disabled) {
                        return !disabled && recipes.contains(recipe.getRepresentation());
                    }
                }, (boolean)false);
            } else {
                FMLLog.warning((String)("Balanced Exchange: Couldn't load 'balancedexchange " + fileVersion + ".drd', so using default recipes definitions"), (Object[])new Object[0]);
            }
        }
    }

    public static void saveMPBValues(String filename, MPBFilter filter) {
        block8: {
            try {
                File file = new File(configDirectory + File.separator + "MPB_values" + File.separator + filename + ".mpb");
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists() && !file.createNewFile()) {
                    return;
                }
                if (!file.canWrite()) break block8;
                FileOutputStream fos = new FileOutputStream(file);
                BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                buffer.write("# Config file for BalancedExchange's MPB values" + Configuration.NEW_LINE);
                buffer.write("# Any line that starts with a hash is a comment and won't be processed by BalancedExchange" + Configuration.NEW_LINE);
                buffer.write("# Every non-empty, non-comment line must contain 3 tab separated values and optionally a true/false value" + Configuration.NEW_LINE);
                buffer.write("# The first value is the id of the item/block to set with optional :metadata suffix" + Configuration.NEW_LINE);
                buffer.write("# The second value is the amount of matter gained when the item/block is consumed (0 makes it inconsumable)" + Configuration.NEW_LINE);
                buffer.write("# The third value is the amount of matter lost when the item/block is created (0 makes it uncreatable)" + Configuration.NEW_LINE);
                buffer.write("# If the fourth value is provided it will control whether the item/block is dispensable" + Configuration.NEW_LINE);
                buffer.write("# Any negative MPB value will be incremented by 1, so the line \"minecraft:dirt -2 -1\" would make dirt consumable at -1 MPB and creatable at 0 MPB" + Configuration.NEW_LINE);
                buffer.write("# Undefined MPB values are automatically set to 0, 0, so if both MPB values are 0 you shouldn't include it in this file unless you wish to overwrite mpb values given by another mpb file" + Configuration.NEW_LINE + Configuration.NEW_LINE);
                ArrayList<AmuletOfTransmutation.MPBEntry> items = new ArrayList<AmuletOfTransmutation.MPBEntry>();
                for (Item item : GameData.getItemRegistry()) {
                    if (item == null) continue;
                    String id = AmuletStack.getDescriptor(item);
                    items.clear();
                    filter.filterItems(item, id, items);
                    if (items.size() < 1) continue;
                    for (AmuletOfTransmutation.MPBEntry entry : items) {
                        String name = "<invalid name>";
                        int metadata = entry.metadata;
                        try {
                            name = item.func_77658_a();
                            name = metadata == Short.MAX_VALUE ? (name == null ? "<unnamed item>" : ("" + StatCollector.func_74838_a((String)(name + ".name"))).trim()) : new ItemStack(item, 1, metadata).func_82833_r();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        buffer.write("# " + name + Configuration.NEW_LINE);
                        String dispensable = AmuletOfTransmutation.dispensableItems.contains("item" + id + "dam" + metadata) ? "\ttrue" : "";
                        buffer.write(id + (metadata == Short.MAX_VALUE ? "" : ":" + metadata) + "\t" + entry.consumed + "\t" + entry.created + dispensable + Configuration.NEW_LINE + Configuration.NEW_LINE);
                    }
                }
                buffer.close();
                fos.close();
            }
            catch (IOException e) {
                BalancedExchange.reportMPBError("Balanced Exchange: Failed to save MPB values to " + filename + ".mpb");
                e.printStackTrace();
            }
        }
    }

    public static void saveOverriddenMPBValues() {
        BalancedExchange.saveMPBValues("overridden", new MPBFilter(){

            @Override
            public void filterItems(Item item, String id, ArrayList<AmuletOfTransmutation.MPBEntry> items) {
                HashSet<Integer> map = AmuletOfTransmutation.overriddenMPBValues.get(id);
                if (map == null) {
                    return;
                }
                for (Integer metadata : map) {
                    AmuletOfTransmutation.MPBEntry entry = AmuletOfTransmutation.getMPBEntry(id, (int)metadata);
                    if (entry == null) continue;
                    items.add(entry);
                }
            }
        });
    }

    static {
        fileVersion = "1.7.2 - 3.0";
        channel = new MessageChannel();
        mpbFilenames = new String[0];
        invertAmuletScrollDirection = false;
        amuletScrollDelay = 6;
        screenOffset = 0;
        dualHotbarSupport = false;
    }

    public static interface MPBFilter {
        public void filterItems(Item var1, String var2, ArrayList<AmuletOfTransmutation.MPBEntry> var3);
    }
}

