/*
 * Decompiled with CFR 0.152.
 */
package brad16840.balancedexchange;

import brad16840.balancedexchange.BalancedExchange;
import brad16840.balancedexchange.PacketHandler;
import brad16840.balancedexchange.items.AmuletOfTransmutation;
import brad16840.balancedexchange.items.AreaUpgrade;
import brad16840.balancedexchange.items.CoreUpgrade;
import brad16840.common.BlockPos;
import brad16840.common.Common;
import brad16840.common.MessageChannel;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class AmuletStack {
    private EntityPlayer player;
    private World world;
    private String id;
    public static double[] _creationEfficiencyPerReactivityCore = new double[]{2.0, 1.75, 1.5, 1.25, 1.0};
    public static double[] _rechargeEfficiencyPerReactivityBlock = new double[]{1.0, 0.666, 0.5, 0.444, 0.4};
    public static double[] creationEfficiencyPerReactivityCore;
    public static double[] rechargeEfficiencyPerReactivityBlock;
    public static Boolean _forceRechargeMode;
    public static Boolean forceRechargeMode;
    public static boolean dualTransmutations;
    public static ItemIdFilter filter_bedrockUpgrade;
    public static ItemIdFilter filter_prechargeUpgrade;
    public static ItemIdFilter filter_efficiencyUpgrade;
    public static ItemIdFilter filter_reactivityUpgrade;
    public static ItemIdFilter filter_rangeUpgrade;
    public static ItemFilter filter_dualTransmutation;
    public static ItemFilter filter_silkTouch;
    public static ItemIdFilter filter_productivityUpgrade;
    public static ItemIdFilter filter_surveyorUpgrade;
    public static ItemIdFilter filter_stabilityUpgrade;
    public static ItemIdFilter filter_chainUpgrade;
    public static ItemIdFilter filter_areaUpgrade;

    public static AmuletStack create(EntityPlayer player, String id) {
        AmuletStack stack = new AmuletStack(player, id);
        if (!stack.ensureNBTTags(player)) {
            return null;
        }
        return stack;
    }

    public static AmuletStack create(EntityPlayer player, World world, String id) {
        AmuletStack stack = player != null ? new AmuletStack(player, id) : new AmuletStack(world, id);
        if (!stack.ensureNBTTags(player)) {
            return null;
        }
        return stack;
    }

    private AmuletStack(EntityPlayer player, String id) {
        this.player = player;
        this.world = player.field_70170_p;
        this.id = id;
    }

    private AmuletStack(World world, String id) {
        this.player = null;
        this.world = world;
        this.id = id;
    }

    public boolean ensureNBTTags(EntityPlayer player) {
        boolean dirty = false;
        NBTTagCompound tagCompound = this.getTagCompound();
        if (tagCompound == null) {
            return false;
        }
        if (!tagCompound.func_74764_b("LearnedItems")) {
            tagCompound.func_74782_a("LearnedItems", (NBTBase)new NBTTagCompound());
            dirty = true;
        }
        String itemKey = "item" + AmuletStack.getDescriptor(AmuletOfTransmutation.defaultItem.func_77973_b()) + "dam" + AmuletOfTransmutation.defaultItem.func_77960_j();
        NBTTagCompound learnedItems = tagCompound.func_74775_l("LearnedItems");
        if (!learnedItems.func_74764_b(itemKey)) {
            NBTTagCompound newTag = new NBTTagCompound();
            ItemStack stack = AmuletOfTransmutation.defaultItem.func_77946_l();
            stack.field_77994_a = AmuletOfTransmutation.learnThreshold;
            UniqueItem.writeItemStackToNBT((ItemStack)stack, (NBTTagCompound)newTag);
            learnedItems.func_74782_a(itemKey, (NBTBase)newTag);
            dirty = true;
        }
        if (!tagCompound.func_74764_b("StoredMatter")) {
            tagCompound.func_74772_a("StoredMatter", 32L);
            dirty = true;
        }
        if (!tagCompound.func_74764_b("handedness")) {
            tagCompound.func_74782_a("handedness", (NBTBase)new NBTTagCompound());
            dirty = true;
        }
        if (!tagCompound.func_74764_b("ActiveItemA")) {
            tagCompound.func_74782_a("ActiveItemA", (NBTBase)new NBTTagCompound());
            this.setActiveItem(AmuletOfTransmutation.defaultItem, true);
            dirty = true;
        }
        if (!tagCompound.func_74764_b("ActiveItemB")) {
            tagCompound.func_74782_a("ActiveItemB", (NBTBase)new NBTTagCompound());
            this.setActiveItem(AmuletOfTransmutation.defaultItem, false);
            dirty = true;
        }
        if (!tagCompound.func_74764_b("QuickList")) {
            tagCompound.func_74782_a("QuickList", (NBTBase)new NBTTagCompound());
            dirty = true;
        }
        if (!tagCompound.func_74764_b("172checked")) {
            this.getLearnedItems(new ArrayList<ItemStack>());
            tagCompound.func_74782_a("172checked", (NBTBase)new NBTTagByte(1));
            dirty = true;
        }
        if (dirty) {
            this.markDirty();
        }
        return true;
    }

    public String getIdentifier() {
        return this.id;
    }

    public void markDirty() {
        UniqueItemData.get((World)this.world).markItemDirty(this.id);
    }

    private NBTTagCompound getTagCompound() {
        UniqueItemData data = UniqueItemData.get((World)this.world);
        if (this.player == null) {
            return data.getItemData(this.id, false);
        }
        return data.getItemData(this.player, this.id);
    }

    public NBTTagCompound getCompoundTag(String key) {
        return this.getTagCompound().func_74775_l(key);
    }

    public static boolean canLearnItemStack(ItemStack stack) {
        if (stack.func_77969_a(AmuletOfTransmutation.defaultItem)) {
            return true;
        }
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        return AmuletOfTransmutation.getMPBEntry((ItemStack)stack).created != 0 && (AmuletOfTransmutation.getMPBEntry((ItemStack)stack).created >= -121 || AmuletOfTransmutation.getMPBEntry((ItemStack)stack).created <= -125);
    }

    public static boolean canConsumeItemStack(EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == BalancedExchange.amulet) {
            if (player == null) {
                return false;
            }
            return UniqueItemData.get((World)player.field_70170_p).hasRequiredPermission(player, UniqueItem.getIdentifier((ItemStack)stack), 2);
        }
        return AmuletOfTransmutation.getMPBEntry((ItemStack)stack).consumed != 0;
    }

    public static int getMPBConsumed(EntityPlayer player, World world, ItemStack stack) {
        if (stack.func_77973_b() == BalancedExchange.amulet) {
            String uuid = UniqueItem.getIdentifier((ItemStack)stack);
            if (uuid.equals("none")) {
                return 0;
            }
            if (player == null || !UniqueItemData.get((World)world).hasRequiredPermission(player, uuid, 2)) {
                return 0;
            }
            AmuletStack amulet = AmuletStack.create(player, world, uuid);
            return amulet == null ? 0 : amulet.getStoredMatter();
        }
        int mpb = AmuletOfTransmutation.getMPBEntry((ItemStack)stack).consumed;
        if (mpb < 0) {
            return mpb + 1;
        }
        return mpb;
    }

    public int getStoredMatter() {
        return (int)this.getTagCompound().func_74763_f("StoredMatter");
    }

    public void setStoredMatter(int matter) {
        UniqueItemData data = UniqueItemData.get((World)this.world);
        if (!this.hasRequiredPermission(data, this.id, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log(this.player);
            return;
        }
        if (matter < 0) {
            matter = 0;
        }
        if (matter > 1000000000) {
            matter = 1000000000;
        }
        this.getTagCompound().func_74772_a("StoredMatter", (long)matter);
        this.markDirty();
    }

    public boolean isValidMode(UniqueItemInventory inventory, String uuid, int mode, Boolean left) {
        if (mode == 0) {
            return true;
        }
        if (mode == 1) {
            if (!AmuletStack.hasUpgrade(this.player, this.world, inventory, uuid, filter_chainUpgrade, left)) {
                return false;
            }
        } else if (mode == 2) {
            if (!AmuletStack.hasUpgrade(this.player, this.world, inventory, uuid, filter_areaUpgrade, left)) {
                return false;
            }
        } else if (mode == 3) {
            if (!AmuletStack.hasUpgrade(this.player, this.world, inventory, uuid, filter_areaUpgrade, left)) {
                return false;
            }
        } else if (mode == 4) {
            if (!AmuletStack.hasUpgrade(this.player, this.world, inventory, uuid, filter_chainUpgrade, left) || !AmuletStack.hasUpgrade(this.player, this.world, inventory, uuid, filter_areaUpgrade, left)) {
                return false;
            }
        } else if (mode == 5) {
            if (!AmuletStack.hasUpgrade(this.player, this.world, inventory, uuid, filter_chainUpgrade, left) || !AmuletStack.hasUpgrade(this.player, this.world, inventory, uuid, filter_areaUpgrade, left)) {
                return false;
            }
        } else if (mode == 6) {
            if (!AmuletOfTransmutation.allowSurveying || !AmuletStack.hasUpgrade(this.player, this.world, inventory, uuid, filter_surveyorUpgrade, left)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public int getMode(boolean left) {
        int mode = this.getTagCompound().func_74762_e("currentMode" + (left ? "A" : "B"));
        String uuid = this.getIdentifier();
        UniqueItemInventory inventory = UniqueItemInventory.createInventory((Item)BalancedExchange.amulet, (EntityPlayer)this.player, (String)uuid);
        if (!this.isValidMode(inventory, uuid, mode, left)) {
            mode = 0;
        }
        return mode;
    }

    public void setMode(boolean left, int mode) {
        UniqueItemData data = UniqueItemData.get((World)this.world);
        if (!this.hasRequiredPermission(data, this.id, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log(this.player);
            return;
        }
        this.getTagCompound().func_74768_a("currentMode" + (left ? "A" : "B"), mode);
        this.markDirty();
    }

    public void nextValidMode(boolean left, boolean triggerUpdate) {
        UniqueItemData data = UniqueItemData.get((World)this.player.field_70170_p);
        if (!data.hasRequiredPermission(this.player, this.id, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log(this.player);
            return;
        }
        int mode = this.getTagCompound().func_74762_e("currentMode" + (left ? "A" : "B")) + 1;
        String uuid = this.getIdentifier();
        UniqueItemInventory inventory = UniqueItemInventory.createInventory((Item)BalancedExchange.amulet, (EntityPlayer)this.player, (String)uuid);
        while (!this.isValidMode(inventory, uuid, mode, left)) {
            if (++mode <= 6 && mode >= 0) continue;
            mode = 0;
        }
        this.getTagCompound().func_74768_a("currentMode" + (left ? "A" : "B"), mode);
        if (triggerUpdate) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.ModeChange(this.getIdentifier(), left, mode));
        }
        this.markDirty();
    }

    public void prevValidMode(boolean left, boolean triggerUpdate) {
        UniqueItemData data = UniqueItemData.get((World)this.player.field_70170_p);
        if (!data.hasRequiredPermission(this.player, this.id, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log(this.player);
            return;
        }
        int mode = this.getTagCompound().func_74762_e("currentMode" + (left ? "A" : "B")) - 1;
        String uuid = this.getIdentifier();
        UniqueItemInventory inventory = UniqueItemInventory.createInventory((Item)BalancedExchange.amulet, (EntityPlayer)this.player, (String)uuid);
        while (!this.isValidMode(inventory, uuid, mode, left)) {
            if (--mode >= 0 && mode <= 6) continue;
            mode = 6;
        }
        this.getTagCompound().func_74768_a("currentMode" + (left ? "A" : "B"), mode);
        if (triggerUpdate) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.ModeChange(this.getIdentifier(), left, mode));
        }
        this.markDirty();
    }

    public int getSurveyMode() {
        int mode = this.getTagCompound().func_74762_e("surveyMode");
        if (mode < 0) {
            mode = 0;
        }
        if (mode > 5) {
            mode = 5;
        }
        return mode;
    }

    public void setSurveyMode(int mode, boolean triggerUpdate) {
        UniqueItemData data = UniqueItemData.get((World)this.world);
        if (!this.hasRequiredPermission(data, this.id, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log(this.player);
            return;
        }
        while (mode < 0) {
            mode += 5;
        }
        while (mode > 5) {
            mode -= 5;
        }
        this.getTagCompound().func_74768_a("surveyMode", mode);
        if (triggerUpdate) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.SurveyModeChange(this.getIdentifier(), mode));
        }
        this.markDirty();
    }

    public String getSurveyAreaString(EntityPlayer player, int mode) {
        while (mode < 0) {
            mode += 5;
        }
        while (mode > 5) {
            mode -= 5;
        }
        if (mode == 0) {
            return "1x1x8";
        }
        if (mode == 1) {
            return "3x3x8";
        }
        if (mode == 2) {
            return "1x1x16";
        }
        if (mode == 3) {
            return "3x3x16";
        }
        if (mode == 4) {
            return "1x1x32";
        }
        if (mode == 5) {
            return "3x3x32";
        }
        return new Translatable("problem.invalidsurveymode", new Object[0]).translate();
    }

    public int getSurveyCost(EntityPlayer player) {
        int mode = this.getSurveyMode();
        if (mode == 0) {
            return 3;
        }
        if (mode == 1) {
            return 9;
        }
        if (mode == 2) {
            return 9;
        }
        if (mode == 3) {
            return 27;
        }
        if (mode == 4) {
            return 27;
        }
        if (mode == 5) {
            return 51;
        }
        return 0;
    }

    private int[] orientateArea(int w, int d, int sideHit) {
        if (sideHit == 1) {
            return new int[]{-w, -d, -w, w, 0, w};
        }
        if (sideHit == 0) {
            return new int[]{-w, 0, -w, w, d, w};
        }
        if (sideHit == 3) {
            return new int[]{-w, -w, -d, w, w, 0};
        }
        if (sideHit == 2) {
            return new int[]{-w, -w, 0, w, w, d};
        }
        if (sideHit == 5) {
            return new int[]{-d, -w, -w, 0, w, w};
        }
        if (sideHit == 4) {
            return new int[]{0, -w, -w, d, w, w};
        }
        return new int[]{0, 0, 0, 0, 0, 0};
    }

    public int[] getSurveyArea(EntityPlayer player, BlockPos pos, int sideHit) {
        int mode = this.getSurveyMode();
        int[] area = null;
        if (mode == 0) {
            area = this.orientateArea(0, 8, sideHit);
        } else if (mode == 1) {
            area = this.orientateArea(1, 8, sideHit);
        } else if (mode == 2) {
            area = this.orientateArea(0, 16, sideHit);
        } else if (mode == 3) {
            area = this.orientateArea(1, 16, sideHit);
        } else if (mode == 4) {
            area = this.orientateArea(0, 32, sideHit);
        } else if (mode == 5) {
            area = this.orientateArea(1, 32, sideHit);
        }
        area[0] = area[0] + pos.x;
        area[1] = area[1] + pos.y;
        area[2] = area[2] + pos.z;
        area[3] = area[3] + pos.x;
        area[4] = area[4] + pos.y;
        area[5] = area[5] + pos.z;
        return area;
    }

    public static String getDescriptor(Item item) {
        return GameData.getItemRegistry().func_148750_c((Object)item);
    }

    public static String getDescriptor(Block block) {
        return GameData.getBlockRegistry().func_148750_c((Object)block);
    }

    public static Item getItem(String itemDescriptor) {
        if (itemDescriptor == null) {
            return Common.unknownItem;
        }
        Item item = (Item)GameData.getItemRegistry().func_82594_a(itemDescriptor);
        return item == null ? Common.unknownItem : item;
    }

    public ItemStack getActiveItem(boolean left) {
        NBTTagCompound tag = this.getCompoundTag("ActiveItem" + (left ? "A" : "B"));
        return UniqueItem.getItemStack((String)UniqueItem.getNBTId((NBTTagCompound)tag), (int)tag.func_74765_d("Damage"), (int)AmuletOfTransmutation.learnThreshold);
    }

    public void setActiveItem(ItemStack stack, boolean left) {
        if (stack == null) {
            return;
        }
        UniqueItemData data = UniqueItemData.get((World)this.world);
        if (!this.hasRequiredPermission(data, this.id, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log(this.player);
            return;
        }
        NBTTagCompound tag = this.getCompoundTag("ActiveItem" + (left ? "A" : "B"));
        UniqueItem.setNBTId((NBTTagCompound)tag, (String)AmuletStack.getDescriptor(stack.func_77973_b()));
        tag.func_74777_a("Damage", (short)stack.func_77960_j());
        this.markDirty();
    }

    public double getCreationEfficiency(Boolean left) {
        String uuid = this.getIdentifier();
        if (creationEfficiencyPerReactivityCore.length == 0) {
            return 1.0;
        }
        int cores = AmuletStack.getReactivityCoreCount(this.player, this.world, uuid, left);
        if (cores >= creationEfficiencyPerReactivityCore.length) {
            return creationEfficiencyPerReactivityCore[creationEfficiencyPerReactivityCore.length - 1];
        }
        return creationEfficiencyPerReactivityCore[cores];
    }

    public double getRechargeEfficiency(Boolean left) {
        if (rechargeEfficiencyPerReactivityBlock.length == 0) {
            return 1.0;
        }
        String uuid = this.getIdentifier();
        if (AmuletStack.hasUpgrade(this.player, this.world, uuid, filter_bedrockUpgrade, left)) {
            return 0.0;
        }
        int totalblocks = AmuletStack.getReactivityUpgradeCount(this.player, this.world, uuid, left);
        int blocks = totalblocks / 64;
        if (blocks >= rechargeEfficiencyPerReactivityBlock.length - 1) {
            return rechargeEfficiencyPerReactivityBlock[rechargeEfficiencyPerReactivityBlock.length - 1];
        }
        int excess = totalblocks - blocks * 64;
        double t = rechargeEfficiencyPerReactivityBlock[blocks];
        return t + (rechargeEfficiencyPerReactivityBlock[blocks + 1] - t) * (double)excess / 64.0;
    }

    public int getBlockCreationCost(ItemStack stack, Boolean left) {
        int baseCost = AmuletOfTransmutation.getMPBEntry((ItemStack)stack).created;
        if (baseCost == 0 || baseCost < -121 && baseCost > -125) {
            return 1000000001;
        }
        if (baseCost < 0) {
            ++baseCost;
        }
        double efficiency = this.getCreationEfficiency(left);
        if (baseCost < 0) {
            efficiency = 1.0;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)BalancedExchange.blockOfReactivity)) {
            baseCost = (int)((double)baseCost * efficiency);
        }
        return (int)((double)baseCost * efficiency);
    }

    public boolean canQuickCreateBlocks(Boolean left) {
        if (!AmuletOfTransmutation.allowQuickCreate) {
            return false;
        }
        return AmuletStack.hasUpgrade(this.player, this.world, this.getIdentifier(), filter_productivityUpgrade, left);
    }

    public void forgetItemStack(ItemStack stack, boolean triggerUpdate) {
        ItemStack s;
        if (stack == null) {
            return;
        }
        if (AmuletOfTransmutation.defaultItem.func_77973_b() == stack.func_77973_b() && AmuletOfTransmutation.defaultItem.func_77960_j() == stack.func_77960_j()) {
            return;
        }
        UniqueItemData data = UniqueItemData.get((World)this.world);
        if (!this.hasRequiredPermission(data, this.id, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log(this.player);
            return;
        }
        String itemKey = "item" + AmuletStack.getDescriptor(stack.func_77973_b()) + "dam" + stack.func_77960_j();
        NBTTagCompound learnedItems = this.getCompoundTag("LearnedItems");
        if (learnedItems.func_74764_b(itemKey)) {
            learnedItems.func_82580_o(itemKey);
        }
        if ((s = this.getActiveItem(true)).func_77973_b() == stack.func_77973_b() && s.func_77960_j() == stack.func_77960_j()) {
            this.setActiveItem(AmuletOfTransmutation.defaultItem, true);
        }
        if ((s = this.getActiveItem(false)).func_77973_b() == stack.func_77973_b() && s.func_77960_j() == stack.func_77960_j()) {
            this.setActiveItem(AmuletOfTransmutation.defaultItem, false);
        }
        this.markDirty();
        if (triggerUpdate) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.ForgetItemStack(this.getIdentifier(), stack));
        }
    }

    public static boolean isDualMode(EntityPlayer player, String uuid) {
        if (dualTransmutations) {
            return true;
        }
        return AmuletStack.hasUpgrade(player, player.field_70170_p, uuid, filter_dualTransmutation, null);
    }

    public static boolean isPrecharged(EntityPlayer player, World world, String uuid, Boolean left) {
        if (forceRechargeMode != null) {
            return forceRechargeMode;
        }
        return AmuletStack.hasUpgrade(player, world, uuid, filter_prechargeUpgrade, left);
    }

    private static ItemStack getUpgrade(UniqueItemInventory inventory, ItemFilter filter, HashSet<String> visited, ArrayList<String> unvisited, Boolean left) {
        if (inventory == null) {
            return null;
        }
        Object tag = inventory.getCompoundTag(inventory.world, null);
        if (tag != null) {
            tag = tag.func_74764_b("handedness") ? tag.func_74775_l("handedness") : null;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            String uuid;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || tag != null && tag.func_74765_d("i" + i) == 3 || tag != null && left != null && tag.func_74765_d("i" + i) == (left != false ? (short)2 : 1)) continue;
            if (filter.allow(stack)) {
                return stack;
            }
            if (!(stack.func_77973_b() instanceof UniqueItem.ContainerItem) || (uuid = UniqueItem.getIdentifier((ItemStack)stack)).equals("none") || visited.contains(uuid)) continue;
            visited.add(uuid);
            unvisited.add(uuid);
        }
        return null;
    }

    public static ItemStack getUpgrade(EntityPlayer player, String uuid, ItemFilter filter, Boolean left) {
        return AmuletStack.getUpgrade(player, UniqueItemInventory.getInventory((EntityPlayer)player, (String)uuid), uuid, filter, left);
    }

    public static ItemStack getUpgrade(EntityPlayer player, UniqueItemInventory inventory, String uuid, ItemFilter filter, Boolean left) {
        HashSet<String> visited = new HashSet<String>();
        ArrayList<String> unvisited = new ArrayList<String>();
        visited.add(uuid);
        ItemStack upgrade = AmuletStack.getUpgrade(inventory, filter, visited, unvisited, left);
        while (!unvisited.isEmpty()) {
            if (upgrade != null) {
                return upgrade;
            }
            uuid = unvisited.remove(0);
            upgrade = AmuletStack.getUpgrade(UniqueItemInventory.getInventory((EntityPlayer)player, (String)uuid), filter, visited, unvisited, left);
        }
        return upgrade;
    }

    private static int countUpgrades(UniqueItemInventory inventory, ItemFilter filter, HashSet<String> visited, ArrayList<String> unvisited, Boolean left) {
        int count = 0;
        if (inventory == null) {
            return count;
        }
        Object tag = inventory.getCompoundTag(inventory.world, null);
        if (tag != null) {
            tag = tag.func_74764_b("handedness") ? tag.func_74775_l("handedness") : null;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            String uuid;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || tag != null && tag.func_74765_d("i" + i) == 3 || tag != null && left != null && tag.func_74765_d("i" + i) == (left != false ? (short)2 : 1)) continue;
            if (filter.allow(stack)) {
                count += stack.field_77994_a;
            }
            if (!(stack.func_77973_b() instanceof UniqueItem.ContainerItem) || (uuid = UniqueItem.getIdentifier((ItemStack)stack)).equals("none") || visited.contains(uuid)) continue;
            visited.add(uuid);
            unvisited.add(uuid);
        }
        return count;
    }

    public static int countUpgrades(EntityPlayer player, World world, String uuid, ItemFilter filter, int maxNeeded, Boolean left) {
        return AmuletStack.countUpgrades(player, world, UniqueItemInventory.getInventory((EntityPlayer)player, (World)world, (String)uuid), uuid, filter, maxNeeded, left);
    }

    public static int countUpgrades(EntityPlayer player, World world, UniqueItemInventory inventory, String uuid, ItemFilter filter, int maxNeeded, Boolean left) {
        if (maxNeeded < 1) {
            maxNeeded = 99;
        }
        HashSet<String> visited = new HashSet<String>();
        ArrayList<String> unvisited = new ArrayList<String>();
        visited.add(uuid);
        int count = AmuletStack.countUpgrades(inventory, filter, visited, unvisited, left);
        while (!unvisited.isEmpty()) {
            if (count > maxNeeded) {
                return maxNeeded;
            }
            uuid = unvisited.remove(0);
            count += AmuletStack.countUpgrades(UniqueItemInventory.getInventory((EntityPlayer)player, (World)world, (String)uuid), filter, visited, unvisited, left);
        }
        return count;
    }

    public static boolean hasUpgrade(EntityPlayer player, World world, String uuid, ItemFilter filter, Boolean left) {
        return AmuletStack.countUpgrades(player, world, uuid, filter, 1, left) > 0;
    }

    public static boolean hasUpgrade(EntityPlayer player, World world, UniqueItemInventory inventory, String uuid, ItemFilter filter, Boolean left) {
        return AmuletStack.countUpgrades(player, world, inventory, uuid, filter, 1, left) > 0;
    }

    public ItemStack getAreaOfEffect(EntityPlayer player, UniqueItemInventory inventory, String uuid, Boolean left) {
        return AmuletStack.getUpgrade(player, inventory, uuid, filter_areaUpgrade, left);
    }

    public ItemStack getAreaOfEffect(EntityPlayer player, String uuid, Boolean left) {
        return AmuletStack.getUpgrade(player, uuid, filter_areaUpgrade, left);
    }

    public Translatable getAreaOfEffectString(EntityPlayer player, UniqueItemInventory inventory, String uuid, Boolean left) {
        ItemStack upgrade = this.getAreaOfEffect(player, inventory, uuid, left);
        if (upgrade != null && upgrade.func_77973_b() instanceof AreaUpgrade) {
            return ((AreaUpgrade)upgrade.func_77973_b()).getAreaString(player, upgrade);
        }
        return new Translatable("", new Object[0]);
    }

    public Translatable getAreaOfEffectString(EntityPlayer player, String uuid, Boolean left) {
        ItemStack upgrade = this.getAreaOfEffect(player, uuid, left);
        if (upgrade != null && upgrade.func_77973_b() instanceof AreaUpgrade) {
            return ((AreaUpgrade)upgrade.func_77973_b()).getAreaString(player, upgrade);
        }
        return new Translatable("", new Object[0]);
    }

    public double getRange(Boolean left) {
        if (AmuletStack.hasUpgrade(this.player, this.world, this.getIdentifier(), filter_rangeUpgrade, left)) {
            return AmuletOfTransmutation.upgradedRange;
        }
        return 4.5;
    }

    private static int getReactivityUpgradeCount(EntityPlayer player, World world, String uuid, Boolean left) {
        return AmuletStack.countUpgrades(player, world, uuid, filter_reactivityUpgrade, rechargeEfficiencyPerReactivityBlock.length * 64, left);
    }

    private static int getReactivityCoreCount(EntityPlayer player, World world, String uuid, Boolean left) {
        return AmuletStack.countUpgrades(player, world, uuid, filter_efficiencyUpgrade, creationEfficiencyPerReactivityCore.length, left);
    }

    public void consumeItemStacks(ArrayList<ItemStack> stacks, boolean triggerUpdate, int x, int y, int z, Boolean left) {
        if (AmuletStack.hasUpgrade(this.player, this.world, this.getIdentifier(), filter_stabilityUpgrade, left)) {
            if (!this.player.field_70170_p.field_72995_K) {
                AmuletOfTransmutation.dropItemStacks(stacks, this.player, new BlockPos(x, y, z));
            }
            return;
        }
        for (int i = 0; i < stacks.size(); ++i) {
            this.consumeItemStack(stacks.get(i), false, false);
        }
        if (!triggerUpdate) {
            return;
        }
        BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.ConsumeItemStacks(this.getIdentifier(), stacks, x, y, z, left));
    }

    public boolean consumeItemStack(ItemStack stack, boolean fromHand, boolean triggerUpdate) {
        UniqueItemData data = UniqueItemData.get((World)this.world);
        if (!this.hasRequiredPermission(data, this.id, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log(this.player);
            return false;
        }
        if (!AmuletStack.canConsumeItemStack(this.player, stack)) {
            return false;
        }
        String itemKey = "item" + AmuletStack.getDescriptor(stack.func_77973_b()) + "dam" + stack.func_77960_j();
        if (stack.func_77973_b() instanceof AmuletOfTransmutation) {
            String id2 = UniqueItem.getIdentifier((ItemStack)stack);
            if (id2.equals(this.id)) {
                return false;
            }
            if (!this.hasRequiredPermission(data, id2, 2)) {
                UniqueItemData.permissionError((String)"consume", (Object)AmuletOfTransmutation.name).log(this.player);
                return false;
            }
            AmuletStack otherAmulet = AmuletStack.create(this.player, this.world, id2);
            if (otherAmulet == null) {
                return false;
            }
            int matter = otherAmulet.getStoredMatter();
            otherAmulet.setStoredMatter(0);
            this.setStoredMatter(this.getStoredMatter() + matter);
        } else {
            this.setStoredMatter(this.getStoredMatter() + stack.field_77994_a * AmuletStack.getMPBConsumed(this.player, this.world, stack));
        }
        if (AmuletStack.canLearnItemStack(stack)) {
            NBTTagCompound itemTag;
            ItemStack learnedItem;
            NBTTagCompound learnedItems = this.getCompoundTag("LearnedItems");
            if (!learnedItems.func_74764_b(itemKey)) {
                NBTTagCompound newTag = new NBTTagCompound();
                learnedItems.func_74782_a(itemKey, (NBTBase)newTag);
                UniqueItem.setNBTId((NBTTagCompound)newTag, (String)AmuletStack.getDescriptor(stack.func_77973_b()));
                newTag.func_74774_a("Count", (byte)0);
                newTag.func_74777_a("Damage", (short)stack.func_77960_j());
            }
            if ((learnedItem = UniqueItem.loadItemStackFromNBT((NBTTagCompound)(itemTag = learnedItems.func_74775_l(itemKey)))) != null && learnedItem.field_77994_a < AmuletOfTransmutation.learnThreshold) {
                learnedItem.field_77994_a += stack.field_77994_a;
                if (learnedItem.field_77994_a >= AmuletOfTransmutation.learnThreshold) {
                    learnedItem.field_77994_a = AmuletOfTransmutation.learnThreshold;
                    if (!this.world.field_72995_K && this.player != null) {
                        this.player.func_146105_b((IChatComponent)new ChatComponentTranslation("message.blocklearnt", new Object[]{learnedItem.func_82833_r()}));
                    }
                }
                UniqueItem.writeItemStackToNBT((ItemStack)learnedItem, (NBTTagCompound)itemTag);
            }
            this.markDirty();
        }
        if (triggerUpdate) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.ConsumeItemStack(this.id, fromHand));
        }
        return true;
    }

    public void shareMatter(String otherId, boolean triggerUpdate) {
        if (otherId.equals(this.id)) {
            return;
        }
        UniqueItemData data = UniqueItemData.get((World)this.world);
        if (!this.hasRequiredPermission(data, this.id, 2) || !this.hasRequiredPermission(data, otherId, 2)) {
            return;
        }
        int matter = this.getStoredMatter();
        int give = matter / 2;
        AmuletStack otherAmulet = AmuletStack.create(this.player, this.world, otherId);
        if (otherAmulet == null) {
            return;
        }
        otherAmulet.setStoredMatter(otherAmulet.getStoredMatter() + give);
        this.setStoredMatter(matter - give);
        if (triggerUpdate) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.ShareMatter(this.getIdentifier(), otherAmulet.getIdentifier()));
        }
    }

    public boolean hasLearnt(ItemStack stack) {
        if (!AmuletStack.canLearnItemStack(stack)) {
            return false;
        }
        if (stack.func_77969_a(AmuletOfTransmutation.defaultItem)) {
            return true;
        }
        String itemKey = "item" + AmuletStack.getDescriptor(stack.func_77973_b()) + "dam" + stack.func_77960_j();
        NBTTagCompound learnedItems = this.getCompoundTag("LearnedItems");
        return learnedItems.func_74764_b(itemKey);
    }

    public void setActiveItemStack(ItemStack stack, boolean triggerUpdate, boolean left) {
        UniqueItemData data = UniqueItemData.get((World)this.world);
        if (!this.hasRequiredPermission(data, this.id, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log(this.player);
            return;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)BalancedExchange.reactiveGlow) && AmuletOfTransmutation.allowTransmutationOfRadiation) {
            this.setActiveItem(stack, left);
            if (triggerUpdate) {
                BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.ActivateItemStack(this.getIdentifier(), stack, left));
            }
            return;
        }
        if (!AmuletStack.canLearnItemStack(stack)) {
            return;
        }
        String itemKey = "item" + AmuletStack.getDescriptor(stack.func_77973_b()) + "dam" + stack.func_77960_j();
        NBTTagCompound learnedItems = this.getCompoundTag("LearnedItems");
        if (!learnedItems.func_74764_b(itemKey)) {
            return;
        }
        NBTTagCompound itemTag = learnedItems.func_74775_l(itemKey);
        ItemStack learnedItem = UniqueItem.loadItemStackFromNBT((NBTTagCompound)itemTag);
        if (learnedItem == null || learnedItem.field_77994_a < AmuletOfTransmutation.learnThreshold) {
            return;
        }
        this.setActiveItem(stack, left);
        if (triggerUpdate) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.ActivateItemStack(this.getIdentifier(), stack, left));
        }
        this.markDirty();
    }

    public void toggleQuickListStack(ItemStack stack, int toggle, boolean triggerUpdate) {
        UniqueItemData data = UniqueItemData.get((World)this.world);
        if (!this.hasRequiredPermission(data, this.id, 2)) {
            UniqueItemData.permissionError((String)"modify", (Object)AmuletOfTransmutation.name).log(this.player);
            return;
        }
        String itemKey = "item" + AmuletStack.getDescriptor(stack.func_77973_b()) + "dam" + stack.func_77960_j();
        NBTTagCompound learnedItems = this.getCompoundTag("LearnedItems");
        if (!(learnedItems.func_74764_b(itemKey) && learnedItems.func_74775_l(itemKey).func_74771_c("Count") >= AmuletOfTransmutation.learnThreshold || AmuletOfTransmutation.allowTransmutationOfRadiation && stack.func_77973_b() == Item.func_150898_a((Block)BalancedExchange.reactiveGlow))) {
            return;
        }
        learnedItems = this.getCompoundTag("QuickList");
        if (toggle == 0 && learnedItems.func_74764_b(itemKey) || toggle == 1) {
            learnedItems.func_82580_o(itemKey);
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("id", AmuletStack.getDescriptor(stack.func_77973_b()));
            tag.func_74777_a("Damage", (short)stack.func_77960_j());
            learnedItems.func_74782_a(itemKey, (NBTBase)tag);
        }
        if (triggerUpdate) {
            BalancedExchange.channel.sendToServer((MessageChannel.Message)new PacketHandler.ToggleQuickList(stack, toggle, this.getIdentifier()));
        }
        this.markDirty();
    }

    public void getLearnedItems(ArrayList<ItemStack> items) {
        String itemKey;
        NBTTagCompound tag = this.getCompoundTag("LearnedItems");
        Object[] keys = tag.func_150296_c().toArray();
        ItemStack activeItemA = this.getActiveItem(true);
        ItemStack activeItemB = this.getActiveItem(false);
        boolean activeItemAExists = false;
        boolean activeItemBExists = false;
        boolean dirty = false;
        NBTTagCompound newTag = new NBTTagCompound();
        HashSet<String> ids = new HashSet<String>();
        for (Object key : keys) {
            Item item;
            NBTTagCompound element = tag.func_74775_l((String)key);
            String id = element.func_74779_i("id");
            short damage = element.func_74765_d("Damage");
            if (element.func_74764_b("id172")) {
                id = element.func_74779_i("id172");
                UniqueItem.setNBTId((NBTTagCompound)element, (String)id);
                dirty = true;
            }
            if ((item = AmuletStack.getItem(id)) != null) {
                id = AmuletStack.getDescriptor(item);
            }
            if (ids.contains("item" + id + "dam" + damage)) {
                dirty = true;
                continue;
            }
            if ((AmuletOfTransmutation.getMPBEntry((Item)item, (int)damage).created == 0 || !(item instanceof ItemBlock) || AmuletOfTransmutation.getMPBEntry((Item)item, (int)damage).created < -121 && AmuletOfTransmutation.getMPBEntry((Item)item, (int)damage).created > -125) && (item != AmuletOfTransmutation.defaultItem.func_77973_b() || damage != AmuletOfTransmutation.defaultItem.func_77960_j())) continue;
            ids.add("item" + id + "dam" + damage);
            if (item == activeItemA.func_77973_b() && damage == activeItemA.func_77960_j()) {
                activeItemAExists = true;
            }
            if (item == activeItemB.func_77973_b() && damage == activeItemB.func_77960_j()) {
                activeItemBExists = true;
            }
            newTag.func_74782_a("item" + id + "dam" + damage, (NBTBase)element);
            items.add(UniqueItem.loadItemStackFromNBT((NBTTagCompound)element));
        }
        if (AmuletOfTransmutation.allowTransmutationOfRadiation) {
            if (activeItemA.func_77973_b() == Item.func_150898_a((Block)BalancedExchange.reactiveGlow)) {
                activeItemAExists = true;
            }
            if (activeItemB.func_77973_b() == Item.func_150898_a((Block)BalancedExchange.reactiveGlow)) {
                activeItemBExists = true;
            }
            items.add(new ItemStack((Block)BalancedExchange.reactiveGlow, AmuletOfTransmutation.learnThreshold, 0));
        }
        if (!newTag.func_74764_b(itemKey = "item" + AmuletStack.getDescriptor(AmuletOfTransmutation.defaultItem.func_77973_b()) + "dam" + AmuletOfTransmutation.defaultItem.func_77960_j())) {
            dirty = true;
            ItemStack stack = AmuletOfTransmutation.defaultItem.func_77946_l();
            stack.field_77994_a = AmuletOfTransmutation.learnThreshold;
            newTag.func_74782_a(itemKey, (NBTBase)UniqueItem.writeItemStackToNBT((ItemStack)stack, null));
            items.add(stack);
        }
        if (dirty) {
            this.getTagCompound().func_74782_a("LearnedItems", (NBTBase)newTag);
            this.markDirty();
        }
        if (!activeItemAExists) {
            this.setActiveItemStack(AmuletOfTransmutation.defaultItem, true, true);
        }
        if (!activeItemBExists) {
            this.setActiveItemStack(AmuletOfTransmutation.defaultItem, true, false);
        }
    }

    public ArrayList<ItemStack> getQuickList() {
        boolean dirty = false;
        NBTTagCompound tag = this.getCompoundTag("QuickList");
        Object[] keys = tag.func_150296_c().toArray();
        ArrayList<ItemStack> quickList = new ArrayList<ItemStack>();
        for (Object key : keys) {
            NBTTagCompound element = tag.func_74775_l((String)key);
            String id = element.func_74779_i("id");
            Item item = AmuletStack.getItem(id);
            short damage = element.func_74765_d("Damage");
            if (!(AmuletOfTransmutation.getMPBEntry((Item)item, (int)damage).created != 0 && item instanceof ItemBlock && (AmuletOfTransmutation.getMPBEntry((Item)item, (int)damage).created >= -121 || AmuletOfTransmutation.getMPBEntry((Item)item, (int)damage).created <= -125) || item == AmuletOfTransmutation.defaultItem.func_77973_b() && damage == AmuletOfTransmutation.defaultItem.func_77960_j())) {
                tag.func_82580_o("item" + id + "dam" + damage);
                dirty = true;
                continue;
            }
            quickList.add(UniqueItem.loadItemStackFromNBT((NBTTagCompound)element));
        }
        Collections.sort(quickList, AmuletOfTransmutation.valueOrder);
        if (dirty) {
            this.markDirty();
        }
        return quickList;
    }

    public void nextQuick(boolean left) {
        if (this.getMode(left) == 6) {
            this.setSurveyMode(this.getSurveyMode() + 1, true);
            return;
        }
        ArrayList<ItemStack> quickList = this.getQuickList();
        if (quickList.size() < 1) {
            return;
        }
        String currentName = this.getActiveItem(left).func_82833_r();
        int currentMPB = AmuletOfTransmutation.getMPBEntry((ItemStack)this.getActiveItem((boolean)left)).created;
        ItemStack next = null;
        for (int i = 0; i < quickList.size(); ++i) {
            ItemStack stack = quickList.get(i);
            int mpb = AmuletOfTransmutation.getMPBEntry((ItemStack)stack).created;
            if (mpb == currentMPB && stack.func_82833_r().compareToIgnoreCase(currentName) > 0) {
                next = stack;
                break;
            }
            if (mpb <= currentMPB) continue;
            next = stack;
            break;
        }
        if (next == null) {
            next = quickList.get(0);
        }
        this.setActiveItemStack(next, true, left);
    }

    public void prevQuick(boolean left) {
        if (this.getMode(left) == 6) {
            this.setSurveyMode(this.getSurveyMode() - 1, true);
            return;
        }
        ArrayList<ItemStack> quickList = this.getQuickList();
        if (quickList.size() < 1) {
            return;
        }
        String currentName = this.getActiveItem(left).func_82833_r();
        int currentMPB = AmuletOfTransmutation.getMPBEntry((ItemStack)this.getActiveItem((boolean)left)).created;
        ItemStack next = null;
        for (int i = quickList.size() - 1; i >= 0; --i) {
            ItemStack stack = quickList.get(i);
            int mpb = AmuletOfTransmutation.getMPBEntry((ItemStack)stack).created;
            if (mpb == currentMPB && stack.func_82833_r().compareToIgnoreCase(currentName) < 0) {
                next = stack;
                break;
            }
            if (mpb >= currentMPB) continue;
            next = stack;
            break;
        }
        if (next == null) {
            next = quickList.get(quickList.size() - 1);
        }
        this.setActiveItemStack(next, true, left);
    }

    public int getRechargeTime() {
        return this.getTagCompound().func_74762_e("RechargeTime");
    }

    private boolean hasRequiredPermission(UniqueItemData data, String id, int permissionLevel) {
        if (this.player == null) {
            return true;
        }
        return data.hasRequiredPermission(this.player, id, permissionLevel);
    }

    public void decreaseRechargeTime() {
        UniqueItemData data = UniqueItemData.get((World)this.world);
        if (!this.hasRequiredPermission(data, this.id, 2)) {
            return;
        }
        int t = this.getTagCompound().func_74762_e("RechargeTime");
        if (t > 0) {
            this.getTagCompound().func_74768_a("RechargeTime", t - 1);
            this.markDirty();
        }
    }

    public void setRechargeTime(int amount) {
        UniqueItemData data = UniqueItemData.get((World)this.world);
        if (!this.hasRequiredPermission(data, this.id, 2)) {
            return;
        }
        if (amount < 0) {
            amount = 0;
        }
        if (amount > 600) {
            amount = 600;
        }
        this.getTagCompound().func_74768_a("RechargeTime", amount);
        this.markDirty();
    }

    static {
        _forceRechargeMode = null;
        dualTransmutations = false;
        filter_bedrockUpgrade = new ItemIdFilter();
        filter_prechargeUpgrade = new ItemIdFilter();
        filter_efficiencyUpgrade = new ItemIdFilter();
        filter_reactivityUpgrade = new ItemIdFilter();
        filter_rangeUpgrade = new ItemIdFilter();
        filter_dualTransmutation = new ItemFilter(){

            @Override
            public boolean allow(ItemStack stack) {
                return stack.func_77973_b() instanceof CoreUpgrade && stack.func_77960_j() == 1;
            }
        };
        filter_silkTouch = new ItemFilter(){

            @Override
            public boolean allow(ItemStack stack) {
                NBTTagList nbttaglist;
                if (stack.func_77973_b() instanceof ItemEnchantedBook && (nbttaglist = ((ItemEnchantedBook)stack.func_77973_b()).func_92110_g(stack)) != null) {
                    for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                        if (nbttaglist.func_150305_b(j).func_74765_d("id") != Enchantment.field_77348_q.field_77352_x) continue;
                        return true;
                    }
                }
                return EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)stack) > 0;
            }
        };
        filter_productivityUpgrade = new ItemIdFilter();
        filter_surveyorUpgrade = new ItemIdFilter();
        filter_stabilityUpgrade = new ItemIdFilter();
        filter_chainUpgrade = new ItemIdFilter();
        filter_areaUpgrade = new ItemIdFilter();
    }

    public static class ItemIdFilter
    implements ItemFilter {
        public Item item = null;

        @Override
        public boolean allow(ItemStack stack) {
            return stack.func_77973_b() == this.item;
        }
    }

    public static interface ItemFilter {
        public boolean allow(ItemStack var1);
    }
}

