/*
 * Decompiled with CFR 0.152.
 */
package eureka.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import eureka.Eureka;
import eureka.api.EurekaKnowledge;
import eureka.api.EurekaRegistry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class MessageEngineeringDiary
implements IMessage,
IMessageHandler<MessageEngineeringDiary, IMessage> {
    EntityPlayer player;
    int[] progress = new int[100];
    boolean[] finished = new boolean[100];

    public MessageEngineeringDiary() {
    }

    public MessageEngineeringDiary(EntityPlayer player) {
        this.player = player;
    }

    public void fromBytes(ByteBuf buf) {
        ArrayList<String> keys = EurekaRegistry.getKeys();
        for (int t = 0; t < keys.size(); ++t) {
            this.progress[t] = buf.readInt();
            this.finished[t] = buf.readBoolean();
        }
    }

    public void toBytes(ByteBuf buf) {
        ArrayList<String> keys = EurekaRegistry.getKeys();
        for (int t = 0; t < keys.size(); ++t) {
            buf.writeInt(EurekaKnowledge.getProgress(this.player, keys.get(t)));
            buf.writeBoolean(EurekaKnowledge.isFinished(this.player, keys.get(t)));
        }
    }

    public IMessage onMessage(MessageEngineeringDiary message, MessageContext ctx) {
        ArrayList<String> keys = EurekaRegistry.getKeys();
        NBTTagCompound info = EurekaKnowledge.getTag(Eureka.proxy.getPlayer());
        for (int t = 0; t < keys.size(); ++t) {
            info.func_74768_a(keys.get(t) + "Progress", message.progress[t]);
            info.func_74757_a(keys.get(t) + "Finished", message.finished[t]);
        }
        return null;
    }
}

