/*
 * Decompiled with CFR 0.152.
 */
package eureka.core;

import buildcraft.api.events.PipePlacedEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import eureka.Eureka;
import eureka.api.EurekaKnowledge;
import eureka.api.EurekaRegistry;
import eureka.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class EventHandler {
    public static void dropItemsFromList(World world, int x, int y, int z, ItemStack[] stacks) {
        for (ItemStack stack : stacks) {
            if (stack == null) continue;
            String key = EurekaRegistry.getKey(stack.func_77973_b());
            if (key.equals("") && stack.func_77973_b() instanceof ItemBlock) {
                key = EurekaRegistry.getKey(((ItemBlock)stack.func_77973_b()).field_150939_a);
            }
            if (key.equals("")) {
                key = EurekaRegistry.getKey(stack.func_77973_b().func_77658_a().replace("item.", "").toLowerCase());
            }
            if (!key.equals("")) {
                for (ItemStack component : EurekaRegistry.getDrops(key)) {
                    Utils.dropItemstack(world, x, y, z, component.func_77946_l());
                }
                continue;
            }
            Utils.dropItemstack(world, x, y, z, stack.func_77946_l());
        }
    }

    public static class Forge {
        @SubscribeEvent
        public void BucketFill(FillBucketEvent event) {
            for (String key : EurekaRegistry.getBucketFillList()) {
                EurekaKnowledge.makeProgress(event.entityPlayer, key, 1);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onPlayerUsesBlock(PlayerInteractEvent event) {
            String key;
            if (event.world.field_72995_K) {
                return;
            }
            if (event.entityPlayer.func_71045_bC() != null && !(key = EurekaRegistry.getKey(event.entityPlayer.func_71045_bC().func_77973_b())).equals("") && !EurekaKnowledge.isFinished(event.entityPlayer, key)) {
                if (event.entityPlayer.func_71045_bC().field_77994_a > 1) {
                    --event.entityPlayer.func_71045_bC().field_77994_a;
                } else {
                    event.entityPlayer.func_71028_bD();
                }
                EventHandler.dropItemsFromList(event.world, (int)event.entityPlayer.field_70165_t, (int)event.entityPlayer.field_70163_u, (int)event.entityPlayer.field_70161_v, EurekaRegistry.getDrops(key));
                event.setCanceled(true);
            }
            if ((key = EurekaRegistry.getKey(event.world.func_147439_a(event.x, event.y, event.z))).equals("")) {
                return;
            }
            if (!EurekaKnowledge.isFinished(event.entityPlayer, key)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public void blockPlacement(BlockEvent.PlaceEvent event) {
            if (event.world.field_72995_K) {
                return;
            }
            String key = EurekaRegistry.getKey(event.block);
            int x = event.blockSnapshot.x;
            int y = event.blockSnapshot.y;
            int z = event.blockSnapshot.z;
            if (!key.equals("") && !EurekaKnowledge.isFinished(event.player, key)) {
                event.player.func_146105_b((IChatComponent)new ChatComponentText(Utils.localize("eureka.missingKnowledge")));
                event.world.func_147468_f(x, y, z);
                EventHandler.dropItemsFromList(event.world, x, y, z, EurekaRegistry.getDrops(key));
            }
            if (!(key = EurekaRegistry.getBlockPlacementKey(event.block)).equals("")) {
                EurekaKnowledge.makeProgress(event.player, key, 1);
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void blockBreakEvent(BlockEvent.BreakEvent event) {
            for (String key : EurekaRegistry.getBreakAnyKeys()) {
                EurekaKnowledge.makeProgress(event.getPlayer(), key, 1);
            }
            String key = EurekaRegistry.getBlockBreakKey(event.block);
            if (!key.equals("")) {
                EurekaKnowledge.makeProgress(event.getPlayer(), key, 1);
            }
            if (!(key = EurekaRegistry.getBlockPlacementKey(event.block)).equals("")) {
                EurekaKnowledge.makeProgress(event.getPlayer(), key, -1);
            }
        }

        @SubscribeEvent
        public void onTeleport(EnderTeleportEvent event) {
            if (event.entityLiving instanceof EntityPlayer) {
                for (String key : EurekaRegistry.getEnderTeleportKeys()) {
                    EurekaKnowledge.makeProgress((EntityPlayer)event.entityLiving, key, 1);
                }
            }
        }

        @SubscribeEvent
        public void onLivingDeath(LivingDeathEvent event) {
            if (event.source.func_76364_f() instanceof EntityPlayer) {
                for (String key : EurekaRegistry.getKillKeys()) {
                    EurekaKnowledge.makeProgress((EntityPlayer)event.source.func_76364_f(), key, 1);
                }
            }
            if (event.entityLiving instanceof EntityPlayer) {
                for (String key : EurekaRegistry.getDeathKeys()) {
                    EurekaKnowledge.makeProgress((EntityPlayer)event.entityLiving, key, 1);
                }
            }
        }
    }

    public static class FML {
        @SubscribeEvent
        public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            EurekaKnowledge.init(event.player);
            if (!event.player.getEntityData().func_74775_l("PlayerPersisted").func_74764_b("bookRecieved")) {
                for (int slot = 0; slot < event.player.field_71071_by.func_70302_i_(); ++slot) {
                    if (event.player.field_71071_by.func_70301_a(slot) != null) continue;
                    event.player.field_71071_by.func_70299_a(slot, new ItemStack(Eureka.engineeringDiary));
                    event.player.getEntityData().func_74775_l("PlayerPersisted").func_74757_a("bookRecieved", true);
                    return;
                }
            }
        }

        @SubscribeEvent
        public void BuildcraftPipePlaced(PipePlacedEvent event) {
            String pipe = event.pipeType.replace("item.", "").toLowerCase();
            String key = EurekaRegistry.getKey(pipe);
            if (!key.equals("") && !EurekaKnowledge.isFinished(event.player, key)) {
                event.player.func_146105_b((IChatComponent)new ChatComponentText(Utils.localize("eureka.missingKnowledge")));
                event.player.field_70170_p.func_147468_f(event.x, event.y, event.z);
                EventHandler.dropItemsFromList(event.player.field_70170_p, event.x, event.y, event.z, EurekaRegistry.getDrops(key));
                return;
            }
            for (String keys : EurekaRegistry.getPipeProgressKeys()) {
                EurekaKnowledge.makeProgress(event.player, keys, 1);
            }
            for (String keys : EurekaRegistry.getPipePlacementKeys(pipe)) {
                EurekaKnowledge.makeProgress(event.player, keys, 1);
            }
        }

        @SubscribeEvent
        public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
            for (String key : EurekaRegistry.getCraftKeys()) {
                EurekaKnowledge.makeProgress(event.player, key, 1);
            }
            String key = EurekaRegistry.getCraftingProgressKey(event.crafting.func_77973_b());
            if (!key.isEmpty()) {
                EurekaKnowledge.makeProgress(event.player, key, 1);
            }
        }
    }
}

