/*
 * Decompiled with CFR 0.152.
 */
package eureka.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eureka.api.EurekaKnowledge;
import eureka.api.EurekaRegistry;
import eureka.api.client.gui.EurekaChapter;
import eureka.client.gui.ContainerEngineeringDiary;
import eureka.core.Logger;
import eureka.utils.Utils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiEngineeringDiary
extends GuiContainer {
    public static ResourceLocation texture = new ResourceLocation("eureka", "textures/gui/EngineeringDiary.png");
    public EntityPlayer player;
    public int category;
    public int[] startX;
    public int[] lineLimit;
    public int page;
    public int chapter;
    public int categoryOffset;
    public int chapterOffset;
    public boolean hasPrevPage;
    public ArrayList<String> categoryList = EurekaRegistry.getCategoriesList();
    public ArrayList<String> keys = EurekaRegistry.getKeys();
    public ArrayList<EurekaChapter> chaptersToDisplay = new ArrayList(20);
    public ArrayList<String> chapterList = new ArrayList(20);

    public GuiEngineeringDiary(EntityPlayer player) {
        super((Container)new ContainerEngineeringDiary(player));
        this.player = player;
        this.category = 0;
        this.startX = new int[20];
        this.lineLimit = new int[20];
        this.page = 0;
        this.chapter = -1;
        this.startX[0] = 85;
        this.startX[1] = 85;
        this.startX[2] = 85;
        this.startX[3] = 85;
        this.startX[4] = 50;
        this.startX[5] = 45;
        this.startX[6] = 40;
        this.startX[7] = 35;
        this.startX[8] = 30;
        this.startX[9] = 25;
        this.startX[10] = 25;
        this.startX[11] = 25;
        this.startX[12] = 25;
        this.startX[13] = 25;
        this.startX[14] = 25;
        this.startX[15] = 25;
        this.startX[16] = 25;
        this.startX[17] = 25;
        this.startX[18] = 25;
        this.startX[19] = 25;
        this.lineLimit[0] = 13;
        this.lineLimit[1] = 13;
        this.lineLimit[2] = 16;
        this.lineLimit[3] = 16;
        this.lineLimit[4] = 17;
        this.lineLimit[5] = 18;
        this.lineLimit[6] = 18;
        this.lineLimit[7] = 21;
        this.lineLimit[8] = 21;
        this.lineLimit[9] = 22;
        this.lineLimit[10] = 22;
        this.lineLimit[11] = 21;
        this.lineLimit[12] = 19;
        this.lineLimit[13] = 18;
        this.lineLimit[14] = 17;
        this.lineLimit[15] = 16;
        this.lineLimit[16] = 14;
        this.lineLimit[17] = 13;
        this.lineLimit[18] = 12;
        this.lineLimit[19] = 12;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.drawText();
        if (this.chapter != -1) {
            this.chaptersToDisplay.get(this.chapter).drawCustomStuff(this.page);
        }
    }

    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        this.field_146999_f = 210;
        this.field_147000_g = 180;
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 30, 0, this.field_146999_f, this.field_147000_g);
        this.drawCategories();
        this.drawChapters();
        this.drawPageButtons(mouseX, mouseY);
        if (this.chapter != -1 && this.page == 0 && !this.chaptersToDisplay.get(this.chapter).isInfoPage()) {
            this.drawProgressBar();
        }
        this.renderItems();
    }

    private void drawProgressBar() {
        this.field_146999_f = 210;
        this.field_147000_g = 180;
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x + 95, y + 38, 148, 180, 60, 7);
        String key = this.chapterList.get(this.chapter);
        this.func_73729_b(x + 96, y + 39, 148, 187, EurekaKnowledge.getProgress(this.player, key) * 58 / EurekaRegistry.getMaxValue(key), 7);
    }

    private void renderItems() {
        this.field_146999_f = 210;
        this.field_147000_g = 180;
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        for (int teller = 0; teller < 7; ++teller) {
            if (teller + this.categoryOffset < this.categoryList.size()) {
                this.renderItem(EurekaRegistry.getCategoryDisplayStack(this.categoryList.get(teller + this.categoryOffset)), x + 12, y + 24 * teller + 9);
                GL11.glDisable((int)2896);
            }
            if (teller + this.chapterOffset >= this.chapterList.size()) continue;
            this.renderItem(EurekaRegistry.getDisplayStack(this.chapterList.get(teller + this.chapterOffset)), x + 177, y + 24 * teller + 9);
            GL11.glDisable((int)2896);
        }
        GL11.glEnable((int)2896);
    }

    private void renderItem(ItemStack stack, int x, int y) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        GuiEngineeringDiary.field_146296_j.field_77023_b = 200.0f;
        try {
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, x, y);
        }
        catch (Throwable e) {
            try {
                field_146296_j.func_77015_a(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, x, y);
            }
            catch (Throwable e2) {
                Logger.error("Failed to render item for category " + this.categoryList.get(this.category));
            }
        }
        this.field_73735_i = 0.0f;
        GuiEngineeringDiary.field_146296_j.field_77023_b = 0.0f;
    }

    private void drawPageButtons(int mouseX, int mouseY) {
        this.field_146999_f = 210;
        this.field_147000_g = 180;
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        boolean hasNextpage = false;
        if (!this.chaptersToDisplay.isEmpty() && this.chapter != -1) {
            hasNextpage = this.chaptersToDisplay.get(this.chapter).hasNextPage(this.page);
        }
        if (this.chapter == -1) {
            boolean bl = hasNextpage = !Utils.localize("engineeringDiary." + this.categoryList.get(this.category) + ".page" + (this.page + 1)).equals("engineeringDiary." + this.categoryList.get(this.category) + ".page" + Integer.toString(this.page + 1));
        }
        if (hasNextpage && (this.chapter == -1 || EurekaKnowledge.isFinished(this.player, this.chapterList.get(this.chapter)))) {
            this.func_73729_b(x + 143, y + 149, 82, 196, 16, 16);
        }
        if (hasNextpage && mouseX > 143 + x && mouseX < 159 + x && mouseY > 149 + y && mouseY < 164 + y && (this.chapter == -1 || EurekaKnowledge.isFinished(this.player, this.chapterList.get(this.chapter)))) {
            this.func_73729_b(x + 143, y + 149, 82, 180, 16, 16);
        }
        if (this.hasPrevPage) {
            this.func_73729_b(x + 44, y + 13, 66, 196, 16, 16);
        }
        if (this.hasPrevPage && mouseX > 44 + x && mouseX < 60 + x && mouseY > 13 + y && mouseY < 28 + y) {
            this.func_73729_b(x + 44, y + 13, 66, 180, 16, 16);
        }
        if (this.categoryList.size() - this.categoryOffset > 7) {
            this.func_73729_b(x + 2, y + 180, 188, 192, 41, 17);
            if (mouseX > x + 2 && mouseX < x + 43 && mouseY > y + 180 && mouseY < y + 197) {
                this.func_73729_b(x + 2, y + 180, 148, 192, 40, 17);
            }
        }
        if (this.categoryOffset > 0) {
            this.func_73729_b(x + 2, y - 15, 188, 210, 41, 17);
            if (mouseX > x + 2 && mouseX < x + 43 && mouseY > y - 15 && mouseY < y) {
                this.func_73729_b(x + 2, y - 15, 148, 210, 40, 17);
            }
        }
        if (this.chaptersToDisplay.size() - this.chapterOffset > 7) {
            this.func_73729_b(x + 165, y + 180, 18, 212, 40, 17);
            if (mouseX > x + 165 && mouseX < x + 205 && mouseY > y + 180 && mouseY < y + 197) {
                this.func_73729_b(x + 165, y + 180, 58, 212, 40, 17);
            }
        }
        if (this.chapterOffset > 0) {
            this.func_73729_b(x + 160, y - 15, 18, 230, 40, 17);
            if (mouseX > x + 160 && mouseX < x + 200 && mouseY > y - 15 && mouseY < y) {
                this.func_73729_b(x + 160, y - 15, 58, 230, 40, 17);
            }
        }
    }

    private void drawCategories() {
        this.field_146999_f = 210;
        this.field_147000_g = 180;
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        for (int teller = 0; teller < 7; ++teller) {
            if (teller + this.categoryOffset >= this.categoryList.size()) continue;
            if (teller + this.categoryOffset == this.category) {
                this.func_73729_b(x + 7, y + (24 * teller + 5), 124, 180, 24, 24);
                continue;
            }
            this.func_73729_b(x + 7, y + (24 * teller + 5), 98, 180, 24, 24);
        }
    }

    private void drawChapters() {
        this.field_146999_f = 210;
        this.field_147000_g = 180;
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        for (int teller = 0; teller < 7; ++teller) {
            if (teller + this.chapterOffset >= this.chaptersToDisplay.size()) continue;
            if (teller + this.chapterOffset == this.chapter) {
                this.func_73729_b(x + 174, y + (24 * teller + 5), 123, 204, 25, 23);
                continue;
            }
            this.func_73729_b(x + 174, y + (24 * teller + 5), 98, 204, 25, 23);
        }
    }

    private void drawText() {
        if (this.chapter == -1) {
            String categoryName = this.categoryList.get(this.category);
            this.writeText(Utils.localize("engineeringDiary." + categoryName + ".title"), 0, 0xFFCC00);
            this.writeText(Utils.localize("engineeringDiary." + categoryName + ".page" + this.page), 4, 0xFFFFFF);
        } else {
            String chapterName = this.chapterList.get(this.chapter);
            this.writeText(Utils.localize("engineeringDiary." + chapterName + ".title"), 0, 0xFFCC00);
            if (this.page == 0) {
                this.writeText(Utils.localize("engineeringDiary.requiredResearch"), 5, 0xFF0000);
                int line = this.writeText(this.chaptersToDisplay.get(this.chapter).getRequiredResearch(), 6, 255);
                line = this.writeText(Utils.localize("engineeringDiary.progress") + " " + EurekaKnowledge.getProgress(this.player, chapterName) + " / " + EurekaRegistry.getMaxValue(chapterName), line, 0xFFFF00);
                line = !EurekaKnowledge.isFinished(this.player, chapterName) ? this.writeText(this.chaptersToDisplay.get(this.chapter).howToMakeProgress(), line, 0xFF6600) : this.writeText(Utils.localize("engineeringDiary.unlocked"), line, 0xFF6600);
                this.writeText(this.chaptersToDisplay.get(this.chapter).getText(this.page), line, 0xFFFFFF);
            } else {
                this.writeText(this.chaptersToDisplay.get(this.chapter).getText(this.page), 4, 0xFFFFFF);
            }
        }
    }

    public int writeText(String text, int line, int color) {
        if (text == null) {
            return line;
        }
        String[] words = text.split(" ", 0);
        String output = "";
        for (String word : words) {
            if (line == 20) {
                return line;
            }
            if (output.length() + word.length() > this.lineLimit[line] || word.equals("@")) {
                this.drawTextAtLine(output, line, color);
                output = "";
                ++line;
            }
            if (word.equals("@")) continue;
            output = output + word + " ";
        }
        this.drawTextAtLine(output, line, color);
        return line += 2;
    }

    public void drawTextAtLine(String text, int line, int color) {
        if (text == null || text.equals("") || line == 20) {
            return;
        }
        this.field_146289_q.func_78276_b(text, this.startX[line], line * 8 + 6, color);
    }

    private void rebuildChapterList() {
        this.chaptersToDisplay.clear();
        this.chapterList.clear();
        for (String key : this.keys) {
            if (!EurekaRegistry.getCategory(key).equals(this.categoryList.get(this.category))) continue;
            this.chaptersToDisplay.add(EurekaRegistry.getChapterGui(key));
            this.chapterList.add(key);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int status) {
        super.func_146286_b(mouseX, mouseY, status);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        int max = 7;
        if (this.categoryList.size() < 7) {
            max = this.categoryList.size();
        }
        if (mouseX > x + 7 && mouseX < x + 31 && (mouseY - y) / 25 < max) {
            this.page = 0;
            this.category = (mouseY - y) / 25 + this.categoryOffset;
            this.chapter = -1;
            this.chapterOffset = 0;
        }
        max = 7;
        if (this.chaptersToDisplay.size() < 7) {
            max = this.chaptersToDisplay.size();
        }
        if (mouseX > x + 174 && mouseX < x + 198 && (mouseY - y) / 25 < max) {
            this.page = 0;
            this.chapter = (mouseY - y) / 25 + this.chapterOffset;
        }
        boolean hasNextpage = false;
        if (!this.chaptersToDisplay.isEmpty() && this.chapter != -1) {
            hasNextpage = this.chaptersToDisplay.get(this.chapter).hasNextPage(this.page);
        }
        if (this.chapter == -1) {
            boolean bl = hasNextpage = !Utils.localize("engineeringDiary." + this.categoryList.get(this.category) + ".page" + (this.page + 1)).equals("engineeringDiary." + this.categoryList.get(this.category) + ".page" + Integer.toString(this.page + 1));
        }
        if (hasNextpage && mouseX > 143 + x && mouseX < 159 + x && mouseY > 149 + y && mouseY < 164 + y && (this.chapter == -1 || EurekaKnowledge.isFinished(this.player, this.chapterList.get(this.chapter)))) {
            ++this.page;
        }
        if (this.hasPrevPage && mouseX > 34 + x && mouseX < 59 + x && mouseY > 13 + y && mouseY < 28 + y) {
            --this.page;
        }
        this.hasPrevPage = this.page > 0;
        if (mouseX > x + 2 && mouseX < x + 43 && mouseY > y + 180 && mouseY < y + 197 && this.categoryList.size() - this.categoryOffset > 7) {
            ++this.categoryOffset;
        }
        if (mouseX > x + 2 && mouseX < x + 43 && mouseY > y - 15 && mouseY < y && this.categoryOffset > 0) {
            --this.categoryOffset;
        }
        if (this.chaptersToDisplay.size() - this.chapterOffset > 7 && mouseX > x + 165 && mouseX < x + 205 && mouseY > y + 180 && mouseY < y + 197) {
            ++this.chapterOffset;
        }
        if (this.chapterOffset > 0 && mouseX > x + 160 && mouseX < x + 200 && mouseY > y - 15 && mouseY < y) {
            --this.chapterOffset;
        }
        this.rebuildChapterList();
    }
}

