/*
 * Decompiled with CFR 0.152.
 */
package eureka.api;

import eureka.api.EurekaRegistry;
import eureka.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class EurekaKnowledge {
    public static void init(EntityPlayer player) {
        if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound tag = EurekaKnowledge.getTag(player);
        for (String key : EurekaRegistry.getKeys()) {
            EurekaKnowledge.initKey(tag, key);
        }
    }

    public static NBTTagCompound getTag(EntityPlayer player) {
        if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        return (NBTTagCompound)player.getEntityData().func_74781_a("PlayerPersisted");
    }

    public static int getProgress(EntityPlayer player, String key) {
        EurekaKnowledge.initKey(EurekaKnowledge.getTag(player), key);
        return EurekaKnowledge.getTag(player).func_74762_e(key + "Progress");
    }

    public static boolean isFinished(EntityPlayer player, String key) {
        EurekaKnowledge.initKey(EurekaKnowledge.getTag(player), key);
        if (player == null) {
            return false;
        }
        return player.field_71075_bZ.field_75098_d || EurekaKnowledge.getTag(player).func_74767_n(key + "Finished");
    }

    public static void makeProgress(EntityPlayer player, String key, int amount) {
        try {
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            if (EurekaRegistry.getRequiredReserch(key) != null && !EurekaRegistry.getRequiredReserch(key).isEmpty()) {
                for (String requiredResearchKey : EurekaRegistry.getRequiredReserch(key)) {
                    if (EurekaKnowledge.isFinished(player, requiredResearchKey) || EurekaRegistry.isInfoChapter(key)) continue;
                    return;
                }
            }
            int progress = EurekaKnowledge.getProgress(player, key);
            NBTTagCompound tag = EurekaKnowledge.getTag(player);
            if (progress < EurekaRegistry.getMaxValue(key)) {
                if ((progress += amount) < 0) {
                    progress = 0;
                }
                EurekaKnowledge.setKey(tag, key + "Progress", progress);
            }
            if (progress >= EurekaRegistry.getMaxValue(key) && !EurekaKnowledge.isFinished(player, key)) {
                EurekaKnowledge.setKey(tag, key + "Finished", true);
                String message = Utils.localize("eureka." + key + "Finished");
                player.func_145747_a((IChatComponent)new ChatComponentText(Utils.localize("Eureka")));
                player.func_146105_b((IChatComponent)new ChatComponentText(message));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void initKey(NBTTagCompound tag, String key) {
        if (!tag.func_74764_b(key + "Progress")) {
            EurekaKnowledge.setKey(tag, key + "Progress", 0);
            EurekaKnowledge.setKey(tag, key + "Finished", false);
        }
    }

    public static void setKey(NBTTagCompound tag, String key, int integer) {
        tag.func_74768_a(key, integer);
    }

    public static void setKey(NBTTagCompound tag, String key, boolean bool) {
        tag.func_74757_a(key, bool);
    }
}

