/*
 * Decompiled with CFR 0.152.
 */
package eureka.api;

import eureka.api.BasicEurekaChapter;
import eureka.api.EurekaInformation;
import eureka.api.client.gui.EurekaChapter;
import eureka.utils.Utils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class EurekaInfo
extends EurekaInformation {
    public String key;
    public String category;
    public int maxValue;
    public ItemStack stack;
    public EurekaChapter gui;
    public ArrayList<String> requiredResearch;

    public EurekaInfo(String key, String category, int maxValue, ItemStack stack, EurekaChapter gui, String ... researches) {
        this.key = key;
        this.category = category;
        this.maxValue = maxValue;
        this.stack = stack;
        this.gui = gui;
        this.requiredResearch = new ArrayList(researches.length);
        for (String research : researches) {
            this.requiredResearch.add(research);
        }
    }

    public EurekaInfo(String key, String category, int maxValue, ItemStack stack, String ... researches) {
        this.key = key;
        this.category = category;
        this.maxValue = maxValue;
        this.stack = stack;
        if (researches.length > 0) {
            boolean first = true;
            String requiredResearch = "";
            for (String research : researches) {
                if (first) {
                    requiredResearch = Utils.localize("engineeringDiary." + research + ".title");
                    first = false;
                    continue;
                }
                requiredResearch = requiredResearch + ", " + Utils.localize("engineeringDiary." + research + ".title");
            }
            this.gui = new BasicEurekaChapter(key, requiredResearch, false);
        } else {
            this.gui = new BasicEurekaChapter(key);
        }
        this.requiredResearch = new ArrayList(researches.length);
        for (String research : researches) {
            this.requiredResearch.add(research);
        }
    }

    public EurekaInfo(String key, String category, int maxValue, ItemStack stack, EurekaChapter gui) {
        this.key = key;
        this.category = category;
        this.maxValue = maxValue;
        this.stack = stack;
        this.gui = gui;
        this.requiredResearch = new ArrayList();
    }

    public EurekaInfo(String key, String category, int maxValue, ItemStack stack) {
        this.key = key;
        this.category = category;
        this.maxValue = maxValue;
        this.stack = stack;
        this.gui = new BasicEurekaChapter(key);
        this.requiredResearch = new ArrayList();
    }

    public EurekaInfo(String key, String category, int maxValue, ItemStack stack, boolean isInfoPage, String ... researches) {
        this.key = key;
        this.category = category;
        this.maxValue = maxValue;
        this.stack = stack;
        if (researches.length > 0) {
            boolean first = true;
            String requiredResearch = "";
            for (String research : researches) {
                if (first) {
                    requiredResearch = Utils.localize("engineeringDiary." + research + ".title");
                    first = false;
                    continue;
                }
                requiredResearch.concat(", " + Utils.localize("engineeringDiary." + research + ".title"));
            }
            this.gui = new BasicEurekaChapter(key, requiredResearch, isInfoPage);
        } else {
            this.gui = new BasicEurekaChapter(key);
        }
        this.requiredResearch = new ArrayList(researches.length);
        for (String research : researches) {
            this.requiredResearch.add(research);
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int getMaxValue() {
        return this.maxValue;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.stack;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public EurekaChapter getGui() {
        return this.gui;
    }

    @Override
    public ArrayList<String> getRequiredResearch() {
        return this.requiredResearch;
    }
}

