/*
 * Decompiled with CFR 0.152.
 */
package eureka.api;

import eureka.api.client.gui.EurekaChapter;
import eureka.utils.Utils;

public class BasicEurekaChapter
extends EurekaChapter {
    public String key;
    public String requiredResearch;
    public boolean isInfoPage;

    public BasicEurekaChapter(String key) {
        this.key = key;
        this.requiredResearch = Utils.localize("engineeringDiary.noRequiredResearch");
    }

    public BasicEurekaChapter(String key, String requiredResearch, boolean isInfoPage) {
        this.key = key;
        if (requiredResearch == null || requiredResearch == "") {
            requiredResearch = Utils.localize("engineeringDiary.noRequiredResearch");
        }
        this.requiredResearch = requiredResearch;
        this.isInfoPage = isInfoPage;
    }

    @Override
    public String getText(int page) {
        return Utils.localize("engineeringDiary." + this.key + ".page" + page);
    }

    @Override
    public void drawCustomStuff(int page) {
    }

    @Override
    public boolean hasNextPage(int page) {
        return !Utils.localize("engineeringDiary." + this.key + ".page" + (page + 1)).equals("engineeringDiary." + this.key + ".page" + Integer.toString(page + 1));
    }

    @Override
    public String getRequiredResearch() {
        return this.requiredResearch;
    }

    @Override
    public String howToMakeProgress() {
        return Utils.localize("engineeringDiary." + this.key + ".howToMakeProgress");
    }

    @Override
    public boolean isInfoPage() {
        return this.isInfoPage;
    }
}

