/*
 * Decompiled with CFR 0.152.
 */
package eureka;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import eureka.api.EurekaRegistry;
import eureka.client.gui.GuiHandler;
import eureka.core.EventHandler;
import eureka.items.ItemEngineeringDiary;
import eureka.items.ItemGlassShard;
import eureka.items.ItemPipePart;
import eureka.json.FileReader;
import eureka.network.PacketHandler;
import eureka.proxy.BaseProxy;
import java.io.File;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="eureka", name="Eureka", version="2.2", acceptedMinecraftVersions="1.7.10")
public class Eureka {
    public static Item engineeringDiary;
    public static CreativeTabs eureka;
    public static Item pipePart;
    public static Item glassShard;
    @Mod.Instance(value="eureka")
    public static Eureka instance;
    @SidedProxy(clientSide="eureka.proxy.ClientProxy", serverSide="eureka.proxy.ServerProxy")
    public static BaseProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        engineeringDiary = new ItemEngineeringDiary();
        engineeringDiary.func_77637_a(eureka).func_77655_b("engineeringDiary");
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(engineeringDiary), (Object[])new Object[]{Items.field_151122_aG, Items.field_151042_j});
        GameRegistry.registerItem((Item)engineeringDiary, (String)"engineeringDiary");
        FileReader.setMainfolder(new File(event.getModConfigurationDirectory(), "Eureka"));
        EurekaRegistry.registerCategory("Eureka", new ItemStack(engineeringDiary));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        FMLCommonHandler.instance().bus().register((Object)new EventHandler.FML());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler.Forge());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        PacketHandler.init();
    }

    @Mod.EventHandler
    public void doneLoading(FMLLoadCompleteEvent event) {
        if (Loader.isModLoaded((String)"BuildCraft|Core")) {
            this.generatePipeParts();
        }
        FileReader.readFiles();
    }

    @Mod.EventHandler
    public void mappings(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (!mapping.name.contains("research")) continue;
            mapping.ignore();
        }
    }

    public void generatePipeParts() {
        glassShard = new ItemGlassShard();
        GameRegistry.registerItem((Item)glassShard, (String)"glassShard");
        this.handlePipe("Wood");
        this.handlePipe("CobbleStone");
        this.handlePipe("Stone");
        this.handlePipe("Quartz");
        this.handlePipe("Sandstone");
        this.handlePipe("Gold");
        this.handlePipe("Iron");
        this.handlePipe("Void");
        this.handlePipe("Obsidian");
        this.handlePipe("Emerald");
        this.handlePipe("Diamond");
        this.handlePipe("Lapis");
        this.handlePipe("Daizuli");
    }

    public void handlePipe(String material) {
        pipePart = new ItemPipePart(material).func_77655_b("pipePart" + material);
        GameRegistry.registerItem((Item)pipePart, (String)("pipePart" + material));
        GameRegistry.addRecipe((ItemStack)new ItemStack(GameRegistry.findItem((String)"BuildCraft|Transport", (String)("item.buildcraftPipe.pipeitems" + material.toLowerCase()))), (Object[])new Object[]{"PSP", Character.valueOf('P'), pipePart, Character.valueOf('S'), glassShard});
    }

    static {
        eureka = new CreativeTabs("Eureka"){

            public Item func_78016_d() {
                return engineeringDiary;
            }
        };
    }
}

