/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.transport;

import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;
import powercrystals.minefactoryreloaded.tile.base.TileEntityBase;
import powercrystals.minefactoryreloaded.tile.transport.FluidNetwork;

public class TileEntityPlasticMultiPipe
extends TileEntityBase {
    protected int[] faces = new int[]{0, 0, 0, 0, 0, 0, 0};
    protected FluidNetwork[] networks = new FluidNetwork[]{null, null, null, null, null, null, null};
    protected IFluidHandler[] cache = new IFluidHandler[]{null, null, null, null, null, null};

    public void addPipeToSide(ForgeDirection forgeDirection) {
        int n;
        int n2 = n = forgeDirection.ordinal();
        this.faces[n2] = this.faces[n2] | 1;
        FluidNetwork fluidNetwork = this.networks[n];
        int n3 = -1;
        int n4 = 0;
        switch (forgeDirection) {
            case DOWN: 
            case UP: {
                int n5 = 7;
                while (n5-- > 3) {
                    if (!fluidNetwork.canMergeGrid(this.networks[n5])) continue;
                    if (n3 == -1 || this.networks[n5] != this.networks[n3]) {
                        ++n4;
                    }
                    n3 = n5;
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                int n6 = 7;
                while (n6-- > 0) {
                    if (!(n6 != 2 & n6 != 3) || !fluidNetwork.canMergeGrid(this.networks[n6])) continue;
                    if (n3 == -1 || this.networks[n6] != this.networks[n3]) {
                        ++n4;
                    }
                    n3 = n6;
                }
                break;
            }
            case WEST: 
            case EAST: {
                int n7 = 7;
                while (n7-- > 0) {
                    if (!(n7 != 4 & n7 != 5) || !fluidNetwork.canMergeGrid(this.networks[n7])) continue;
                    if (n3 == -1 || this.networks[n7] != this.networks[n3]) {
                        ++n4;
                    }
                    n3 = n7;
                }
                break;
            }
            case UNKNOWN: {
                int n8 = 6;
                while (n8-- > 0) {
                    if (!fluidNetwork.canMergeGrid(this.networks[n8])) continue;
                    if (n3 == -1 || this.networks[n8] != this.networks[n3]) {
                        ++n4;
                    }
                    n3 = n8;
                }
                break;
            }
        }
        if (n4 == 1) {
            fluidNetwork.mergeGrid(this.networks[n3]);
        }
        this.updateConnectionStatus(forgeDirection);
    }

    private void updateConnectionStatus(ForgeDirection forgeDirection) {
        int n = forgeDirection.ordinal();
        int[] nArray = Flags.LOOKUP[n];
        FluidNetwork fluidNetwork = this.networks[n];
        int n2 = n;
        this.faces[n2] = this.faces[n2] & 1;
        int n3 = 7;
        while (n3-- > 0) {
            ForgeDirection forgeDirection2;
            int n4 = nArray[n3];
            if (n4 == 0) {
                if (this.cache[n3] == null) continue;
                if (this.cache[n3] instanceof TileEntityPlasticMultiPipe) {
                    int n5 = n;
                    this.faces[n5] = this.faces[n5] | (Flags.LOOKUP_B[n][n3] | 0x100 | 0x200);
                    continue;
                }
                forgeDirection2 = Flags.getTo(n4);
                if (!this.cache[n3].canFill(forgeDirection2, null) && !this.cache[n3].canDrain(forgeDirection2, null)) continue;
                int n6 = n;
                this.faces[n6] = this.faces[n6] | (Flags.LOOKUP_B[n][n3] | 0x80 | 0x200);
                continue;
            }
            if (fluidNetwork == this.networks[n3]) {
                int n7 = n;
                this.faces[n7] = this.faces[n7] | (n4 | 0x100);
                continue;
            }
            if (n3 >= 6 || this.cache[n3] == null || !this.cache[n3].canFill(forgeDirection2 = Flags.getTo(n4), null) && !this.cache[n3].canDrain(forgeDirection2, null)) continue;
            int n8 = n;
            this.faces[n8] = this.faces[n8] | (n4 | 0x80);
        }
    }

    protected static final class Flags {
        protected static final int EXISTS = 1;
        protected static final int CONNECTED_DOWN = 2;
        protected static final int CONNECTED_UP = 4;
        protected static final int CONNECTED_NORTH = 8;
        protected static final int CONNECTED_SOUTH = 16;
        protected static final int CONNECTED_WEST = 32;
        protected static final int CONNECTED_EAST = 64;
        protected static final int HAS_CACHE = 128;
        protected static final int HAS_NETWORK = 256;
        protected static final int IS_EXTERNAL = 512;
        protected static final int[][] LOOKUP = new int[][]{{0, 0, 8, 16, 32, 64, 4}, {0, 0, 8, 16, 32, 64, 2}, {2, 4, 0, 0, 32, 64, 16}, {2, 4, 0, 0, 32, 64, 8}, {2, 4, 8, 16, 0, 0, 64}, {2, 4, 8, 16, 0, 0, 32}, {2, 4, 8, 16, 32, 64, 0}};
        protected static final int[][] LOOKUP_B = new int[][]{{2, 0, 0, 0, 0, 0, 0}, {0, 4, 0, 0, 0, 0, 0}, {0, 0, 8, 0, 0, 0, 0}, {0, 0, 0, 16, 0, 0, 0}, {0, 0, 0, 0, 32, 0, 0}, {0, 0, 0, 0, 0, 64, 0}, {0, 0, 0, 0, 0, 0, 0}};

        protected Flags() {
        }

        protected static final ForgeDirection getTo(int n) {
            switch (n) {
                case 2: {
                    return ForgeDirection.UP;
                }
                case 4: {
                    return ForgeDirection.DOWN;
                }
                case 8: {
                    return ForgeDirection.SOUTH;
                }
                case 16: {
                    return ForgeDirection.NORTH;
                }
                case 32: {
                    return ForgeDirection.EAST;
                }
                case 64: {
                    return ForgeDirection.WEST;
                }
            }
            return ForgeDirection.UNKNOWN;
        }

        protected static final ForgeDirection getFrom(int n) {
            switch (n) {
                case 2: {
                    return ForgeDirection.DOWN;
                }
                case 4: {
                    return ForgeDirection.UP;
                }
                case 8: {
                    return ForgeDirection.NORTH;
                }
                case 16: {
                    return ForgeDirection.SOUTH;
                }
                case 32: {
                    return ForgeDirection.WEST;
                }
                case 64: {
                    return ForgeDirection.EAST;
                }
            }
            return ForgeDirection.UNKNOWN;
        }
    }
}

