/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.tank;

import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.lib.util.position.BlockPosition;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import powercrystals.minefactoryreloaded.core.IDelayedValidate;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.net.ConnectionHandler;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;
import powercrystals.minefactoryreloaded.tile.tank.TankNetwork;

public class TileEntityTank
extends TileEntityFactory
implements ITankContainerBucketable,
IDelayedValidate {
    public static int CAPACITY = 4000;
    TankNetwork grid;
    FluidTankAdv _tank;
    protected byte sides;

    public TileEntityTank() {
        super(null);
        this.setManageFluids(true);
        this._tank = new FluidTankAdv(CAPACITY);
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            TileEntityTank tileEntityTank;
            if ((this.sides & 1 << forgeDirection.ordinal()) == 0 || (tileEntityTank = (TileEntityTank)BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)forgeDirection, TileEntityTank.class)) == null) continue;
            tileEntityTank.part(forgeDirection.getOpposite());
        }
        if (this.grid != null) {
            this.grid.removeNode(this);
        }
    }

    @Override
    public final boolean isNotValid() {
        return this.func_145837_r();
    }

    @Override
    public void firstTick() {
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            TileEntityTank tileEntityTank;
            if (forgeDirection.offsetY != 0 || !BlockPosition.blockExists((TileEntity)this, (ForgeDirection)forgeDirection) || (tileEntityTank = (TileEntityTank)BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)forgeDirection, TileEntityTank.class)) == null || tileEntityTank.grid == null || !FluidHelper.isFluidEqualOrNull((FluidStack)tileEntityTank.grid.storage.getFluid(), (FluidStack)this._tank.getFluid()) || tileEntityTank.grid == null || tileEntityTank.grid != this.grid && !tileEntityTank.grid.addNode(this)) continue;
            tileEntityTank.join(forgeDirection.getOpposite());
            this.join(forgeDirection);
        }
        if (this.grid == null) {
            this.grid = new TankNetwork(this);
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ConnectionHandler.update(this);
    }

    public void join(ForgeDirection forgeDirection) {
        this.sides = (byte)(this.sides | 1 << forgeDirection.ordinal());
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void part(ForgeDirection forgeDirection) {
        this.sides = (byte)(this.sides & ~(1 << forgeDirection.ordinal()));
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isInterfacing(ForgeDirection forgeDirection) {
        return 0 != (this.sides & 1 << forgeDirection.ordinal());
    }

    int interfaceCount() {
        return Integer.bitCount(this.sides);
    }

    @Override
    public Packet func_145844_m() {
        if (this.grid == null) {
            return null;
        }
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        FluidStack fluidStack = this.grid.storage.drain(1, false);
        nBTTagCompound.func_74782_a("fluid", fluidStack == null ? null : fluidStack.writeToNBT(new NBTTagCompound()));
        nBTTagCompound.func_74774_a("sides", this.sides);
        S35PacketUpdateTileEntity s35PacketUpdateTileEntity = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nBTTagCompound);
        return s35PacketUpdateTileEntity;
    }

    @Override
    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity s35PacketUpdateTileEntity) {
        super.onDataPacket(networkManager, s35PacketUpdateTileEntity);
        NBTTagCompound nBTTagCompound = s35PacketUpdateTileEntity.func_148857_g();
        switch (s35PacketUpdateTileEntity.func_148853_f()) {
            case 0: {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound.func_74775_l("fluid"));
                this._tank.setFluid(fluidStack);
                this.sides = nBTTagCompound.func_74771_c("sides");
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        if (this._tank.getFluidAmount() != 0) {
            nBTTagCompound.func_74782_a("tank", (NBTBase)this._tank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._tank.readFromNBT(nBTTagCompound.func_74775_l("tank"));
    }

    public FluidStack getFluid() {
        if (this.grid == null) {
            return this._tank.getFluid();
        }
        return this.grid.storage.getFluid();
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (this.grid == null) {
            return 0;
        }
        return this.grid.storage.fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (this.grid == null) {
            return null;
        }
        return this.grid.storage.drain(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (this.grid == null) {
            return this.field_145850_b.field_72995_K ? this._tank.drain(n, false) : null;
        }
        return this.grid.storage.drain(n, bl);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return this.grid != null;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return this.grid != null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        if (this.grid == null) {
            return FluidHelper.NULL_TANK_INFO;
        }
        return new FluidTankInfo[]{this.grid.storage.getInfo()};
    }

    @Override
    public boolean allowBucketFill(ItemStack itemStack) {
        return itemStack.func_77973_b() != MFRThings.plasticTankItem;
    }

    @Override
    public boolean allowBucketDrain(ItemStack itemStack) {
        return true;
    }

    @Override
    public void getTileInfo(List<IChatComponent> list, ForgeDirection forgeDirection, EntityPlayer entityPlayer, boolean bl) {
        if (bl) {
            list.add((IChatComponent)new ChatComponentText("Grid: " + this.grid));
        }
        if (this.grid == null) {
            list.add((IChatComponent)new ChatComponentText("Null Grid!!"));
            if (bl) {
                list.add((IChatComponent)new ChatComponentText("FluidForGrid: " + StringHelper.getFluidName((FluidStack)this._tank.getFluid(), (String)"") + "@" + this._tank.getFluidAmount()));
            }
            return;
        }
        if (this.grid.storage.getFluidAmount() == 0) {
            list.add((IChatComponent)new ChatComponentText(MFRUtil.empty()));
        } else {
            list.add((IChatComponent)new ChatComponentText(MFRUtil.getFluidName(this.grid.storage.getFluid())));
        }
        list.add((IChatComponent)new ChatComponentText((float)this.grid.storage.getFluidAmount() / (float)this.grid.storage.getCapacity() * 100.0f + "%"));
        if (bl) {
            list.add((IChatComponent)new ChatComponentText("Sides: " + Integer.toBinaryString(this.sides)));
            list.add((IChatComponent)new ChatComponentText(this.grid.storage.getFluidAmount() + " / " + this.grid.storage.getCapacity()));
            list.add((IChatComponent)new ChatComponentText("Size: " + this.grid.getSize() + " | FluidForGrid: " + StringHelper.getFluidName((FluidStack)this._tank.getFluid(), (String)"") + "@" + this._tank.getFluidAmount()));
            list.add((IChatComponent)new ChatComponentText("Length: " + this.grid.storage.length + " | Index: " + this.grid.storage.index + " | Reserve: " + this.grid.storage.tanks.length));
        }
    }
}

