/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.rednet;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cofh.asm.relauncher.Strippable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.core.ArrayQueue;
import powercrystals.minefactoryreloaded.net.Packets;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;

public class TileEntityRedNetHistorian
extends TileEntityFactory {
    @SideOnly(value=Side.CLIENT)
    private ArrayQueue<Integer> _valuesClient;
    @SideOnly(value=Side.CLIENT)
    private int _currentValueClient;
    private int _currentSubnet = 0;
    private int[] _lastValues = new int[16];

    public TileEntityRedNetHistorian() {
        super(null);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74768_a("facing", this.getDirectionFacing().ordinal());
        nBTTagCompound.func_74768_a("subnet", this._currentSubnet);
        nBTTagCompound.func_74768_a("current", this._lastValues[this._currentSubnet]);
        S35PacketUpdateTileEntity s35PacketUpdateTileEntity = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nBTTagCompound);
        return s35PacketUpdateTileEntity;
    }

    @Override
    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity s35PacketUpdateTileEntity) {
        NBTTagCompound nBTTagCompound = s35PacketUpdateTileEntity.func_148857_g();
        switch (s35PacketUpdateTileEntity.func_148853_f()) {
            case 0: {
                this._currentSubnet = nBTTagCompound.func_74762_e("subnet");
                this._currentValueClient = nBTTagCompound.func_74762_e("current");
                this.rotateDirectlyTo(nBTTagCompound.func_74762_e("facing"));
                break;
            }
            case 1: {
                this._currentValueClient = nBTTagCompound.func_74762_e("value");
            }
        }
    }

    @Override
    public void func_145829_t() {
        if (!this.field_145850_b.field_72995_K) {
            this.setSelectedSubnet(this._currentSubnet);
        } else {
            this._valuesClient = new ArrayQueue(100);
            this._currentValueClient = 0;
        }
    }

    @SideOnly(value=Side.SERVER)
    public boolean canUpdate() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this._valuesClient.pop();
            this._valuesClient.push(this._currentValueClient);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Integer[] getValues() {
        Integer[] integerArray = new Integer[this._valuesClient.size()];
        return this._valuesClient.toArray((Integer[])integerArray);
    }

    @SideOnly(value=Side.CLIENT)
    public void setClientValue(int n) {
        this._currentValueClient = n;
    }

    public void setSelectedSubnet(int n) {
        this._currentSubnet = n;
        if (this.field_145850_b.field_72995_K) {
            this._valuesClient.fill(null);
        } else {
            this.sendValue(this._lastValues[this._currentSubnet]);
        }
    }

    public void valuesChanged(int[] nArray) {
        for (int i = 0; i < 16; ++i) {
            if (nArray[i] == this._lastValues[i]) continue;
            this._lastValues[i] = nArray[i];
            if (i != this._currentSubnet) continue;
            this.sendValue(nArray[i]);
        }
    }

    protected void sendValue(int n) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74768_a("value", n);
        Packets.sendToAllPlayersInRange(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 50, (Packet)new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nBTTagCompound));
    }

    public int getSelectedSubnet() {
        return this._currentSubnet;
    }

    @Override
    public boolean canRotate() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._currentSubnet = nBTTagCompound.func_74762_e("subnet");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("subnet", this._currentSubnet);
    }

    @Override
    @Strippable(value={"buildcraft.api.transport.IPipeConnection"})
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 4096.0;
    }
}

