/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.WeightedRandomItemStack;
import cofh.lib.util.position.Area;
import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntitySludgeBoiler
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private Random _rand;
    private int _tick;
    private Area _area;

    public TileEntitySludgeBoiler() {
        super(Machine.SludgeBoiler);
        this.setManageSolids(true);
        this._activeSyncTimeout = (byte)5;
        this._rand = new Random();
        this._tanks[0].setLock(FluidRegistry.getFluid((String)"sludge"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this._area = new Area(new BlockPosition((TileEntity)this), 3, 3, 3);
    }

    @Override
    public int getWorkMax() {
        return 100;
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    @Override
    protected boolean activateMachine() {
        if (this.drain(this._tanks[0], 10, false) == 10) {
            Object object;
            if (!this.incrementWorkDone()) {
                return false;
            }
            this.drain(this._tanks[0], 10, true);
            ++this._tick;
            if (this.getWorkDone() >= this.getWorkMax()) {
                object = ((WeightedRandomItemStack)WeightedRandom.func_76271_a((Random)this._rand, MFRRegistry.getSludgeDrops())).getStack();
                this.doDrop((ItemStack)object);
                this.setWorkDone(0);
            }
            if (this._tick >= 23) {
                object = this.field_145850_b.func_72872_a(EntityLivingBase.class, this._area.toAxisAlignedBB());
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    EntityLivingBase entityLivingBase = (EntityLivingBase)iterator.next();
                    entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 400, 0));
                    entityLivingBase.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 120, 0));
                }
                this._tick = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean updateIsActive(boolean bl) {
        return super.updateIsActive(bl) && this.drain(this._tanks[0], 10, false) == 10;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void machineDisplayTick() {
        int n = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (n < 2 && this.isActive()) {
            int n2 = MFRThings.sludgeLiquid.color;
            int n3 = 8 >> n;
            int n4 = 4 >> n;
            while (n4-- > 0) {
                this.field_145850_b.func_72869_a(this._rand.nextInt(n3) == 0 ? "mobSpell" : "mobSpellAmbient", (double)((float)this._area.xMin + this._rand.nextFloat() * (float)(this._area.xMax - this._area.xMin)), (double)((float)this._area.yMin + this._rand.nextFloat() * (float)(this._area.yMax - this._area.yMin)), (double)((float)this._area.zMin + this._rand.nextFloat() * (float)(this._area.zMax - this._area.zMin)), (double)((float)(n2 >> 16 & 0xFF) / 255.0f), (double)((float)(n2 >> 8 & 0xFF) / 255.0f), (double)((float)(n2 & 0xFF) / 255.0f));
            }
        }
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.DOWN;
    }

    @Override
    public boolean allowBucketFill(ItemStack itemStack) {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.drain(fluidStack, bl);
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(4000)};
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

