/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.fluid.FluidTankAdv;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiAutoAnvil;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoAnvil;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityAutoAnvil
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private float maximumCost;
    private int stackSizeToBeUsedInRepair;
    private boolean repairOnly;
    private ItemStack _output;

    public TileEntityAutoAnvil() {
        super(Machine.AutoAnvil);
        this.setManageSolids(true);
        this._tanks[0].setLock(FluidRegistry.getFluid((String)"mobessence"));
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (itemStack == null) {
            return false;
        }
        if (this.repairOnly) {
            if (n == 0) {
                return itemStack.func_77973_b().isRepairable();
            }
            if (n == 1 && this._inventory[0] != null && itemStack.func_77973_b().isRepairable()) {
                return this._inventory[0].func_77973_b().equals(itemStack.func_77973_b());
            }
            return false;
        }
        if (n == 0) {
            return itemStack.func_77984_f() || itemStack.func_77973_b().equals(Items.field_151134_bR);
        }
        if (n == 1 && this._inventory[0] != null) {
            if (itemStack.func_77973_b().equals(Items.field_151134_bR) && Items.field_151134_bR.func_92110_g(itemStack).func_74745_c() > 0) {
                return true;
            }
            return itemStack.func_77973_b().equals(this._inventory[0].func_77973_b()) && itemStack.func_77984_f() && itemStack.func_77973_b().isRepairable() || this._inventory[0].func_77973_b().func_82789_a(this._inventory[0], itemStack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 2;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiAutoAnvil(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerAutoAnvil(this, inventoryPlayer);
    }

    @Override
    protected boolean activateMachine() {
        if (this._output == null || this._inventory[2] != null) {
            return false;
        }
        if (this.repairOnly) {
            if (this._inventory[0] != null && this._inventory[1] != null && this._inventory[0].func_77973_b().equals(this._inventory[1].func_77973_b()) && this._inventory[0].func_77973_b().isRepairable()) {
                if (!this.incrementWorkDone()) {
                    return false;
                }
                if (this.getWorkDone() >= this.getWorkMax()) {
                    this._inventory[0] = null;
                    this._inventory[1] = null;
                    this._inventory[2] = this._output;
                    this.setWorkDone(0);
                    this._output = null;
                }
                return true;
            }
            return false;
        }
        if (this.drain(this._tanks[0], 4, false) != 4) {
            return false;
        }
        if (this.stackSizeToBeUsedInRepair > 0 && (this._inventory[1] == null || this._inventory[1].field_77994_a < this.stackSizeToBeUsedInRepair)) {
            return false;
        }
        this.drain(this._tanks[0], 4, true);
        if (!this.incrementWorkDone()) {
            return false;
        }
        if (this.getWorkDone() >= this.getWorkMax()) {
            this._inventory[0] = null;
            this._inventory[2] = this._output;
            if (this.stackSizeToBeUsedInRepair > 0 && this._inventory[1].field_77994_a > this.stackSizeToBeUsedInRepair) {
                this._inventory[1].field_77994_a -= this.stackSizeToBeUsedInRepair;
            } else {
                this._inventory[1] = null;
            }
            this.setWorkDone(0);
            this._output = null;
        }
        return true;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        super.onFactoryInventoryChanged();
        this._output = this.getAnvilOutput();
        if (this._output != null) {
            this.setIdleTicks(this.getIdleTicksMax());
        }
        this.setWorkDone(0);
    }

    public ItemStack getRepairOutput() {
        return this._output;
    }

    private ItemStack getAnvilOutput() {
        int n;
        int n2;
        int n3;
        ItemStack itemStack = this._inventory[0];
        this.maximumCost = 0.0f;
        int n4 = 0;
        if (itemStack == null) {
            return null;
        }
        if (this.repairOnly) {
            this.stackSizeToBeUsedInRepair = 0;
            ItemStack itemStack2 = this._inventory[1];
            Item item = itemStack.func_77973_b();
            if (itemStack2 != null && item.isRepairable() && itemStack.func_77973_b() == itemStack2.func_77973_b()) {
                int n5 = item.func_77612_l();
                int n6 = itemStack.func_77952_i();
                int n7 = itemStack2.func_77952_i();
                int n8 = n5 - n6 + (n5 - n7) + n5 / 10;
                int n9 = Math.max(n5 - n8, 0);
                this.maximumCost = (float)((n6 + n7) / 2 - n9) / 100.0f;
                return new ItemStack(itemStack.func_77973_b(), 1, n9);
            }
            return null;
        }
        ItemStack itemStack3 = itemStack.func_77946_l();
        ItemStack itemStack4 = this._inventory[1];
        Map map = EnchantmentHelper.func_82781_a((ItemStack)itemStack3);
        boolean bl = false;
        int n10 = itemStack3.func_82838_A() + (itemStack4 == null ? 0 : itemStack4.func_82838_A());
        this.stackSizeToBeUsedInRepair = 0;
        if (itemStack4 != null) {
            AnvilUpdateEvent anvilUpdateEvent = new AnvilUpdateEvent(itemStack3.func_77946_l(), itemStack4.func_77946_l(), "", n10);
            if (MinecraftForge.EVENT_BUS.post((Event)anvilUpdateEvent)) {
                return null;
            }
            if (anvilUpdateEvent.output != null) {
                this.maximumCost = anvilUpdateEvent.cost;
                return anvilUpdateEvent.output;
            }
            bl = itemStack4.func_77973_b().equals(Items.field_151134_bR) && Items.field_151134_bR.func_92110_g(itemStack4).func_74745_c() > 0;
            n3 = 0;
            if (itemStack3.func_77984_f() && itemStack3.func_77973_b().func_82789_a(itemStack3, itemStack4)) {
                int n11;
                int n12 = Math.min(itemStack3.func_77952_i(), itemStack3.func_77958_k() / 4);
                if (n12 <= 0) {
                    return null;
                }
                for (n11 = 0; n12 > 0 && n11 < itemStack4.field_77994_a; ++n11) {
                    itemStack3.func_77964_b(itemStack3.func_77952_i() - n12);
                    n4 += Math.max(1, n12 / 100) + map.size();
                    n12 = Math.min(itemStack3.func_77952_i(), itemStack3.func_77958_k() / 4);
                }
                this.stackSizeToBeUsedInRepair = n11;
                if (n11 > 0) {
                    ++n3;
                }
            } else {
                if (!(bl || itemStack3.func_77973_b().equals(itemStack4.func_77973_b()) && itemStack3.func_77984_f())) {
                    return null;
                }
                if (itemStack3.func_77984_f() && !bl) {
                    int n13 = itemStack3.func_77958_k() - itemStack3.func_77952_i();
                    int n14 = itemStack4.func_77958_k() - itemStack4.func_77952_i();
                    int n15 = n14 + itemStack3.func_77958_k() * 12 / 100;
                    n2 = n13 + n15;
                    n = itemStack3.func_77958_k() - n2;
                    if (n < 0) {
                        n = 0;
                    }
                    if (n < itemStack3.func_77960_j()) {
                        ++n3;
                        itemStack3.func_77964_b(n);
                        n4 += Math.max(1, n15 / 100);
                    }
                }
                Map map2 = EnchantmentHelper.func_82781_a((ItemStack)itemStack4);
                for (Integer n16 : map2.keySet()) {
                    Enchantment enchantment = Enchantment.field_77331_b[n16];
                    if (enchantment == null) continue;
                    n = map.containsKey(n16) ? (Integer)map.get(n16) : 0;
                    int n17 = (Integer)map2.get(n16);
                    int n18 = n == n17 ? ++n17 : Math.max(n17, n);
                    n17 = n18;
                    int n19 = n17 - n;
                    boolean bl2 = enchantment.func_92089_a(itemStack3);
                    if (itemStack3.func_77973_b().equals(Items.field_151134_bR)) {
                        bl2 = true;
                    }
                    for (Integer n20 : map.keySet()) {
                        if (n20 == n16 || enchantment.func_77326_a(Enchantment.field_77331_b[n20])) continue;
                        bl2 = false;
                        n4 += n19;
                    }
                    if (!bl2) continue;
                    if (n18 > enchantment.func_77325_b()) {
                        n18 = enchantment.func_77325_b();
                    } else {
                        ++n3;
                    }
                    map.put(Integer.valueOf(n16), n18);
                    int n21 = 0;
                    switch (enchantment.func_77324_c()) {
                        case 1: {
                            n21 = 8;
                            break;
                        }
                        case 2: {
                            n21 = 4;
                        }
                        default: {
                            break;
                        }
                        case 5: {
                            n21 = 2;
                            break;
                        }
                        case 10: {
                            n21 = 1;
                        }
                    }
                    if (bl) {
                        n21 = Math.max(1, n21 / 2);
                    }
                    n4 += n21 * n19;
                }
            }
            if (n3 == 0) {
                n4 = 0;
            }
        }
        n3 = 0;
        for (Integer n22 : map.keySet()) {
            Enchantment enchantment = Enchantment.field_77331_b[n22];
            n2 = (Integer)map.get(n22);
            n = 0;
            ++n3;
            switch (enchantment.func_77324_c()) {
                case 1: {
                    n = 8;
                    break;
                }
                case 2: {
                    n = 4;
                }
                default: {
                    break;
                }
                case 5: {
                    n = 2;
                    break;
                }
                case 10: {
                    n = 1;
                }
            }
            if (bl) {
                n = Math.max(1, n / 2);
            }
            n10 += n3 + n2 * n;
        }
        if (bl) {
            n10 = Math.max(1, n10 / 2);
        }
        if (bl && !itemStack3.func_77973_b().isBookEnchantable(itemStack3, itemStack4)) {
            itemStack3 = null;
        }
        this.maximumCost = n10 + n4;
        if (n4 <= 0) {
            itemStack3 = null;
        }
        if (itemStack3 != null) {
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)itemStack3);
        }
        return itemStack3;
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        nBTTagCompound.func_74757_a("repairOnly", this.repairOnly);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.repairOnly = nBTTagCompound.func_74767_n("repairOnly");
    }

    public boolean getRepairOnly() {
        return this.repairOnly;
    }

    public void setRepairOnly(boolean bl) {
        this.repairOnly = bl;
        this.onFactoryInventoryChanged();
    }

    @Override
    public int getWorkMax() {
        return (int)(100.0f * this.maximumCost);
    }

    @Override
    public int getIdleTicksMax() {
        return 30;
    }

    @Override
    public boolean allowBucketFill(ItemStack itemStack) {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(4000)};
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

