/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import appeng.api.implementations.tiles.ICrankable;
import cofh.api.energy.IEnergyReceiver;
import cofh.asm.relauncher.Strippable;
import cofh.core.util.CoreUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

@Strippable(value={"appeng.api.implementations.tiles.ICrankable"})
public abstract class TileEntityFactoryPowered
extends TileEntityFactoryInventory
implements IEnergyReceiver,
ICrankable {
    public static final int energyPerAE = 2;
    public static final int energyPerEU = 4;
    public static final int energyPerMJ = 10;
    private static final int energyFudge = 80;
    private int _energyStored;
    private int _maxEnergyStored;
    private int _maxEnergyTick;
    private int _energyRequiredThisTick = 0;
    protected int _energyActivation;
    private int _workDone;
    private int _idleTicks;

    protected TileEntityFactoryPowered(Machine machine) {
        this(machine, machine.getActivationEnergy());
    }

    protected TileEntityFactoryPowered(Machine machine, int n) {
        super(machine);
        this._maxEnergyStored = machine.getMaxEnergyStorage();
        this.setActivationEnergy(n);
        this.setIsActive(false);
    }

    protected void setActivationEnergy(int n) {
        this._energyActivation = n;
        this._maxEnergyTick = Math.min(n * 4, this._maxEnergyStored);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this._energyStored = Math.min(this._energyStored, this.getEnergyStoredMax());
        if (this.field_145850_b.field_72995_K) {
            this.machineDisplayTick();
            return;
        }
        this.markChunkDirty();
        int n = Math.min(this.getEnergyStoredMax() - this.getEnergyStored(), this.getActivationEnergy() + 80);
        this._energyRequiredThisTick = Math.max(this._energyRequiredThisTick + n, this.getMaxEnergyPerTick());
        this.setIsActive(this.updateIsActive(this.failedDrops != null));
        if (this.failedDrops != null) {
            this.setIdleTicks(this.getIdleTicksMax());
            return;
        }
        if (CoreUtils.isRedstonePowered((TileEntity)this)) {
            this.setIdleTicks(this.getIdleTicksMax());
        } else if (this._idleTicks > 0) {
            --this._idleTicks;
        } else if (this._energyStored >= this._energyActivation && this.activateMachine()) {
            this._energyStored -= this._energyActivation;
        }
    }

    protected boolean updateIsActive(boolean bl) {
        return !bl && this.hasSufficientPower();
    }

    protected abstract boolean activateMachine();

    @SideOnly(value=Side.CLIENT)
    protected void machineDisplayTick() {
    }

    public final boolean hasSufficientPower() {
        return this._energyStored >= this._energyActivation * 2;
    }

    public int getActivationEnergy() {
        return this._energyActivation;
    }

    public int getMaxEnergyPerTick() {
        return this._maxEnergyTick;
    }

    public int getEnergyStored() {
        return this._energyStored;
    }

    public int getEnergyStoredMax() {
        return this._maxEnergyStored;
    }

    public void setEnergyStored(int n) {
        this._energyStored = n;
    }

    public void drainEnergy(int n) {
        this._energyStored -= n;
    }

    public int getWorkDone() {
        return this._workDone;
    }

    public abstract int getWorkMax();

    public void setWorkDone(int n) {
        this._workDone = n;
    }

    protected boolean incrementWorkDone() {
        this.setWorkDone(this.getWorkDone() + 1);
        return true;
    }

    public int getIdleTicks() {
        return this._idleTicks;
    }

    public abstract int getIdleTicksMax();

    public void setIdleTicks(int n) {
        this._idleTicks = n;
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        if (this._workDone > 0) {
            nBTTagCompound.func_74768_a("workDone", this._workDone);
        }
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        if (this._energyStored > 0) {
            nBTTagCompound.func_74768_a("energyStored", this._energyStored);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._energyStored = Math.min(nBTTagCompound.func_74762_e("energyStored"), this.getEnergyStoredMax());
        this._workDone = Math.min(nBTTagCompound.func_74762_e("workDone"), this.getWorkMax());
    }

    public int getEnergyRequired() {
        return Math.min(this.getEnergyStoredMax() - this.getEnergyStored(), this._energyRequiredThisTick);
    }

    public int storeEnergy(int n, boolean bl) {
        int n2 = Math.max(Math.min(n, this.getEnergyRequired()), 0);
        if (bl) {
            this._energyStored += n2;
            this._energyRequiredThisTick -= n2;
        }
        return n2;
    }

    public int storeEnergy(int n) {
        return this.storeEnergy(n, true);
    }

    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.storeEnergy(n, !bl);
    }

    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return true;
    }

    public int getEnergyStored(ForgeDirection forgeDirection) {
        return this.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return this.getEnergyStoredMax();
    }

    public boolean canTurn() {
        return this.getEnergyStored() < this.getEnergyStoredMax();
    }

    public void applyTurn() {
        this.storeEnergy(90, true);
    }

    public boolean canCrankAttach(ForgeDirection forgeDirection) {
        return true;
    }
}

