/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.setup;

import java.io.File;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import powercrystals.minefactoryreloaded.setup.Machine;

public class MFRConfig {
    public static Property spyglassRange;
    public static Property brightRednetBand;
    public static boolean TESRCables;
    public static Property dropFilledContainers;
    public static Property zoolologistEntityId;
    public static Property colorblindMode;
    public static Property enableBonemealFertilizing;
    public static Property conveyorCaptureNonItems;
    public static Property conveyorNeverCapturesPlayers;
    public static Property conveyorNeverCapturesTCGolems;
    public static Property playSounds;
    public static Property defaultRedNetCableOnly;
    public static Property treeSearchMaxVertical;
    public static Property treeSearchMaxHorizontal;
    public static Property verticalHarvestSearchMaxVertical;
    public static Property fruitTreeSearchMaxVertical;
    public static Property fruitTreeSearchMaxHorizontal;
    public static Property breederShutdownThreshold;
    public static Property autospawnerCostStandard;
    public static Property autospawnerCostExact;
    public static Property laserdrillCost;
    public static Property disenchanterEssence;
    public static Property steamBoilerExplodes;
    public static Property largeSlimesDrop;
    public static Property meatSaturation;
    public static Property fishingDropRate;
    public static Property vanillaOverrideMilkBucket;
    public static Property enableCheapDSU;
    public static Property craftSingleDSU;
    public static Property enableMossyCobbleRecipe;
    public static Property enableSmoothSlabRecipe;
    public static Property enablePortaSpawner;
    public static Property enableSyringes;
    public static Property enableLiquidSyringe;
    public static Property enableGuns;
    public static Property enableNetLauncher;
    public static Property enableSPAMRExploding;
    public static Property enableFuelExploding;
    public static Property enableSpawnerCarts;
    public static Property enableExpensiveSafariNet;
    public static Property enableChunkLimitBypassing;
    public static Property enableChunkLoaderRequiresOwner;
    public static Property enableCheapCL;
    public static Property enableConfigurableCLEnergy;
    public static Property redNetDebug;
    public static Property redNetConnectionBlacklist;
    public static Property worldGenDimensionBlacklist;
    public static Property rubberTreeWorldGen;
    public static Property rubberTreeBiomeWhitelist;
    public static Property rubberTreeBiomeBlacklist;
    public static Property enableMassiveTree;
    public static Property mfrLakeWorldGen;
    public static Property mfrLakeSewageRarity;
    public static Property mfrLakeSewageBiomeList;
    public static Property mfrLakeSewageBiomeListToggle;
    public static Property mfrLakeSludgeRarity;
    public static Property mfrLakeSludgeBiomeList;
    public static Property mfrLakeSludgeBiomeListToggle;
    public static Property mfrLakeSewageRetrogen;
    public static Property mfrLakeSludgeRetrogen;
    public static Property rubberTreeRetrogen;
    public static Property unifierBlacklist;
    public static Property spawnerBlacklist;
    public static Property safarinetBlacklist;
    public static ConfigCategory spawnerCustomization;
    public static Property passengerRailSearchMaxHorizontal;
    public static Property passengerRailSearchMaxVertical;
    public static Property vanillaRecipes;
    public static Property thermalExpansionRecipes;
    public static Property enderioRecipes;
    public static String CATEGORY_ITEM;

    public static void loadClientConfig(File file) {
        Configuration configuration = new Configuration(file, true);
        spyglassRange = configuration.get("general", "SpyglassRange", 200);
        MFRConfig.spyglassRange.comment = "The maximum number of blocks the spyglass and ruler can look to find something. This calculation is performed only on the client side.";
        brightRednetBand = configuration.get("general", "BrightRedNetColors", false);
        MFRConfig.brightRednetBand.comment = "If true, RedNet color bands will always be bright.";
        TESRCables = !configuration.get("general", "DisableRedNetFramerateStabilization", false, "Set to true to disable RedNet cables switching to TESRs when they detect that they are updating too rapidly.").getBoolean(false);
        colorblindMode = configuration.get("general", "EnableColorblindMode", false);
        MFRConfig.colorblindMode.comment = "Set to true to enable the RedNet GUI's colorblind mode.";
        configuration.save();
    }

    public static void loadCommonConfig(File file) {
        Configuration configuration = new Configuration(file, true);
        configuration.load();
        String string = "Entity";
        String string2 = "";
        zoolologistEntityId = configuration.get(string, "ID.Zoologist", 330).setRequiresMcRestart(true);
        enableSpawnerCarts = configuration.get(string, "EnableSpawnerCarts", true);
        MFRConfig.enableSpawnerCarts.comment = "If true, using a portaspawner on an empty minecart will make it into a spawner cart";
        playSounds = configuration.get("general", "PlaySounds", true);
        MFRConfig.playSounds.comment = "Set to false to disable various sounds and particle effects, such as when a block is harvested.";
        safarinetBlacklist = configuration.get("general", "SafariNetBlacklist", new String[0]);
        MFRConfig.safarinetBlacklist.comment = "A list of entity IDs (e.g.: CaveSpider or VillagerGolem or Forestry.butterflyGE) to blacklist from being captured by the SafariNet. The Debugger item will display an entity's ID when used.";
        treeSearchMaxHorizontal = configuration.get("general.SearchDistance", "Tree.MaxHorizontal", 512);
        MFRConfig.treeSearchMaxHorizontal.comment = "When searching for parts of a tree, how far out to the sides (radius) to search";
        treeSearchMaxVertical = configuration.get("general.SearchDistance", "Tree.MaxVertical", 256);
        MFRConfig.treeSearchMaxVertical.comment = "When searching for parts of a tree, how far up to search";
        verticalHarvestSearchMaxVertical = configuration.get("general.SearchDistance", "StackingBlock.MaxVertical", 5);
        MFRConfig.verticalHarvestSearchMaxVertical.comment = "How far upward to search for members of \"stacking\" blocks, like cactus and sugarcane";
        passengerRailSearchMaxVertical = configuration.get("general.SearchDistance", "PassengerRail.MaxVertical", 2);
        MFRConfig.passengerRailSearchMaxVertical.comment = "When searching for players or dropoff locations, how far up to search";
        passengerRailSearchMaxHorizontal = configuration.get("general.SearchDistance", "PassengerRail.MaxHorizontal", 3);
        MFRConfig.passengerRailSearchMaxHorizontal.comment = "When searching for players or dropoff locations, how far out to the sides (radius) to search";
        fruitTreeSearchMaxHorizontal = configuration.get("general.SearchDistance", "FruitTree.MaxHoriztonal", 5);
        MFRConfig.fruitTreeSearchMaxHorizontal.comment = "When searching for parts of a fruit tree, how far out to the sides (radius) to search";
        fruitTreeSearchMaxVertical = configuration.get("general.SearchDistance", "FruitTree.MaxVertical", 20);
        MFRConfig.fruitTreeSearchMaxVertical.comment = "When searching for parts of a fruit tree, how far up to search";
        string = "general.RedNet";
        redNetDebug = configuration.get(string, "Debug", false);
        MFRConfig.redNetDebug.comment = "If true, RedNet cables will dump a massive amount of data to the log file. You should probably only use this if PC tells you to.";
        redNetConnectionBlacklist = configuration.get(string, "ConnectionBlackList", new String[0]).setRequiresMcRestart(true);
        MFRConfig.redNetConnectionBlacklist.comment = "A list of block IDs to prevent RedNet cables from connecting to. (e.g., minecraft:torch)";
        defaultRedNetCableOnly = configuration.get(string, "CableOnly", false);
        MFRConfig.defaultRedNetCableOnly.comment = "If true, placed rednet cable will default to cable-only connections.";
        string = "general.WorldGen";
        worldGenDimensionBlacklist = configuration.get(string, "Dimension.Blacklist", new int[0]).setRequiresMcRestart(true);
        MFRConfig.worldGenDimensionBlacklist.comment = "A list of dimension IDs to disable MFR worldgen in.";
        string2 = string + ".RetroGen";
        configuration.getCategory(string2).setComment("Enable or disable specific retrogen items.\nOnly has an effect if retroactive geneneration is enabled in CoFHCore.");
        mfrLakeSewageRetrogen = configuration.get(string2, "SewageLakes", false).setRequiresMcRestart(true);
        mfrLakeSludgeRetrogen = configuration.get(string2, "SludgeLakes", false).setRequiresMcRestart(true);
        rubberTreeRetrogen = configuration.get(string2, "RubberTrees", true).setRequiresMcRestart(true);
        string2 = string + ".RubberTrees";
        rubberTreeWorldGen = configuration.get(string2, "Enable", true).setRequiresMcRestart(true);
        MFRConfig.rubberTreeWorldGen.comment = "Whether or not to generate MFR rubber trees during map generation";
        rubberTreeBiomeWhitelist = configuration.get(string2, "Biome.Whitelist", new String[0]).setRequiresMcRestart(true);
        MFRConfig.rubberTreeBiomeWhitelist.comment = "A list of biomes to allow rubber trees to spawn in. Does nothing if rubber tree worldgen is disabled.";
        rubberTreeBiomeBlacklist = configuration.get(string2, "Biome.Blacklist", new String[0]).setRequiresMcRestart(true);
        MFRConfig.rubberTreeBiomeBlacklist.comment = "A list of biomes to disallow rubber trees to spawn in. Overrides any other biomes added.";
        enableMassiveTree = configuration.get(string2, "SacredRubberSapling", true).setRequiresMcRestart(true);
        MFRConfig.enableMassiveTree.comment = "If true, enable adding Enchanted Sacred Rubber Saplings to stronghold library loot.";
        string2 = string + ".Lakes";
        mfrLakeWorldGen = configuration.get(string2, "Enable", true).setRequiresMcRestart(true);
        MFRConfig.mfrLakeWorldGen.comment = "Whether or not to generate MFR lakes during map generation. By default, MFR will not attempt lake worldgen in dimensions where the player cannot respawn.";
        mfrLakeSludgeRarity = configuration.get(string2 + ".Sludge", "Rarity", 32).setRequiresMcRestart(true);
        MFRConfig.mfrLakeSludgeRarity.comment = "Higher numbers make sludge lakes rarer. A value of one will be approximately one per chunk. 0 will disable.";
        mfrLakeSludgeBiomeList = configuration.get(string2 + ".Sludge", "BiomeList", new String[0]).setRequiresMcRestart(true);
        MFRConfig.mfrLakeSludgeBiomeList.comment = "A list of biomes to allow/disallow Sludge lakes to spawn in. Does nothing if lake worldgen is disabled.";
        mfrLakeSludgeBiomeListToggle = configuration.get(string2 + ".Sludge", "BiomeList.Mode", false).setRequiresMcRestart(true);
        MFRConfig.mfrLakeSludgeBiomeListToggle.comment = "If false, the biome list is a blacklist. If true, the biome list is a whitelist.";
        mfrLakeSewageRarity = configuration.get(string2 + ".Sewage", "Rarity", 32).setRequiresMcRestart(true);
        MFRConfig.mfrLakeSewageRarity.comment = "Higher numbers make Sewage lakes rarer. A value of one will be approximately one per chunk. 0 will disable.";
        mfrLakeSewageBiomeList = configuration.get(string2 + ".Sewage", "BiomeList", new String[0]).setRequiresMcRestart(true);
        MFRConfig.mfrLakeSewageBiomeList.comment = "A list of biomes to allow/disallow Sewage lakes to spawn in. Does nothing if lake worldgen is disabled.";
        mfrLakeSewageBiomeListToggle = configuration.get(string2 + ".Sewage", "BiomeList.Mode", false).setRequiresMcRestart(true);
        MFRConfig.mfrLakeSewageBiomeListToggle.comment = "If false, the biome list is a blacklist. If true, the biome list is a whitelist.";
        vanillaRecipes = configuration.get("RecipeSets", "Vanilla", true).setRequiresMcRestart(true);
        MFRConfig.vanillaRecipes.comment = "If true, MFR will register its standard (vanilla-item-only) recipes.";
        thermalExpansionRecipes = configuration.get("RecipeSets", "ThermalExpansion", false).setRequiresMcRestart(true);
        MFRConfig.thermalExpansionRecipes.comment = "If true, MFR will register its Thermal Expansion-based recipes.";
        enderioRecipes = configuration.get("RecipeSets", "EnderIO", false).setRequiresMcRestart(true);
        MFRConfig.enderioRecipes.comment = "If true, MFR will register its EnderIO-based recipes.";
        string = CATEGORY_ITEM + ".VanillaOverride";
        vanillaOverrideMilkBucket = configuration.get(string, "MilkBucket", true).setRequiresMcRestart(true);
        MFRConfig.vanillaOverrideMilkBucket.comment = "If true, replaces the vanilla milk bucket so milk can be placed in the world.";
        meatSaturation = configuration.get(CATEGORY_ITEM, "Meat.IncreasedSaturation", false).setRequiresMcRestart(true);
        MFRConfig.meatSaturation.comment = "If true, meat will be worth steak saturation instead of cookie saturation.";
        fishingDropRate = configuration.get(CATEGORY_ITEM, "FishDropRate", 5);
        MFRConfig.fishingDropRate.comment = "The rate at which fish are dropped from the fishing rod. The drop rate is 1 / this number. Must be greater than 0.";
        enableSPAMRExploding = configuration.get(CATEGORY_ITEM, "SPAMR.Exploding", true);
        MFRConfig.enableSPAMRExploding.comment = "If true, SPAMRs will explode when they run out of fuel.";
        enableFuelExploding = configuration.get(CATEGORY_ITEM, "Biofuel.Exploding", true);
        MFRConfig.enableFuelExploding.comment = "If true, biofuel will explode when in the nether.";
        enableLiquidSyringe = configuration.get(CATEGORY_ITEM, "LiquidSyringes", true).setRequiresMcRestart(true);
        MFRConfig.enableLiquidSyringe.comment = "If true, Empty Syringes will be able to contain liquids and inject players.";
        largeSlimesDrop = configuration.get(CATEGORY_ITEM, "LargeSlimeDrop", false);
        MFRConfig.largeSlimesDrop.comment = "If true, only pink slimes larger than tiny will drop pink slimeballs. Provided for those who want a more work-intensive laser drill. (slimes can only be made larger through the slime embiggening syringe)";
        string = CATEGORY_ITEM + ".Recipe";
        enableCheapDSU = configuration.get(string, "CheaperDSU", false).setRequiresMcRestart(true);
        MFRConfig.enableCheapDSU.comment = "If true, the DSU can be built out of chests instead of ender pearls. Does nothing if the recipe is disabled.";
        craftSingleDSU = configuration.get(string, "SingleDSU", true).setRequiresMcRestart(true);
        MFRConfig.craftSingleDSU.comment = "DSU recipes will always craft one DSU. Does nothing for recipes that already only craft one DSU (cheap mode, etc).";
        enableMossyCobbleRecipe = configuration.get(string, "MossyCobble", true).setRequiresMcRestart(true);
        MFRConfig.enableMossyCobbleRecipe.comment = "If true, mossy cobble can be crafted.";
        enablePortaSpawner = configuration.get(string, "PortaSpawner", true).setRequiresMcRestart(true);
        MFRConfig.enablePortaSpawner.comment = "If true, the PortaSpawner will be craftable.";
        enableSyringes = configuration.get(string, "Syringes", true).setRequiresMcRestart(true);
        MFRConfig.enableSyringes.comment = "If true, the Syringes will be craftable.";
        enableGuns = configuration.get(string, "Guns", true).setRequiresMcRestart(true);
        MFRConfig.enableGuns.comment = "If true, the Guns will be craftable.";
        enableNetLauncher = configuration.get(string, "NetLauncher", true).setRequiresMcRestart(true);
        MFRConfig.enableNetLauncher.comment = "If true, the safarinet launcher will be craftable.";
        enableSmoothSlabRecipe = configuration.get(string, "SmoothSlab", true).setRequiresMcRestart(true);
        MFRConfig.enableSmoothSlabRecipe.comment = "If true, smooth double stone slabs can be craftable.";
        enableCheapCL = configuration.get(string, "CheaperChunkLoader", false).setRequiresMcRestart(true);
        MFRConfig.enableCheapCL.comment = "If true, the ChunkLoader can be built out of cheaper materials. Does nothing if the recipe is disabled.";
        enableExpensiveSafariNet = configuration.get(string, "ExpensiveSafariNet", false).setRequiresMcRestart(true);
        MFRConfig.enableExpensiveSafariNet.comment = "If true, the reusable safarinet will require a portaspawner to craft. The portaspawner must be enabled for the safarinet to be craftable.";
        string = "Machine.Conveyor";
        conveyorCaptureNonItems = configuration.get(string, "CaptureNonItems", true).setRequiresMcRestart(true);
        MFRConfig.conveyorCaptureNonItems.comment = "If false, conveyors will not grab non-item entities. Breaks conveyor mob grinders but makes them safe for golems, etc.";
        conveyorNeverCapturesPlayers = configuration.get(string, "NeverCapturePlayers", false).setRequiresMcRestart(true);
        MFRConfig.conveyorNeverCapturesPlayers.comment = "If true, conveyors will NEVER capture players regardless of other settings.";
        conveyorNeverCapturesTCGolems = configuration.get(string, "NeverCaptureTCGolems", false).setRequiresMcRestart(true);
        MFRConfig.conveyorNeverCapturesTCGolems.comment = "If true, conveyors will NEVER capture ThaumCraft golems regardless of other settings.";
        string = "Machine." + Machine.ChunkLoader.getName();
        enableChunkLimitBypassing = configuration.get(string, "IgnoreChunkLimit", false);
        MFRConfig.enableChunkLimitBypassing.comment = "If true, the Chunk Loader will ignore forgeChunkLoading.cfg.";
        enableChunkLoaderRequiresOwner = configuration.get(string, "RequiresOwnerOnline", false);
        MFRConfig.enableChunkLoaderRequiresOwner.comment = "If true, the Chunk Loader will require that the player who placed it be online to function";
        enableConfigurableCLEnergy = configuration.get(string, "EnableConfigurableActivationEnergy", false).setRequiresMcRestart(true);
        MFRConfig.enableConfigurableCLEnergy.comment = "If true, the Chunk Loader will use the activation energy config in this section. WARNING: this makes it much more expensive at lower values. (non-configurable is exponential)";
        string = "Machine." + Machine.AutoSpawner.getName();
        spawnerBlacklist = configuration.get(string, "Blacklist", new String[]{"VillagerGolem"}).setRequiresMcRestart(true);
        MFRConfig.spawnerBlacklist.comment = "A list of entity IDs (e.g.: CaveSpider or VillagerGolem or Forestry.butterflyGE) to blacklist from the AutoSpawner. The Debugger item will display an entity's ID when used.";
        string = string + ".Cost";
        autospawnerCostExact = configuration.get(string, "Exact", 5).setRequiresMcRestart(true);
        MFRConfig.autospawnerCostExact.comment = "The multiplier for work required to generate a mob in exact mode.";
        autospawnerCostStandard = configuration.get(string, "Standard", 1).setRequiresMcRestart(true);
        MFRConfig.autospawnerCostStandard.comment = "The multiplier for work required to generate a mob in standard (non-exact) mode.";
        spawnerCustomization = configuration.getCategory(string + ".Custom").setRequiresMcRestart(true);
        spawnerCustomization.setComment("Custom base XP costs for entities. format: I:<entityid> = #. e.g.:\nI:VillagerGolem = 25\nI:Slime = 50");
        laserdrillCost = configuration.get("Machine." + Machine.LaserDrill.getName(), "Work", 300).setRequiresMcRestart(true);
        MFRConfig.laserdrillCost.comment = "The work required by the drill to generate a single ore.";
        unifierBlacklist = configuration.get("Machine." + Machine.Unifier.getName(), "Blacklist", new String[]{"dyeBlue", "dyeWhite", "dyeBrown", "dyeBlack", "listAllwater", "listAllmilk"}).setRequiresMcRestart(true);
        MFRConfig.unifierBlacklist.comment = "A list of ore dictionary entrys to disable unifying for. By default, MFR will not attempt to unify anything with more than one oredict name.";
        breederShutdownThreshold = configuration.get("Machine." + Machine.Breeder.getName(), "ShutdownThreshold", 50).setRequiresMcRestart(true);
        MFRConfig.breederShutdownThreshold.comment = "If the number of entities in the breeder's target area exceeds this value, the breeder will cease operating. This is provided to control server lag.";
        enableBonemealFertilizing = configuration.get("Machine." + Machine.Fertilizer.getName(), "EnableBonemeal", false).setRequiresMcRestart(true);
        MFRConfig.enableBonemealFertilizing.comment = "If true, the fertilizer will use bonemeal as well as MFR fertilizer. Provided for those who want a less work-intensive farm.";
        disenchanterEssence = configuration.get("Machine." + Machine.AutoDisenchanter.getName(), "EnableEssence", false).setRequiresMcRestart(true);
        MFRConfig.disenchanterEssence.comment = "If true, the disenchanter will use essence to disenchant items. Provided for those who want a more work-intensive enchanting system.";
        steamBoilerExplodes = configuration.get("Machine." + Machine.SteamBoiler.getName(), "Explodes", false);
        MFRConfig.steamBoilerExplodes.comment = "If true, the steam boiler will explode if it's hot and dry when you try to pump water into it.";
        for (Machine machine : Machine.values()) {
            machine.load(configuration);
        }
        dropFilledContainers = configuration.get("general", "Tanks.FillWithoutEmptySlots", true);
        MFRConfig.dropFilledContainers.comment = "If true, when you have no empty slots in your inventory, you will continue filling buckets from tanks and drop them on the ground.";
        configuration.save();
    }

    static {
        CATEGORY_ITEM = "item";
    }
}

