/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.core.IAdvFluidContainerItem;
import powercrystals.minefactoryreloaded.core.IUseHandler;
import powercrystals.minefactoryreloaded.core.IUseable;
import powercrystals.minefactoryreloaded.farmables.usehandlers.DefaultUseHandler;
import powercrystals.minefactoryreloaded.farmables.usehandlers.DrinkUseHandler;
import powercrystals.minefactoryreloaded.item.base.ItemFactory;

public class ItemFactoryCup
extends ItemFactory
implements IAdvFluidContainerItem,
IUseable {
    public static final int MELTING_POINT = 523;
    public static final IUseHandler defaultUseAction = new DefaultUseHandler();
    public static final IUseHandler drinkUseAction = new DrinkUseHandler();
    private boolean _prefix = false;
    @SideOnly(value=Side.CLIENT)
    protected IIcon fillIcon;
    protected List<IUseHandler> useHandlers;

    public ItemFactoryCup(int n, int n2) {
        this.func_77625_d(n);
        this.func_77656_e(n2);
        this.func_77627_a(true);
        this.useHandlers = new LinkedList<IUseHandler>();
        this.useHandlers.add(defaultUseAction);
        this.useHandlers.add(drinkUseAction);
    }

    public int getItemStackLimit(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound != null && nBTTagCompound.func_74764_b("fluid")) {
            return 1;
        }
        return this.field_77777_bU;
    }

    @Override
    public boolean addUseHandler(IUseHandler iUseHandler) {
        return this.useHandlers.add(iUseHandler);
    }

    @Override
    public boolean removeUseHandler(IUseHandler iUseHandler) {
        return this.useHandlers.remove(iUseHandler);
    }

    public String func_77667_c(ItemStack itemStack) {
        if (this.getFluid(itemStack) != null) {
            return this.func_77658_a() + (this._prefix ? ".prefix" : ".suffix");
        }
        return this.func_77658_a();
    }

    public String getLocalizedName(String string) {
        String string2 = this.func_77658_a() + "." + string;
        if (StatCollector.func_94522_b((String)string2)) {
            return StatCollector.func_74838_a((String)string2);
        }
        return null;
    }

    public String func_77653_i(ItemStack itemStack) {
        String string = this.getFluidName(itemStack);
        String string2 = this.getLocalizedName(string);
        if (string2 != null && !string2.isEmpty()) {
            return EnumChatFormatting.RESET + string2 + EnumChatFormatting.RESET;
        }
        if (string == null) {
            return super.func_77653_i(itemStack);
        }
        FluidStack fluidStack = this.getFluid(itemStack);
        if (fluidStack != null) {
            string = fluidStack.getFluid().getLocalizedName(fluidStack);
        }
        this._prefix = true;
        string2 = super.func_77653_i(itemStack);
        this._prefix = false;
        string2 = string2 != null ? string2.trim() : "";
        string = (string2.isEmpty() ? "" : string2 + " ") + string;
        string2 = super.func_77653_i(itemStack);
        string2 = string2 != null ? string2.trim() : "";
        string = string + (string2.isEmpty() ? " Cup" : " " + string2);
        return string;
    }

    public String getFluidName(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        return nBTTagCompound == null || !nBTTagCompound.func_74764_b("fluid") ? null : nBTTagCompound.func_74775_l("fluid").func_74779_i("FluidName");
    }

    public FluidStack getFluid(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        FluidStack fluidStack = null;
        if (nBTTagCompound != null && nBTTagCompound.func_74764_b("fluid") && (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound.func_74775_l("fluid"))) == null) {
            nBTTagCompound.func_82580_o("fluid");
        }
        return fluidStack;
    }

    public int getCapacity(ItemStack itemStack) {
        return 1000;
    }

    public int fill(ItemStack itemStack, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || itemStack.field_77994_a != 1) {
            return 0;
        }
        int n = 0;
        int n2 = this.getCapacity(itemStack);
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        NBTTagCompound nBTTagCompound2 = null;
        FluidStack fluidStack2 = null;
        if (nBTTagCompound == null || !nBTTagCompound.func_74764_b("fluid") || (nBTTagCompound2 = nBTTagCompound.func_74775_l("fluid")) == null || (fluidStack2 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound2)) == null) {
            n = Math.min(n2, fluidStack.amount);
        }
        if (fluidStack2 == null) {
            if (bl) {
                fluidStack2 = fluidStack.copy();
                fluidStack2.amount = 0;
            }
        } else {
            if (!fluidStack2.isFluidEqual(fluidStack)) {
                return 0;
            }
            n = Math.min(n2 - fluidStack2.amount, fluidStack.amount);
        }
        n = Math.max(n, 0);
        if (bl) {
            if (nBTTagCompound == null) {
                nBTTagCompound = itemStack.field_77990_d = new NBTTagCompound();
            }
            fluidStack2.amount += n;
            nBTTagCompound.func_74782_a("fluid", (NBTBase)fluidStack2.writeToNBT(nBTTagCompound2 == null ? new NBTTagCompound() : nBTTagCompound2));
        }
        return n;
    }

    public FluidStack drain(ItemStack itemStack, int n, boolean bl) {
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        NBTTagCompound nBTTagCompound2 = null;
        FluidStack fluidStack = null;
        if (nBTTagCompound == null || !nBTTagCompound.func_74764_b("fluid") || (nBTTagCompound2 = nBTTagCompound.func_74775_l("fluid")) == null || (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound2)) == null) {
            return null;
        }
        int n2 = Math.min(n, fluidStack.amount);
        if (bl) {
            nBTTagCompound.func_82580_o("fluid");
            nBTTagCompound.func_74757_a("drained", true);
            fluidStack.amount -= n2;
            if (fluidStack.amount > 0) {
                this.fill(itemStack, fluidStack, true);
            }
            if (nBTTagCompound.func_74764_b("toDrain")) {
                n2 = nBTTagCompound.func_74762_e("toDrain");
                nBTTagCompound.func_82580_o("toDrain");
            } else {
                n2 = (int)((double)n2 * (Math.max(Math.random() - 0.75, 0.0) + 0.75));
            }
        } else {
            n2 = (int)((double)n2 * (Math.max(Math.random() - 0.75, 0.0) + 0.75));
            nBTTagCompound.func_74768_a("toDrain", n2);
        }
        fluidStack.amount = n2;
        return fluidStack;
    }

    public Item func_77668_q() {
        return this;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (itemStack.field_77994_a <= 0) {
            return null;
        }
        ItemStack itemStack2 = itemStack.func_77946_l();
        NBTTagCompound nBTTagCompound = itemStack2.func_77978_p();
        if (nBTTagCompound != null) {
            if (nBTTagCompound.func_74764_b("drained")) {
                itemStack2.field_77994_a = 1;
                itemStack2.func_96631_a(1, Item.field_77697_d);
            }
            nBTTagCompound.func_82580_o("drained");
            nBTTagCompound.func_82580_o("fluid");
            nBTTagCompound.func_82580_o("toDrain");
            if (nBTTagCompound.func_82582_d()) {
                itemStack2.func_77982_d(null);
            }
        }
        return itemStack2;
    }

    public boolean hasContainerItem(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        return nBTTagCompound != null && (nBTTagCompound.func_74764_b("fluid") || nBTTagCompound.func_74764_b("drained"));
    }

    public boolean hasDrinkableLiquid(ItemStack itemStack) {
        return itemStack.field_77994_a == 1 && MFRRegistry.getLiquidDrinkHandlers().containsKey(this.getFluidName(itemStack)) && this.getFluid((ItemStack)itemStack).amount == this.getCapacity(itemStack);
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        for (IUseHandler iUseHandler : this.useHandlers) {
            if (!iUseHandler.isUsable(itemStack)) continue;
            return iUseHandler.onUse(itemStack, (EntityLivingBase)entityPlayer);
        }
        return itemStack;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        for (IUseHandler iUseHandler : this.useHandlers) {
            if (!iUseHandler.isUsable(itemStack)) continue;
            return iUseHandler.useAction(itemStack);
        }
        return EnumAction.none;
    }

    public int func_77626_a(ItemStack itemStack) {
        for (IUseHandler iUseHandler : this.useHandlers) {
            if (!iUseHandler.isUsable(itemStack)) continue;
            return iUseHandler.getMaxUseDuration(itemStack);
        }
        return 0;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        for (IUseHandler iUseHandler : this.useHandlers) {
            if (!iUseHandler.canUse(itemStack, (EntityLivingBase)entityPlayer)) continue;
            return iUseHandler.onTryUse(itemStack, world, (EntityLivingBase)entityPlayer);
        }
        return itemStack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iIconRegister) {
        this.field_77791_bV = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a());
        this.fillIcon = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + ".fill");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int n) {
        switch (n) {
            case 1: {
                return this.fillIcon;
            }
        }
        return this.field_77791_bV;
    }

    public boolean isValidArmor(ItemStack itemStack, int n, Entity entity) {
        return n == 0 && entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70005_c_().equalsIgnoreCase("Eyamaz");
    }

    public String getArmorTexture(ItemStack itemStack, Entity entity, int n, String string) {
        return "minefactoryreloaded:textures/armor/plastic_layer_1.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLivingBase, ItemStack itemStack, int n) {
        if (n == 0) {
            return null;
        }
        return null;
    }

    @Override
    public boolean canBeFilledFromWorld() {
        return true;
    }

    @Override
    public boolean canPlaceInWorld() {
        return false;
    }

    @Override
    public boolean shouldReplaceWhenFilled() {
        return true;
    }

    @Override
    public MovingObjectPosition rayTrace(World world, EntityLivingBase entityLivingBase, boolean bl) {
        Vec3 vec3;
        MovingObjectPosition movingObjectPosition;
        float f = entityLivingBase.field_70125_A;
        float f2 = entityLivingBase.field_70177_z;
        double d = entityLivingBase.field_70163_u + (double)entityLivingBase.func_70047_e() - (double)entityLivingBase.field_70129_M;
        Vec3 vec32 = Vec3.func_72443_a((double)entityLivingBase.field_70165_t, (double)d, (double)entityLivingBase.field_70161_v);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d2 = 5.0;
        if (entityLivingBase instanceof EntityPlayerMP) {
            d2 = ((EntityPlayerMP)entityLivingBase).field_71134_c.getBlockReachDistance();
        }
        if ((movingObjectPosition = world.func_147447_a(vec32, vec3 = vec32.func_72441_c((double)f7 * d2, (double)f6 * d2, (double)f8 * d2), bl, !bl, false)) != null && bl) {
            ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)movingObjectPosition.field_72310_e);
            movingObjectPosition.field_72311_b += forgeDirection.offsetX;
            movingObjectPosition.field_72312_c += forgeDirection.offsetY;
            movingObjectPosition.field_72309_d += forgeDirection.offsetZ;
        }
        return movingObjectPosition;
    }

    public boolean canPipette(ItemStack itemStack) {
        return true;
    }
}

