/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import cofh.api.energy.IEnergyContainerItem;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import powercrystals.minefactoryreloaded.block.BlockFactoryMachine;
import powercrystals.minefactoryreloaded.block.ItemBlockFactory;
import powercrystals.minefactoryreloaded.setup.Machine;

public class ItemBlockFactoryMachine
extends ItemBlockFactory
implements IEnergyContainerItem {
    private int _machineBlockIndex;

    public ItemBlockFactoryMachine(Block block) {
        super(block);
        int n;
        this.func_77656_e(0);
        this.func_77627_a(true);
        this._machineBlockIndex = ((BlockFactoryMachine)block).getBlockIndex();
        int n2 = Machine.getHighestMetadata(this._machineBlockIndex);
        String[] stringArray = new String[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            stringArray[n] = Machine.getMachineFromIndex(this._machineBlockIndex, n).getInternalName();
        }
        this.setNames(stringArray);
        for (n = 0; n <= n2; ++n) {
            ItemStack itemStack = new ItemStack((Item)this, 1, n);
            GameRegistry.registerCustomItemStack((String)itemStack.func_77977_a(), (ItemStack)itemStack);
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_77629_n_() {
        return false;
    }

    @Override
    public String func_77667_c(ItemStack itemStack) {
        return this._names[Math.min(itemStack.func_77960_j(), this._names.length - 1)];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        } else {
            this.getMachine(itemStack).addInformation(itemStack, entityPlayer, list, bl);
        }
    }

    private Machine getMachine(ItemStack itemStack) {
        return Machine.getMachineFromIndex(this._machineBlockIndex, itemStack.func_77960_j());
    }

    private int getTransferRate(ItemStack itemStack) {
        if (itemStack.field_77994_a != 1) {
            return 0;
        }
        return this.getMachine(itemStack).getActivationEnergy();
    }

    private void setEnergy(ItemStack itemStack, int n) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
            itemStack.func_77982_d(nBTTagCompound);
        }
        nBTTagCompound.func_74768_a("energyStored", n);
    }

    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        n = Math.min(this.getTransferRate(itemStack), n);
        if (n <= 0) {
            return 0;
        }
        int n5 = this.getEnergyStored(itemStack);
        if (!bl & (n4 = (n3 = Math.max(0, Math.min(n2 = this.getMaxEnergyStored(itemStack), n5 + n))) - n5) > 0) {
            this.setEnergy(itemStack, n3);
        }
        return n4;
    }

    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        n = Math.min(this.getTransferRate(itemStack), n);
        if (n <= 0) {
            return 0;
        }
        if (!bl & (n4 = (n3 = this.getEnergyStored(itemStack)) - (n2 = Math.max(0, n3 - n))) > 0) {
            this.setEnergy(itemStack, n2);
        }
        return n4;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74762_e("energyStored");
        }
        return 0;
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return this.getMachine(itemStack).getMaxEnergyStorage();
    }
}

