/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.NonNull;
import net.minecraft.util.StringTranslate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import tterrag.core.TTCore;
import tterrag.core.common.config.ConfigHandler;

public final class TTFileUtils {
    public static final FileFilter pngFilter = FileFilterUtils.suffixFileFilter((String)".png");
    public static final FileFilter langFilter = FileFilterUtils.suffixFileFilter((String)".lang");

    public static void copyFromJar(Class<?> jarClass, String filename, File to) {
        TTCore.logger.info("Copying file " + filename + " from jar");
        URL url = jarClass.getResource("/assets/" + filename);
        try {
            FileUtils.copyURLToFile((URL)url, (File)to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static File extractZip(File zip) {
        String zipPath = zip.getParent() + "/extracted";
        File temp = new File(zipPath);
        temp.mkdir();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                int b;
                ZipEntry entry = e.nextElement();
                File destinationPath = new File(zipPath, entry.getName());
                destinationPath.getParentFile().mkdirs();
                if (entry.isDirectory()) continue;
                TTCore.logger.info("Extracting file: " + destinationPath);
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] buffer = new byte[1024];
                FileOutputStream fos = new FileOutputStream(destinationPath);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
                while ((b = bis.read(buffer, 0, 1024)) != -1) {
                    bos.write(buffer, 0, b);
                }
                bos.close();
                bis.close();
            }
        }
        catch (IOException e) {
            TTCore.logger.error("Error opening zip file" + e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException e) {
                TTCore.logger.error("Error while closing zip file" + e);
            }
        }
        return temp;
    }

    @NonNull
    public static File writeToFile(String filepath, String json) {
        File file = new File(filepath);
        try {
            file.createNewFile();
            FileWriter fw = new FileWriter(file);
            fw.write(json);
            fw.flush();
            fw.close();
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static void safeDelete(File file) {
        try {
            file.delete();
        }
        catch (Exception e) {
            TTCore.logger.error("Deleting file " + file.getAbsolutePath() + " failed.");
        }
    }

    @NonNull
    public static void safeDeleteDirectory(File file) {
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (Exception e) {
            TTCore.logger.error("Deleting directory " + file.getAbsolutePath() + " failed.");
        }
    }

    @NonNull
    public static void loadLangFiles(File directory) {
        for (File file : directory.listFiles(langFilter)) {
            StringTranslate.inject((InputStream)new FileInputStream(file));
        }
    }

    public static boolean manuallyChangeConfigValue(String filePathFromConfigFolder, String prefix, String from, String to) {
        File config = new File(ConfigHandler.configFolder.getAbsolutePath() + "/" + filePathFromConfigFolder);
        boolean found = false;
        try {
            FileReader fr1 = new FileReader(config);
            BufferedReader read = new BufferedReader(fr1);
            ArrayList<String> strings = new ArrayList<String>();
            while (read.ready()) {
                strings.add(read.readLine());
            }
            fr1.close();
            read.close();
            FileWriter fw = new FileWriter(config);
            BufferedWriter bw = new BufferedWriter(fw);
            for (String s : strings) {
                if (!found && s.contains(prefix + "=" + from) && !s.contains("=" + to)) {
                    s = s.replace(prefix + "=" + from, prefix + "=" + to);
                    TTCore.logger.info("Successfully changed config value " + prefix + " from " + from + " to " + to);
                    found = true;
                }
                fw.write(s + "\n");
            }
            bw.flush();
            bw.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return found;
    }

    public static String manuallyGetConfigValue(String filePathFromConfigFolder, String key) {
        File config = new File(ConfigHandler.configFolder.getAbsolutePath() + "/" + filePathFromConfigFolder);
        Scanner scan = null;
        try {
            scan = new Scanner(config);
        }
        catch (FileNotFoundException e) {
            return "";
        }
        while (scan.hasNext()) {
            String s = scan.next();
            if (!s.contains(key)) continue;
            scan.close();
            return s.substring(s.indexOf("=") + 1, s.length());
        }
        scan.close();
        return "";
    }

    private TTFileUtils() {
    }
}

