/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.util;

import java.beans.ConstructorProperties;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockCoord {
    public int x;
    public int y;
    public int z;

    public BlockCoord(Entity e) {
        this(MathHelper.func_76128_c((double)e.field_70165_t), MathHelper.func_76128_c((double)e.field_70163_u), MathHelper.func_76128_c((double)e.field_70161_v));
    }

    public BlockCoord(TileEntity te) {
        this(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public BlockCoord(BlockCoord other) {
        this(other.x, other.y, other.z);
    }

    public Block getBlock(World world) {
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public double getDistSq(BlockCoord other) {
        double xDiff = (double)this.x + 0.5 - (double)other.x;
        double yDiff = (double)this.y + 0.5 - (double)other.y;
        double zDiff = (double)this.z + 0.5 - (double)other.z;
        return xDiff * xDiff + yDiff * yDiff + zDiff * zDiff;
    }

    public double getDistSq(TileEntity other) {
        return other.func_145835_a((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("blockCoordx", this.x);
        tag.func_74768_a("blockCoordy", this.y);
        tag.func_74768_a("blockCoordz", this.z);
    }

    public static BlockCoord readFromNBT(NBTTagCompound tag) {
        int x = tag.func_74762_e("blockCoordx");
        int y = tag.func_74762_e("blockCoordy");
        int z = tag.func_74762_e("blockCoordz");
        return new BlockCoord(x, y, z);
    }

    public void setPosition(double x, double y, double z) {
        this.x = MathHelper.func_76128_c((double)x);
        this.y = MathHelper.func_76128_c((double)y);
        this.z = MathHelper.func_76128_c((double)z);
    }

    public String toString() {
        return "X: " + this.x + "  Y: " + this.y + "  Z: " + this.z;
    }

    @ConstructorProperties(value={"x", "y", "z"})
    public BlockCoord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockCoord)) {
            return false;
        }
        BlockCoord other = (BlockCoord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockCoord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.x;
        result = result * 59 + this.y;
        result = result * 59 + this.z;
        return result;
    }
}

