/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.config;

import java.io.File;
import tterrag.core.TTCore;
import tterrag.core.common.Handlers;
import tterrag.core.common.config.AbstractConfigHandler;
import tterrag.core.common.config.ITweakConfigHandler;
import tterrag.core.common.config.JsonConfigReader;
import tterrag.core.common.handlers.RightClickCropHandler;
import tterrag.core.common.tweaks.Tweak;
import tterrag.core.common.tweaks.Tweaks;

@Handlers.Handler(value={Handlers.Handler.HandlerType.FML})
public class ConfigHandler
extends AbstractConfigHandler
implements ITweakConfigHandler {
    public static boolean showOredictTooltips = false;
    public static boolean extraDebugStuff = true;
    public static int disableVoidFog = 1;
    public static int anvilMaxLevel = 40;
    public static boolean betterAchievements = true;
    public static boolean allowCropRC = true;
    public static int enchantIDXPBoost = 43;
    public static boolean allowXPBoost = true;
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    public static File configFolder;

    protected ConfigHandler() {
        super("ttCore");
    }

    @Override
    public void init() {
        this.addSection("general");
        this.addSection("enchants");
        this.addSection("tweaks");
    }

    @Override
    protected void reloadIngameConfigs() {
        this.activateSection("general");
        showOredictTooltips = this.getValue("showOredictTooltips", "Show oredictionary names of every item in its tooltip.", showOredictTooltips);
        extraDebugStuff = this.getValue("extraDebugStuff", "Show item registry names and other things in debug mode (f3+h)", extraDebugStuff);
        disableVoidFog = this.getValue("disableVoidFog", "Removes all void fog.\n0 = off\n1 = DEFAULT worldtype only\n2 = all world types", disableVoidFog);
        anvilMaxLevel = this.getValue("anvilMaxLevel", "The max amount of XP levels an anvil recipe can use", anvilMaxLevel);
        betterAchievements = this.getValue("superDuperFunMode", "The way the game should have been made.", betterAchievements);
        Tweaks.loadIngameTweaks();
    }

    @Override
    protected void reloadNonIngameConfigs() {
        this.activateSection("enchants");
        enchantIDXPBoost = this.getValue("enchantIDXPBoost", "Enchant ID for the XP boost enchant.", enchantIDXPBoost);
        allowXPBoost = this.getValue("allowXPBoost", "Allow the XP Boost enchant to be registered.", allowXPBoost);
        Tweaks.loadNonIngameTweaks();
    }

    @Override
    public boolean addBooleanFor(Tweak tweak) {
        this.activateSection("tweaks");
        return this.getValue(tweak.getName(), tweak.getComment(), true);
    }

    public void loadRightClickCrops() {
        JsonConfigReader<RightClickCropHandler.PlantInfo> reader = new JsonConfigReader<RightClickCropHandler.PlantInfo>(new JsonConfigReader.ModToken(TTCore.class, "ttCore".toLowerCase() + "/config"), configFolder.getAbsolutePath() + "/ttCore/cropConfig.json", RightClickCropHandler.PlantInfo.class);
        for (RightClickCropHandler.PlantInfo i : reader) {
            i.init();
            RightClickCropHandler.INSTANCE.addCrop(i);
        }
    }
}

