/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.sound;

import net.minecraft.client.audio.ISound;
import net.minecraft.util.ResourceLocation;

public class MuseSound
implements ISound {
    private ResourceLocation soundLoc;
    private float volume;
    private float pitch;
    private float xPos;
    private float yPos;
    private float zPos;
    private boolean canRepeat;
    private int repeatDelay;
    private ISound.AttenuationType type;

    public MuseSound(String sound) {
        this(sound, 1.0f);
    }

    public MuseSound(String sound, float volume) {
        this(sound, volume, 1.0f);
    }

    public MuseSound(String sound, float volume, float pitch) {
        this(sound, volume, pitch, 0.0f, 0.0f, 0.0f, ISound.AttenuationType.NONE);
    }

    public MuseSound(String sound, float xPos, float yPos, float zPos) {
        this(sound, 1.0f, 1.0f, xPos, yPos, zPos, ISound.AttenuationType.LINEAR);
    }

    public MuseSound(String sound, boolean canRepeat, int repeatDelay) {
        this(sound, 1.0f, 1.0f, canRepeat, repeatDelay, 0.0f, 0.0f, 0.0f, ISound.AttenuationType.NONE);
    }

    public MuseSound(String sound, float volume, float pitch, float xPos, float yPos, float zPos, ISound.AttenuationType type) {
        this(sound, volume, pitch, false, 0, xPos, yPos, zPos, type);
    }

    public MuseSound(String sound, float volume, float pitch, boolean canRepeat, int repeatDelay, float xPos, float yPos, float zPos, ISound.AttenuationType type) {
        this(new ResourceLocation(sound), volume, pitch, canRepeat, repeatDelay, xPos, yPos, zPos, type);
    }

    public MuseSound(ResourceLocation soundLoc) {
        this(soundLoc, 1.0f);
    }

    public MuseSound(ResourceLocation soundLoc, float volume) {
        this(soundLoc, volume, 1.0f);
    }

    public MuseSound(ResourceLocation soundLoc, float volume, float pitch) {
        this(soundLoc, volume, pitch, 0.0f, 0.0f, 0.0f, ISound.AttenuationType.NONE);
    }

    public MuseSound(ResourceLocation soundLoc, float xPos, float yPos, float zPos) {
        this(soundLoc, 1.0f, 1.0f, xPos, yPos, zPos, ISound.AttenuationType.LINEAR);
    }

    public MuseSound(ResourceLocation soundLoc, boolean canRepeat, int repeatDelay) {
        this(soundLoc, 1.0f, 1.0f, canRepeat, repeatDelay, 0.0f, 0.0f, 0.0f, ISound.AttenuationType.NONE);
    }

    public MuseSound(ResourceLocation soundLoc, float volume, float pitch, float xPos, float yPos, float zPos, ISound.AttenuationType type) {
        this(soundLoc, volume, pitch, false, 0, xPos, yPos, zPos, type);
    }

    public MuseSound(ResourceLocation soundLoc, float volume, float pitch, boolean canRepeat, int repeatDelay, float xPos, float yPos, float zPos, ISound.AttenuationType type) {
        this.soundLoc = soundLoc;
        this.volume = volume;
        this.pitch = pitch;
        this.canRepeat = canRepeat;
        this.repeatDelay = repeatDelay;
        this.xPos = xPos;
        this.yPos = yPos;
        this.zPos = zPos;
        this.type = type;
    }

    public MuseSound(ISound other) {
        this.soundLoc = other.func_147650_b();
        this.volume = other.func_147653_e();
        this.pitch = other.func_147655_f();
        this.canRepeat = other.func_147657_c();
        this.repeatDelay = other.func_147652_d();
        this.xPos = other.func_147649_g();
        this.yPos = other.func_147654_h();
        this.zPos = other.func_147651_i();
        this.type = other.func_147656_j();
    }

    public MuseSound setVolume(float volume) {
        this.volume = volume;
        return this;
    }

    public MuseSound setPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public MuseSound setVolumeAndPitch(float volume, float pitch) {
        this.volume = volume;
        this.pitch = pitch;
        return this;
    }

    public MuseSound setLocation(float xPos, float yPos, float zPos) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.zPos = zPos;
        this.type = ISound.AttenuationType.LINEAR;
        return this;
    }

    public MuseSound removeLocation() {
        this.zPos = 0.0f;
        this.yPos = 0.0f;
        this.xPos = 0.0f;
        this.type = ISound.AttenuationType.NONE;
        return this;
    }

    public MuseSound setRepeatable(int repeatDelay) {
        this.canRepeat = true;
        this.repeatDelay = repeatDelay;
        return this;
    }

    public MuseSound unsetRepeatable() {
        this.canRepeat = false;
        this.repeatDelay = 0;
        return this;
    }

    public ResourceLocation func_147650_b() {
        return this.soundLoc;
    }

    public boolean func_147657_c() {
        return this.canRepeat;
    }

    public int func_147652_d() {
        return this.repeatDelay;
    }

    public float func_147653_e() {
        return this.volume;
    }

    public float func_147655_f() {
        return this.pitch;
    }

    public float func_147649_g() {
        return this.xPos;
    }

    public float func_147654_h() {
        return this.yPos;
    }

    public float func_147651_i() {
        return this.zPos;
    }

    public ISound.AttenuationType func_147656_j() {
        return this.type;
    }
}

