/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.recipe;

import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.recipe.IItemMaker;
import net.machinemuse.numina.recipe.ItemNameMappings;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SimpleItemMaker
implements IItemMaker {
    public Item item;
    public Integer meta;
    public Integer quantity;
    public String unlocalizedName;
    public String oredictName;

    @Override
    public ItemStack makeItem(InventoryCrafting i) {
        return this.getRecipeOutput();
    }

    private int getOrElse(Integer input, int defaultval) {
        if (input == null) {
            return defaultval;
        }
        return input;
    }

    @Override
    public ItemStack getRecipeOutput() {
        int newmeta = this.getOrElse(this.meta, 0);
        int newquantity = this.getOrElse(this.quantity, 1);
        if (this.item != null) {
            ItemStack stack = new ItemStack(this.item, newquantity, newmeta);
            return stack;
        }
        if (this.oredictName != null) {
            try {
                ItemStack stack = ((ItemStack)OreDictionary.getOres((String)this.oredictName).get(0)).func_77946_l();
                stack.field_77994_a = newquantity;
                return stack;
            }
            catch (Exception e) {
                MuseLogger.logError("Unable to load " + this.oredictName + " from oredict");
                return null;
            }
        }
        if (this.unlocalizedName != null) {
            try {
                ItemStack stack = ItemNameMappings.getItem(this.unlocalizedName).func_77946_l();
                newmeta = this.getOrElse(this.meta, stack.func_77960_j());
                stack.func_77964_b(newmeta);
                stack.field_77994_a = newquantity;
                return stack;
            }
            catch (Exception e) {
                MuseLogger.logError("Unable to load " + this.unlocalizedName + " from unlocalized names");
                return null;
            }
        }
        return null;
    }
}

