/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.geometry;

import net.machinemuse.numina.geometry.FlyFromPointToPoint2D;
import net.machinemuse.numina.geometry.MusePoint2D;

public class MuseRect {
    MusePoint2D ul;
    MusePoint2D wh;

    public MuseRect(double left, double top, double right, double bottom, boolean growFromMiddle) {
        this.ul = new MusePoint2D(left, top);
        this.wh = new MusePoint2D(right - left, bottom - top);
        if (growFromMiddle) {
            MusePoint2D center = this.ul.plus(this.wh.times(0.5));
            this.ul = new FlyFromPointToPoint2D(center, this.ul, 200.0);
            this.wh = new FlyFromPointToPoint2D(new MusePoint2D(0.0, 0.0), this.wh, 200.0);
        }
    }

    public MuseRect(double left, double top, double right, double bottom) {
        this(left, top, right, bottom, false);
    }

    public MuseRect(MusePoint2D ul, MusePoint2D br) {
        this.ul = ul;
        this.wh = br.minus(ul);
    }

    public double left() {
        return this.ul.x();
    }

    public double right() {
        return this.ul.x() + this.wh.x();
    }

    public double top() {
        return this.ul.y();
    }

    public double bottom() {
        return this.ul.y() + this.wh.y();
    }

    public double width() {
        return this.wh.x();
    }

    public double height() {
        return this.wh.y();
    }

    public MuseRect setLeft(double value) {
        this.ul.x = value;
        return this;
    }

    public MuseRect setRight(double value) {
        this.wh.x = value - this.ul.x();
        return this;
    }

    public MuseRect setTop(double value) {
        this.ul.y = value;
        return this;
    }

    public MuseRect setBottom(double value) {
        this.wh.y = value - this.ul.y();
        return this;
    }

    public MuseRect setWidth(double value) {
        this.wh.x = value;
        return this;
    }

    public MuseRect setHeight(double value) {
        this.wh.y = value;
        return this;
    }

    public boolean equals(MuseRect other) {
        return this.ul.equals(other.ul) && this.wh.equals(other.wh);
    }

    public boolean containsPoint(double x, double y) {
        return x > this.left() && x < this.right() && y > this.top() && y < this.bottom();
    }

    public double centerx() {
        return (this.left() + this.right()) / 2.0;
    }

    public double centery() {
        return (this.top() + this.bottom()) / 2.0;
    }
}

